/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.common.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class LcBuyerIntHelper {
    public static void writeBackArrival(DynamicObject[] dataEntities, boolean isDelete) {
        DynamicObject[] arrivals = LcBuyerIntHelper.getArrivalByBuyerInt(dataEntities);
        if (isDelete) {
            for (DynamicObject arrival : arrivals) {
                arrival.set("buyerint", (Object)"0");
                arrival.set("buyerintid", (Object)0);
                arrival.set("buyerintamt", (Object)0);
                arrival.set("intcurrency", (Object)0);
            }
        } else {
            Map arrivalMap = Arrays.stream(arrivals).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
            for (DynamicObject buyerInt : dataEntities) {
                DynamicObjectCollection entry = buyerInt.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry) {
                    Object arrivalId = row.getDynamicObject("arrival").getPkValue();
                    DynamicObject arrival = (DynamicObject)arrivalMap.get(arrivalId);
                    if (null == arrival) continue;
                    arrival.set("buyerint", (Object)"1");
                    arrival.set("buyerintid", buyerInt.getPkValue());
                    arrival.set("buyerintamt", (Object)row.getBigDecimal("obversionamt"));
                    arrival.set("intcurrency", (Object)buyerInt.getDynamicObject("currency"));
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])arrivals);
        LcBuyerIntHelper.writeBackLetterCredit(arrivals, isDelete);
    }

    private static void writeBackLetterCredit(DynamicObject[] arrivals, boolean isDelete) {
        List letterCreditIds = Arrays.stream(arrivals).map(v -> v.getDynamicObject("lettercredit")).filter(EmptyUtil::isNoEmpty).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] letterCredits = TmcDataServiceHelper.load((String)"lc_lettercredit", (String)"buyerint", (QFilter[])new QFilter[]{new QFilter("id", "in", letterCreditIds)});
        if (isDelete) {
            LcBuyerIntHelper.removeBuyerInt(arrivals, letterCredits);
        } else {
            for (DynamicObject letterCredit : letterCredits) {
                letterCredit.set("buyerint", (Object)"1");
            }
        }
        SaveServiceHelper.update((DynamicObject[])letterCredits);
    }

    private static void removeBuyerInt(DynamicObject[] arrivals, DynamicObject[] letterCredits) {
        List letterCreditIds = Arrays.stream(letterCredits).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter filter = new QFilter("buyerint", "=", (Object)"1").and("lettercredit", "in", letterCreditIds);
        DynamicObject[] buyerIntArrivals = TmcDataServiceHelper.load((String)"lc_arrival", (String)"id,lettercredit", (QFilter[])new QFilter[]{filter});
        Map letterCreditMap = Arrays.stream(buyerIntArrivals).collect(Collectors.groupingBy(v -> v.getDynamicObject("lettercredit").getPkValue(), Collectors.mapping(DataEntityBase::getPkValue, Collectors.toList())));
        for (DynamicObject arrival : arrivals) {
            Object letterCreditId = arrival.getDynamicObject("lettercredit").getPkValue();
            List arrivalIds = letterCreditMap.get(letterCreditId);
            if (!EmptyUtil.isNoEmpty(arrivalIds)) continue;
            arrivalIds.remove(arrival.getPkValue());
        }
        for (DynamicObject letterCredit : letterCredits) {
            String buyerInt = EmptyUtil.isEmpty((Collection)letterCreditMap.get(letterCredit.getPkValue())) ? "0" : "1";
            letterCredit.set("buyerint", (Object)buyerInt);
        }
    }

    private static DynamicObject[] getArrivalByBuyerInt(DynamicObject[] dataEntities) {
        ArrayList arrivalIds = new ArrayList(16);
        for (DynamicObject buyerInt : dataEntities) {
            DynamicObjectCollection entry = buyerInt.getDynamicObjectCollection("entry");
            arrivalIds.addAll(entry.stream().map(v -> v.getDynamicObject("arrival").getPkValue()).collect(Collectors.toList()));
        }
        return TmcDataServiceHelper.load((String)"lc_arrival", (String)"lettercredit,buyerint,buyerintid,buyerintamt,intcurrency", (QFilter[])new QFilter[]{new QFilter("id", "in", arrivalIds)});
    }
}

