/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BeBillStatusEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.FeeSourceEnum;
import kd.tmc.fbp.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.SuretyBizStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.surety.SuretyDebtEntryStatusInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.BackCreditTypeEnum;
import kd.tmc.lc.common.enums.LetterCreditStatusEnum;
import kd.tmc.lc.common.enums.TradeChannelEnum;
import kd.tmc.lc.common.property.LetterCreditHistoryProp;
import kd.tmc.lc.common.property.LetterCreditProp;

public class LetterCreditHelper {
    private static final Log logger = LogFactory.getLog(LetterCreditHelper.class);

    public static BigDecimal autoUseCreditLimit(DynamicObject bill, boolean isForceCreate, boolean isPreOcupty, BigDecimal creditRatio) {
        QFilter filter = new QFilter("sourcebillid", "=", bill.get("id"));
        DynamicObject creditLimit = bill.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            filter.and(new QFilter("creditlimit", "=", creditLimit.getPkValue()));
        }
        filter.and(new QFilter("returnamt", "=", (Object)Constants.ZERO));
        if (!TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])filter.toArray()) || isForceCreate) {
            CreditLimitUseBean useBean = LetterCreditHelper.getCreditLimitUseInfo(bill, creditRatio, Constants.ZERO);
            useBean.setCreditLimitNo(creditLimit.getString("number"));
            useBean.setPreOccupy(Boolean.valueOf(isPreOcupty));
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
            return useBean.getCreditRatio();
        }
        return LetterCreditHelper.getCreditRatio(bill);
    }

    public static CreditLimitUseBean getCreditLimitUseInfo(DynamicObject bill, BigDecimal creditRatio, BigDecimal doneAmount) {
        CreditLimitUseBean useBean = new CreditLimitUseBean();
        useBean.setPkId(Long.valueOf(bill.getLong("id")));
        useBean.setEntityName(bill.getDataEntityType().getName());
        useBean.setOrgId((Long)bill.getDynamicObject("org").getPkValue());
        useBean.setFinOrgId((Long)bill.getDynamicObject("bank").getPkValue());
        useBean.setCurrencyId((Long)bill.getDynamicObject("currency").getPkValue());
        useBean.setCreditTypeId(LetterCreditHelper.getCreditTypeId(bill));
        useBean.setMaxAmt(LetterCreditHelper.getAmount(bill).subtract(doneAmount));
        useBean.setBizAmt(bill.getBigDecimal("creditamount").subtract(doneAmount));
        DynamicObject creditLimit = bill.getDynamicObject("creditlimit");
        useBean.setCreditLimitId((Long)creditLimit.getPkValue());
        return useBean;
    }

    private static BigDecimal getCreditRatio(DynamicObject bill) {
        String entityName = bill.getDataEntityType().getName();
        DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)((Long)bill.getPkValue()), (String)entityName);
        if (creditUseBill != null) {
            return creditUseBill.getBigDecimal("creditratio");
        }
        return null;
    }

    private static Long getCreditTypeId(DynamicObject letterCredit) {
        DynamicObject creditType = letterCredit.getDynamicObject("credittype");
        DynamicObject creditLimitType = creditType.getDynamicObject("creditlimittype");
        if (EmptyUtil.isEmpty((DynamicObject)creditLimitType)) {
            return null;
        }
        return (Long)creditLimitType.getPkValue();
    }

    public static BigDecimal getAmount(DynamicObject letterCredit) {
        BigDecimal amount = letterCredit.getBigDecimal("amount");
        BigDecimal amountUpper = letterCredit.getBigDecimal("amountscaleupper");
        BigDecimal amt = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP)));
        return amt;
    }

    public static DynamicObject[] queryArrivalInfo(DynamicObject letterCredit) {
        QFilter qFilter = new QFilter("lettercredit", "=", letterCredit.getPkValue());
        return TmcDataServiceHelper.load((String)"lc_arrival", (String)"id,arrivalamount", (QFilter[])qFilter.toArray());
    }

    public static boolean isHaveArrival(DynamicObject letterCredit) {
        QFilter qFilter;
        boolean exists;
        boolean ispay = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit) && (exists = TmcDataServiceHelper.exists((String)"lc_arrival", (QFilter[])(qFilter = new QFilter("lettercredit", "=", letterCredit.getPkValue())).toArray()))) {
            ispay = true;
        }
        return ispay;
    }

    public static boolean isEquals(Object oldVal, Object newVal) {
        if (EmptyUtil.isEmpty((Object)oldVal) && EmptyUtil.isEmpty((Object)newVal)) {
            return true;
        }
        if (EmptyUtil.isEmpty((Object)oldVal) && EmptyUtil.isNoEmpty((Object)newVal)) {
            return false;
        }
        if (EmptyUtil.isNoEmpty((Object)oldVal) && EmptyUtil.isEmpty((Object)newVal)) {
            return false;
        }
        if (oldVal instanceof OrmLocaleValue) {
            return LetterCreditHelper.isEquals(((OrmLocaleValue)oldVal).getLocaleValue(), ((OrmLocaleValue)newVal).getLocaleValue());
        }
        if (oldVal instanceof LocaleDynamicObjectCollection) {
            boolean isEqual = true;
            for (int index = 0; index < ((LocaleDynamicObjectCollection)oldVal).size() && (isEqual = LetterCreditHelper.isEquals(((LocaleDynamicObjectCollection)oldVal).get(index), ((LocaleDynamicObjectCollection)newVal).get(index))); ++index) {
            }
            return isEqual;
        }
        return oldVal.equals(newVal);
    }

    public static void applyEditSaveOrSubmit(DynamicObject applyBill) {
        DynamicObject creditF7 = applyBill.getDynamicObject("lettercredit");
        if (EmptyUtil.isEmpty((DynamicObject)creditF7)) {
            return;
        }
        DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)creditF7.getPkValue(), (String)"lc_lettercredit");
        letterCredit.set("creditstatus", (Object)LetterCreditStatusEnum.CHANGE_ING.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterCredit});
        DynamicObject letterCreditLimit = letterCredit.getDynamicObject("creditlimit");
        DynamicObject applyCreditLimit = applyBill.getDynamicObject("creditlimit");
        QFilter filter = new QFilter("id", "=", (Object)applyBill.getLong("id"));
        DynamicObject dataBase = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"billno,creditlimit,amount,amountscaleupper", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)applyCreditLimit)) {
            Long dataBaseId;
            Long applyLimitId = applyCreditLimit.getLong("id");
            Long letterLimitId = letterCreditLimit.getLong("id");
            if (EmptyUtil.isNoEmpty((DynamicObject)dataBase) && EmptyUtil.isNoEmpty((DynamicObject)dataBase.getDynamicObject("creditlimit")) && (applyLimitId.equals(dataBaseId = Long.valueOf(dataBase.getDynamicObject("creditlimit").getLong("id"))) && !applyLimitId.equals(letterLimitId) || !applyLimitId.equals(dataBaseId) && !dataBaseId.equals(letterLimitId))) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)applyBill, null, (boolean)true);
            }
            if (!applyLimitId.equals(letterLimitId)) {
                BigDecimal creditRatio = LetterCreditHelper.autoUseCreditLimit(applyBill, true, true, null);
                applyBill.set("creditgratio", (Object)creditRatio);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyBill, null, (boolean)true, (Date)applyBill.getDate("bizdate"));
            }
        } else if (EmptyUtil.isEmpty((DynamicObject)letterCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)applyCreditLimit)) {
            if (EmptyUtil.isNoEmpty((DynamicObject)dataBase) && EmptyUtil.isNoEmpty((DynamicObject)dataBase.getDynamicObject("creditlimit"))) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)applyBill, null, (boolean)true);
            }
            BigDecimal creditRatio = LetterCreditHelper.autoUseCreditLimit(applyBill, true, true, null);
            applyBill.set("creditgratio", (Object)creditRatio);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyBill, null, (boolean)true, (Date)applyBill.getDate("bizdate"));
        }
    }

    public static void applyEditSaveOrSubmit_Letter(DynamicObject applyBill, String creditStatus) {
        DynamicObject creditF7 = applyBill.getDynamicObject("lettercredit");
        if (EmptyUtil.isEmpty((DynamicObject)creditF7)) {
            return;
        }
        DynamicObject letterCredit = TmcDataServiceHelper.loadSingle((Object)creditF7.getPkValue(), (String)"lc_lettercredit");
        letterCredit.set("creditstatus", (Object)creditStatus);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterCredit});
    }

    public static String getIsCloseCreditStatus(DynamicObject letterCredit) {
        if (EmptyUtil.isNoEmpty((DynamicObject)letterCredit)) {
            DynamicObject credit = TmcDataServiceHelper.loadSingle((Object)letterCredit.getPkValue(), (String)letterCredit.getDynamicObjectType().getName());
            String creditStatus = credit.getString("creditstatus");
            if (LetterCreditStatusEnum.DONE_CLOSE.getValue().equals(creditStatus)) {
                return credit.getString("billno");
            }
        }
        return "";
    }

    public static void letterCreditSaveProcess(DynamicObject letterCredit, Map<String, String> operationVariable) {
        DynamicObject dataBase;
        String history = operationVariable.get(LetterCreditProp.OP_HISTORY_KEY);
        QFilter filter = new QFilter("id", "=", (Object)letterCredit.getLong("id"));
        DynamicObject oldCreditLimit = dataBase = TmcDataServiceHelper.loadSingle((String)"lc_lettercredit", (String)"id,billno,creditlimit,amount,amountscaleupper,currency,creditamount", (QFilter[])filter.toArray());
        boolean fistSave = false;
        if (EmptyUtil.isNoEmpty((DynamicObject)dataBase)) {
            oldCreditLimit = dataBase.getDynamicObject("creditlimit");
        } else {
            fistSave = true;
        }
        DynamicObject newCreditLimit = letterCredit.getDynamicObject("creditlimit");
        if ("true".equals(history)) {
            Long applyId = Long.parseLong(operationVariable.get("applyId"));
            DynamicObject sourceBill = TmcDataServiceHelper.loadSingle((Object)applyId, (String)"lc_bizapply");
            LetterCreditHelper.changeCreditByApply(sourceBill, letterCredit, dataBase);
        } else {
            DynamicObject applyBill = null;
            String letterApplyNo = letterCredit.getString("creditapplyno");
            if (EmptyUtil.isNoEmpty((String)letterApplyNo)) {
                QFilter qfilter = new QFilter("billno", "=", (Object)letterApplyNo);
                applyBill = TmcDataServiceHelper.loadSingle((String)"lc_bizapply", (String)"id,billno,currency,creditlimit,amount,amountscaleupper,creditgratio,creditamount", (QFilter[])qfilter.toArray());
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)oldCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataBase, null, (boolean)true);
                LetterCreditHelper.autoUseCreditLimit(letterCredit, false, true, null);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)BillStatusEnum.isSave((String)letterCredit.getString("billstatus")), (Date)letterCredit.getDate("bizdate"));
            } else if (EmptyUtil.isEmpty((DynamicObject)oldCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
                LetterCreditHelper.letterConfirmCredit(applyBill, letterCredit, fistSave);
            } else if (EmptyUtil.isNoEmpty((DynamicObject)oldCreditLimit)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)dataBase, null, (boolean)true);
                LetterCreditHelper.deleteCreditUse(dataBase.getDataEntityType().getName(), dataBase.getLong("id"));
            }
        }
        for (DynamicObject entry : letterCredit.getDynamicObjectCollection("entrys")) {
            if (!EmptyUtil.isEmpty((Long)entry.getLong(LetterCreditHistoryProp.SOURCEENTRYID))) continue;
            entry.set(LetterCreditHistoryProp.SOURCEENTRYID, (Object)entry.getLong("id"));
        }
    }

    private static void letterConfirmCredit(DynamicObject applyBill, DynamicObject letterCredit, boolean fistSave) {
        BigDecimal creditRatio = null;
        logger.info("creditRatio=============begin");
        DynamicObject creditUseApplyBill = null;
        if (fistSave && EmptyUtil.isNoEmpty((DynamicObject)applyBill) && EmptyUtil.isNoEmpty((DynamicObject)applyBill.getDynamicObject("creditlimit"))) {
            BigDecimal letterAmt;
            BigDecimal amt = applyBill.getBigDecimal("creditamount");
            if (amt.compareTo(letterAmt = letterCredit.getBigDecimal("creditamount")) == 0) {
                creditUseApplyBill = LetterCreditHelper.getCreditUse(applyBill.getLong("id"), applyBill.getDataEntityType().getName());
            }
            CreditLimitServiceHelper.returnCreditLimit((DynamicObject)letterCredit, (DynamicObject)applyBill, (boolean)true, (BigDecimal)amt, null, (boolean)true, (Date)letterCredit.getDate("bizdate"));
            creditRatio = applyBill.getBigDecimal("creditgratio");
        }
        logger.info("creditRatio=============end" + creditRatio);
        boolean isSave = BillStatusEnum.isSave((String)letterCredit.getString("billstatus"));
        if (EmptyUtil.isNoEmpty(creditUseApplyBill)) {
            DynamicObject letterCreditUse = TmcDataServiceHelper.clone(creditUseApplyBill);
            letterCreditUse.set("sourcebillid", (Object)letterCredit.getLong("id"));
            letterCreditUse.set("sourcebillentryid", (Object)letterCredit.getLong("id"));
            letterCreditUse.set("sourcetype", (Object)letterCredit.getDynamicObjectType().getName());
            letterCreditUse.set("sourcename", letterCredit.getDynamicObjectType().getDisplayName() == null ? null : letterCredit.getDynamicObjectType().getDisplayName().getLocaleValue());
            letterCreditUse.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{letterCreditUse});
        } else {
            LetterCreditHelper.autoUseCreditLimit(letterCredit, true, isSave, creditRatio);
        }
        CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)isSave, (Date)letterCredit.getDate("bizdate"));
    }

    private static void changeCreditByApply(DynamicObject sourceBill, DynamicObject letterCredit, DynamicObject dataBase) {
        DynamicObject oldCreditLimit = dataBase.getDynamicObject("creditlimit");
        DynamicObject newCreditLimit = sourceBill.getDynamicObject("creditlimit");
        boolean haveArrival = LetterCreditHelper.isHaveArrival(letterCredit);
        if (EmptyUtil.isNoEmpty((DynamicObject)oldCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
            Long oldId = oldCreditLimit.getLong("id");
            Long newId = newCreditLimit.getLong("id");
            BigDecimal oldAmt = LetterCreditHelper.getAmount(dataBase);
            BigDecimal newAmt = LetterCreditHelper.getAmount(letterCredit);
            BigDecimal oldCreditAmt = dataBase.getBigDecimal("creditamount");
            BigDecimal newCreditAmt = letterCredit.getBigDecimal("creditamount");
            String oldCurNum = dataBase.getDynamicObject("currency").getString("number");
            String nowCurNum = letterCredit.getDynamicObject("currency").getString("number");
            if (oldId.equals(newId) && oldAmt.compareTo(newAmt) != 0 && oldCreditAmt.compareTo(newCreditAmt) == 0) {
                CreditLimitServiceHelper.updateCreditLimitUse((String)"lc_lettercredit", (Long)letterCredit.getLong("id"), (BigDecimal)newAmt, (boolean)false);
            } else if (oldId.equals(newId) && oldAmt.compareTo(newAmt) == 0 && oldCreditAmt.compareTo(newCreditAmt) == 0 && !oldCurNum.equals(nowCurNum)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
                LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, sourceBill.getBigDecimal("creditgratio"));
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
            }
            if (!haveArrival && !oldId.equals(newId)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)sourceBill, null, (boolean)true);
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
                LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, sourceBill.getBigDecimal("creditgratio"));
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
            }
        } else if (EmptyUtil.isEmpty((DynamicObject)oldCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)sourceBill, null, (boolean)true);
            LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, sourceBill.getBigDecimal("creditgratio"));
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
        } else if (EmptyUtil.isNoEmpty((DynamicObject)oldCreditLimit)) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
        }
    }

    public static void changeUnAuditCreditLimit(DynamicObject letterCredit, DynamicObject applyBill) {
        DynamicObject newCreditLimit = letterCredit.getDynamicObject("creditlimit");
        DynamicObject applyCreditLimit = applyBill.getDynamicObject("creditlimit");
        boolean haveArrival = LetterCreditHelper.isHaveArrival(letterCredit);
        if (EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)applyCreditLimit)) {
            Long oldId = applyCreditLimit.getLong("id");
            Long newId = newCreditLimit.getLong("id");
            BigDecimal oldAmt = LetterCreditHelper.getAmount(applyBill);
            BigDecimal newAmt = LetterCreditHelper.getAmount(letterCredit);
            BigDecimal oldCreditAmt = applyBill.getBigDecimal("creditamount");
            BigDecimal newCreditAmt = letterCredit.getBigDecimal("creditamount");
            String oldCurNum = applyBill.getDynamicObject("currency").getString("number");
            String nowCurNum = letterCredit.getDynamicObject("currency").getString("number");
            if (oldId.equals(newId) && oldAmt.compareTo(newAmt) != 0 && oldCreditAmt.compareTo(newCreditAmt) == 0) {
                CreditLimitServiceHelper.updateCreditLimitUse((String)"lc_lettercredit", (Long)letterCredit.getLong("id"), (BigDecimal)newAmt, (boolean)false);
            } else if (oldId.equals(newId) && oldAmt.compareTo(newAmt) == 0 && oldCreditAmt.compareTo(newCreditAmt) == 0 && !oldCurNum.equals(nowCurNum)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
                LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, applyBill.getBigDecimal("creditgratio"));
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
            }
            if (!haveArrival && !oldId.equals(newId)) {
                CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
                LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, null);
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
                LetterCreditHelper.autoUseCreditLimit(applyBill, true, true, applyBill.getBigDecimal("creditgratio"));
                CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyBill, null, (boolean)true, (Date)applyBill.getDate("bizdate"));
            }
        } else if (EmptyUtil.isEmpty((DynamicObject)applyCreditLimit) && EmptyUtil.isNoEmpty((DynamicObject)newCreditLimit)) {
            LetterCreditHelper.autoUseCreditLimit(letterCredit, true, false, null);
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)letterCredit, null, (boolean)false, (Date)letterCredit.getDate("bizdate"));
        } else if (EmptyUtil.isNoEmpty((DynamicObject)applyCreditLimit)) {
            CreditLimitServiceHelper.cancelCreditLimit((DynamicObject)letterCredit, null, (boolean)false);
            LetterCreditHelper.autoUseCreditLimit(applyBill, true, true, applyBill.getBigDecimal("creditgratio"));
            CreditLimitServiceHelper.confirmCreditLimit((DynamicObject)applyBill, null, (boolean)true, (Date)applyBill.getDate("bizdate"));
        }
    }

    public static void setDefaultBillType(IDataModel model) {
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong("1173859806029548544"));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject billType = TmcDataServiceHelper.loadSingleFromCache((String)"lc_billtype", (QFilter[])qFilter.toArray());
        model.setValue("credittype", (Object)billType);
        model.setDataChanged(false);
    }

    public static boolean checkIsforward(DynamicObject bill) {
        int forwardDays;
        boolean isForward = bill.getBoolean("isforward");
        boolean result = false;
        if (isForward && (forwardDays = bill.getInt("forwarddays")) == 0) {
            result = true;
        }
        return result;
    }

    public static DynamicObject getLetterInfo(Long pkId, boolean loadSuretyInfo) {
        QFilter qFilter;
        Object[] creditUses;
        DynamicObject letterInfo = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"lc_lettercredit");
        GuaranteeUseHelper.genContractUseInfo((DynamicObject)letterInfo);
        if (loadSuretyInfo) {
            LetterCreditHelper.setFeeInfo(letterInfo);
            SuretyHelper.setSuretyInfo((DynamicObject)letterInfo);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)letterInfo) && EmptyUtil.isNoEmpty((DynamicObject)letterInfo.getDynamicObject("creditlimit")) && EmptyUtil.isNoEmpty((Object[])(creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"sourcebillentryid,currency,realamt", (QFilter[])new QFilter[]{qFilter = new QFilter("sourcebillid", "=", letterInfo.getPkValue()).and(new QFilter("isrelease", "=", (Object)"0")).and(new QFilter("creditlimit.isclose", "=", (Object)"0"))})))) {
            Object creditUse = creditUses[0];
            letterInfo.set("creditcurrency", (Object)creditUse.getDynamicObject("currency"));
            letterInfo.set("creditamt", (Object)creditUse.getBigDecimal("realamt"));
        }
        return letterInfo;
    }

    public static void setFeeInfo(DynamicObject letterInfo) {
        Object[] feeBills;
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "=", letterInfo.getPkValue());
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)FeeSourceEnum.LINKGEN.getValue()).or(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("feesource", "in", Arrays.asList(FeeSourceEnum.HAND.getValue(), FeeSourceEnum.BIZPATCH.getValue(), FeeSourceEnum.BATCHINPUT.getValue()))));
        QFilter arrivalQFilter = new QFilter("lettercredit", "=", letterInfo.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("arrivalstatus", "in", Arrays.asList(ArrivalStatusEnum.ARRIVAL_CONFIRM.getValue(), ArrivalStatusEnum.ARRIVAL_PAY.getValue()));
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"id", (QFilter[])arrivalQFilter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)arrivalBills)) {
            List arrivalBillIds = arrivalBills.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            feeIdFilter.or("entry.srcbillid", "in", arrivalBillIds);
        }
        if (EmptyUtil.isEmpty((Object[])(feeBills = BusinessDataServiceHelper.load((String)"cfm_feebill", (String)"id,billno,org,feescheme,feetype,paydate,currency,amountrate,payamt,feeacctbank,settlementtype,oppunittype,oppunit,oppunittext,oppacctbank,oppbebank,sharetype,issettle,feesource,description,entry.id,entry.producttype,entry.srcbillno,entry.srcbillid,entry.feedetailamt,entry.remark,entry.srcstatus,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter}, (String)"modifytime asc")))) {
            return;
        }
        DynamicObjectCollection feeDetail = letterInfo.getDynamicObjectCollection("feedetail");
        for (Object feeBill : feeBills) {
            DynamicObjectCollection feeEntrys = feeBill.getDynamicObjectCollection("entry");
            for (DynamicObject feeEntry : feeEntrys) {
                DynamicObject addNew = feeDetail.addNew();
                String productTypeId = String.valueOf(feeEntry.getDynamicObject("producttype").get("id"));
                ProductTypeEnum typeEnum = ProductTypeEnum.getEnumById((String)String.valueOf(productTypeId));
                addNew.set("feeproducttype", (Object)typeEnum.getValue());
                addNew.set("feescheme", (Object)feeBill.getDynamicObject("feescheme"));
                addNew.set("feetype", (Object)feeBill.getDynamicObject("feetype"));
                addNew.set("feepaydate", (Object)feeBill.getDate("paydate"));
                addNew.set("feecurrency", (Object)feeBill.getDynamicObject("currency"));
                addNew.set("feeamt", (Object)feeEntry.getBigDecimal("feedetailamt"));
                addNew.set("feerate", (Object)feeBill.getBigDecimal("amountrate"));
                addNew.set("feesettletype", (Object)feeBill.getDynamicObject("settlementtype"));
                addNew.set("feeacctbank", (Object)feeBill.getDynamicObject("feeacctbank"));
                addNew.set("feeoppunittype", (Object)feeBill.getString("oppunittype"));
                addNew.set("feeoppunit", (Object)feeBill.getDynamicObject("oppunit"));
                addNew.set("feeoppunittext", (Object)feeBill.getString("oppunittext"));
                addNew.set("feeoppacctbank", (Object)feeBill.getString("oppacctbank"));
                addNew.set("feeoppbebank", (Object)feeBill.getDynamicObject("oppbebank"));
                addNew.set("feeissettle", (Object)feeBill.getBoolean("issettle"));
                addNew.set("feesource", (Object)feeBill.getString("feesource"));
                addNew.set("feeremark", (Object)feeEntry.getString("remark"));
                addNew.set("feebillnum", (Object)feeBill.getString("billno"));
                addNew.set("feebillid", (Object)feeBill.getLong("id"));
                addNew.set("feebillentryid", (Object)feeEntry.getLong("id"));
                addNew.set("feenumber", (Object)feeBill.getString("billno"));
                addNew.set("excrate", (Object)feeEntry.getBigDecimal("excrate"));
            }
        }
    }

    public static void updateSuretyStatus(DynamicObject creditBill, String creditStatus) {
        SuretyDebtEntryStatusInfo param = new SuretyDebtEntryStatusInfo();
        param.setId(Long.valueOf(creditBill.getLong("id")));
        param.setEntityName(creditBill.getDataEntityType().getName());
        param.setBizStatus(creditStatus);
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"fbd", (String)"suretyService", (String)"updateDebtStatus", (Object[])new Object[]{param});
    }

    public static void deleteCreditUse(String billType, long billId) {
        DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)billId), new QFilter("sourcetype", "=", (Object)billType), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())});
    }

    public static String checkCreditlimit(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        DynamicObject creditLimit = bill.getDynamicObject("creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObject)creditLimit)) {
            long applyLimit;
            String creditApplyNo;
            DynamicObjectCollection applyBill;
            long creditLimitBankCateId;
            DynamicObject org;
            DynamicObject currency;
            DynamicObject bank;
            DynamicObject credType;
            DynamicObject creditUseBill = CreditLimitServiceHelper.getCreditUseBill((Long)bill.getLong("id"), (String)bill.getDataEntityType().getName());
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUseBill)) {
                return "";
            }
            DataEntityPropertyCollection properties = bill.getDataEntityType().getProperties();
            StringBuilder msgStr = new StringBuilder();
            if (EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("amount"))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "amount", ResManager.loadKDString((String)"\u91d1\u989d\u3001", (String)"LetterCreditHelper_0", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isEmpty((BigDecimal)bill.getBigDecimal("creditamount"))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "creditamount", ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u3001", (String)"LetterCreditHelper_10", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(credType = bill.getDynamicObject("credittype")))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "credittype", ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u7c7b\u578b\u3001", (String)"LetterCreditHelper_1", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(bank = bill.getDynamicObject("bank")))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "bank", ResManager.loadKDString((String)"\u5f00\u8bc1\u884c\u3001", (String)"LetterCreditHelper_3", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(currency = bill.getDynamicObject("currency")))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "currency", ResManager.loadKDString((String)"\u5e01\u79cd\u3001", (String)"LetterCreditHelper_4", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isEmpty((DynamicObject)(org = bill.getDynamicObject("org")))) {
                msgStr.append(LetterCreditHelper.getLocalName(properties, "org", ResManager.loadKDString((String)"\u5f00\u8bc1\u4eba\u3001", (String)"LetterCreditHelper_5", (String)"tmc-lc-common", (Object[])new Object[0])));
            }
            if (EmptyUtil.isNoEmpty((String)msgStr.toString())) {
                return ResManager.loadKDString((String)"\u8bf7\u586b\u5199%s\u3002", (String)"LetterCreditHelper_6", (String)"tmc-lc-common", (Object[])new Object[]{msgStr.substring(0, msgStr.length() - 1)});
            }
            String billStatus = creditLimit.getString("status");
            String number = creditLimit.getString("number");
            if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                return ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"LetterCreditHelper_7", (String)"tmc-lc-common", (Object[])new Object[]{number});
            }
            boolean isClose = creditLimit.getBoolean("isclose");
            if (isClose) {
                return ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u5df2\u5173\u95ed\u3002", (String)"LetterCreditHelper_8", (String)"tmc-lc-common", (Object[])new Object[]{number});
            }
            long useBankCateId = LetterCreditHelper.getBankCateIdByFinOrgId(bank.getLong("id"));
            if (useBankCateId != (creditLimitBankCateId = LetterCreditHelper.getBankCateIdByFinOrgId((Long)creditLimit.getDynamicObject("bank").getPkValue()))) {
                return ResManager.loadKDString((String)"\u5f00\u8bc1\u884c\u548c\u5360\u7528\u6388\u4fe1\u7684\u6388\u4fe1\u673a\u6784\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e0d\u5339\u914d\u3002", (String)"LetterCreditHelper_9", (String)"tmc-lc-common", (Object[])new Object[0]);
            }
            CreditLimitUseBean bean = new CreditLimitUseBean();
            bean.setPkId(Long.valueOf(bill.getLong("id")));
            DynamicObject creditLimitType = credType.getDynamicObject("creditlimittype");
            bean.setCreditTypeId(Long.valueOf(creditLimitType != null ? creditLimitType.getLong("id") : 0L));
            bean.setOrgId(Long.valueOf(org.getLong("id")));
            bean.setCurrencyId(Long.valueOf(currency.getLong("id")));
            bean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
            bean.setBizAmt(bill.getBigDecimal("creditamount"));
            Long pkId = bean.getPkId();
            String type = bill.getDataEntityType().getName();
            if ("lc_lettercredit".equals(bill.getDynamicObjectType().getName()) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(applyBill = QueryServiceHelper.query((String)"lc_bizapply", (String)"id,creditlimit", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)(creditApplyNo = bill.getString("creditapplyno")))}))) && EmptyUtil.isNoEmpty((Long)(applyLimit = ((DynamicObject)applyBill.get(0)).getLong("creditlimit")))) {
                if (creditLimit.getLong("id") == applyLimit) {
                    return "";
                }
                pkId = ((DynamicObject)applyBill.get(0)).getLong("id");
                type = "lc_bizapply";
            }
            bean.setSourceBillId(pkId);
            bean.setSourceType(type);
            bean.setCreditRatio(Constants.ONE_HUNDRED);
            CreditLimitF7ResBean result = CreditLimitServiceHelper.validataCreditLimitAmt((CreditLimitUseBean)bean);
            if (!result.getSuccess().booleanValue()) {
                return result.getMsg();
            }
        }
        return "";
    }

    private static String getLocalName(DataEntityPropertyCollection properties, String field, String defaultStr) {
        IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)field);
        if (property == null || property.getDisplayName() == null) {
            return defaultStr;
        }
        return property.getDisplayName().getLocaleValue() + "\u3001";
    }

    public static String checkContainsSurety(DynamicObject letterCredit) {
        DynamicObjectCollection suretyEntry = letterCredit.getDynamicObjectCollection("entry_surety");
        QFilter suretyFilter = null;
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)suretyEntry)) {
            DynamicObject suretyBillF7 = ((DynamicObject)suretyEntry.get(0)).getDynamicObject("suretybill");
            if (EmptyUtil.isNoEmpty((DynamicObject)suretyBillF7)) {
                suretyFilter = new QFilter("id", "=", suretyBillF7.getPkValue());
            }
        } else {
            suretyFilter = new QFilter("entry.debttype", "=", (Object)"lc_lettercredit");
            suretyFilter.and("entry.debtbillid", "=", letterCredit.getPkValue());
            suretyFilter.and("enable", "=", (Object)true);
            suretyFilter.and("bizstatus", "in", Arrays.asList(SuretyBizStatusEnum.SURETY_DONE.getValue(), SuretyBizStatusEnum.SURETY_PART.getValue(), SuretyBizStatusEnum.SURETY_END.getValue()));
        }
        if (suretyFilter == null) {
            return "";
        }
        DynamicObject suretyBill = QueryServiceHelper.queryOne((String)"fbd_suretybill", (String)String.join((CharSequence)",", "currency", "surplusamount"), (QFilter[])new QFilter[]{suretyFilter});
        if (EmptyUtil.isEmpty((DynamicObject)suretyBill)) {
            return "";
        }
        String guaWay = letterCredit.getString("guarantee");
        List guaWayList = Arrays.stream(guaWay.split(",")).filter(r -> EmptyUtil.isNoEmpty((String)r)).collect(Collectors.toList());
        BigDecimal proMisRate = letterCredit.getBigDecimal("promisrate");
        if (!guaWayList.contains(GuaranteeWayEnum.ENSUAMT.getNumberValue()) || EmptyUtil.isEmpty((BigDecimal)proMisRate) || proMisRate.compareTo(Constants.ZERO) == 0) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u62c5\u4fdd\u65b9\u5f0f\u5305\u542b\u4fdd\u8bc1\u91d1\uff0c\u4e14\u4fdd\u8bc1\u91d1\u6bd4\u4f8b\u5927\u4e8e0\uff0c\u624d\u5141\u8bb8\u5b58\u5165\u4fdd\u8bc1\u91d1\u3002", (String)"LetterCreditHelper_12", (String)"tmc-lc-common", (Object[])new Object[0]);
        }
        Long currencyId = suretyBill.getLong("currency");
        DynamicObject suretyCurDo = letterCredit.getDynamicObject("suretycur");
        if (EmptyUtil.isEmpty((DynamicObject)suretyCurDo) || !currencyId.equals(suretyCurDo.getLong("id"))) {
            return ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u5e01\u79cd\u4e0e\u6240\u9009\u62e9\u7684\u4fdd\u8bc1\u91d1\u5206\u5f55\u4e2d\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditHelper_13", (String)"tmc-lc-common", (Object[])new Object[0]);
        }
        BigDecimal surplusAmount = suretyBill.getBigDecimal("surplusamount");
        if (surplusAmount.compareTo(letterCredit.getBigDecimal("suretymoney")) < 0) {
            return ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u521d\u59cb\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4fdd\u8bc1\u91d1\u5b58\u5165\u5355\u7684\u5269\u4f59\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LetterCreditHelper_14", (String)"tmc-lc-common", (Object[])new Object[0]);
        }
        return "";
    }

    private static long getBankCateIdByFinOrgId(Long finOrgId) {
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo", (String)"id,bank_cate");
        DynamicObject bankCate = finOrg.getDynamicObject("bank_cate");
        long bankCateId = bankCate != null ? bankCate.getLong("id") : 0L;
        return bankCateId;
    }

    public static void updateLetterArr(String entityName, Map<Long, BigDecimal> letterArrMap) {
        DynamicObject[] letterBills;
        if (letterArrMap.size() == 0) {
            return;
        }
        Set letterIds = letterArrMap.keySet().stream().collect(Collectors.toSet());
        for (DynamicObject letterBill : letterBills = TmcDataServiceHelper.load((String)entityName, (String)"amount,amountscaleupper,totalarramount,notarramount", (QFilter[])new QFilter[]{new QFilter("id", "in", letterIds)})) {
            BigDecimal arrAmount = letterArrMap.get(letterBill.getLong("id"));
            BigDecimal totalArrAmount = letterBill.getBigDecimal("totalarramount").add(arrAmount);
            letterBill.set("totalarramount", (Object)(totalArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalArrAmount));
            BigDecimal notArrAmount = letterBill.getBigDecimal("notarramount").subtract(arrAmount);
            if (EmptyUtil.isEmpty((BigDecimal)totalArrAmount)) {
                notArrAmount = LetterCreditHelper.getAmount(letterBill);
            }
            letterBill.set("notarramount", (Object)(notArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : notArrAmount));
        }
        SaveServiceHelper.update((DynamicObject[])letterBills);
    }

    public static void updateLetterArr(String entityName, Map<Long, BigDecimal> letterArrMap, Map<Long, Date> letterDateArrMap) {
        DynamicObject[] letterBills;
        if (letterArrMap.size() == 0) {
            return;
        }
        Set letterIds = letterArrMap.keySet().stream().collect(Collectors.toSet());
        for (DynamicObject letterBill : letterBills = TmcDataServiceHelper.load((String)entityName, (String)"amount,amountscaleupper,totalarramount,notarramount,negotiatingdate", (QFilter[])new QFilter[]{new QFilter("id", "in", letterIds)})) {
            BigDecimal arrAmount = letterArrMap.get(letterBill.getLong("id"));
            BigDecimal totalArrAmount = letterBill.getBigDecimal("totalarramount").add(arrAmount);
            letterBill.set("totalarramount", (Object)(totalArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : totalArrAmount));
            BigDecimal notArrAmount = letterBill.getBigDecimal("notarramount").subtract(arrAmount);
            if (EmptyUtil.isEmpty((BigDecimal)totalArrAmount)) {
                notArrAmount = LetterCreditHelper.getAmount(letterBill);
            }
            letterBill.set("notarramount", (Object)(notArrAmount.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : notArrAmount));
            Date negotiatingDate = letterDateArrMap.get(letterBill.getLong("id"));
            if (!EmptyUtil.isNoEmpty((Object)negotiatingDate)) continue;
            letterBill.set("negotiatingdate", (Object)negotiatingDate);
        }
        SaveServiceHelper.update((DynamicObject[])letterBills);
    }

    public static void updateLetterCreditLimit(String entityName, Long letterId, DynamicObject arrivalBill, boolean isRelease) {
        DynamicObject[] letterBills;
        if (EmptyUtil.isEmpty((Long)letterId) || EmptyUtil.isEmpty((DynamicObject)arrivalBill)) {
            return;
        }
        for (DynamicObject letterBill : letterBills = TmcDataServiceHelper.load((String)entityName, (String)"billno,creditlimit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)letterId)})) {
            BigDecimal arrAmount;
            DynamicObject creditLimitDo = letterBill.getDynamicObject("creditlimit");
            if (EmptyUtil.isEmpty((DynamicObject)creditLimitDo) || BigDecimal.ZERO.compareTo(arrAmount = arrivalBill.getBigDecimal("arrivalamount")) == 0) continue;
            if (isRelease) {
                CreditLimitServiceHelper.returnCreditLimit((DynamicObject)letterBill, (DynamicObject)letterBill, (boolean)false, (BigDecimal)arrAmount, (Long)((Long)arrivalBill.getPkValue()), (boolean)false, (Date)new Date());
                continue;
            }
            CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)letterBill, (DynamicObject)letterBill, (boolean)false, (BigDecimal)arrAmount, (Long)((Long)arrivalBill.getPkValue()));
        }
    }

    public static void updateLetterDateArr(String entityName, Map<Long, Date> letterDateArrMap) {
        DynamicObject[] letterBills;
        if (letterDateArrMap.size() == 0) {
            return;
        }
        for (DynamicObject letterBill : letterBills = TmcDataServiceHelper.load((String)entityName, (String)"negotiatingdate", (QFilter[])new QFilter[]{new QFilter("id", "in", letterDateArrMap.keySet())})) {
            letterBill.set("negotiatingdate", (Object)letterDateArrMap.get(letterBill.getLong("id")));
        }
        SaveServiceHelper.update((DynamicObject[])letterBills);
    }

    public static boolean checkPayamount(DynamicObject letterCredit, BigDecimal payAmount) {
        BigDecimal amount = LetterCreditHelper.getAmount(letterCredit);
        DynamicObjectCollection arrPayBills = QueryServiceHelper.query((String)"lc_arrival", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("lettercredit", "=", (Object)letterCredit.getLong("id")), new QFilter("doneamount", ">", (Object)BigDecimal.ZERO)});
        BigDecimal payedAmount = arrPayBills.parallelStream().map(o -> o.getBigDecimal("doneamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal notPayAmount = amount.subtract(payedAmount).subtract(payAmount);
        return notPayAmount.compareTo(BigDecimal.ZERO) <= 0;
    }

    public static void deleteBotpRation(String currEntity, Long currBillId, String sourceEntity, Long letterId) {
        DynamicObject sourBill;
        boolean isLetter = QueryServiceHelper.exists((String)currEntity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currBillId), new QFilter("lettercredit", "!=", (Object)letterId)});
        if (isLetter && EmptyUtil.isNoEmpty((DynamicObject)(sourBill = TmcBotpHelper.getSourceBill((String)currEntity, (Object)currBillId, (String)sourceEntity)))) {
            TmcBotpHelper.deleteRation((String)currEntity, (Long)sourBill.getLong("id"), (Long)currBillId);
        }
    }

    public static void deleteBotpRation(Object letterId) {
        Long letterCreditId = (Long)letterId;
        DynamicObject sourBill = TmcBotpHelper.getSourceBill((String)"lc_lettercredit", (Object)letterCreditId, (String)"lc_receipt");
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            TmcBotpHelper.deleteRation((String)"lc_lettercredit", (Long)sourBill.getLong("id"), (Long)letterCreditId);
        }
    }

    public static boolean checkIsExist(String entityName, String billNo, String creditNo) {
        QFilter qFilter = null;
        if (EmptyUtil.isNoEmpty((String)billNo)) {
            qFilter = new QFilter("billno", "=", (Object)billNo);
        }
        if (EmptyUtil.isNoEmpty((String)creditNo)) {
            qFilter = new QFilter("creditno", "=", (Object)creditNo);
        }
        if (qFilter == null) {
            return false;
        }
        return QueryServiceHelper.exists((String)entityName, (QFilter[])new QFilter[]{qFilter});
    }

    public static void initCreditInfo(IFormView formView, IDataModel model, DynamicObject motherCredit, DynamicObject childCredit, Map<Object, BigDecimal> payAmountMap, int rowIndex) {
        TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_org", "b_benefiter"}, (boolean)Boolean.TRUE);
        TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_orgother", "b_benefiterother"}, (boolean)Boolean.FALSE);
        String backCreditType = (String)model.getValue("backcredittype");
        boolean isChanged = model.getDataChanged();
        if (BackCreditTypeEnum.CHILD_CREDIT.getValue().equals(backCreditType) && EmptyUtil.isNoEmpty((DynamicObject)motherCredit)) {
            BigDecimal amount = motherCredit.getBigDecimal("amount");
            BigDecimal payAmountSum = EmptyUtil.isEmpty((BigDecimal)payAmountMap.get(motherCredit.getPkValue())) ? Constants.ZERO : payAmountMap.get(motherCredit.getPkValue());
            BigDecimal amountUpper = motherCredit.getBigDecimal("amountscaleupper");
            BigDecimal actualAmount = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP)));
            model.setValue("b_creditstatus", (Object)motherCredit.getString("creditstatus"), rowIndex);
            model.setValue("b_creditno", (Object)motherCredit.getString("number"), rowIndex);
            model.setValue("b_credittype", (Object)motherCredit.getDynamicObject("credittype"), rowIndex);
            model.setValue("b_org", (Object)motherCredit.getDynamicObject("benefiter"), rowIndex);
            model.setValue("b_orgother", (Object)motherCredit.getString("benefiterother"), rowIndex);
            model.setValue("b_benefiter", (Object)motherCredit.getDynamicObject("org"), rowIndex);
            TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_org"}, (boolean)"bos_org".equals(motherCredit.getString("benefitertype")));
            TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_orgother"}, (!"bos_org".equals(motherCredit.getString("benefitertype")) ? 1 : 0) != 0);
            model.setValue("b_currency", (Object)motherCredit.getDynamicObject("currency"), rowIndex);
            model.setValue("b_ramount", (Object)amount, rowIndex);
            model.setValue("b_totalpreamount", (Object)motherCredit.getBigDecimal("totalarramount"), rowIndex);
            model.setValue("b_rpayamount", (Object)payAmountSum, rowIndex);
            model.setValue("b_rnopayamount", (Object)actualAmount.subtract(payAmountSum), rowIndex);
            model.setValue("b_childcredit", null, rowIndex);
            model.setValue("b_camount", null, rowIndex);
            model.setValue("b_totalarramount", null, rowIndex);
            model.setValue("b_cpayamount", null, rowIndex);
            model.setValue("b_cnopayamount", null, rowIndex);
        } else if (BackCreditTypeEnum.MOTHER_CREDIT.getValue().equals(backCreditType) && EmptyUtil.isNoEmpty((DynamicObject)childCredit)) {
            BigDecimal amount = childCredit.getBigDecimal("amount");
            BigDecimal payAmountSum = EmptyUtil.isEmpty((BigDecimal)payAmountMap.get(childCredit.getPkValue())) ? Constants.ZERO : payAmountMap.get(childCredit.getPkValue());
            BigDecimal amountUpper = childCredit.getBigDecimal("amountscaleupper");
            BigDecimal actualAmount = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 4, RoundingMode.HALF_UP)));
            model.setValue("b_creditstatus", (Object)childCredit.getString("creditstatus"), rowIndex);
            model.setValue("b_creditno", (Object)childCredit.getString("number"), rowIndex);
            model.setValue("b_credittype", (Object)childCredit.getDynamicObject("credittype"), rowIndex);
            model.setValue("b_org", (Object)childCredit.getDynamicObject("org"), rowIndex);
            model.setValue("b_benefiter", (Object)childCredit.getDynamicObject("benefiter"), rowIndex);
            model.setValue("b_benefiterother", (Object)childCredit.getString("benefiterother"), rowIndex);
            TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_benefiter"}, (boolean)"bos_org".equals(childCredit.getString("benefitertype")));
            TmcViewInputHelper.registerVisibleStatus((IFormView)formView, (String[])new String[]{"b_benefiterother"}, (!"bos_org".equals(childCredit.getString("benefitertype")) ? 1 : 0) != 0);
            model.setValue("b_currency", (Object)childCredit.getDynamicObject("currency"), rowIndex);
            model.setValue("b_camount", (Object)amount, rowIndex);
            model.setValue("b_totalarramount", (Object)childCredit.getBigDecimal("totalarramount"), rowIndex);
            model.setValue("b_cpayamount", (Object)payAmountSum, rowIndex);
            model.setValue("b_cnopayamount", (Object)actualAmount.subtract(payAmountSum), rowIndex);
            model.setValue("b_mothercredit", null, rowIndex);
            model.setValue("b_ramount", null, rowIndex);
            model.setValue("b_totalpreamount", null, rowIndex);
            model.setValue("b_rpayamount", null, rowIndex);
            model.setValue("b_rnopayamount", null, rowIndex);
        } else if (EmptyUtil.isEmpty((DynamicObject)motherCredit) && EmptyUtil.isEmpty((DynamicObject)childCredit)) {
            model.setValue("b_creditstatus", null, rowIndex);
            model.setValue("b_creditno", null, rowIndex);
            model.setValue("b_credittype", null, rowIndex);
            model.setValue("b_org", null, rowIndex);
            model.setValue("b_benefiter", null, rowIndex);
            model.setValue("b_benefiterother", null, rowIndex);
            model.setValue("b_currency", null, rowIndex);
            model.setValue("b_ramount", null, rowIndex);
            model.setValue("b_totalpreamount", null, rowIndex);
            model.setValue("b_rpayamount", null, rowIndex);
            model.setValue("b_rnopayamount", null, rowIndex);
            model.setValue("b_camount", null, rowIndex);
            model.setValue("b_totalarramount", null, rowIndex);
            model.setValue("b_cpayamount", null, rowIndex);
            model.setValue("b_cnopayamount", null, rowIndex);
        }
        if (!isChanged) {
            model.setDataChanged(false);
        }
    }

    public static boolean hyperLink(String appId, String fieldName, DynamicObject creditDo) {
        if (!"b_mothercredit".equals(fieldName) && !"b_childcredit".equals(fieldName)) {
            return false;
        }
        boolean isMother = "b_mothercredit".equals(fieldName);
        long userId = RequestContext.get().getCurrUserId();
        String formId = isMother ? "lc_receipt" : "lc_lettercredit";
        long orgId = creditDo.getDynamicObject("org").getLong("id");
        return TmcOrgDataHelper.hasPermission((String)appId, (long)userId, (long)orgId, (String)formId, (String)"47150e89000000ac");
    }

    public static void writeBackChildCredit(DynamicObject receiptBill) {
        if (!receiptBill.getBoolean("isbackcredit")) {
            return;
        }
        DynamicObjectCollection backCreditCollection = receiptBill.getDynamicObjectCollection("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditCollection)) {
            return;
        }
        ArrayList<DynamicObject> bizDoList = new ArrayList<DynamicObject>(backCreditCollection.size());
        for (DynamicObject backCredit : backCreditCollection) {
            DynamicObject letterCreditDo;
            if (!BackCreditTypeEnum.MOTHER_CREDIT.getValue().equals(receiptBill.getString("backcredittype")) || !EmptyUtil.isNoEmpty((DynamicObject)(letterCreditDo = backCredit.getDynamicObject("b_childcredit")))) continue;
            letterCreditDo = TmcDataServiceHelper.loadSingle((Object)letterCreditDo.getPkValue(), (String)"lc_lettercredit");
            DynamicObjectCollection backCreditArr = letterCreditDo.getDynamicObjectCollection("entry_backcredit");
            DynamicObject newChildCredit = backCreditArr.addNew();
            newChildCredit.set("b_mothercredit", (Object)receiptBill);
            bizDoList.add(letterCreditDo);
        }
        SaveServiceHelper.save((DynamicObject[])bizDoList.toArray(new DynamicObject[0]));
    }

    public static void writeBackMotherChildCredit(DynamicObject letterCredit) {
        if (!letterCredit.getBoolean("isbackcredit")) {
            return;
        }
        DynamicObjectCollection backCreditCollection = letterCredit.getDynamicObjectCollection("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditCollection)) {
            return;
        }
        ArrayList<DynamicObject> bizDoList = new ArrayList<DynamicObject>(backCreditCollection.size());
        for (DynamicObject backCredit : backCreditCollection) {
            DynamicObject receiptBillDo;
            if (!BackCreditTypeEnum.CHILD_CREDIT.getValue().equals(letterCredit.getString("backcredittype")) || !EmptyUtil.isNoEmpty((DynamicObject)(receiptBillDo = backCredit.getDynamicObject("b_mothercredit")))) continue;
            receiptBillDo = TmcDataServiceHelper.loadSingle((Object)receiptBillDo.getPkValue(), (String)"lc_receipt");
            DynamicObjectCollection backCreditArr = receiptBillDo.getDynamicObjectCollection("entry_backcredit");
            DynamicObject newChildCredit = backCreditArr.addNew();
            newChildCredit.set("b_childcredit", (Object)letterCredit);
            bizDoList.add(receiptBillDo);
        }
        SaveServiceHelper.save((DynamicObject[])bizDoList.toArray(new DynamicObject[0]));
    }

    public static void cancelWriteBackChildCredit(DynamicObject receiptBill) {
        if (!receiptBill.getBoolean("isbackcredit")) {
            return;
        }
        DynamicObjectCollection backCreditCollection = receiptBill.getDynamicObjectCollection("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditCollection)) {
            return;
        }
        ArrayList<DynamicObject> bizDoList = new ArrayList<DynamicObject>(backCreditCollection.size());
        for (DynamicObject backCredit : backCreditCollection) {
            DynamicObject letterCreditDo;
            if (!BackCreditTypeEnum.MOTHER_CREDIT.getValue().equals(receiptBill.getString("backcredittype")) || !EmptyUtil.isNoEmpty((DynamicObject)(letterCreditDo = backCredit.getDynamicObject("b_childcredit")))) continue;
            letterCreditDo = TmcDataServiceHelper.loadSingle((Object)letterCreditDo.getPkValue(), (String)"lc_lettercredit");
            DynamicObjectCollection backCreditArr = letterCreditDo.getDynamicObjectCollection("entry_backcredit");
            for (int i = backCreditArr.size() - 1; i >= 0; --i) {
                DynamicObject backCreditDo = (DynamicObject)backCreditArr.get(i);
                if (!EmptyUtil.isEmpty((DynamicObject)backCreditDo.getDynamicObject("b_mothercredit")) && !receiptBill.get("id").equals(backCreditDo.getDynamicObject("b_mothercredit").get("id"))) continue;
                backCreditArr.remove(i);
            }
            bizDoList.add(letterCreditDo);
        }
        SaveServiceHelper.save((DynamicObject[])bizDoList.toArray(new DynamicObject[0]));
    }

    public static void cancelWriteBackMotherChildCredit(DynamicObject letterCredit) {
        if (!letterCredit.getBoolean("isbackcredit")) {
            return;
        }
        DynamicObjectCollection backCreditCollection = letterCredit.getDynamicObjectCollection("entry_backcredit");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)backCreditCollection)) {
            return;
        }
        ArrayList<DynamicObject> bizDoList = new ArrayList<DynamicObject>(backCreditCollection.size());
        for (DynamicObject backCredit : backCreditCollection) {
            DynamicObject receiptBillDo;
            DynamicObject backCreditDo;
            int i;
            DynamicObjectCollection backCreditArr;
            if (BackCreditTypeEnum.MOTHER_CREDIT.getValue().equals(letterCredit.getString("backcredittype"))) {
                DynamicObject letterCreditDo = backCredit.getDynamicObject("b_childcredit");
                if (!EmptyUtil.isNoEmpty((DynamicObject)letterCreditDo)) continue;
                letterCreditDo = TmcDataServiceHelper.loadSingle((Object)letterCreditDo.getPkValue(), (String)"lc_lettercredit");
                backCreditArr = letterCreditDo.getDynamicObjectCollection("entry_backcredit");
                for (i = backCreditArr.size() - 1; i >= 0; --i) {
                    backCreditDo = (DynamicObject)backCreditArr.get(i);
                    if (!EmptyUtil.isEmpty((DynamicObject)backCreditDo.getDynamicObject("b_mothercredit")) && !letterCredit.get("id").equals(backCreditDo.getDynamicObject("b_mothercredit").get("id"))) continue;
                    backCreditArr.remove(i);
                }
                bizDoList.add(letterCreditDo);
                continue;
            }
            if (!BackCreditTypeEnum.CHILD_CREDIT.getValue().equals(letterCredit.getString("backcredittype")) || !EmptyUtil.isNoEmpty((DynamicObject)(receiptBillDo = backCredit.getDynamicObject("b_mothercredit")))) continue;
            receiptBillDo = TmcDataServiceHelper.loadSingle((Object)receiptBillDo.getPkValue(), (String)"lc_receipt");
            backCreditArr = receiptBillDo.getDynamicObjectCollection("entry_backcredit");
            for (i = backCreditArr.size() - 1; i >= 0; --i) {
                backCreditDo = (DynamicObject)backCreditArr.get(i);
                if (!EmptyUtil.isEmpty((DynamicObject)backCreditDo.getDynamicObject("b_childcredit")) && !letterCredit.get("id").equals(backCreditDo.getDynamicObject("b_childcredit").get("id"))) continue;
                backCreditArr.remove(i);
            }
            bizDoList.add(receiptBillDo);
        }
        SaveServiceHelper.save((DynamicObject[])bizDoList.toArray(new DynamicObject[0]));
    }

    public static DynamicObject getCreditUse(Long billId, String billType) {
        return TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillentryid", "=", (Object)billId), new QFilter("sourcetype", "=", (Object)billType), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("isrelease", "=", (Object)"0")});
    }

    public static void setIsSurety(DynamicObject bizBill) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bizBill.getDynamicObjectCollection("entry_surety"))) {
            bizBill.set("issurety", (Object)true);
        } else {
            bizBill.set("issurety", (Object)false);
        }
    }

    public static void dealExceed(DynamicObject arrivalBill) {
        arrivalBill.set("exceedreson", (Object)"");
        arrivalBill.set("exceeduser", null);
        arrivalBill.set("exceedtime", null);
    }

    public static boolean checkPushPaybill(long arrId, String settleNum) {
        Object[] casBillIds = TmcBotpHelper.getTargetBillIds((String)"lc_arrival", (Object)arrId, (String)"cas_paybill");
        if (EmptyUtil.isNoEmpty((Object[])casBillIds)) {
            QFilter filter = new QFilter("id", "in", (Object)casBillIds).and("billstatus", "not in", Arrays.asList("G", "F")).and("settletnumber", "=", (Object)settleNum);
            return QueryServiceHelper.exists((String)"cas_paybill", (QFilter[])new QFilter[]{filter});
        }
        return false;
    }

    public static boolean checkRecCompPresent(DynamicObject bizBill, long orgId) {
        DataEntityPropertyCollection properties = bizBill.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"tradechannel")) {
            return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent") && !TradeChannelEnum.ONLINE.getValue().equals(bizBill.getString("tradechannel"));
        }
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccomppresent");
    }

    public static boolean checkRecCompCredit(DynamicObject bizBill, long orgId) {
        DataEntityPropertyCollection properties = bizBill.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"tradechannel")) {
            return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccompcredit") && !TradeChannelEnum.ONLINE.getValue().equals(bizBill.getString("tradechannel"));
        }
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccompcredit");
    }

    public static boolean checkRecCompCredit(IDataModel model, long orgId) {
        return TmcParameterHelper.getAppBoolParameter((String)TmcAppEnum.LC.getId(), (long)orgId, (String)"reccompcredit") && !TradeChannelEnum.ONLINE.getValue().equals(model.getValue("tradechannel"));
    }

    public static boolean isExistsLcApply(DynamicObject letterCredit) {
        QFilter lcFilter = new QFilter("creditapplyno", "=", (Object)letterCredit.getString("creditapplyno"));
        lcFilter.and(new QFilter("id", "!=", letterCredit.getPkValue()));
        lcFilter.and(new QFilter("bebankstatus", "!=", (Object)BeBillStatusEnum.TF.getValue()));
        return QueryServiceHelper.exists((String)"lc_lettercredit", (QFilter[])new QFilter[]{lcFilter});
    }

    public static boolean isExistsCreditNo(DynamicObject letterCredit) {
        String creditNo = letterCredit.getString("creditno");
        if (EmptyUtil.isEmpty((String)creditNo)) {
            return false;
        }
        QFilter qFilter = new QFilter("creditno", "=", (Object)creditNo);
        qFilter.and(new QFilter("bebankstatus", "!=", (Object)BeBillStatusEnum.TF.getValue()));
        qFilter.and(new QFilter("id", "!=", letterCredit.getPkValue()));
        return QueryServiceHelper.exists((String)"lc_lettercredit", (QFilter[])new QFilter[]{qFilter});
    }

    public static int getAmtprecision(DynamicObject currency) {
        return EmptyUtil.isEmpty((DynamicObject)currency) ? 2 : currency.getInt("amtprecision");
    }
}

