/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.form;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.filter.ReportFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.form.AbstractTmcOrgViewRptFormPlugin;
import kd.tmc.lc.common.enums.ArrivalStatusEnum;
import kd.tmc.lc.common.enums.PresentStatusEnum;
import kd.tmc.lc.report.helper.DetailReportHelper;
import kd.tmc.lc.report.helper.ReportHelper;

public class DetailBaseReportFormPlugin
extends AbstractTmcOrgViewRptFormPlugin
implements HyperLinkClickListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit creditLimitEdit = (BasedataEdit)this.getControl("filter_lettercredit");
        creditLimitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        this.initQueryFromSum();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Date queryEndDate;
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("lc_detail_lettercredit".equals(formId) && EmptyUtil.isEmpty((Object)(queryEndDate = (Date)this.getModel().getValue("filter_queryenddate")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"DetailBaseReportFormPlugin_4", (String)"tmc-lc-report", (Object[])new Object[0]));
            return false;
        }
        return TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"filter_statcurrency");
    }

    private void initQueryFromSum() {
        ReportShowParameter formShowParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object filterStr = customParams.get("filter");
        if (EmptyUtil.isEmpty(filterStr)) {
            return;
        }
        if (customParams.get("queryDetail") != null) {
            this.queryDetailByConditionFilter(customParams);
        } else {
            this.queryDetailByClickLetterNum(customParams);
        }
        ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
        rptFilter.search();
    }

    private void queryDetailByConditionFilter(Map<String, Object> customParams) {
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)customParams.get("filter").toString());
        List filterItems = queryParam.getFilter().getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            if (this.getView().getControl(propName) != null) {
                if (value instanceof DynamicObjectCollection) {
                    DynamicObjectCollection objs = (DynamicObjectCollection)value;
                    ArrayList ids = new ArrayList();
                    objs.forEach(v -> ids.add(v.getPkValue()));
                    this.getModel().setValue(propName, (Object)ids.toArray(new Object[0]));
                    continue;
                }
                this.getModel().setValue(propName, value);
                continue;
            }
            if (!"filter_org_id".equals(propName)) continue;
            List orgList = (List)value;
            this.getModel().setValue("filter_org", (Object)orgList.toArray());
        }
    }

    private void queryDetailByClickLetterNum(Map<String, Object> customParams) {
        Object filterStr = customParams.get("filter");
        if (EmptyUtil.isEmpty((Object)filterStr)) {
            return;
        }
        FilterInfo filter = (FilterInfo)SerializationUtils.deSerializeFromBase64((String)((String)filterStr));
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo filterItem : filterItems) {
            String propName = filterItem.getPropName();
            Object value = filterItem.getValue();
            if (this.getView().getControl(propName) != null) {
                this.getModel().setValue(propName, value);
                continue;
            }
            if (!"filter_org_id".equals(propName) || EmptyUtil.isEmpty((Object)value)) continue;
            List orgList = (List)value;
            this.getModel().setValue("filter_org", (Object)orgList.toArray());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("filter_lettercredit".equals(key)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("filter_org");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)orgs)) {
                String formId = this.getView().getFormShowParameter().getFormId();
                String tips = "lc_detail_receipt".equals(formId) ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d7\u76ca\u4eba", (String)"DetailBaseReportFormPlugin_2", (String)"tmc-lc-report", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5f00\u8bc1\u4eba", (String)"DetailBaseReportFormPlugin_1", (String)"tmc-lc-report", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                evt.setCancel(true);
            } else {
                HashSet<Object> orgIds = new HashSet<Object>(orgs.size());
                for (DynamicObject org : orgs) {
                    DynamicObject data = org.getDynamicObject("fbasedataid");
                    orgIds.add(data.getPkValue());
                }
                QFilter filter = new QFilter("org", "in", orgIds);
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                parameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        DynamicObject currency = (DynamicObject)this.getModel().getValue("filter_statcurrency");
        List columns = event.getColumns();
        Map<String, LocaleString> columnFieldMap = ReportHelper.getColumnField(event);
        String groupColum = ReportHelper.getGroupColums((String)this.getModel().getValue("filter_statdim"));
        for (int i = columns.size() - 1; i >= 0; --i) {
            ReportColumn column = (ReportColumn)columns.get(i);
            if (EmptyUtil.isEmpty((DynamicObject)currency) && "rateamount".equals(column.getFieldKey())) {
                columns.remove(i);
                continue;
            }
            if ("orgtext".equals(column.getFieldKey()) && !"org".equals(groupColum)) {
                column.setCaption(columnFieldMap.get(groupColum));
            }
            if (!column.getFieldKey().equals(groupColum)) continue;
            columns.remove(i);
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        String statdim = (String)this.getModel().getValue("filter_statdim");
        queryParam.getFilter().addFilterItem("filter_statdim", (Object)statdim);
        this.getModel().setValue("filter_isshowsubtotal", (Object)true);
        queryParam.getFilter().addFilterItem("fields", this.getAllFields());
        super.beforeQuery(queryParam);
    }

    protected String getFilterOrgField() {
        return "filter_org";
    }

    protected String getFilterOrgViewField() {
        return "filter_orgview";
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName;
        int rowIndex = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        switch (fieldName = evt.getFieldName()) {
            case "creditno": {
                this.showLetterCredit(rowIndex, reportModel);
                break;
            }
            case "arrnum": {
                this.showLetterCreditList(rowIndex, reportModel);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "filter_lettercredit": {
                String formId = this.getView().getFormShowParameter().getFormId();
                ChangeData[] changeData = e.getChangeSet();
                Object newValue = changeData[0].getNewValue();
                if (EmptyUtil.isNoEmpty((Object)newValue)) {
                    this.getModel().setValue("filter_bizdate", (Object)"");
                    if ("lc_detail_receipt".equals(formId)) {
                        this.getModel().setValue("filter_redate", (Object)"");
                    }
                    this.getModel().setValue("filter_vadate", (Object)"");
                    this.getModel().setValue("filter_bank", null);
                    this.getModel().setValue("filter_bizcurrency", null);
                    this.getModel().setValue("filter_isnationalcard", (Object)"");
                    this.getModel().setValue("filter_isforward", (Object)"");
                    this.getModel().setValue("filter_credittype", null);
                    if ("lc_detail_lettercredit".equals(formId)) {
                        this.getModel().setValue("filter_credittypes", null);
                    }
                } else {
                    String date = "lc_detail_receipt".equals(formId) ? "filter_redate" : "filter_bizdate";
                    this.getModel().setValue(date, (Object)"month");
                }
                this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((Object)newValue)), new String[]{"filter_bizdate", "filter_redate", "filter_bank", "filter_bizcurrency", "filter_isnationalcard", "filter_isforward", "filter_credittypes", "filter_credittype", "filter_vadate"});
                break;
            }
            case "filter_bizdate_startdate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_bizdate_startdate");
                break;
            }
            case "filter_bizdate_enddate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_bizdate_enddate");
                break;
            }
            case "filter_vadate_startdate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_vadate_startdate");
                break;
            }
            case "filter_vadate_enddate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_vadate_enddate");
                break;
            }
            case "filter_redate_startdate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_redate_startdate");
                break;
            }
            case "filter_redate_enddate": {
                ReportHelper.controlFilterDate((IFormView)this.getView(), "filter_redate_enddate");
                break;
            }
            case "filter_org": {
                this.getModel().setValue("filter_lettercredit", null);
                break;
            }
            case "filter_statdim": {
                ReportFilter rptFilter = (ReportFilter)this.getControl("reportfilterap");
                try {
                    rptFilter.search();
                }
                catch (KDBizException bizEx) {
                    this.getView().showErrorNotification(bizEx.getMessage());
                }
                break;
            }
        }
    }

    private void showLetterCreditList(int index, IReportListModel reportModel) {
        DynamicObject rowData = reportModel.getRowData(index);
        DynamicObject lett = rowData.getDynamicObject("id");
        IReportView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        String entryName = "lc_detail_receipt".equals(formId) ? "lc_present" : "lc_arrival";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        boolean isArrival = entryName.equals("lc_arrival");
        if ("lc_detail_lettercredit".equals(formId)) {
            Date queryEndDate = (Date)this.getModel().getValue("filter_queryenddate");
            queryEndDate = DateUtils.getDataFormat((Date)queryEndDate, (boolean)false);
            filters.add(new QFilter("arrivaldate", "<=", (Object)queryEndDate));
        }
        filters.add(new QFilter("arrivalstatus", "!=", (Object)(isArrival ? ArrivalStatusEnum.ARRIVAL_REGISTER.getValue() : PresentStatusEnum.PRESENT_REGISTER.getValue())));
        if (EmptyUtil.isEmpty((DynamicObject)lett)) {
            Set<Long> lettIds = DetailReportHelper.getLettIds(reportModel, index);
            filters.add(new QFilter("lettercredit", "in", lettIds));
        } else {
            filters.add(new QFilter("lettercredit", "=", lett.getPkValue()));
        }
        DynamicObjectCollection arrs = QueryServiceHelper.query((String)entryName, (String)"id", (QFilter[])filters.toArray(new QFilter[0]));
        if (EmptyUtil.isEmpty((DynamicObjectCollection)arrs)) {
            return;
        }
        if (arrs.size() == 1) {
            BillShowParameter parameter = new BillShowParameter();
            Long arrId = ((DynamicObject)arrs.get(0)).getLong("id");
            parameter.setPkId((Object)arrId);
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setFormId(entryName);
            view.showForm((FormShowParameter)parameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entryName);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", arrs.stream().map(d -> d.get("id")).collect(Collectors.toSet())));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setCustomParam("report", (Object)"1");
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private void showLetterCredit(int index, IReportListModel reportModel) {
        DynamicObject rowData = reportModel.getRowData(index);
        DynamicObject lett = rowData.getDynamicObject("id");
        IReportView view = this.getView();
        String formId = view.getFormShowParameter().getFormId();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setPkId(lett.getPkValue());
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId("lc_detail_receipt".equals(formId) ? "lc_receipt" : "lc_lettercredit");
        view.showForm((FormShowParameter)parameter);
    }

    private Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>(16);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        for (AbstractReportColumn column : columns) {
            fields.add(((ReportColumn)column).getFieldKey());
        }
        return fields;
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        DynamicObject row = e.getRowData();
        Object source = e.getSource();
        if (source instanceof ReportColumn) {
            String sumlevel = row.getString("sumlevel");
            ReportColumn column = (ReportColumn)source;
            String fieldType = column.getFieldType();
            if (("1".equals(sumlevel) || "2".equals(sumlevel)) && !"rateamount".equals(column.getFieldKey()) && "amount".equals(fieldType)) {
                e.setFormatValue((Object)"");
            }
        }
    }
}

