/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lc.report.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.orm.query.QFilter;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.fbp.common.enums.ReportOrgQueryWayEnum;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lc.report.helper.ReportQueryInfo;

public class ReportHelper {
    public static void buildStrFilter(QFilter filter, String str, String filed) {
        if (EmptyUtil.isNoEmpty((String)str)) {
            filter.and(filed, "=", (Object)str);
        }
    }

    public static void buildDynamicObjectFilter(QFilter filter, DynamicObject baseData, String filed) {
        if (EmptyUtil.isNoEmpty((DynamicObject)baseData)) {
            filter.and(filed, "=", baseData.getPkValue());
        }
    }

    public static void buildDateRangesFilter(QFilter filter, String rangeId, String rangeVal, String dateField, Map<String, Object> paramMap) {
        Date currentDate = DateUtils.getCurrentDate();
        int currentYear = DateUtils.getYear((Date)currentDate);
        if (EmptyUtil.isNoEmpty((String)rangeVal)) {
            switch (rangeVal) {
                case "month": {
                    filter.and(dateField, ">=", (Object)DateUtils.getMinMonthDate((Date)currentDate));
                    filter.and(dateField, "<=", (Object)DateUtils.getMaxMonthDate((Date)currentDate));
                    break;
                }
                case "last_month": {
                    Date minMonthDate = DateUtils.getMinMonthDate((Date)currentDate);
                    filter.and(dateField, ">=", (Object)DateUtils.getLastMonth((Date)minMonthDate, (int)1));
                    filter.and(dateField, "<", (Object)minMonthDate);
                    break;
                }
                case "last_year": {
                    filter.and(dateField, ">=", (Object)DateUtils.getYearFirst((int)(currentYear - 1)));
                    filter.and(dateField, "<=", (Object)DateUtils.getYearLast((int)(currentYear - 1)));
                    break;
                }
                case "today": {
                    filter.and(dateField, ">=", (Object)DateUtils.getDataFormat((Date)currentDate, (boolean)true));
                    filter.and(dateField, "<=", (Object)DateUtils.getDataFormat((Date)currentDate, (boolean)false));
                    break;
                }
                case "year": {
                    filter.and(dateField, ">=", (Object)DateUtils.getYearFirst((int)currentYear));
                    filter.and(dateField, "<=", (Object)DateUtils.getYearLast((int)currentYear));
                    break;
                }
                case "defined": {
                    Date endDate;
                    Date startDate = (Date)paramMap.get(rangeId + "_startdate");
                    if (startDate != null) {
                        filter.and(dateField, ">=", (Object)startDate);
                    }
                    if ((endDate = (Date)paramMap.get(rangeId + "_enddate")) == null) break;
                    filter.and(dateField, "<=", (Object)endDate);
                    break;
                }
            }
        }
    }

    public static String getUnit(String currencyUnit) {
        String divisor = "1";
        switch (currencyUnit) {
            case "Billion": {
                divisor = "100000000";
                break;
            }
            case "Million": {
                divisor = "1000000";
                break;
            }
            case "TenThousand": {
                divisor = "10000";
                break;
            }
            case "Thousand": {
                divisor = "1000";
                break;
            }
        }
        return divisor;
    }

    public static DataSet getExchgRateDataSet(DataSet sourceDataSet, DynamicObject toCurrency, Map<String, Object> paramMap) {
        Iterator it = sourceDataSet.copy().iterator();
        Long toCurrencyId = toCurrency.getLong("id");
        Long orgRootId = Long.parseLong(paramMap.get("orgid").toString());
        HashSet<Long> fromCurrencyIdSet = new HashSet<Long>();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Long fromCurrencyId = row.getLong("currency");
            fromCurrencyIdSet.add(fromCurrencyId);
        }
        ArrayList fromCurrencyIdList = new ArrayList(fromCurrencyIdSet);
        String queryWay = (String)paramMap.get("filter_queryway");
        DataSet exChangeDataSet = TmcBusinessBaseHelper.getExChangeDataSet(fromCurrencyIdList, (Long)toCurrencyId, (long)orgRootId, (Date)DateUtils.getCurrentDate(), (!ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryWay) ? 1 : 0) != 0);
        exChangeDataSet = exChangeDataSet.addField("tarcurrency", "currency");
        exChangeDataSet = exChangeDataSet.updateField("tarcurrency", toCurrencyId.toString());
        return exChangeDataSet;
    }

    public static void controlFilterDate(IFormView view, String prop) {
        IDataModel model = view.getModel();
        boolean isStartDate = prop.contains("startdate");
        Date propVal = (Date)model.getValue(prop);
        if (isStartDate) {
            String endProp = prop.replace("startdate", "enddate");
            Date endVal = (Date)model.getValue(endProp);
            if (endVal != null && propVal != null && endVal.compareTo(propVal) < 0) {
                model.setValue(endProp, (Object)propVal);
            }
            DateEdit control = (DateEdit)view.getControl(endProp);
            if (propVal == null) {
                propVal = DateUtils.getLastYear((Date)new Date(), (int)100);
            }
            control.setMinDate(propVal);
        } else {
            String startProp = prop.replace("enddate", "startdate");
            Date startVal = (Date)model.getValue(startProp);
            if (startVal != null && propVal != null && startVal.compareTo(propVal) > 0) {
                model.setValue(startProp, (Object)propVal);
            }
            DateEdit control = (DateEdit)view.getControl(startProp);
            if (propVal == null) {
                propVal = DateUtils.getNextYear((Date)new Date(), (int)100);
            }
            control.setMaxDate(propVal);
        }
    }

    public static String getFirstColumnText(Map<String, Object> paramMap) {
        String statim = (String)paramMap.get("filter_statdim");
        String[] statimArr = statim.split(",");
        if (statimArr.length > 0) {
            return "," + statimArr[0] + ".name as orgtext";
        }
        return "";
    }

    public static String getGroupColums(String statim) {
        String[] statimArr = statim.split(",");
        if (statimArr.length > 0) {
            return statimArr[0];
        }
        return "";
    }

    public static Map<String, LocaleString> getColumnField(CreateColumnEvent event) {
        List columns = event.getColumns();
        return columns.stream().collect(Collectors.toMap(k -> ((ReportColumn)k).getFieldKey(), AbstractReportColumn::getCaption, (e1, e2) -> e1));
    }

    public static ReportQueryInfo getReportQueryInfo(ReportQueryParam queryParam, String appId, String entityName) {
        String queryType = (String)queryParam.getFilter().getFilterItem("filter_queryway").getValue();
        long currUserId = RequestContext.get().getCurrUserId();
        if (ReportOrgQueryWayEnum.ORGVIEW.getValue().equals(queryType)) {
            DynamicObject companyView = (DynamicObject)queryParam.getFilter().getFilterItem("filter_orgview").getValue();
            String companyViewNum = companyView.getString("number");
            String orgRootId = ReportHelper.getOrgRootId(companyViewNum);
            if (EmptyUtil.isEmpty((String)orgRootId)) {
                throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ReportHelper.loadKDString("\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe[%s]\u914d\u7f6e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", "CimReportCommon_4", companyViewNum)});
            }
            TmcOrgDataHelper.checkFunctionPermission((String)appId, (long)currUserId, (long)Long.parseLong(orgRootId == null ? "0" : orgRootId), (String)entityName, (String)"47150e89000000ac");
            List orgIds = OrgUnitServiceHelper.getAllOrg((String)companyViewNum);
            if (EmptyUtil.isEmpty((Collection)orgIds)) {
                throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ReportHelper.loadKDString("\u8d44\u91d1\u7ec4\u7ec7\u89c6\u56fe\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4e3a\u7a7a\u3002", "CimReportCommon_1", new Object[0])});
            }
            return ReportQueryInfo.build(orgRootId, orgIds);
        }
        String orgRootId = String.valueOf(RequestContext.get().getOrgId());
        FilterInfo filter = queryParam.getFilter();
        List orgIds = (List)filter.getFilterItem("filter_org").getValue();
        if (orgIds != null) {
            return ReportQueryInfo.build(orgRootId, orgIds);
        }
        orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)currUserId, (String)appId, (String)entityName, (String)"47150e89000000ac");
        if (EmptyUtil.isEmpty((Collection)orgIds)) {
            throw new TmcBizException(TmcErrorCode.COMMON, (Object[])new String[]{ReportHelper.loadKDString("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u8be5\u62a5\u8868\u67e5\u8be2\u6743\u9650\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", "CimReportCommon_2", new Object[0])});
        }
        return ReportQueryInfo.build(orgRootId, orgIds);
    }

    public static String loadKDString(String description, String resourceID, Object ... args) {
        return ResManager.loadKDString((String)description, (String)resourceID, (String)"tmc-lc-report", (Object[])new Object[0]);
    }

    public static String getOrgRootId(String orgViewNumber) {
        OrgTreeParam param = new OrgTreeParam();
        param.setOrgViewNumber(orgViewNumber);
        TreeNode rootNode = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        return rootNode != null ? rootNode.getId() : null;
    }
}

