/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public abstract class AbstractLimitEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String TMATURITY_SYMBOL_MIN = "\u2264";
    private static final String TMATURITY_SYMBOL_MAX = ">";

    protected abstract String getLimUseBillName();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit productType = (BasedataEdit)this.getView().getControl("producttype");
        productType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit productTypeHis = (BasedataEdit)this.getView().getControl("producttypehis");
        productTypeHis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection entity;
        super.afterBindData(e);
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (TcBillStatusEnum.ADJUST.getValue().equals(billStatus) || TcBillStatusEnum.CLOSE.getValue().equals(billStatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"entrys", "fs_baseinfo"});
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(entity = this.getModel().getEntryEntity("entrys")))) {
            this.getModel().deleteEntryData("entrys");
            this.getModel().createNewEntryRow("entrys");
        }
        this.setAdjShowAble();
        this.calResVal();
        this.setMustInput();
    }

    private void setAdjShowAble() {
        Object isadj = this.getView().getFormShowParameter().getCustomParam("isadj");
        boolean isAdj = EmptyUtil.isEmpty((Object)isadj) ? false : (Boolean)isadj;
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (isAdj || TcBillStatusEnum.AUDIT.getValue().equals(billStatus) || TcBillStatusEnum.ADJUST.getValue().equals(billStatus) || TcBillStatusEnum.CLOSE.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"warnadjval", "warnresval", "limitadjval", "limitresval", "uselimitval", "remalimitval", "remawarnval"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"warnadjval", "warnresval", "limitadjval", "limitresval", "uselimitval", "remalimitval", "remawarnval"});
        }
        if (isAdj) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_unadj", "bar_adjaudit", "barunclose"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"producthisgroup", "coefficienthis"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productgroup", "coefficient"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"producthisgroup", "coefficienthis"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"productgroup", "coefficient"});
        }
        if (TcBillStatusEnum.ADJUST.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_unadj", "bar_adjaudit", "barrefresh", "bar_close"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_submitandnew", "bar_print", "bar_more", "barunclose"});
        } else if (TcBillStatusEnum.CLOSE.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"barunclose", "barrefresh", "bar_close"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_submitandnew", "bar_print", "bar_more", "bar_unadj", "bar_adjaudit"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_unadj", "bar_adjaudit", "barunclose"});
        }
    }

    private void setMustInput() {
        boolean isAdj;
        Object isadj = this.getView().getFormShowParameter().getCustomParam("isadj");
        boolean bl = isAdj = EmptyUtil.isEmpty((Object)isadj) ? false : (Boolean)isadj;
        if (isAdj) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"coefficienthis"});
            Boolean assignProductHis = (Boolean)this.getModel().getValue("assignproducthis");
            if (assignProductHis.booleanValue()) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"producttypehis"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"producttypehis"});
            }
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"coefficienthis"});
            Boolean assignProduct = (Boolean)this.getModel().getValue("assignproduct");
            if (assignProduct.booleanValue()) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"producttype"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"producttype"});
            }
            Boolean assignTerm = (Boolean)this.getModel().getValue("assignterm");
            if (assignTerm.booleanValue()) {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"term"});
            } else {
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"term"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        ChangeData[] changeData = args.getChangeSet();
        switch (propName) {
            case "assignterm": {
                boolean assignterm = (Boolean)this.getModel().getValue("assignterm");
                if (!assignterm) {
                    this.getModel().setValue("term", null);
                }
                this.setMustInput();
                this.creatEntrysData();
                break;
            }
            case "term": {
                this.creatEntrysData();
                break;
            }
            case "assignproduct": {
                boolean assignProduct = (Boolean)this.getModel().getValue("assignproduct");
                if (!assignProduct) {
                    this.getModel().setValue("producttype", null);
                }
                this.setMustInput();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"assignproducthis", (Object)assignProduct);
                break;
            }
            case "assignproducthis": {
                boolean assignProductHis = (Boolean)this.getModel().getValue("assignproducthis");
                if (!assignProductHis) {
                    this.getModel().setValue("producttypehis", null);
                    TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"producttypehis"});
                    break;
                }
                TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"producttypehis"});
                break;
            }
            case "producttype": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"producttypehis", (Object)this.getModel().getValue("producttype"));
                break;
            }
            case "coefficient": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"coefficienthis", (Object)this.getModel().getValue("coefficient"));
                break;
            }
        }
    }

    private void calResVal() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        for (int i = 0; i < entrys.size(); ++i) {
            Object pkValue = ((DynamicObject)entrys.get(i)).getPkValue();
            QFilter qFilter = new QFilter("limentryid", "=", pkValue);
            DynamicObject[] cpLimUse = TmcDataServiceHelper.load((String)this.getLimUseBillName(), (String)"useamt,actuseamt", (QFilter[])new QFilter[]{qFilter});
            BigDecimal useLimitVal = BigDecimal.ZERO;
            for (DynamicObject limUse : cpLimUse) {
                useLimitVal = useLimitVal.add(limUse.getBigDecimal("actuseamt"));
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"uselimitval", (Object)useLimitVal, (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remalimitval", (Object)((DynamicObject)entrys.get(i)).getBigDecimal("limitval").subtract(useLimitVal), (int)i);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"remawarnval", (Object)((DynamicObject)entrys.get(i)).getBigDecimal("warnval").subtract(useLimitVal), (int)i);
        }
        this.getModel().setDataChanged(false);
    }

    private void creatEntrysData() {
        String limitMaturity = (String)this.getModel().getValue("term");
        if (EmptyUtil.isEmpty((String)limitMaturity)) {
            this.getModel().deleteEntryData("entrys");
            this.getModel().createNewEntryRow("entrys");
            return;
        }
        List<String> maturitys = this.getSortMaturitys();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(maturitys.size());
        for (int i = 0; i < maturitys.size(); ++i) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("limitmaturity", TMATURITY_SYMBOL_MIN + maturitys.get(i));
            list.add(map);
            if (i != maturitys.size() - 1) continue;
            HashMap<String, String> mapMax = new HashMap<String, String>();
            mapMax.put("limitmaturity", TMATURITY_SYMBOL_MAX + maturitys.get(i));
            list.add(mapMax);
        }
        this.fillData(list);
    }

    private List<String> getSortMaturitys() {
        ArrayList<String> maturitys = new ArrayList<String>();
        String limitMaturity = (String)this.getModel().getValue("term");
        List<String> limitMaturitys = Arrays.asList(limitMaturity.substring(1).split(","));
        MulComboEdit termControl = (MulComboEdit)this.getView().getControl("term");
        MulComboProp property = (MulComboProp)termControl.getProperty();
        List comboItems = property.getComboItems();
        comboItems.forEach(comb -> {
            if (limitMaturitys.contains(comb.getValue())) {
                maturitys.add(comb.getValue());
            }
        });
        return maturitys;
    }

    private void fillData(List<Map<String, Object>> list) {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrys");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            this.getModel().deleteEntryData("entrys");
        }
        int[] rows = this.getModel().batchCreateNewEntryRow("entrys", list.size());
        for (int i = 0; i < rows.length; ++i) {
            this.getModel().setValue("limitmaturity", list.get(i).get("limitmaturity"), i);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String fieldKey = arg.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"producttype") || StringUtils.equals((CharSequence)fieldKey, (CharSequence)"producttypehis")) {
            QFilter filter = new QFilter("enable", "=", (Object)true);
            filter.and(new QFilter("number", "!=", (Object)ProductTypeEnum.RATEOPEN.getValue())).and(new QFilter("number", "!=", (Object)ProductTypeEnum.EXRATEOPEN.getValue())).and(new QFilter("number", "!=", (Object)ProductTypeEnum.BONDISSUE.getValue())).and(new QFilter("isbiznode", "=", (Object)true));
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        DynamicObjectCollection entity;
        super.afterDoOperation(e);
        if (("adjsubmit".equals(e.getOperateKey()) || "unadj".equals(e.getOperateKey()) || "adjaudit".equals(e.getOperateKey()) || "basunclose".equals(e.getOperateKey())) && e.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_unadj", "bar_adjaudit", "basunclose", "bar_submit"});
        }
        if (EmptyUtil.isEmpty((DynamicObjectCollection)(entity = this.getModel().getEntryEntity("entrys")))) {
            this.getModel().deleteEntryData("entrys");
            this.getModel().createNewEntryRow("entrys");
        }
        this.setAdjShowAble();
        this.getView().updateView();
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        int rowIndex = e.getRowIndex();
        switch (key) {
            case "warnadjval": {
                BigDecimal warnVal = (BigDecimal)this.getModel().getValue("warnval", rowIndex);
                if (EmptyUtil.isEmpty((Object)value)) {
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    return;
                }
                BigDecimal warnAdjVal = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                BigDecimal warnResVal = warnVal.add(warnAdjVal);
                if (warnResVal.compareTo(Constants.ZERO) < 0) {
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    return;
                }
                this.getModel().setValue("warnresval", (Object)warnResVal, rowIndex);
                break;
            }
            case "warnval": {
                this.getModel().setValue("warnresval", value, rowIndex);
                break;
            }
            case "limitadjval": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    return;
                }
                BigDecimal limitVal = (BigDecimal)this.getModel().getValue("limitval", rowIndex);
                BigDecimal limitAdjVal = BigDecimal.valueOf(Double.parseDouble(String.valueOf(value)));
                BigDecimal useVal = (BigDecimal)this.getModel().getValue("uselimitval", rowIndex);
                BigDecimal limitResVal = limitVal.add(limitAdjVal);
                if (limitResVal.compareTo(useVal) < 0) {
                    e.setCancel(true);
                    this.getView().updateView(key, rowIndex);
                    return;
                }
                this.getModel().setValue("limitresval", (Object)limitResVal, rowIndex);
                this.getModel().setValue("remalimitval", (Object)limitResVal.subtract(useVal), rowIndex);
                break;
            }
            case "limitval": {
                this.getModel().setValue("limitresval", value, rowIndex);
                break;
            }
        }
    }
}

