/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lm.formplugin;

import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.lm.business.provider.LimitListDataProvider;
import kd.tmc.lm.common.resource.LmBizResource;

public abstract class AbstractLimitList
extends AbstractTmcListPlugin {
    protected abstract String getAdjBillName();

    protected abstract String getUseBillName();

    protected abstract String getUseViewBillName();

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LimitListDataProvider(this.getUseBillName()));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        ListView view = (ListView)this.getView();
        view.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        ListView listView = (ListView)operate.getView();
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (operate.getOperateKey().equals("adj")) {
            e.setCancel(true);
            if (this.isMutilOpt(selectedRows)) {
                this.getView().showTipNotification(LmBizResource.notBatchOpt());
            } else if (!TcBillStatusEnum.AUDIT.getValue().equals(selectedRows.get(0).getBillStatus())) {
                this.getView().showErrorNotification(LmBizResource.adjBillStatus());
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("isadj", true);
                this.showForm(this.getAdjBillName(), selectedRows.get(0).getPrimaryKeyValue(), params);
            }
        } else if (operate.getOperateKey().equals("viewuse")) {
            e.setCancel(true);
            if (this.isMutilOpt(selectedRows)) {
                this.getView().showErrorNotification(LmBizResource.notBatchOpt());
            } else {
                FormShowParameter param = new FormShowParameter();
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setFormId(this.getUseViewBillName());
                param.setCustomParam("id", selectedRows.get(0).getPrimaryKeyValue());
                this.getView().showForm(param);
            }
        }
    }

    private boolean isMutilOpt(ListSelectedRowCollection selectedRows) {
        ListSelectedRow selectedRow = selectedRows.get(0);
        for (ListSelectedRow row : selectedRows) {
            if (row.getPrimaryKeyValue().equals(selectedRow.getPrimaryKeyValue())) continue;
            return true;
        }
        return false;
    }

    private void showForm(String formId, Object pkId, Map<String, Object> params) {
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "adj");
        BillShowParameter param = new BillShowParameter();
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setFormId(formId);
        param.setPkId(pkId);
        param.setStatus(OperationStatus.EDIT);
        param.setCloseCallBack(closeCallBack);
        param.setCustomParams(params);
        this.getView().showForm((FormShowParameter)param);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        if (operate.getOperateKey().equals("adj") || operate.getOperateKey().equals("unadj") || operate.getOperateKey().equals("busclose") || operate.getOperateKey().equals("busunclose") || operate.getOperateKey().equals("adjaudit")) {
            ListView view = (ListView)this.getView();
            view.refresh();
        }
    }
}

