/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.lm.business.validate;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.lm.common.resource.LmBizResource;

public class LimitUnAuditOpValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("billstatus");
        list.add("isadj");
        return list;
    }

    public void validate(ExtendedDataEntity[] paramArrayOfExtendedDataEntity) throws KDBizException {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean isAdj = bill.getBoolean("isadj");
            if (isAdj) {
                this.addErrorMessage(data, LmBizResource.adjBillNotAudit());
            }
            QFilter qFilter = new QFilter("limid", "=", data.getBillPkId());
            Object[] cpLimUse = TmcDataServiceHelper.load((String)"lm_cplimit_use", (String)"useamt,actuseamt", (QFilter[])new QFilter[]{qFilter});
            Object[] riskLimUse = TmcDataServiceHelper.load((String)"lm_risklimit_use", (String)"useamt,actuseamt", (QFilter[])new QFilter[]{qFilter});
            if (!EmptyUtil.isNoEmpty((Object[])cpLimUse) && !EmptyUtil.isNoEmpty((Object[])riskLimUse)) continue;
            this.addErrorMessage(data, LmBizResource.useBillNotAudit());
        }
    }
}

