/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.opservice.forex;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ForexQuoteHDeleteOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("issuetime");
        sic.add("sourcebillid");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Object sourceBillId = dataEntities[0].get("sourcebillid");
        DynamicObject forexQuote = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"md_forexquote");
        HashSet<Object> ids = new HashSet<Object>(8);
        boolean isFinish = true;
        for (DynamicObject dataEntity : dataEntities) {
            if (forexQuote.getDate("issuetime").equals(dataEntity.get("issuetime"))) {
                isFinish = false;
            }
            ids.add(dataEntity.getPkValue());
        }
        if (isFinish) {
            return;
        }
        QFilter filter = new QFilter("sourcebillid", "=", sourceBillId).and(new QFilter("id", "not in", ids));
        List list = QueryServiceHelper.queryPrimaryKeys((String)"md_forexquote_h", (QFilter[])new QFilter[]{filter}, (String)"issuetime desc", (int)1);
        if (EmptyUtil.isNoEmpty((Object)list)) {
            DynamicObject forexQuoteH = BusinessDataServiceHelper.loadSingle(list.get(0), (String)"md_forexquote_h");
            this.copy(forexQuote, forexQuoteH);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{forexQuote});
        }
    }

    private void copy(DynamicObject forexQuote, DynamicObject forexQuoteH) {
        forexQuote.set("billno", forexQuoteH.get("billno"));
        forexQuote.set("issuezone", forexQuoteH.get("issuezone"));
        forexQuote.set("issuetime", forexQuoteH.get("issuetime"));
        forexQuote.set("desc", forexQuoteH.get("desc"));
        DynamicObjectCollection define = forexQuote.getDynamicObjectCollection("define");
        define.clear();
        int seq = 1;
        for (Object defineRow : forexQuoteH.getDynamicObjectCollection("define")) {
            DynamicObject defineObj = define.addNew();
            defineObj.set("seq", (Object)seq);
            this.copyColumns(defineObj, (DynamicObject)defineRow, "quotetype", "spotmethod", "dateaxis", "fowardmethod", "fowardquotation", "workcalendar", "dateadjustmethod", "spotdelay", "rateaccuracy", "midcurrency", "lcuryieldcurve", "rcuryieldcurve", "daterule");
            ++seq;
        }
        DynamicObjectCollection input = forexQuote.getDynamicObjectCollection("quoteinput");
        input.clear();
        seq = 1;
        for (DynamicObject inputRow : forexQuoteH.getDynamicObjectCollection("quoteinput")) {
            DynamicObject inputObj = input.addNew();
            inputObj.set("seq", (Object)seq);
            this.copyColumns(inputObj, inputRow, "input_quotetype", "term", "date", "buyprice", "buypoints", "sellprice", "sellpoints", "midprice", "midpoints");
            ++seq;
        }
        DynamicObjectCollection output = forexQuote.getDynamicObjectCollection("quoteoutput");
        output.clear();
        seq = 1;
        for (DynamicObject outputRow : forexQuoteH.getDynamicObjectCollection("quoteoutput")) {
            DynamicObject outputObj = output.addNew();
            outputObj.set("seq", (Object)seq);
            this.copyColumns(outputObj, outputRow, "output_quotetype", "output_term", "output_date", "output_buyprice", "output_sellprice", "output_midprice");
            ++seq;
        }
    }

    private void copyColumns(DynamicObject target, DynamicObject source, String ... keys) {
        for (String key : keys) {
            target.set(key, source.get(key));
        }
    }
}

