/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.opservice.marketdata;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class MarketDataBakService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            if (!this.bakHistoryDataList().contains(bill.getDataEntityType().getName())) continue;
            this.bakHistoryData(bill);
        }
    }

    private void bakHistoryData(final DynamicObject bill) {
        ThreadPools.executeOnceIncludeRequestContext((String)"history", (Runnable)new Runnable(){

            @Override
            public void run() {
                String hisEntity = bill.getDataEntityType().getName() + "_h";
                MarketDataBakService.this.copyAndSaveHistory(bill, hisEntity);
            }
        });
    }

    private void copyAndSaveHistory(DynamicObject bill, String hisEntity) {
        QFilter filter = new QFilter("sourcebillid", "=", bill.getPkValue());
        filter.and("issuezone", "=", bill.getDynamicObject("issuezone").getPkValue());
        filter.and("issuetime", "=", (Object)bill.getDate("issuetime"));
        DeleteServiceHelper.delete((String)hisEntity, (QFilter[])filter.toArray());
        DynamicObject bill_h = TmcDataServiceHelper.newDynamicObject((String)hisEntity);
        DataEntityPropertyCollection propertys = bill.getDataEntityType().getProperties();
        for (IDataEntityProperty property : propertys) {
            if ("id".equals(property.getName()) || "multilanguagetext".equals(property.getName())) continue;
            if (bill.get(property) instanceof DynamicObjectCollection) {
                DynamicObjectCollection entrys = (DynamicObjectCollection)bill_h.get(property);
                DynamicObjectCollection colls = (DynamicObjectCollection)bill.get(property);
                for (DynamicObject info : colls) {
                    DynamicObject entry = entrys.addNew();
                    DataEntityPropertyCollection props = entry.getDataEntityType().getProperties();
                    DynamicObjectType type = colls.getDynamicObjectType();
                    for (IDataEntityProperty prop : props) {
                        if (("id".equals(prop.getName()) || "currpairs".equals(type.toString())) && (!"currpairs".equals(type.toString()) || "pkid".equals(prop.getName()))) continue;
                        entry.set(prop, info.get(prop));
                    }
                }
                continue;
            }
            bill_h.set(property, bill.get(property));
        }
        bill_h.set("sourcebillid", bill.getPkValue());
        bill_h.set("enable", (Object)1);
        bill_h.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        bill_h.set("issuezone", (Object)bill.getDynamicObject("issuezone"));
        this.beforeSaveOp(hisEntity, bill_h);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill_h});
    }

    private void beforeSaveOp(String hisEntity, DynamicObject bill_h) {
        if ("md_forexquote_h".equals(hisEntity)) {
            for (DynamicObject defineRow : bill_h.getDynamicObjectCollection("define")) {
                for (DynamicObject workCalendar : defineRow.getDynamicObjectCollection("workcalendar")) {
                    workCalendar.set("pkid", null);
                    DynamicObject baseData = workCalendar.getDynamicObject("fbasedataid");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)baseData)) continue;
                    workCalendar.set("fbasedataid", workCalendar.getDynamicObject("fbasedataid").getPkValue());
                }
            }
        }
    }

    private List<String> bakHistoryDataList() {
        return Collections.singletonList("md_forexquote");
    }
}

