/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.service.forex;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class ForexQuoteDataService {
    private static Log logger = LogFactory.getLog(ForexQuoteDataService.class);
    private static final String selectProperties = "billno,issuetime,define.quotetype,define.spotdelay,define.workcalendar,input_quotetype,term,buyprice,sellprice,midprice,output_quotetype,output_term,output_date,output_buyprice,output_sellprice,output_midprice";

    public ForexQuoteInfo getForexQuoteInfoWithIssueTime(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        if (issueTime == null) {
            ForexQuoteInfo forexQuoteInfo = new ForexQuoteInfo();
            forexQuoteInfo.setErrMsg(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u53d1\u5e03\u65f6\u95f4\u3002", (String)"ForexQuoteDataService_3", (String)"tmc-md-business", (Object[])new Object[0]));
            return forexQuoteInfo;
        }
        DynamicObject forexQuoteObject = this.queryLatestOfDate(forexQuoteId, currencyPair, issueTime);
        if (forexQuoteObject == null) {
            forexQuoteObject = TmcDataServiceHelper.loadSingle((String)"md_forexquote", (String)"billno", (QFilter[])new QFilter("id", "=", (Object)forexQuoteId).toArray());
            ForexQuoteInfo forexQuoteInfo = new ForexQuoteInfo();
            forexQuoteInfo.setErrMsg(String.format(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u3010%1$s\u3011\u6ca1\u6709\u7ef4\u62a4\u53d1\u5e03\u65e5\u671f\u3010%2$s\u3011\u7684\u6570\u636e\u3002", (String)"ForexQuoteDataService_2", (String)"tmc-md-business", (Object[])new Object[0]), forexQuoteObject.getString("billno"), DateUtils.formatString((Date)issueTime, (String)"yyyy-MM-dd")));
            return forexQuoteInfo;
        }
        logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4e14\u5b58\u5728\u5f53\u5929\u7684\uff0c\u53d6\u5f53\u5929\u6700\u665a\u7684\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
        return this.getInfo(forexQuoteObject, currencyPair, Dm);
    }

    protected void dealPrice(DynamicObjectCollection coll, ForexQuoteInfo forexQuoteInfo, Date Dm) {
        if (coll.size() == 1) {
            forexQuoteInfo.setBuyPrice(((DynamicObject)coll.get(0)).getBigDecimal("output_buyprice"));
            forexQuoteInfo.setSellPrice(((DynamicObject)coll.get(0)).getBigDecimal("output_sellprice"));
            forexQuoteInfo.setMiddleprice(((DynamicObject)coll.get(0)).getBigDecimal("output_midprice"));
            return;
        }
        Date firstDate = ((DynamicObject)coll.get(0)).getDate("output_date");
        Date endDate = ((DynamicObject)coll.get(coll.size() - 1)).getDate("output_date");
        DynamicObject F1ROW = null;
        DynamicObject F2ROW = null;
        if (this.getDiffDays(firstDate, Dm) > 0 && this.getDiffDays(endDate, Dm) <= 0) {
            for (int j = 0; j < coll.size() - 1; ++j) {
                if (this.getDiffDays(((DynamicObject)coll.get(j)).getDate("output_date"), Dm) < 0 || this.getDiffDays(((DynamicObject)coll.get(j + 1)).getDate("output_date"), Dm) > 0) continue;
                F1ROW = (DynamicObject)coll.get(j);
                F2ROW = (DynamicObject)coll.get(j + 1);
                break;
            }
        } else if (this.getDiffDays(firstDate, Dm) <= 0) {
            F1ROW = (DynamicObject)coll.get(0);
            F2ROW = null;
        } else {
            F1ROW = null;
            F2ROW = (DynamicObject)coll.get(coll.size() - 1);
        }
        if (F1ROW != null && F2ROW != null) {
            Date D1 = F1ROW.getDate("output_date");
            Date D2 = F2ROW.getDate("output_date");
            BigDecimal F1 = F1ROW.getBigDecimal("output_buyprice");
            BigDecimal F2 = F2ROW.getBigDecimal("output_buyprice");
            BigDecimal buyPrice = this.calAmount(F1, F2, D1, D2, Dm);
            F1 = F1ROW.getBigDecimal("output_sellprice");
            F2 = F2ROW.getBigDecimal("output_sellprice");
            BigDecimal sellPrice = this.calAmount(F1, F2, D1, D2, Dm);
            F1 = F1ROW.getBigDecimal("output_midprice");
            F2 = F2ROW.getBigDecimal("output_midprice");
            BigDecimal midPrice = this.calAmount(F1, F2, D1, D2, Dm);
            forexQuoteInfo.setBuyPrice(buyPrice);
            forexQuoteInfo.setSellPrice(sellPrice);
            forexQuoteInfo.setMiddleprice(midPrice);
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u4e0a\u4e00\u4e2a\u65e5\u671f={}, \u4e0b\u4e00\u4e2a\u65e5\u671f={}, \u7ebf\u6027\u63d2\u503c\u8ba1\u7b97\u7ed3\u679c\uff1a\u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}", new Object[]{D1, D2, buyPrice, sellPrice});
        } else if (F1ROW != null) {
            forexQuoteInfo.setBuyPrice(F1ROW.getBigDecimal("output_buyprice"));
            forexQuoteInfo.setSellPrice(F1ROW.getBigDecimal("output_sellprice"));
            forexQuoteInfo.setMiddleprice(F1ROW.getBigDecimal("output_midprice"));
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u65e5\u671fD_m\u2264\u62a5\u4ef7\u8f93\u51fa\u9875\u7b7e.\u5bf9\u5e94\u7684\u62a5\u4ef7\u65b9\u5f0f.Today\u7684\u65e5\u671f\uff1a\u53d6Today\u76f8\u5e94\u7684\u4e70\u5165\u4ef7\uff08\u5356\u51fa\u4ef7\u3001\u4e2d\u95f4\u4ef7\uff09\uff0c\u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}", new Object[]{F1ROW.getBigDecimal("output_buyprice"), F1ROW.getBigDecimal("output_sellprice")});
        } else if (F2ROW != null) {
            forexQuoteInfo.setBuyPrice(F2ROW.getBigDecimal("output_buyprice"));
            forexQuoteInfo.setSellPrice(F2ROW.getBigDecimal("output_sellprice"));
            forexQuoteInfo.setMiddleprice(F2ROW.getBigDecimal("output_midprice"));
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u65e5\u671fD_m>\u62a5\u4ef7\u8f93\u51fa\u9875\u7b7e.\u5bf9\u5e94\u7684\u62a5\u4ef7\u65b9\u5f0f.\u6700\u540e\u7684\u65e5\u671f\uff1a\u53d6\u6700\u540e\u7684\u65e5\u671f\u76f8\u5e94\u7684\u4e70\u5165\u4ef7\uff08\u5356\u51fa\u4ef7\u3001\u4e2d\u95f4\u4ef7\uff09\uff0c\u4e70\u5165\u4ef7={}, \u5356\u51fa\u4ef7={}", new Object[]{F2ROW.getBigDecimal("output_buyprice"), F2ROW.getBigDecimal("output_sellprice")});
        }
    }

    private int getDiffDays(Date d1, Date d2) {
        return TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)d1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)d2, (boolean)true));
    }

    protected ForexQuoteInfo getInfoWhenSpot(ForexQuoteInfo forexQuoteInfo, String currencyPair, DynamicObject forexQuoteObject) {
        String[] currencyPairs = this.getCurrencyPair(currencyPair);
        currencyPair = currencyPairs[0];
        String otherPair = currencyPairs[1];
        for (DynamicObject outputRow : forexQuoteObject.getDynamicObjectCollection("quoteoutput")) {
            if (!"Spot".equals(outputRow.getString("output_term"))) continue;
            if (currencyPair.equals(outputRow.getString("output_quotetype"))) {
                forexQuoteInfo.setFxquote(currencyPair);
            } else {
                if (!otherPair.equals(outputRow.getString("output_quotetype"))) continue;
                forexQuoteInfo.setFxquote(otherPair);
            }
            forexQuoteInfo.setBuyPrice(outputRow.getBigDecimal("output_buyprice"));
            forexQuoteInfo.setSellPrice(outputRow.getBigDecimal("output_sellprice"));
            forexQuoteInfo.setMiddleprice(outputRow.getBigDecimal("output_midprice"));
            return forexQuoteInfo;
        }
        forexQuoteInfo.setErrMsg(String.format(ResManager.loadResFormat((String)"\u8d27\u5e01\u5bf9%1$s\u5728\u5e02\u573a\u6570\u636e\u4e0b\u7684\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6216\u91cd\u65b0\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexQuoteDataService_1", (String)"tmc-md-business", (Object[])new Object[0]), currencyPair, forexQuoteObject.getString("billno")));
        return forexQuoteInfo;
    }

    private String[] getCurrencyPair(String currencyPair) {
        String[] currencyPairs = new String[2];
        String[] ss = !currencyPair.contains("/") ? currencyPair.split("-") : currencyPair.split("/");
        currencyPairs[0] = ss[0] + "/" + ss[1];
        currencyPairs[1] = ss[1] + "/" + ss[0];
        return currencyPairs;
    }

    public ForexQuoteInfo getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        DynamicObject forexQuoteObject;
        QFilter quoteTypeFilter = new QFilter("quoteoutput.output_quotetype", "in", (Object)this.getCurrencyPair(currencyPair));
        logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1aforexQuoteId={}, currencyPair={}, issueTime={}, Dm={}", new Object[]{forexQuoteId, currencyPair, issueTime, Dm});
        if (issueTime == null) {
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u4e0d\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\uff0c\u53d6\u6700\u65b0");
            forexQuoteObject = this.queryNewestForexQuote(forexQuoteId, quoteTypeFilter);
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(issueTime);
            if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
                forexQuoteObject = this.queryLatestOfDate(forexQuoteId, currencyPair, issueTime);
                if (forexQuoteObject == null) {
                    forexQuoteObject = this.queryRecentForexQuote(issueTime, forexQuoteId, quoteTypeFilter);
                    if (forexQuoteObject != null) {
                        logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4f46\u4e0d\u5b58\u5728\u5f53\u5929\u7684\uff0c\u53d6\u524d\u540e\u6700\u8fd1\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
                    } else {
                        logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4f46\u4e0d\u5b58\u5728\u5f53\u5929\u7684\uff0c\u53d6\u524d\u540e\u6700\u8fd1\u7684\u4e5f\u672a\u67e5\u8be2\u5230");
                    }
                } else {
                    logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4e14\u5b58\u5728\u5f53\u5929\u7684\uff0c\u53d6\u5f53\u5929\u6700\u665a\u7684\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
                }
            } else {
                forexQuoteObject = this.queryRecentForexQuote(issueTime, forexQuoteId, quoteTypeFilter);
                if (forexQuoteObject != null) {
                    logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4e14\u4e3a\u957f\u65e5\u671f\uff0c\u53d6\u524d\u540e\u6700\u8fd1\u4e00\u6761\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
                } else {
                    logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6307\u5b9a\u53d1\u5e03\u65e5\u671f\u4e14\u4e3a\u957f\u65e5\u671f\uff0c\u53d6\u524d\u540e\u6700\u8fd1\u7684\uff0c\u4f46\u672a\u67e5\u8be2\u5230\u6570\u636e");
                }
            }
        }
        if (forexQuoteObject == null) {
            forexQuoteObject = TmcDataServiceHelper.loadSingle((String)"md_forexquote", (String)"billno", (QFilter[])new QFilter("id", "=", (Object)forexQuoteId).toArray());
            ForexQuoteInfo forexQuoteInfo = new ForexQuoteInfo();
            forexQuoteInfo.setErrMsg(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9%1$s\u5728\u5e02\u573a\u6570\u636e\u4e0b\u7684\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6216\u91cd\u65b0\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexQuoteDataService_1", (String)"tmc-md-business", (Object[])new Object[0]), currencyPair, forexQuoteObject.getString("billno")));
            return forexQuoteInfo;
        }
        return this.getInfo(forexQuoteObject, currencyPair, Dm);
    }

    private DynamicObject queryLatestOfDate(Long forexQuoteId, String currencyPair, Date issueTime) {
        Date min = DateUtils.truncateDate((Date)issueTime);
        Date max = DateUtils.getNextDay((Date)min, (int)1);
        QFilter quoteTypeFilter = new QFilter("quoteoutput.output_quotetype", "in", (Object)this.getCurrencyPair(currencyPair));
        QFilter qFilter = new QFilter("id", "=", (Object)forexQuoteId);
        QFilter historyQFilter = new QFilter("sourcebillid", "=", (Object)forexQuoteId);
        QFilter issueTimeQFilter = new QFilter("issuetime", ">=", (Object)min).and(new QFilter("issuetime", "<", (Object)max));
        Object[] fqs = TmcDataServiceHelper.load((String)"md_forexquote_h", (String)selectProperties, (QFilter[])historyQFilter.and(issueTimeQFilter).and(quoteTypeFilter).toArray(), (String)"issuetime desc");
        DynamicObject fq = TmcDataServiceHelper.loadSingle((String)"md_forexquote", (String)selectProperties, (QFilter[])qFilter.and(issueTimeQFilter).and(quoteTypeFilter).toArray());
        if (EmptyUtil.isNoEmpty((Object[])fqs) && fq != null) {
            Date issueTime1 = fqs[0].getDate("issuetime");
            Date issueTime2 = fq.getDate("issuetime");
            return issueTime2.compareTo(issueTime1) >= 0 ? fq : fqs[0];
        }
        if (EmptyUtil.isEmpty((Object[])fqs) && fq != null) {
            return fq;
        }
        if (EmptyUtil.isNoEmpty((Object[])fqs) && fq == null) {
            return fqs[0];
        }
        return null;
    }

    private ForexQuoteInfo getInfo(DynamicObject forexQuoteObject, String currencyPair, Date Dm) {
        logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u5916\u6c47\u62a5\u4ef7\u7f16\u53f7\uff1a" + forexQuoteObject.getString("billno"));
        ForexQuoteInfo forexQuoteInfo = new ForexQuoteInfo();
        forexQuoteInfo.setIssuetime(forexQuoteObject.getDate("issuetime"));
        if (EmptyUtil.isEmpty((Object)Dm)) {
            return this.getInfoWhenSpot(forexQuoteInfo, currencyPair, forexQuoteObject);
        }
        DynamicObjectCollection coll = this.getSortedOutEntry(currencyPair, forexQuoteObject, forexQuoteInfo);
        if (coll.size() == 0) {
            forexQuoteInfo.setErrMsg(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9%1$s\u5728\u5e02\u573a\u6570\u636e\u4e0b\u7684\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u6216\u91cd\u65b0\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexQuoteDataService_1", (String)"tmc-md-business", (Object[])new Object[0]), currencyPair, forexQuoteObject.getString("billno")));
            return forexQuoteInfo;
        }
        this.dealPrice(coll, forexQuoteInfo, Dm);
        return forexQuoteInfo;
    }

    private DynamicObject queryNewestForexQuote(Long forexQuoteId, QFilter quoteTypeFilter) {
        Object forexQuoteObject = TmcDataServiceHelper.loadSingle((String)"md_forexquote", (String)selectProperties, (QFilter[])new QFilter("id", "=", (Object)forexQuoteId).and(quoteTypeFilter).toArray());
        if (forexQuoteObject == null) {
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u6700\u65b0\u62a5\u4ef7\u6570\u636e\u4e2d\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u7ee7\u7eed\u67e5\u8be2\u5386\u53f2\u62a5\u4ef7");
            Object[] forexQuoteObjects = TmcDataServiceHelper.load((String)"md_forexquote_h", (String)selectProperties, (QFilter[])new QFilter("sourcebillid", "=", (Object)forexQuoteId).and(quoteTypeFilter).toArray(), (String)"issuetime desc", (int)1);
            if (EmptyUtil.isNoEmpty((Object[])forexQuoteObjects)) {
                forexQuoteObject = forexQuoteObjects[0];
                logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u5386\u53f2\u62a5\u4ef7\u67e5\u8be2\u5230\u6570\u636e\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
            } else {
                logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u5386\u53f2\u62a5\u4ef7\u4e5f\u672a\u67e5\u8be2\u5230\u6570\u636e");
            }
        } else {
            logger.info("\u62a5\u4ef7\u63a5\u53e3\uff1a\u67e5\u8be2\u51fa\u6700\u65b0\u62a5\u4ef7\u6570\u636e\uff0c\u53d1\u5e03\u65e5\u671f={}", forexQuoteObject.get("issuetime"));
        }
        return forexQuoteObject;
    }

    private DynamicObject queryRecentForexQuote(Date issueTime, Long forexQuoteId, QFilter quoteTypeFilter) {
        Set set;
        DynamicObject fq;
        DynamicObject lessObj;
        QFilter less;
        List lessList;
        DynamicObject largeObj;
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(3);
        long time = issueTime.getTime();
        QFilter large = new QFilter("sourcebillid", "=", (Object)forexQuoteId).and(new QFilter("issuetime", ">=", (Object)issueTime));
        List largeList = QueryServiceHelper.queryPrimaryKeys((String)"md_forexquote_h", (QFilter[])new QFilter[]{large, quoteTypeFilter}, (String)"issuetime asc", (int)1);
        if (EmptyUtil.isNoEmpty((Object)largeList) && (largeObj = BusinessDataServiceHelper.loadSingle(largeList.get(0), (String)"md_forexquote_h")) != null && EmptyUtil.isNoEmpty((Object)largeObj.getDate("issuetime"))) {
            map.put(largeObj.getDate("issuetime").getTime() - time, largeObj);
        }
        if (EmptyUtil.isNoEmpty((Object)(lessList = QueryServiceHelper.queryPrimaryKeys((String)"md_forexquote_h", (QFilter[])new QFilter[]{less = new QFilter("sourcebillid", "=", (Object)forexQuoteId).and(new QFilter("issuetime", "<", (Object)issueTime)), quoteTypeFilter}, (String)"issuetime desc", (int)1))) && (lessObj = BusinessDataServiceHelper.loadSingle(lessList.get(0), (String)"md_forexquote_h")) != null && EmptyUtil.isNoEmpty((Object)lessObj.getDate("issuetime"))) {
            map.put(time - lessObj.getDate("issuetime").getTime(), lessObj);
        }
        if ((fq = TmcDataServiceHelper.loadSingle((String)"md_forexquote", (String)selectProperties, (QFilter[])new QFilter("id", "=", (Object)forexQuoteId).and(quoteTypeFilter).toArray())) != null && EmptyUtil.isNoEmpty((Object)fq.getDate("issuetime"))) {
            map.put(Math.abs(fq.getDate("issuetime").getTime()) - time, fq);
        }
        if (!(set = map.keySet()).isEmpty()) {
            Long minDiffMs = (Long)set.stream().min(Long::compare).get();
            return (DynamicObject)map.get(minDiffMs);
        }
        return null;
    }

    private DynamicObjectCollection getSortedOutEntry(String currencyPair, DynamicObject forexQuoteObject, ForexQuoteInfo forexQuoteInfo) {
        DynamicObjectCollection coll = (DynamicObjectCollection)forexQuoteObject.getDynamicObjectCollection("quoteoutput").clone();
        coll.removeIf(DynamicObject2 -> !currencyPair.equals(DynamicObject2.getString("output_quotetype")));
        forexQuoteInfo.setFxquote(currencyPair);
        if (coll.size() == 0) {
            String[] currencyArray = currencyPair.contains("/") ? currencyPair.split("/") : currencyPair.split("-");
            String quoteType = currencyArray[1] + "/" + currencyArray[0];
            forexQuoteInfo.setFxquote(quoteType);
            coll = forexQuoteObject.getDynamicObjectCollection("quoteoutput");
            coll.removeIf(DynamicObject2 -> !quoteType.equals(DynamicObject2.getString("output_quotetype")));
        }
        coll.sort((row1, row2) -> {
            Date date2;
            Date date1 = row1.getDate("output_date");
            if (TcDateUtils.isSameDay((Date)date1, (Date)(date2 = row2.getDate("output_date")))) {
                return 0;
            }
            return date1.after(date2) ? 1 : -1;
        });
        return coll;
    }

    private BigDecimal calAmount(BigDecimal F1, BigDecimal F2, Date D1, Date D2, Date Dm) {
        BigDecimal param1 = F2.subtract(F1);
        BigDecimal param2 = new BigDecimal(TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)D1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)Dm, (boolean)true)));
        BigDecimal param3 = new BigDecimal(TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)D1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)D2, (boolean)true)));
        return F1.add(param1.multiply(param2).divide(param3, 10, 4));
    }
}

