/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.service.impl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.md.business.service.factory.IMarketDataServiceFacade;
import kd.tmc.md.business.service.forex.ForexQuoteDataService;
import kd.tmc.md.business.service.refer.IndexDataService;
import kd.tmc.md.business.service.refer.ReferRateDataService;
import kd.tmc.md.business.service.yieldcurve.YieldCurveDataService;

public class MarketDataServiceFacadeImpl
implements IMarketDataServiceFacade {
    @Override
    public PriceRuleInfo priceRule(Long priceRuleId, PriceRuleInfo param) {
        DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)priceRuleId, (String)"md_pricerule");
        try {
            DynamicObject forexquote = priceRule.getDynamicObject("forexquote");
            if (EmptyUtil.isNoEmpty((DynamicObject)forexquote) && EmptyUtil.isNoEmpty((Object[])param.getForexQuote())) {
                ForexQuoteDataService forexQuoteService = new ForexQuoteDataService();
                ForexQuoteInfo[] forexQuoteInfoArray = param.getForexQuote();
                int n = forexQuoteInfoArray.length;
                for (int i = 0; i < n; ++i) {
                    ForexQuoteInfo forexQuoteParam = forexQuoteInfoArray[i];
                    if (forexQuoteParam == null) continue;
                    forexQuoteParam = forexQuoteService.getForexQuoteInfo((Long)forexquote.getPkValue(), forexQuoteParam.getFxquote(), forexQuoteParam.getIssuetime(), forexQuoteParam.getIssuetime());
                }
            }
        }
        catch (KDBizException e) {
            param.setErr(e.getMessage());
        }
        try {
            YieldCurveDataService yieldCurveService = new YieldCurveDataService();
            if (EmptyUtil.isNoEmpty((Object[])param.getYieldCurve())) {
                for (YieldCurveInfo yieldCurveParam : param.getYieldCurve()) {
                    if (yieldCurveParam == null) continue;
                    yieldCurveParam = yieldCurveService.queryYieldCurve(priceRule, yieldCurveParam);
                }
            }
        }
        catch (KDBizException e) {
            param.setErr(e.getMessage());
        }
        return param;
    }

    @Override
    public YieldCurveInfo yieldCurve(YieldCurveInfo yieldCurve) {
        if (EmptyUtil.isNoEmpty((Long)yieldCurve.getYieldCurveId())) {
            YieldCurveDataService yieldCurveService = new YieldCurveDataService();
            yieldCurve = yieldCurveService.queryYieldCurve(null, yieldCurve);
        }
        return yieldCurve;
    }

    @Override
    public Long yieldCurve(Long priceRuleId, Long marketId, YieldTypeEnum yieldType) {
        YieldCurveDataService service = new YieldCurveDataService();
        return service.yieldCurve(priceRuleId, marketId, yieldType);
    }

    @Override
    public Map<Date, BigDecimal> index(String index, Set<Date> quoteDate, MarkPriceEnum markprice, boolean isReturnEmpty) {
        IndexDataService service = new IndexDataService();
        return service.index(index, quoteDate, markprice, isReturnEmpty);
    }

    @Override
    public Map<Date, BigDecimal> referRate(String index, Set<Date> quoteDate, boolean isReturnEmpty) {
        ReferRateDataService service = new ReferRateDataService();
        return service.referRate(index, quoteDate, isReturnEmpty);
    }

    @Override
    public Map<Date, BigDecimal> getReferRatesByDate(String referRate, Date startDate, Date endDate) {
        ReferRateDataService service = new ReferRateDataService();
        return service.getReferRatesByDate(referRate, startDate, endDate);
    }

    @Override
    public String getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        ForexQuoteDataService service = new ForexQuoteDataService();
        ForexQuoteInfo forexQuoteInfo = service.getForexQuoteInfo(forexQuoteId, currencyPair, issueTime, Dm);
        return SerializationUtils.toJsonString((Object)forexQuoteInfo);
    }

    @Override
    public String getForexQuoteInfoWithIssueTime(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        ForexQuoteDataService service = new ForexQuoteDataService();
        ForexQuoteInfo forexQuoteInfo = service.getForexQuoteInfoWithIssueTime(forexQuoteId, currencyPair, issueTime, Dm);
        return SerializationUtils.toJsonString((Object)forexQuoteInfo);
    }
}

