/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.service.refer;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class IndexDataService {
    public Map<Date, BigDecimal> index(String number, Set<Date> quoteDates, MarkPriceEnum markprice, boolean isReturnEmpty) {
        HashMap<Date, BigDecimal> data = new HashMap<Date, BigDecimal>(quoteDates.size());
        for (Date quoteDate : quoteDates) {
            BigDecimal value = this.index(number, quoteDate, markprice, isReturnEmpty);
            data.put(quoteDate, value);
        }
        return data;
    }

    public BigDecimal index(String number, Date quoteDate, MarkPriceEnum markprice, boolean isReturnEmpty) {
        BigDecimal rate = null;
        quoteDate = EmptyUtil.isEmpty((Object)quoteDate) ? TcDateUtils.getCurrentDate() : TcDateUtils.truncateDate((Date)quoteDate);
        QFilter filter = new QFilter("referindex.number", "=", (Object)number);
        if (isReturnEmpty) {
            filter.and(new QFilter("bizdate", "=", (Object)quoteDate));
        }
        Map indexs = TmcDataServiceHelper.loadFromCache((String)"md_dataindex", (String)"bizdate,begin_price,end_price,max_price,min_price,spec_point,avg_price", (QFilter[])filter.toArray(), (String)"bizdate desc");
        for (DynamicObject index : indexs.values()) {
            if (index.getDate("bizdate").compareTo(quoteDate) == 0) {
                rate = index.getBigDecimal(markprice.getValue());
                break;
            }
            if (index.getDate("bizdate").compareTo(quoteDate) >= 0) continue;
            rate = index.getBigDecimal(markprice.getValue());
            break;
        }
        return rate;
    }
}

