/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.service.refer;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class ReferRateDataService {
    public Map<Date, BigDecimal> referRate(String index, Set<Date> quoteDates, boolean isReturnEmpty) {
        HashMap<Date, BigDecimal> data = new HashMap<Date, BigDecimal>(quoteDates.size());
        for (Date quoteDate : quoteDates) {
            BigDecimal value = this.referRate(index, quoteDate, isReturnEmpty);
            data.put(quoteDate, value);
        }
        return data;
    }

    public BigDecimal referRate(String referRateNum, Date quoteDate, boolean isReturnEmpty) {
        BigDecimal rate = null;
        quoteDate = EmptyUtil.isEmpty((Object)quoteDate) ? TcDateUtils.getCurrentDate() : TcDateUtils.truncateDate((Date)quoteDate);
        QFilter filter = new QFilter("referrate.number", "=", (Object)referRateNum).and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("bizdate", "<", (Object)TcDateUtils.getNextDay((Date)quoteDate, (int)1)));
        DynamicObjectCollection referRates = QueryServiceHelper.query((String)"md_datarate", (String)"bizdate,endprice", (QFilter[])filter.toArray(), (String)"bizdate desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)referRates)) {
            DynamicObject referRate = (DynamicObject)referRates.get(0);
            if (isReturnEmpty && referRate.getDate("bizdate").compareTo(quoteDate) != 0) {
                return BigDecimal.ZERO;
            }
            rate = referRate.getBigDecimal("endprice");
        }
        return rate;
    }

    public Map<Date, BigDecimal> getReferRatesByDate(String referRateNum, Date startDate, Date endDate) {
        endDate = endDate == null ? TcDateUtils.stringToDate((String)"2099-01-01", (String)"yyyy-MM-dd") : TcDateUtils.truncateDate((Date)endDate);
        TreeMap<Date, BigDecimal> result = new TreeMap<Date, BigDecimal>(Date::compareTo);
        QFilter filter = new QFilter("referrate.number", "=", (Object)referRateNum).and(new QFilter("bizdate", "<", (Object)TcDateUtils.getNextDay((Date)endDate, (int)1))).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection referRates = QueryServiceHelper.query((String)"md_datarate", (String)"id,bizdate,endprice", (QFilter[])filter.toArray(), (String)"bizdate asc");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)referRates)) {
            TreeMap tempFirstMap = new TreeMap(Comparator.reverseOrder());
            for (DynamicObject referRate : referRates) {
                Date bizdate = TcDateUtils.truncateDate((Date)referRate.getDate("bizdate"));
                BigDecimal endprice = referRate.getBigDecimal("endprice");
                if (bizdate.compareTo(startDate) <= 0) {
                    tempFirstMap.put(bizdate, endprice);
                    continue;
                }
                result.put(bizdate, endprice);
            }
            if (EmptyUtil.isNoEmpty(tempFirstMap)) {
                tempFirstMap.entrySet().stream().findFirst().ifPresent(o -> {
                    BigDecimal cfr_ignored_0 = (BigDecimal)result.put((Date)o.getKey(), (BigDecimal)o.getValue());
                });
            }
        }
        return result;
    }
}

