/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.service.yieldcurve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.md.common.enums.BootStrapEnum;
import kd.tmc.md.common.errorcode.MdErrorCode;
import kd.tmc.md.common.info.YieldCurveDataInfo;

public class YieldCurveDataService {
    private static final Log logger = LogFactory.getLog(YieldCurveDataService.class);

    public YieldCurveInfo queryYieldCurve(DynamicObject priceRule, YieldCurveInfo yieldCurveParam) {
        if (EmptyUtil.isNoEmpty((Long)yieldCurveParam.getYieldCurveId())) {
            DynamicObject yieldInfo = TmcDataServiceHelper.loadSingle((Object)yieldCurveParam.getYieldCurveId(), (String)"md_yieldline");
            YieldCurveDataInfo ycInfo = this.parserYieldCurveDataByYield(yieldCurveParam, yieldInfo);
            Map<Date, BigDecimal> furDFMap = YieldCurveDataService.getDataMap(ycInfo, yieldInfo);
            yieldCurveParam.setDfMap(furDFMap);
        } else {
            DynamicObjectCollection priceYieldColls = priceRule.getDynamicObjectCollection("yield");
            boolean match = false;
            for (DynamicObject priceYield : priceYieldColls) {
                if (priceYield.getDynamicObject("market").getLong("id") != yieldCurveParam.getMarketId().longValue() || !priceYield.getString("type").equals(yieldCurveParam.getYieldType().getValue())) continue;
                match = true;
                if (priceYield.getDynamicObject("yields") == null) {
                    throw new TmcBizException(MdErrorCode.NOT_FILL_YIELDCURVE());
                }
                DynamicObject yieldInfo = TmcDataServiceHelper.loadSingle((Object)priceYield.getDynamicObject("yields").getLong("id"), (String)"md_yieldline");
                YieldCurveDataInfo ycInfo = this.parseYieldCurveDataInfo(yieldCurveParam, yieldInfo);
                Map<Date, BigDecimal> furDFMap = YieldCurveDataService.getDataMap(ycInfo, yieldInfo);
                yieldCurveParam.setDfMap(furDFMap);
            }
            if (!match) {
                throw new TmcBizException(new MdErrorCode().NOT_MATCH_YIELD());
            }
        }
        return yieldCurveParam;
    }

    private YieldCurveDataInfo parserYieldCurveDataByYield(YieldCurveInfo yieldCurveParam, DynamicObject yieldInfo) {
        Date refDate = EmptyUtil.isEmpty((Object)yieldCurveParam.getReferDate()) ? TcDateUtils.getCurrentDate() : yieldCurveParam.getReferDate();
        boolean zerorate = yieldInfo.getBoolean("zerorate");
        String bootStrap = yieldInfo.getString("bootstrap");
        String interpolation = yieldInfo.getString("interptype");
        String bondDealType = yieldInfo.getString("bonddealtype");
        YieldCurveDataInfo ycInfo = new YieldCurveDataInfo();
        String intbench = yieldInfo.getString("basis");
        BasisEnum intbenchEnum = BasisEnum.valueOf((String)intbench);
        ycInfo.setIntbenchEnum(intbenchEnum);
        if (zerorate) {
            ycInfo.setZerorate(zerorate);
        } else {
            BootStrapEnum bootStrapEnum = BootStrapEnum.valueOf((String)bootStrap);
            ycInfo.setBootStrapEnum(bootStrapEnum);
        }
        DynamicObjectCollection workCalendars = yieldInfo.getDynamicObjectCollection("workcalendar");
        ycInfo.setCalendars(workCalendars);
        String frequency = yieldInfo.getString("frequency");
        ycInfo.setFrequency(frequency);
        ycInfo.setRefDate(refDate);
        ycInfo.setYieldFinEntrys(yieldInfo.getDynamicObjectCollection("fintoolentry"));
        ycInfo.setInterpolation(interpolation);
        ycInfo.setBondDealType(bondDealType);
        Date furDate = yieldCurveParam.getFurDate();
        ycInfo.setFurDate(furDate);
        Map furDateToQueryDateMap = yieldCurveParam.getFurDateToQueryDateMap();
        if (EmptyUtil.isEmpty((Object)furDateToQueryDateMap)) {
            ycInfo.setFurDateList(new ArrayList(yieldCurveParam.getDfMap().keySet()));
        } else {
            ycInfo.setFurDateToQueryDateMap(yieldCurveParam.getFurDateToQueryDateMap());
        }
        ycInfo.setFurType(yieldCurveParam.getValType());
        return ycInfo;
    }

    public Long yieldCurve(Long priceRuleId, Long marketId, YieldTypeEnum yieldType) {
        Long id = null;
        String sSQL = "Select FYieldsId From t_tbd_pricerule_yield Where Fid = ? and FMarketId = ? and FType = ?";
        DataSet ds = DB.queryDataSet((String)"workCalendar", (DBRoute)DBRouteConst.TC, (String)sSQL, (Object[])new Object[]{priceRuleId, marketId, yieldType});
        if (ds.hasNext()) {
            Row row = ds.next();
            id = row.getLong("FYieldsId");
        }
        return id;
    }

    private YieldCurveDataInfo parseYieldCurveDataInfo(YieldCurveInfo param, DynamicObject yieldInfo) {
        Date refDate = param.getReferDate();
        Date furDate = param.getFurDate();
        ReturnValTypeEnum queryType = param.getValType();
        boolean zerorate = yieldInfo.getBoolean("zerorate");
        String bootStrap = yieldInfo.getString("bootstrap");
        String interpolation = yieldInfo.getString("interptype");
        String bondDealType = yieldInfo.getString("bonddealtype");
        DynamicObjectCollection workCalendars = yieldInfo.getDynamicObjectCollection("workcalendar");
        DynamicObjectCollection fintoolEntry = yieldInfo.getDynamicObjectCollection("fintoolentry");
        String frequency = yieldInfo.getString("frequency");
        String intbench = yieldInfo.getString("basis");
        BasisEnum intbenchEnum = BasisEnum.valueOf((String)intbench);
        YieldCurveDataInfo ycInfo = new YieldCurveDataInfo();
        ycInfo.setRefDate(refDate);
        ycInfo.setIntbenchEnum(intbenchEnum);
        if (zerorate) {
            ycInfo.setZerorate(zerorate);
        } else {
            BootStrapEnum bootStrapEnum = BootStrapEnum.valueOf((String)bootStrap);
            ycInfo.setBootStrapEnum(bootStrapEnum);
        }
        ycInfo.setCalendars(workCalendars);
        ycInfo.setFrequency(frequency);
        ycInfo.setInterpolation(interpolation);
        ycInfo.setYieldFinEntrys(fintoolEntry);
        ycInfo.setBondDealType(bondDealType);
        ycInfo.setFurDate(furDate);
        ycInfo.setBondEndRoll(yieldInfo.getBoolean("bondendroll"));
        Map furDateToQueryDateMap = param.getFurDateToQueryDateMap();
        if (EmptyUtil.isEmpty((Object)furDateToQueryDateMap)) {
            ycInfo.setFurDateList(new ArrayList(param.getDfMap().keySet()));
        } else {
            ycInfo.setFurDateToQueryDateMap(param.getFurDateToQueryDateMap());
        }
        ycInfo.setFurType(queryType);
        return ycInfo;
    }

    private static Map<Date, BigDecimal> getDataMap(YieldCurveDataInfo ycInfo, DynamicObject yieldInfo) {
        DynamicObjectCollection fintoolEntry = ycInfo.getYieldFinEntrys();
        ArrayList dateList = new ArrayList(fintoolEntry.size());
        HashMap result = new HashMap(fintoolEntry.size());
        YieldCurveHelper.fillAllDFByFintool((DynamicObject)yieldInfo, (Date)ycInfo.getRefDate(), dateList, result);
        Map furDateToQueryDateMap = ycInfo.getFurDateToQueryDateMap();
        Map<Date, BigDecimal> querydateResult = new HashMap<Date, BigDecimal>();
        if (EmptyUtil.isEmpty((Object)furDateToQueryDateMap)) {
            querydateResult = YieldCurveHelper.getDFOrZeroRate((DynamicObject)yieldInfo, (ReturnValTypeEnum)ycInfo.getFurType(), (Date)ycInfo.getRefDate(), (Date)ycInfo.getFurDate(), (List)ycInfo.getFurDateList(), dateList, result);
            for (Map.Entry<Date, BigDecimal> oneResult : querydateResult.entrySet()) {
                if (oneResult.getKey().after(ycInfo.getRefDate())) continue;
                oneResult.setValue(BigDecimal.ONE);
            }
        } else {
            Set entries = furDateToQueryDateMap.entrySet();
            for (Map.Entry entry : entries) {
                Date furDate = (Date)entry.getKey();
                ArrayList<Date> furDateList = new ArrayList<Date>((Collection)entry.getValue());
                if (!furDateList.contains(furDate)) {
                    furDateList.add(furDate);
                }
                Map res = YieldCurveHelper.getDFOrZeroRate((DynamicObject)yieldInfo, (ReturnValTypeEnum)ycInfo.getFurType(), (Date)ycInfo.getRefDate(), (Date)furDate, furDateList, dateList, result);
                for (Map.Entry entry2 : res.entrySet()) {
                    if (((Date)entry2.getKey()).after(ycInfo.getRefDate())) continue;
                    entry2.setValue(BigDecimal.ONE);
                }
                querydateResult.putAll(res);
            }
        }
        return querydateResult;
    }
}

