/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.validate.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.md.common.enums.CalMethodEnum;
import kd.tmc.md.common.enums.DateRuleEnum;

public class ForexQuoteSaveOppValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validate(dataEntity);
        }
    }

    private void validate(ExtendedDataEntity dataEntity) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dataEntity.getDataEntity().getDynamicObjectCollection("quoteoutput"))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u4ef7\u8f93\u51fa\u9875\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForexQuoteSaveOppValidator_4", (String)"tmc-md-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection defineRows = dataEntity.getDataEntity().getDynamicObjectCollection("define");
        for (int rowIndex = 0; rowIndex < defineRows.size(); ++rowIndex) {
            DynamicObject defineRow = (DynamicObject)defineRows.get(rowIndex);
            String spotMethod = defineRow.getString("spotmethod");
            String fowardMethod = defineRow.getString("fowardmethod");
            String dateRule = defineRow.getString("daterule");
            if (fowardMethod.equals(CalMethodEnum.specify.getValue())) {
                this.validateMustInput(dataEntity, defineRow, rowIndex, "fowardquotation", "dateaxis");
            } else if (fowardMethod.equals(CalMethodEnum.crossExRate.getValue())) {
                this.validateMustInput(dataEntity, defineRow, rowIndex, "dateaxis");
            } else if (fowardMethod.equals(CalMethodEnum.ycDeduction.getValue())) {
                this.validateMustInput(dataEntity, defineRow, rowIndex, "rcuryieldcurve", "lcuryieldcurve", "dateaxis");
            }
            if (spotMethod.equals(CalMethodEnum.crossExRate.getValue()) || fowardMethod.equals(CalMethodEnum.crossExRate.getValue())) {
                this.validateMustInput(dataEntity, defineRow, rowIndex, "midcurrency");
            }
            if (!DateRuleEnum.sys.getValue().equals(dateRule)) continue;
            this.validateMustInput(dataEntity, defineRow, rowIndex, "dateadjustmethod");
        }
        DynamicObjectCollection inputRows = dataEntity.getDataEntity().getDynamicObjectCollection("quoteinput");
        for (int rowIndex = 0; rowIndex < inputRows.size(); ++rowIndex) {
            DynamicObject inputRow = (DynamicObject)inputRows.get(rowIndex);
            if (EmptyUtil.isEmpty((Object)inputRow.get("date"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u9875\u5b58\u5728\u672a\u5f55\u5165\u201c\u65e5\u671f\u201d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForexQuoteSaveOppValidator_3", (String)"tmc-md-business", (Object[])new Object[0]));
                break;
            }
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{inputRow.get("buyprice"), inputRow.get("sellprice"), inputRow.get("midprice")}) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{inputRow.get("buypoints"), inputRow.get("sellpoints"), inputRow.get("midpoints")})) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f55\u5165\u9875\u5b58\u5728\u672a\u5f55\u5165\u201c\u4ef7\u683c\u201d\u6216\u201c\u70b9\u6570\u201d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForexQuoteSaveOppValidator_1", (String)"tmc-md-business", (Object[])new Object[0]));
            break;
        }
        this.validatePrice(dataEntity);
    }

    private void validateMustInput(ExtendedDataEntity dataEntity, DynamicObject entryRow, int rowIndex, String ... columnKeys) {
        for (String columnKey : columnKeys) {
            if (!this.isValNull(entryRow, columnKey)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadResFormat((String)ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\u7684{1}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexQuoteSaveOppValidator_0", (String)"tmc-md-business", (Object[])new Object[0]), (String)"ForexQuoteSaveOppValidator_0", (String)"tmc-md-business", (Object[])new Object[]{rowIndex + 1, ((IDataEntityProperty)entryRow.getDataEntityType().getProperties().get((Object)columnKey)).getDisplayName()}));
        }
        if (!dataEntity.getDataEntity().getString("billno").startsWith("UNITTEST")) {
            this.validatePrice(dataEntity);
        }
    }

    private boolean isValNull(DynamicObject entryRow, String columnKey) {
        Object rowVal = entryRow.get(columnKey);
        return EmptyUtil.isEmpty((Object)rowVal);
    }

    private void validatePrice(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection outputRows = dataEntity.getDataEntity().getDynamicObjectCollection("quoteoutput");
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (int i = 0; i < outputRows.size(); ++i) {
            DynamicObject row = (DynamicObject)outputRows.get(i);
            if ("Today".equals(row.get("output_term")) || ((BigDecimal)row.get("output_buyprice")).compareTo((BigDecimal)row.get("output_sellprice")) <= 0) continue;
            map.computeIfAbsent((String)row.get("output_quotetype"), k -> new ArrayList());
            ((List)map.get(row.get("output_quotetype"))).add((String)row.get("output_term"));
        }
        if (EmptyUtil.isNoEmpty(map)) {
            int max = 9;
            StringBuilder errorMsgBuilder = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                StringBuilder itemsBuilder = new StringBuilder();
                List items = (List)entry.getValue();
                for (int i = 0; i < items.size() && i <= max; ++i) {
                    if (i == 0) {
                        itemsBuilder.append(" ");
                    }
                    itemsBuilder.append((String)items.get(i));
                    if (i == max || i == items.size() - 1) {
                        itemsBuilder.append(" ");
                        continue;
                    }
                    itemsBuilder.append("\u3001");
                }
                if (items.size() > max) {
                    itemsBuilder.append("... ");
                }
                errorMsgBuilder.append(ResManager.loadResFormat((String)ResManager.loadKDString((String)"{0}\u671f\u9650\u4e3a {1} \u7684\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\u3002", (String)"ForexQuoteSaveOppValidator_2", (String)"tmc-md-business", (Object[])new Object[0]), (String)"ForexQuoteSaveOppValidator_2", (String)"tmc-md-business", (Object[])new Object[]{entry.getKey(), itemsBuilder.toString()}));
                errorMsgBuilder.append("\n");
                this.addErrorMessage(dataEntity, errorMsgBuilder.toString());
            }
        }
    }
}

