/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.validate.ratedericative;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateDericDataBatchSaveValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection entryEntities = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            ArrayList<String> list = new ArrayList<String>(entryEntities.size());
            ArrayList<DynamicObject> oldDataList = new ArrayList<DynamicObject>(entryEntities.size());
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject rateDericative = entryEntity.getDynamicObject("ratedericative");
                Date bizDate = entryEntity.getDate("bizdate");
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{rateDericative, bizDate})) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5229\u7387\u884d\u751f\u54c1\u4ee3\u7801\u548c\u62a5\u4ef7\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RateDericDataBatchSaveValidator_0", (String)"tmc-md-business", (Object[])new Object[0]));
                    continue;
                }
                StringBuilder numberDate = new StringBuilder();
                String rateDericativeNumber = rateDericative.getString("number");
                numberDate.append(rateDericativeNumber).append(bizDate);
                boolean isContain = list.contains(numberDate.toString());
                if (isContain) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u5229\u7387\u884d\u751f\u54c1\u4ee3\u7801\u548c\u62a5\u4ef7\u65f6\u95f4\uff0c\u8bf7\u4fee\u6539\u6570\u636e\u3002", (String)"RateDericDataBatchSaveValidator_1", (String)"tmc-md-business", (Object[])new Object[0]));
                    return;
                }
                list.add(numberDate.toString());
                DynamicObject oldData = BusinessDataServiceHelper.loadSingle((String)"md_dataratederic", (String)"id,ratedericative,number,bizdate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)rateDericativeNumber).and(new QFilter("bizdate", "=", (Object)bizDate))});
                if (!EmptyUtil.isNoEmpty((DynamicObject)oldData)) continue;
                oldDataList.add(oldData);
            }
            for (DynamicObject oldData : oldDataList) {
                String oldNumber = oldData.getDynamicObject("ratedericative").getString("number");
                String oldDate = oldData.getString("bizdate");
                this.addWarningMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s:%2$s\u4e0b\u6570\u636e\u503c\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\u539f\u6709\u6570\u636e\uff1f", (String)"RateDericDataBatchSaveValidator_2", (String)"tmc-md-business", (Object[])new Object[0]), oldNumber, oldDate));
            }
        }
    }
}

