/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.business.validate.referdata;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReferIndexSaveOppValidator
extends AbstractTmcBizOppValidator {
    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObjectCollection entryEntities = extendedDataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            ArrayList<String> list = new ArrayList<String>(entryEntities.size());
            ArrayList<DynamicObject> oldDataList = new ArrayList<DynamicObject>(entryEntities.size());
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject oldIndexData;
                DynamicObject referIndex = entryEntity.getDynamicObject("referindex");
                Date bizDate = entryEntity.getDate("bizdate");
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referIndex, bizDate})) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6307\u6570\u4ee3\u7801\u548c\u62a5\u4ef7\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReferIndexSaveOppValidator_1", (String)"tmc-md-business", (Object[])new Object[0]));
                    continue;
                }
                StringBuilder numberDateType = new StringBuilder();
                String indexNumber = referIndex.getString("number");
                String quoteType = entryEntity.getString("quotetype");
                numberDateType.append(indexNumber).append(bizDate).append(quoteType);
                boolean isContain = list.contains(numberDateType.toString());
                if (isContain) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u6307\u6570\u4ee3\u7801\u3001\u62a5\u4ef7\u65f6\u95f4\u548c\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReferIndexSaveOppValidator_3", (String)"tmc-md-business", (Object[])new Object[0]));
                } else {
                    list.add(numberDateType.toString());
                }
                if (!EmptyUtil.isNoEmpty((DynamicObject)(oldIndexData = BusinessDataServiceHelper.loadSingle((String)"md_dataindex", (String)"id,referindex,number,bizdate,quotetype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)indexNumber).and(new QFilter("bizdate", "=", (Object)bizDate)).and(new QFilter("quotetype", "=", (Object)quoteType))})))) continue;
                oldDataList.add(oldIndexData);
            }
            for (DynamicObject oldData : oldDataList) {
                String oldNumber = oldData.getDynamicObject("referindex").getString("number");
                String oldDate = oldData.getString("bizdate");
                String oldType = oldData.getString("quotetype");
                this.addWarningMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%1$s:%2$s,%3$s\u4e0b\u6570\u636e\u503c\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\u539f\u6709\u6570\u636e\uff1f", (String)"ReferIndexSaveOppValidator_2", (String)"tmc-md-business", (Object[])new Object[0]), oldNumber, oldDate, oldType));
            }
        }
    }
}

