/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.service;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.md.business.service.factory.IMarketDataServiceFacade;
import kd.tmc.md.business.service.factory.MarketDataServiceFacadeFactory;
import kd.tmc.md.business.service.yieldcurve.YieldCurveDataService;

public class MarketDataService
implements IMarketDataServiceFacade {
    private static final Log logger = LogFactory.getLog(MarketDataService.class);

    public PriceRuleInfo priceRule(Long priceRuleId, PriceRuleInfo param) {
        PriceRuleInfo priceRule = MarketDataServiceFacadeFactory.getService().priceRule(priceRuleId, param);
        if (this.isUnitTest()) {
            priceRule = (PriceRuleInfo)this.unitTest("priceRule", priceRule, param);
        }
        return priceRule;
    }

    public Long yieldCurve(Long priceRuleId, Long marketId, YieldTypeEnum yieldType) {
        return MarketDataServiceFacadeFactory.getService().yieldCurve(priceRuleId, marketId, yieldType);
    }

    public Map<Date, BigDecimal> index(String index, Set<Date> quoteDate, MarkPriceEnum markprice, boolean isReturnEmpty) {
        Map result = MarketDataServiceFacadeFactory.getService().index(index, quoteDate, markprice, isReturnEmpty);
        if (this.isUnitTest()) {
            result = (Map)this.unitTest("index", result, index, quoteDate, markprice, isReturnEmpty);
        }
        return result;
    }

    public Map<Date, BigDecimal> referRate(String referRate, Set<Date> quoteDate, boolean isReturnEmpty) {
        Map result = MarketDataServiceFacadeFactory.getService().referRate(referRate, quoteDate, isReturnEmpty);
        if (this.isUnitTest()) {
            result = (Map)this.unitTest("referRate", result, referRate, quoteDate, isReturnEmpty);
        }
        return result;
    }

    public Map<Date, BigDecimal> getReferRatesByDate(String referRate, Date startDate, Date endDate) {
        return MarketDataServiceFacadeFactory.getService().getReferRatesByDate(referRate, startDate, endDate);
    }

    private Object unitTest(String method2, Object result, Object ... param) {
        String testService = this.getUnitTestService();
        if (EmptyUtil.isNoEmpty((String)testService)) {
            logger.info("\u8c03\u7528\u5355\u5143\u6d4b\u8bd5\u6a21\u62df\u5668\u65b9\u6cd5 " + method2);
            try {
                Object service = Class.forName(testService).newInstance();
                if ("priceRule".equals(method2)) {
                    Method method = service.getClass().getMethod("priceRule", PriceRuleInfo.class);
                    result = method.invoke(service, param);
                } else if ("index".equals(method2)) {
                    Method method = service.getClass().getMethod("index", String.class, Set.class, MarkPriceEnum.class, Boolean.class);
                    result = method.invoke(service, param);
                } else if ("referRate".equals(method2)) {
                    Method method = service.getClass().getMethod("referRate", String.class, Set.class, Boolean.class);
                    result = method.invoke(service, param);
                } else if ("getForexQuoteInfo".equals(method2)) {
                    Method method = service.getClass().getMethod("getForexQuoteInfo", Long.class, String.class, Date.class, Date.class);
                    result = method.invoke(service, param);
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            logger.info("\u8c03\u7528\u5355\u5143\u6d4b\u8bd5\u6a21\u62df\u5668\u8fd4\u56de\u7ed3\u679c -- " + SerializationUtils.toJsonString((Object)result));
        }
        return result;
    }

    private boolean isUnitTest() {
        String property = System.getProperty("unit_test");
        if (EmptyUtil.isNoEmpty((String)property) && "tmc".equals(property)) {
            logger.info("\u83b7\u53d6\u5230\u5355\u5143\u6d4b\u8bd5\u7cfb\u7edf\u53c2\u6570");
            return true;
        }
        return false;
    }

    private String getUnitTestService() {
        String simulator = null;
        try {
            String sSQL = "Select fsimulator From t_tbp_simulator where Fname = 'unit_test'";
            DataSet ds = DB.queryDataSet((String)"unit", (DBRoute)DBRoute.of((String)"tmc"), (String)sSQL);
            if (ds.hasNext()) {
                Row rs = ds.next();
                simulator = rs.getString("fsimulator");
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u5230\u5355\u5143\u6d4b\u8bd5\u6a21\u62df\u5668\u5f02\u5e38 " + e);
        }
        logger.info("\u83b7\u53d6\u5230\u5355\u5143\u6d4b\u8bd5\u6a21\u62df\u5668 " + simulator);
        return simulator;
    }

    public String getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        String forexQuote = MarketDataServiceFacadeFactory.getService().getForexQuoteInfo(forexQuoteId, currencyPair, issueTime, Dm);
        if (this.isUnitTest() && forexQuote.contains("errMsg")) {
            forexQuote = SerializationUtils.toJsonString((Object)((ForexQuoteInfo)this.unitTest("getForexQuoteInfo", forexQuote, forexQuoteId, currencyPair, issueTime, Dm)));
        }
        return forexQuote;
    }

    public YieldCurveInfo yieldCurve(YieldCurveInfo yieldCurve) {
        if (EmptyUtil.isNoEmpty((Long)yieldCurve.getYieldCurveId())) {
            YieldCurveDataService yieldCurveService = new YieldCurveDataService();
            yieldCurve = yieldCurveService.queryYieldCurve(null, yieldCurve);
        }
        return yieldCurve;
    }

    public String getForexQuoteInfoWithIssueTime(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        String forexQuote = MarketDataServiceFacadeFactory.getService().getForexQuoteInfoWithIssueTime(forexQuoteId, currencyPair, issueTime, Dm);
        return forexQuote;
    }
}

