/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.service.unit;

import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.bean.tc.YieldCurveInfo;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.md.service.MarketDataService;

public class MarketUnitTestSimulator {
    private static final Log logger = LogFactory.getLog(MarketDataService.class);

    public PriceRuleInfo priceRule(PriceRuleInfo param) {
        if (EmptyUtil.isNoEmpty((Object[])param.getForexQuote())) {
            for (ForexQuoteInfo forexQuoteInfo : param.getForexQuote()) {
                forexQuoteInfo.setBuyPrice(BigDecimal.valueOf(MarketUnitTestSimulator.randomInt()));
                forexQuoteInfo.setSellPrice(BigDecimal.valueOf(MarketUnitTestSimulator.randomInt()));
                forexQuoteInfo.setMiddleprice(BigDecimal.valueOf(MarketUnitTestSimulator.randomInt()));
            }
        }
        if (EmptyUtil.isNoEmpty((Object[])param.getYieldCurve())) {
            for (ForexQuoteInfo forexQuoteInfo : param.getYieldCurve()) {
                forexQuoteInfo.getDfMap().forEach((arg_0, arg_1) -> this.lambda$priceRule$0((YieldCurveInfo)forexQuoteInfo, arg_0, arg_1));
            }
        }
        param.setErr("");
        return param;
    }

    public ForexQuoteInfo getForexQuoteInfo(Long forexQuoteId, String currencyPair, Date issueTime, Date Dm) {
        ForexQuoteInfo forexQuote = new ForexQuoteInfo();
        forexQuote.setFxquote(currencyPair);
        forexQuote.setIssuetime(Dm == null ? new Date() : Dm);
        forexQuote.setSellPrice(new BigDecimal("5"));
        forexQuote.setBuyPrice(new BigDecimal("5"));
        forexQuote.setMiddleprice(new BigDecimal("5"));
        return forexQuote;
    }

    public Map<Date, BigDecimal> index(String index, Set<Date> quoteDate, MarkPriceEnum markprice, Boolean isReturnEmpty) {
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>(quoteDate.size());
        for (Date date : quoteDate) {
            result.put(date, BigDecimal.valueOf(this.randomFloat()));
        }
        return result;
    }

    public Map<Date, BigDecimal> referRate(String index, Set<Date> quoteDate, Boolean isReturnEmpty) {
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>(quoteDate.size());
        for (Date date : quoteDate) {
            result.put(date, BigDecimal.valueOf(this.randomFloat()));
        }
        return result;
    }

    private float randomFloat() {
        SecureRandom random = new SecureRandom();
        float floatNumber = random.nextFloat();
        logger.info("randomFloat() = " + floatNumber);
        return floatNumber;
    }

    private static float randomInt() {
        SecureRandom random = new SecureRandom();
        float floatNumber = random.nextInt(10);
        logger.info("randomInt() = " + floatNumber);
        return floatNumber;
    }

    private /* synthetic */ void lambda$priceRule$0(YieldCurveInfo yieldCurve, Date date, BigDecimal val) {
        yieldCurve.getDfMap().put(date, BigDecimal.valueOf(this.randomFloat()));
    }
}

