/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.IntegerProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.md.common.enums.CalMethodEnum;
import kd.tmc.md.common.enums.DateRuleEnum;

public class ForexQuoteEdit
extends AbstractTmcBillEdit
implements ItemClickListener,
BeforeF7SelectListener,
TabSelectListener {
    public static final String NEED_REFRESH_LIST = "needRefreshList";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit edit = (TextEdit)this.getView().getControl("quotetype");
        edit.addButtonClickListener((ClickListener)this);
        BasedataEdit midCurrency = (BasedataEdit)this.getView().getControl("midcurrency");
        midCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit lCurYiedldCurve = (BasedataEdit)this.getView().getControl("lcuryieldcurve");
        lCurYiedldCurve.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        lCurYiedldCurve.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        BasedataEdit rCurYiedldCurve = (BasedataEdit)this.getView().getControl("rcuryieldcurve");
        rCurYiedldCurve.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        rCurYiedldCurve.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail);
        BasedataEdit dateAxis = (BasedataEdit)this.getView().getControl("dateaxis");
        dateAxis.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("lcuryieldcurve".equals(key) || "rcuryieldcurve".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("md_yieldline");
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.genInputDate();
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("quoteinputpage")) {
            this.setEnableForInputPage();
            this.showTips();
        }
    }

    public void afterBindData(EventObject e) {
        this.initControls();
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if (event.getActionId().equals("selectPair") && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            Object buyCurrencyId = data.get(0).getPrimaryKeyValue();
            Object sellCurrencyId = data.get(1).getPrimaryKeyValue();
            this.getModel().setValue("currency", buyCurrencyId);
            this.getModel().setValue("sellcurrency", sellCurrencyId);
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            this.getModel().setValue("quotetype", (Object)(buyCurrency.getString("number") + "/" + sellCurrency.getString("number")));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String FieldKey = arg.getProperty().getName();
        int rowIndex = arg.getRow();
        if ("lcuryieldcurve".equals(FieldKey) || "rcuryieldcurve".equals(FieldKey)) {
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("quotetype", rowIndex))) {
                arg.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"ForexQuoteEdit_2", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            } else {
                String[] quoteType = ((String)this.getModel().getValue("quotetype")).split("/");
                String cuNumber = FieldKey.equals("lcuryieldcurve") ? quoteType[0] : quoteType[1];
                QFilter qFilter = new QFilter("currency.number", "=", (Object)cuNumber);
                ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
                showParameter.setMultiSelect(false);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("midcurrency".equals(FieldKey)) {
            List<String> currencyList = this.getMidCurrencyNumbers();
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            QFilter qFilter = new QFilter("number", "in", currencyList);
            showParameter.getListFilterParameter().setFilter(qFilter);
            showParameter.setMultiSelect(false);
        } else if ("dateaxis".equals(FieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)arg.getFormShowParameter();
            showParameter.setMultiSelect(false);
        }
    }

    private void clearWrongMiddleCurrency() {
        ArrayList<String> midCurrencyList = new ArrayList<String>(2);
        ArrayList<String> leftList = new ArrayList<String>(4);
        ArrayList<String> rightList = new ArrayList<String>(4);
        for (int i = 0; i < this.getModel().getEntryEntity("define").size(); ++i) {
            String pair = (String)this.getModel().getValue("quotetype", i);
            DynamicObject middleCurrency = (DynamicObject)this.getModel().getValue("midcurrency", i);
            if (middleCurrency == null) continue;
            String middle = middleCurrency.getString("number");
            String[] ss = pair.split("/");
            String left = ss[0];
            String right = ss[1];
            if (!EmptyUtil.isNoEmpty((String)pair)) continue;
            midCurrencyList.clear();
            leftList.clear();
            rightList.clear();
            for (DynamicObject _define : this.getModel().getEntryEntity("define")) {
                String _pair = _define.getString("quotetype");
                if (EmptyUtil.isEmpty((String)_pair) || _pair.equals(pair)) continue;
                String[] _ss = _pair.split("/");
                String _left = _ss[0];
                String _right = _ss[1];
                if (_left.equals(left)) {
                    leftList.add(_right);
                    continue;
                }
                if (_left.equals(right)) {
                    rightList.add(_right);
                    continue;
                }
                if (_right.equals(left)) {
                    leftList.add(_left);
                    continue;
                }
                if (!_right.equals(right)) continue;
                rightList.add(_left);
            }
            for (String number : leftList) {
                if (!rightList.contains(number)) continue;
                midCurrencyList.add(number);
            }
            if (midCurrencyList.contains(middle)) continue;
            this.getModel().setValue("midcurrency", null, i);
        }
    }

    private List<String> getMidCurrencyNumbers() {
        String pair = (String)this.getModel().getValue("quotetype");
        ArrayList<String> currencyList = new ArrayList<String>();
        if (EmptyUtil.isNoEmpty((String)pair)) {
            String[] ss = pair.split("/");
            String left = ss[0];
            String right = ss[1];
            ArrayList<String> leftList = new ArrayList<String>();
            ArrayList<String> rightList = new ArrayList<String>();
            for (DynamicObject define : this.getModel().getEntryEntity("define")) {
                String _middle;
                String _pair = define.getString("quotetype");
                if (EmptyUtil.isEmpty((String)_pair) || _pair.equals(pair)) continue;
                String[] _ss = _pair.split("/");
                String _left = _ss[0];
                String _right = _ss[1];
                DynamicObject middleCurrency = define.getDynamicObject("midcurrency");
                if (middleCurrency != null && (((_middle = middleCurrency.getString("number")) + "/" + _left).equals(pair) || (_left + "/" + _middle).equals(pair) || (_right + "/" + _middle).equals(pair) || (_middle + "/" + _right).equals(pair))) continue;
                if (_left.equals(left)) {
                    leftList.add(_right);
                    continue;
                }
                if (_left.equals(right)) {
                    rightList.add(_right);
                    continue;
                }
                if (_right.equals(left)) {
                    leftList.add(_left);
                    continue;
                }
                if (!_right.equals(right)) continue;
                rightList.add(_left);
            }
            for (String number : leftList) {
                if (!rightList.contains(number)) continue;
                currencyList.add(number);
            }
        }
        return currencyList;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        switch (propName) {
            case "quotetype": {
                Object oldValue = changeData.getOldValue();
                if (EmptyUtil.isNoEmpty((Object)oldValue)) {
                    this.deleteInputRow((String)oldValue, rowIndex);
                }
                this.quotationChangeEvt(changeData);
                this.clearWrongMiddleCurrency();
                break;
            }
            case "fowardmethod": 
            case "spotmethod": {
                this.setEnableByMethod(rowIndex);
                this.genInputRow(rowIndex, this.deleteInputRow((String)this.getModel().getValue("quotetype", rowIndex), rowIndex), false);
                this.setEnable_dateRule();
                break;
            }
            case "midcurrency": {
                this.midCurrencyChangeEvt(changeData);
                break;
            }
            case "dateaxis": 
            case "fowardquotation": {
                this.genInputRow(rowIndex, this.deleteInputRow((String)this.getModel().getValue("quotetype", rowIndex), rowIndex), false);
                this.setEnable_dateRule();
                break;
            }
            case "buyprice": 
            case "sellprice": {
                this.calMidData(true, rowIndex);
                break;
            }
            case "buypoints": 
            case "sellpoints": {
                this.calMidData(false, rowIndex);
                break;
            }
            case "date": 
            case "midprice": 
            case "midpoints": {
                break;
            }
            case "daterule": {
                this.dateRuleChanged(rowIndex, false);
                this.genInputRow(rowIndex, this.deleteInputRow((String)this.getModel().getValue("quotetype", rowIndex), rowIndex), true);
                this.setEnable_dateRule();
                break;
            }
            case "issuetime": 
            case "spotdelay": 
            case "dateadjustmethod": {
                this.issueTimeChanged();
            }
        }
        if ("quotetype".equals(propName) || "rcuryieldcurve".equals(propName) || "lcuryieldcurve".equals(propName) || "fowardmethod".equals(propName) || "spotmethod".equals(propName) || "midcurrency".equals(propName) || "dateaxis".equals(propName) || "fowardquotation".equals(propName) || "buyprice".equals(propName) || "sellprice".equals(propName) || "buypoints".equals(propName) || "sellpoints".equals(propName) || "date".equals(propName) || "midprice".equals(propName) || "midpoints".equals(propName) || "daterule".equals(propName) || "issuetime".equals(propName) || "rateaccuracy".equals(propName) || "dateadjustmethod".equals(propName) || "spotdelay".equals(propName)) {
            this.getPageCache().put("ismodify", "true");
        }
    }

    public void click(EventObject e) {
        if (e.getSource() instanceof TextEdit && ((TextEdit)e.getSource()).getKey().equals("quotetype")) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency_tc", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectPair"));
            showParameter.setShowTitle(false);
            showParameter.setCustomParam("billFormId", (Object)"bd_currency_tc");
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("quotetype")) && buyCurrency != null && sellCurrency != null) {
                showParameter.setSelectedRows(new Object[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
            }
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            showParameter.getListFilterParameter().setFilter(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if ("bar_history".equals(evt.getItemKey())) {
            ListShowParameter param = ShowFormHelper.createShowListForm((String)"md_forexquote_h", (boolean)true, (int)0, (boolean)false);
            ListFilterParameter filterParameter = new ListFilterParameter();
            Long id = (Long)this.getModel().getValue("id");
            QFilter qFilter = id.equals(0L) ? new QFilter("1", "=", (Object)2) : new QFilter("sourcebillid", "=", (Object)id);
            filterParameter.setFilter(qFilter);
            param.setListFilterParameter(filterParameter);
            IAppCache appCache = AppCache.get((String)"md_forexquote_h");
            appCache.put("sourcebillid", this.getModel().getValue("id"));
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (e.getEntryProp().getName().equals("define")) {
            for (int rowIndex : e.getRowIndexs()) {
                this.deleteInputRow((String)this.getModel().getValue("quotetype", rowIndex), rowIndex);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if ("define".equals(e.getEntryProp().getName())) {
            this.clearWrongMiddleCurrency();
            this.getPageCache().put("ismodify", "true");
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("define".equals(e.getEntryProp().getName())) {
            int rowIndex = e.getRowDataEntities()[0].getRowIndex();
            this.setEnableByMethod(rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if ("customsave".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            if (((Boolean)this.getModel().getValue("issavehistorytip")).booleanValue()) {
                this.getModel().setValue("issavehistorytip", (Object)false);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u5f55\u5165\u7684\u4e3a\u5386\u53f2\u5916\u6c47\u62a5\u4ef7\uff0c\u6570\u636e\u5df2\u4fdd\u5b58\u4e8e\u5386\u53f2\u5916\u6c47\u62a5\u4ef7\u5217\u8868\u3002", (String)"ForexQuoteEdit_26", (String)"tmc-md-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ForexQuoteEdit_27", (String)"tmc-md-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            }
            if (this.getView().getParentView() != null) {
                this.getView().getParentView().getPageCache().put(NEED_REFRESH_LIST, "1");
            }
            this.initControls();
            if (!this.getModel().getEntryEntity("define").stream().anyMatch(row -> EmptyUtil.isNoEmpty((Object)row.get("workcalendar")))) {
                this.getView().updateView("define");
            }
        }
    }

    private void initControls() {
        for (int i = 0; i < this.getModel().getEntryRowCount("define"); ++i) {
            this.setEnableByMethod(i);
            this.dateRuleChanged(i, true);
        }
        this.setEnable_dateRule();
        this.getModel().setDataChanged(false);
    }

    private void setEnableForInputPage() {
        DynamicObjectCollection defineEntity = this.getModel().getEntryEntity("define");
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject dynamicObject : defineEntity) {
            map.put(dynamicObject.getString("quotetype"), dynamicObject.getString("fowardquotation"));
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("quoteinput"); ++i) {
            String forwardQuotation = (String)map.get(this.getModel().getEntryRowEntity("quoteinput", i).getString("input_quotetype"));
            boolean priceEnable = "Spot".equals(this.getModel().getEntryRowEntity("quoteinput", i).getString("term")) || "exRate".equals(forwardQuotation);
            boolean pointEnable = !"Spot".equals(this.getModel().getEntryRowEntity("quoteinput", i).getString("term")) && "point".equals(forwardQuotation);
            this.getView().setEnable(Boolean.valueOf(priceEnable), i, new String[]{"buyprice", "sellprice", "midprice"});
            this.getView().setEnable(Boolean.valueOf(pointEnable), i, new String[]{"buypoints", "sellpoints", "midpoints"});
        }
    }

    private void setEnableByMethod(int rowIndex) {
        String spotMethod = (String)this.getModel().getEntryRowEntity("define", rowIndex).get("spotmethod");
        String forwardMethod = (String)this.getModel().getEntryRowEntity("define", rowIndex).get("fowardmethod");
        if (forwardMethod.equals(CalMethodEnum.specify.getValue())) {
            this.disEnableAndClearVal(rowIndex, "rcuryieldcurve", "lcuryieldcurve");
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"fowardquotation", "dateaxis"});
        } else if (forwardMethod.equals(CalMethodEnum.crossExRate.getValue())) {
            this.disEnableAndClearVal(rowIndex, "fowardquotation", "rcuryieldcurve", "lcuryieldcurve");
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"dateaxis"});
        } else if (forwardMethod.equals(CalMethodEnum.ycDeduction.getValue())) {
            this.disEnableAndClearVal(rowIndex, "fowardquotation");
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"rcuryieldcurve", "lcuryieldcurve", "dateaxis"});
        } else {
            this.disEnableAndClearVal(rowIndex, "fowardquotation", "rcuryieldcurve", "lcuryieldcurve", "dateaxis");
        }
        if (spotMethod.equals(CalMethodEnum.crossExRate.getValue()) || forwardMethod.equals(CalMethodEnum.crossExRate.getValue())) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"midcurrency"});
        } else {
            this.disEnableAndClearVal(rowIndex, "midcurrency");
        }
        if (spotMethod.equals(CalMethodEnum.specify.getValue()) && (forwardMethod.equals(CalMethodEnum.specify.getValue()) || forwardMethod.equals(CalMethodEnum.none.getValue()))) {
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"daterule"});
        } else {
            if (DateRuleEnum.specify.getValue().equals(this.getModel().getValue("daterule", rowIndex))) {
                this.getModel().setValue("daterule", (Object)DateRuleEnum.sys.getValue(), rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"daterule"});
        }
    }

    private void issueTimeChanged() {
        for (DynamicObject defineRow : this.getModel().getEntryEntity("define")) {
            String quoteType = defineRow.getString("quotetype");
            if (DateRuleEnum.specify.getValue().equals(defineRow.getString("daterule"))) {
                this.clearDate(defineRow.getString("quotetype"));
                continue;
            }
            Date spotDate = null;
            for (DynamicObject inputRow : this.getModel().getEntryEntity("quoteinput")) {
                if (!quoteType.equals(inputRow.getString("input_quotetype"))) continue;
                String term = inputRow.getString("term");
                inputRow.set("date", (Object)this.calDate(-1, term, defineRow, spotDate));
                if (!"Spot".equals(term)) continue;
                spotDate = inputRow.getDate("date");
            }
        }
        this.getView().updateView("quoteinput");
        this.setEnableForInputPage();
        this.setEnable_dateRule();
    }

    private void clearDate(String quoteType) {
        for (DynamicObject input : this.getModel().getEntryEntity("quoteinput")) {
            if (!quoteType.equals(input.getString("input_quotetype"))) continue;
            input.set("date", null);
        }
    }

    private void dateRuleChanged(int rowIndex, boolean isInit) {
        if (DateRuleEnum.specify.getValue().equals(this.getModel().getValue("daterule", rowIndex))) {
            this.disEnableAndClearVal(rowIndex, "workcalendar", "dateadjustmethod", "spotdelay");
        } else {
            if (!isInit) {
                this.getModel().setValue("spotdelay", (Object)2, rowIndex);
            }
            this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"workcalendar", "dateadjustmethod", "spotdelay"});
        }
    }

    private void disEnableAndClearVal(int rowIndex, String ... columnKeys) {
        this.getView().setEnable(Boolean.valueOf(false), rowIndex, columnKeys);
        for (String columnKey : columnKeys) {
            if (this.isValNull(rowIndex, columnKey)) continue;
            if (this.getModel().getProperty(columnKey) instanceof IntegerProp) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)columnKey, (Object)0, (int)rowIndex);
                continue;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)columnKey, null, (int)rowIndex);
        }
    }

    private boolean isValNull(int rowIndex, String columnKey) {
        Object rowVal = this.getModel().getValue(columnKey, rowIndex);
        return rowVal == null || "".equals(rowVal);
    }

    private void quotationChangeEvt(ChangeData changeData) {
        int rowindex = changeData.getRowIndex();
        String newQuotation = (String)changeData.getNewValue();
        DynamicObjectCollection defineColl = this.getModel().getEntryEntity("define");
        if (EmptyUtil.isNoEmpty((String)newQuotation)) {
            for (int i = 0; i < defineColl.size(); ++i) {
                String[] cuQuoArray;
                String currentQuotation;
                if (rowindex == i || !EmptyUtil.isNoEmpty((String)(currentQuotation = ((DynamicObject)defineColl.get(i)).getString("quotetype")))) continue;
                if (newQuotation.equals(currentQuotation)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d27\u5e01\u5bf9\u5df2\u5b58\u5728\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexQuoteEdit_3", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"quotetype", (Object)changeData.getOldValue(), (int)rowindex);
                    return;
                }
                String[] newQuoArray = newQuotation.split("/");
                if (!newQuoArray[1].equals((cuQuoArray = currentQuotation.split("/"))[0]) || !newQuoArray[0].equals(cuQuoArray[1])) continue;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"quotetype", (Object)changeData.getOldValue(), (int)rowindex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d27\u5e01\u5bf9\u5df2\u5b58\u5728\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexQuoteEdit_3", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        this.getModel().setValue("midcurrency", null, rowindex);
        this.getModel().setValue("lcuryieldcurve", null, rowindex);
        this.getModel().setValue("rcuryieldcurve", null, rowindex);
        this.genInputRow(rowindex, this.deleteInputRow((String)this.getModel().getValue("quotetype", rowindex), rowindex), false);
        this.setEnable_dateRule();
    }

    private void midCurrencyChangeEvt(ChangeData changeData) {
        if (changeData.getNewValue() != null) {
            DynamicObject midCurrency = (DynamicObject)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            boolean notContains = true;
            for (int i = 0; i < this.getModel().getEntryRowCount("define"); ++i) {
                String quoteType;
                if (rowIndex == i || !EmptyUtil.isNoEmpty((String)(quoteType = (String)this.getModel().getValue("quotetype", i))) || !quoteType.contains(midCurrency.getString("number"))) continue;
                notContains = false;
                break;
            }
            if (notContains) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"midcurrency", (Object)changeData.getOldValue(), (int)rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u62a5\u4ef7\u65b9\u5f0f\u4e2d\u7684\u5e01\u79cd\u7f3a\u5c11\u4e0e\u4e2d\u95f4\u5e01\u79cd\u7684\u62a5\u4ef7\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"ForexQuoteEdit_5", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<DynamicObject> deleteInputRow(String quoteType, int rowIndex) {
        if (EmptyUtil.isNoEmpty((String)quoteType)) {
            DynamicObjectCollection inputColl = this.getModel().getEntryEntity("quoteinput");
            List<DynamicObject> removedRows = inputColl.stream().filter(inputRow -> quoteType.equals(inputRow.getString("input_quotetype"))).collect(Collectors.toList());
            inputColl.removeIf(inputRow -> quoteType.equals(inputRow.getString("input_quotetype")));
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"quoteinput", this.transToDataMap(inputColl), (boolean)true);
            this.getModel().setValue("inputcount", (Object)0, rowIndex);
            return removedRows;
        }
        return new ArrayList<DynamicObject>();
    }

    private void genInputRow(int defineIndex, List<DynamicObject> removedRows, boolean dateRuleChanged) {
        Map<String, DynamicObject> removedRowsMap = removedRows.stream().collect(Collectors.toMap(row -> row.getString("term"), row -> row));
        DynamicObject defineRow = this.getModel().getEntryRowEntity("define", defineIndex);
        if (EmptyUtil.isNoEmpty((String)defineRow.getString("quotetype"))) {
            DynamicObject dateAxis = defineRow.getDynamicObject("dateaxis");
            String dateRule = defineRow.getString("daterule");
            String forwardQuotation = defineRow.getString("fowardquotation");
            int size = 0;
            DynamicObjectCollection ponintColl = null;
            if (dateAxis != null) {
                ponintColl = dateAxis.getDynamicObjectCollection("entrys");
                size = ponintColl == null ? 0 : ponintColl.size();
            }
            int inputCount = this.calCount(size, defineRow.getString("spotmethod"), defineRow.getString("fowardmethod"));
            String quoteType = defineRow.getString("quotetype");
            int startIndex = this.calStartIndex(defineIndex);
            DynamicObjectCollection inputColl = this.getModel().getEntryEntity("quoteinput");
            Date tempSpotDate = null;
            for (int i = 0; i < inputCount; ++i) {
                int rowIndex = i + startIndex;
                DynamicObject inputRow = (DynamicObject)inputColl.getDynamicObjectType().createInstance();
                inputRow.set("input_quotetype", (Object)quoteType);
                String term = this.calTerm(i, inputCount, ponintColl);
                inputRow.set("term", (Object)term);
                DynamicObject originalRow = removedRowsMap.get(term);
                if (!DateRuleEnum.specify.getValue().equals(dateRule)) {
                    Date date = this.calDate(i, term, defineRow, tempSpotDate);
                    if (i == 0) {
                        tempSpotDate = date;
                    }
                    inputRow.set("date", (Object)date);
                } else if (!dateRuleChanged && originalRow != null) {
                    inputRow.set("date", originalRow.get("date"));
                }
                if (originalRow != null) {
                    if ("exRate".equals(forwardQuotation) || "Spot".equals(term)) {
                        inputRow.set("buyprice", originalRow.get("buyprice"));
                        inputRow.set("sellprice", originalRow.get("sellprice"));
                        inputRow.set("midprice", originalRow.get("midprice"));
                    } else if ("point".equals(forwardQuotation)) {
                        inputRow.set("buypoints", originalRow.get("buypoints"));
                        inputRow.set("sellpoints", originalRow.get("sellpoints"));
                        inputRow.set("midpoints", originalRow.get("midpoints"));
                    }
                }
                inputRow.set("seq", (Object)(rowIndex + 1));
                inputColl.add(rowIndex, inputRow);
            }
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"quoteinput", this.transToDataMap(inputColl), (boolean)true);
            this.getModel().setValue("inputcount", (Object)inputCount, defineIndex);
        }
    }

    private void genInputDate() {
        for (DynamicObject defineRow : this.getModel().getEntryEntity("define")) {
            if (!DateRuleEnum.sys.getValue().equals(defineRow.getString("daterule"))) continue;
            String quoteType = defineRow.getString("quotetype");
            List list = this.getModel().getEntryEntity("quoteinput").stream().filter(row -> quoteType.equals(row.getString("input_quotetype"))).collect(Collectors.toList());
            Date tempSpotDate = null;
            for (DynamicObject inputRow : list) {
                String term = inputRow.getString("term");
                Date date = this.calDate(-1, term, defineRow, tempSpotDate);
                if ("Spot".equals(term)) {
                    tempSpotDate = date;
                }
                inputRow.set("date", (Object)date);
            }
        }
    }

    private void setEnable_dateRule() {
        Map<String, String> map = this.getModel().getEntryEntity("define").stream().filter(defineRow -> !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{defineRow.getString("quotetype"), defineRow.getString("daterule")})).collect(Collectors.toMap(defineRow -> defineRow.getString("quotetype"), defineRow -> defineRow.getString("daterule")));
        for (int i = 0; i < this.getModel().getEntryEntity("quoteinput").size(); ++i) {
            DynamicObject input = (DynamicObject)this.getModel().getEntryEntity("quoteinput").get(i);
            if (DateRuleEnum.specify.getValue().equals(map.get(input.getString("input_quotetype")))) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"date"});
        }
    }

    private Date calDate(int index, String term, DynamicObject defineRow, Date spotDate) {
        Date issueTime = (Date)this.getModel().getValue("issuetime");
        DynamicObjectCollection workCalendar = defineRow.getDynamicObjectCollection("workcalendar");
        if (index == 0 || "Spot".equals(term)) {
            int spotDelay = defineRow.get("spotdelay") == null ? 0 : defineRow.getInt("spotdelay");
            TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workCalendar, (Date)issueTime, (int)spotDelay);
            return TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workCalendar, (Date)issueTime, (int)spotDelay);
        }
        Date date = TermUtils.getDateByTerm((String)term, (Date)(spotDate == null ? issueTime : spotDate));
        String adjMethod = defineRow.getString("dateadjustmethod");
        adjMethod = StringUtils.isBlank((CharSequence)adjMethod) ? "forward" : adjMethod;
        return TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendar, (Date)date, (AdjustMethodEnum)AdjustMethodEnum.getEnumByValue((String)adjMethod));
    }

    private int calStartIndex(int defineIndex) {
        int allBeforeCount = 0;
        for (int i = 0; i < defineIndex; ++i) {
            int singleCount = (Integer)this.getModel().getValue("inputcount", i);
            allBeforeCount += singleCount;
        }
        return allBeforeCount;
    }

    private int calCount(int size, String spotMethod, String forwardMethod) {
        if (size != 0 && CalMethodEnum.specify.getValue().equals(spotMethod) && CalMethodEnum.specify.getValue().equals(forwardMethod)) {
            ++size;
        } else if (CalMethodEnum.specify.getValue().equals(spotMethod) && !CalMethodEnum.specify.getValue().equals(forwardMethod)) {
            size = 1;
        } else if (CalMethodEnum.crossExRate.getValue().equals(spotMethod) && !CalMethodEnum.specify.getValue().equals(forwardMethod)) {
            size = 0;
        }
        return size;
    }

    private String calTerm(int index, int inputCount, DynamicObjectCollection pointColl) {
        if (pointColl == null || inputCount == 1) {
            return "Spot";
        }
        if (inputCount > pointColl.size()) {
            if (index == 0) {
                return "Spot";
            }
            return ((DynamicObject)pointColl.get(index - 1)).getString("point");
        }
        if (pointColl.size() == inputCount) {
            return ((DynamicObject)pointColl.get(index)).getString("point");
        }
        return ((DynamicObject)pointColl.get(index)).getString("point");
    }

    private ArrayList<Map<String, Object>> transToDataMap(DynamicObjectCollection inputColl) {
        ArrayList<Map<String, Object>> dataMap = new ArrayList<Map<String, Object>>(inputColl.size());
        for (DynamicObject inputRow : inputColl) {
            HashMap<String, Object> row = new HashMap<String, Object>(8);
            row.put("input_quotetype", inputRow.get("input_quotetype"));
            row.put("term", inputRow.get("term"));
            row.put("date", inputRow.get("date"));
            row.put("buyprice", inputRow.get("buyprice"));
            row.put("buypoints", inputRow.get("buypoints"));
            row.put("sellprice", inputRow.get("sellprice"));
            row.put("sellpoints", inputRow.get("sellpoints"));
            row.put("midprice", inputRow.get("midprice"));
            row.put("midpoints", inputRow.get("midpoints"));
            dataMap.add(row);
        }
        return dataMap;
    }

    private void showTips() {
        StringBuilder sb = new StringBuilder();
        int count = this.getModel().getEntryRowCount("define");
        for (int i = 0; i < count; ++i) {
            boolean valid = true;
            if (EmptyUtil.isEmpty((Object)this.getModel().getValue("quotetype", i))) {
                sb.append(i + 1);
                valid = false;
            } else if (EmptyUtil.isEmpty((Object)this.getModel().getValue("dateaxis", i))) {
                String forwardMethod = (String)this.getModel().getValue("fowardmethod", i);
                if (!CalMethodEnum.none.getValue().equals(forwardMethod)) {
                    sb.append(i + 1);
                    valid = false;
                }
            } else if (CalMethodEnum.specify.getValue().equals(this.getModel().getValue("fowardmethod", i)) && StringUtils.isBlank((Object)this.getModel().getValue("fowardquotation", i))) {
                sb.append(i + 1);
                valid = false;
            }
            if (i >= count - 1 || valid) continue;
            sb.append(",");
        }
        String seqString = sb.toString();
        if (EmptyUtil.isNoEmpty((String)seqString)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5b9a\u4e49\u3010\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u3011\u3001\u3010\u8fdc\u671f\u6c47\u7387\u5f55\u5165\u65b9\u5f0f\u3011\u6216\u3010\u8fdc\u671f\u6c47\u7387\u65e5\u671f\u8f74\u3011\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u62a5\u4ef7\u5f55\u5165\u884c\u3002", (String)"ForexQuoteEdit_6", (String)"tmc-md-formplugin", (Object[])new Object[0]), seqString));
        }
    }

    private void calMidData(boolean isPrice, int rowIndex) {
        BigDecimal buyAmount = (BigDecimal)(isPrice ? this.getModel().getValue("buyprice", rowIndex) : this.getModel().getValue("buypoints", rowIndex));
        BigDecimal sellAmount = (BigDecimal)(isPrice ? this.getModel().getValue("sellprice", rowIndex) : this.getModel().getValue("sellpoints", rowIndex));
        String midField = isPrice ? "midprice" : "midpoints";
        this.getModel().setValue(midField, (Object)buyAmount.add(sellAmount).divide(new BigDecimal("2"), 10, 4), rowIndex);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (!("buyprice".equals(key) || "sellprice".equals(key) || "date".equals(key) || "buypoints".equals(key) || "sellpoints".equals(key) || "issuetime".equals(key))) {
            return;
        }
        this.verifyInput(key, e);
    }

    private void verifyInput(String key, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "buypoints": {
                BigDecimal buyPoints = e.getValue() == null ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                BigDecimal sellPoints = (BigDecimal)this.getModel().getValue("sellpoints");
                this.validatePoint(buyPoints, sellPoints);
                break;
            }
            case "sellpoints": {
                BigDecimal buyPoints = (BigDecimal)this.getModel().getValue("buypoints");
                BigDecimal sellPoints = e.getValue() == null ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                this.validatePoint(buyPoints, sellPoints);
                break;
            }
            case "buyprice": {
                BigDecimal buyAmount = e.getValue() == null ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                BigDecimal sellAmount = (BigDecimal)this.getModel().getValue("sellprice");
                if (buyAmount.compareTo(sellAmount) <= 0 || BigDecimal.ZERO.compareTo(sellAmount) == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\u3002", (String)"ForexQuoteEdit_18", (String)"tmc-md-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "sellprice": {
                BigDecimal sellAmount;
                BigDecimal buyAmount = (BigDecimal)this.getModel().getValue("buyprice");
                BigDecimal bigDecimal = sellAmount = e.getValue() == null ? BigDecimal.ZERO : new BigDecimal((String)e.getValue());
                if (buyAmount.compareTo(sellAmount) <= 0 || BigDecimal.ZERO.compareTo(sellAmount) == 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\u3002", (String)"ForexQuoteEdit_18", (String)"tmc-md-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                break;
            }
            case "date": {
                int rowIndex = e.getRowIndex();
                String dateStr = (String)e.getValue();
                if (dateStr == null) break;
                Date date = TcDateUtils.stringToDate((String)((String)e.getValue()), (String)"yyyy-MM-dd");
                String quoteType = (String)this.getModel().getValue("input_quotetype", rowIndex);
                if (rowIndex == 0 || !quoteType.equals(this.getModel().getValue("input_quotetype", rowIndex - 1))) {
                    Date nextDate;
                    DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar", rowIndex);
                    Date issueTime = (Date)this.getModel().getValue("issuetime", rowIndex);
                    Date maxSpotDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workCalendar, (Date)issueTime, (int)2);
                    if ("Spot".equals(this.getModel().getValue("term", rowIndex)) && (maxSpotDate.before(date) || TcDateUtils.getDataFormat((Date)issueTime, (boolean)true).after(date))) {
                        this.setCancelAndTip(e, ResManager.loadKDString((String)"Spot\u884c\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5728\u5f55\u5165\u7684\u53d1\u5e03\u65e5+0,1,2\u4e2a\u5de5\u4f5c\u65e5\u5185\u3002", (String)"ForexQuoteEdit_30", (String)"tmc-md-formplugin", (Object[])new Object[0]), "date");
                    }
                    if ((nextDate = (Date)this.getModel().getValue("date", rowIndex + 1)) == null || nextDate.after(date) || !quoteType.equals(this.getModel().getValue("input_quotetype", rowIndex + 1))) break;
                    this.setCancelAndTip(e, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u4e0b\u4e00\u65e5\u671f\u3002", (String)"ForexQuoteEdit_32", (String)"tmc-md-formplugin", (Object[])new Object[0]), "date");
                    break;
                }
                if (rowIndex == this.getModel().getEntryRowCount("quoteinput") - 1 || !quoteType.equals(this.getModel().getValue("input_quotetype", rowIndex + 1))) {
                    Date preDate = (Date)this.getModel().getValue("date", rowIndex - 1);
                    if (preDate == null || date.after(preDate)) break;
                    this.setCancelAndTip(e, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u65e5\u671f\u3002", (String)"ForexQuoteEdit_31", (String)"tmc-md-formplugin", (Object[])new Object[0]), "date");
                    break;
                }
                Date preDate = (Date)this.getModel().getValue("date", rowIndex - 1);
                Date nextDate = (Date)this.getModel().getValue("date", rowIndex + 1);
                if (preDate != null && !date.after(preDate)) {
                    this.setCancelAndTip(e, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u65e5\u671f\u3002", (String)"ForexQuoteEdit_31", (String)"tmc-md-formplugin", (Object[])new Object[0]), "date");
                }
                if (nextDate == null || nextDate.after(date)) break;
                this.setCancelAndTip(e, ResManager.loadKDString((String)"\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5c0f\u4e8e\u4e0b\u4e00\u65e5\u671f\u3002", (String)"ForexQuoteEdit_32", (String)"tmc-md-formplugin", (Object[])new Object[0]), "date");
                break;
            }
            case "issuetime": {
                if (!EmptyUtil.isEmpty((Object)e.getValue())) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexQuoteEdit_33", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                this.getView().updateView("issuetime");
            }
        }
    }

    private void validatePoint(BigDecimal buyPoints, BigDecimal sellPoints) {
        DynamicObject spotRow;
        Optional<DynamicObject> first;
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyPoints, sellPoints}) && (first = this.getModel().getEntryEntity("quoteinput").stream().filter(row -> this.getModel().getValue("input_quotetype").equals(row.getString("input_quotetype")) && "Spot".equals(row.getString("term")) && EmptyUtil.isNoEmpty((Object)row.get("buyprice")) && EmptyUtil.isNoEmpty((Object)row.get("sellprice"))).findFirst()).isPresent() && (spotRow = first.get()).getBigDecimal("buyprice").add(buyPoints.divide(new BigDecimal("10000"))).compareTo(spotRow.getBigDecimal("sellprice").add(sellPoints.divide(new BigDecimal("10000")))) > 0) {
            this.getView().showTipNotification(ResManager.loadResFormat((String)"{0}\u5728{1}\u671f\u9650\u7684\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForexQuoteEdit_0", (String)"tmc-md-formplugin", (Object[])new Object[]{this.getModel().getValue("input_quotetype"), this.getModel().getValue("term")}), Integer.valueOf(3000));
        }
    }

    private void setCancelAndTip(BeforeFieldPostBackEvent e, String tipMsg, String key) {
        e.setCancel(true);
        this.getView().showTipNotification(tipMsg);
        this.getView().updateView(key, this.getModel().getEntryCurrentRowIndex("quoteinput"));
    }
}

