/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.forex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.md.common.enums.CalMethodEnum;
import kd.tmc.md.common.enums.DateRuleEnum;

public class ForexQuoteImportService {
    public void beforeImportData(String dataStr, String importType) {
        JSONObject dataMap = (JSONObject)JSON.parseObject((String)dataStr, JSONObject.class);
        JSONObject option = new JSONObject();
        option.put("importtype", (Object)importType);
        BeforeImportDataEventArgs e = new BeforeImportDataEventArgs((Object)1, (Map)dataMap, null, (Map)option);
        this.beforeImportData(e);
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        if ("new".equals(e.getOption().get("importtype"))) {
            this.beforeImportData_new(e);
        } else if ("override".equals(e.getOption().get("importtype"))) {
            this.beforeImportData_override(e);
        } else {
            this.beforeImportData_newAndOverride(e);
        }
    }

    private void beforeImportData_newAndOverride(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        QFilter filter = new QFilter("billno", "=", data.get("billno"));
        if (!QueryServiceHelper.exists((String)"md_forexquote", (QFilter[])new QFilter[]{filter})) {
            this.beforeImportData_new(e);
        } else {
            this.beforeImportData_override(e);
        }
    }

    private void beforeImportData_override(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        QFilter filter = new QFilter("billno", "=", data.get("billno"));
        if (!QueryServiceHelper.exists((String)"md_forexquote", (QFilter[])new QFilter[]{filter})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5916\u6c47\u62a5\u4ef7\u7f16\u53f7\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u66f4\u65b0\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_24", (String)"tmc-md-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"md_forexquote", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject originalData = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)ids.get(0)).get("id"), (String)"md_forexquote");
        List<String> importDefineQuoteTypeList = this.getDefineQuoteTypeList(data);
        ArrayList<String> originalDefineQuoteTypeList = new ArrayList<String>();
        for (DynamicObject define : originalData.getDynamicObjectCollection("define")) {
            originalDefineQuoteTypeList.add(define.getString("quotetype"));
        }
        for (String importDefineQuoteType : importDefineQuoteTypeList) {
            String[] importPair = importDefineQuoteType.split("/");
            if (importPair.length != 2) {
                throw new KDBizException(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_19", (String)"tmc-md-formplugin", (Object[])new Object[]{importDefineQuoteType}));
            }
            String importPairStr = importPair[1] + "/" + importPair[0];
            if (!originalDefineQuoteTypeList.contains(importPairStr)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u539f\u62a5\u4ef7\u65b9\u5f0f{1}\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_25", (String)"tmc-md-formplugin", (Object[])new Object[]{importDefineQuoteType, importPairStr}));
        }
        if (!this.validateForImportData(data)) {
            return;
        }
        if (TcDateUtils.stringToDate((String)((String)data.get("issuetime")), (String)"yyyy-MM-dd HH:mm:ss").before(originalData.getDate("issuetime"))) {
            data.put("issavehistorytip", true);
        }
    }

    private void beforeImportData_new(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        this.validateForImportData(data);
    }

    private List<String> getDefineQuoteTypeList(Map data) {
        ArrayList<String> importDefineQuoteTypeList = new ArrayList<String>();
        JSONArray define = (JSONArray)data.get("define");
        if (define != null) {
            for (int i = 0; i < define.size(); ++i) {
                Map defineRow = (Map)define.get(i);
                String quoteType = (String)defineRow.get("quotetype");
                importDefineQuoteTypeList.add(quoteType);
            }
        }
        return importDefineQuoteTypeList;
    }

    private boolean validateForImportData(Map data) {
        List terms;
        Date issueTime = TcDateUtils.stringToDate((String)((String)data.get("issuetime")), (String)"yyyy-MM-dd HH:mm:ss");
        StringBuilder errorInfo = new StringBuilder();
        JSONArray define = (JSONArray)data.get("define");
        HashMap quoteTypeToTerms = new HashMap(8);
        HashMap<String, String> quoteTypeToPointOrPrice = new HashMap<String, String>(8);
        ArrayList<String> defineQuoteTypeList = new ArrayList<String>(8);
        HashMap<String, String> quoteTypeToDateRule = new HashMap<String, String>(8);
        if (define != null) {
            for (int i = 0; i < define.size(); ++i) {
                int spotDelay;
                Map defineRow = (Map)define.get(i);
                String quoteType = (String)defineRow.get("quotetype");
                if (quoteType == null || quoteType.trim().length() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexQuoteImport_41", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                }
                if (!quoteType.contains("/")) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c%s\u201d\u8d27\u5e01\u5bf9\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u683c\u5f0f\u6709\u8bef\u3002", (String)"ForexQuoteImport_42", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                }
                String[] ss = quoteType.split("/");
                if (ss.length != 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c%s\u201d\u8d27\u5e01\u5bf9\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u683c\u5f0f\u6709\u8bef\u3002", (String)"ForexQuoteImport_42", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                }
                if (ss[0].equals(ss[1])) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c%s\u201d\u8d27\u5e01\u5bf9\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u683c\u5f0f\u6709\u8bef\u3002", (String)"ForexQuoteImport_42", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                }
                if (EmptyUtil.isEmpty((String)quoteType)) {
                    return false;
                }
                defineQuoteTypeList.add(quoteType);
                defineRow.put("spotmethod", CalMethodEnum.specify.getValue());
                ArrayList<String> terms2 = new ArrayList<String>();
                terms2.add("Spot");
                quoteTypeToTerms.put(quoteType, terms2);
                if (EmptyUtil.isEmpty(defineRow.get("daterule"))) {
                    defineRow.put("daterule", DateRuleEnum.sys.getValue());
                }
                if (EmptyUtil.isEmpty(defineRow.get("spotdelay"))) {
                    defineRow.put("spotdelay", 0);
                    spotDelay = 0;
                } else {
                    spotDelay = Integer.parseInt((String)defineRow.get("spotdelay"));
                }
                String dateRule = (String)defineRow.get("daterule");
                if (DateRuleEnum.specify.getValue().equals(dateRule) && (EmptyUtil.isNoEmpty(defineRow.get("workcalendar")) || EmptyUtil.isNoEmpty(defineRow.get("dateadjustmethod")) || spotDelay > 0)) {
                    throw new KDBizException(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\uff0c\u4e0a\u4f20\u7684\u6570\u636e\u4e2d\u65e5\u671f\u9009\u62e9\u6307\u5b9a\uff0c\u65e5\u5386\u3001\u65e5\u671f\u8c03\u6574\u65b9\u5f0f\u3001\u5373\u671f\u504f\u79fb\u4e0d\u53ef\u8f93\u5165\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_34", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                }
                quoteTypeToDateRule.put(quoteType, dateRule);
                if (EmptyUtil.isNoEmpty(defineRow.get("dateaxis"))) {
                    defineRow.put("fowardmethod", CalMethodEnum.specify.getValue());
                    String forwardQuotation = (String)defineRow.get("fowardquotation");
                    if (EmptyUtil.isEmpty((String)forwardQuotation)) {
                        throw new KDBizException(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\uff0c\u7f3a\u5c11\u8fdc\u671f\u6c47\u7387\u5f55\u5165\u65b9\u5f0f\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ForexQuoteImport_23", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                    }
                    quoteTypeToPointOrPrice.put(quoteType, forwardQuotation);
                    Map dateAxisMap = (Map)defineRow.get("dateaxis");
                    QFilter[] filters = new QFilter[]{new QFilter("number", "=", dateAxisMap.get("number"))};
                    if (QueryServiceHelper.exists((String)"tbd_dateaxis", (QFilter[])filters)) {
                        DynamicObject dateAxis = BusinessDataServiceHelper.loadSingle((String)"tbd_dateaxis", (String)"entrys,entrys.point", (QFilter[])filters);
                        DynamicObjectCollection entrys = dateAxis.getDynamicObjectCollection("entrys");
                        for (int index = 0; index < entrys.size(); ++index) {
                            terms2.add(((DynamicObject)entrys.get(index)).getString("point"));
                        }
                        continue;
                    }
                    return false;
                }
                defineRow.put("fowardmethod", CalMethodEnum.none.getValue());
            }
        }
        JSONArray input = (JSONArray)data.get("quoteinput");
        HashSet<String> skipQuoteTypes = new HashSet<String>();
        HashMap<String, List<Date>> quoteTypeToDateList = new HashMap<String, List<Date>>();
        if (input != null) {
            for (int i = 0; i < input.size(); ++i) {
                Map spotRow;
                Optional<Object> first;
                String errorMsg;
                Map inputRow = (Map)input.get(i);
                String inputQuoteType = (String)inputRow.get("input_quotetype");
                if (EmptyUtil.isEmpty((String)inputQuoteType)) {
                    return false;
                }
                if (skipQuoteTypes.contains(inputQuoteType)) continue;
                String[] importPair = inputQuoteType.split("/");
                if (importPair.length != 2) {
                    throw new KDBizException(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_19", (String)"tmc-md-formplugin", (Object[])new Object[]{inputQuoteType}));
                }
                defineQuoteTypeList.remove(inputQuoteType);
                terms = (List)quoteTypeToTerms.get(inputQuoteType);
                if (DateRuleEnum.specify.getValue().equals(quoteTypeToDateRule.get(inputQuoteType)) && EmptyUtil.isEmpty(inputRow.get("date"))) {
                    errorInfo.append(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\uff0c\u4e0a\u4f20\u7684\u6570\u636e\u4e2d\u8f93\u5165\u7684\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_36", (String)"tmc-md-formplugin", (Object[])new Object[]{inputQuoteType}));
                    errorInfo.append("\n");
                    skipQuoteTypes.add(inputQuoteType);
                    terms.clear();
                    continue;
                }
                if (DateRuleEnum.sys.getValue().equals(quoteTypeToDateRule.get(inputQuoteType)) && !EmptyUtil.isEmpty(inputRow.get("date"))) {
                    errorInfo.append(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\uff0c\u4e0a\u4f20\u7684\u6570\u636e\u4e2d\u65e5\u671f\u9009\u62e9\u7cfb\u7edf\u751f\u6210\uff0c\u4e0d\u652f\u6301\u624b\u5de5\u8f93\u5165\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_35", (String)"tmc-md-formplugin", (Object[])new Object[]{inputQuoteType}));
                    errorInfo.append("\n");
                    skipQuoteTypes.add(inputQuoteType);
                    terms.clear();
                    continue;
                }
                String term = (String)inputRow.get("term");
                if (DateRuleEnum.specify.getValue().equals(quoteTypeToDateRule.get(inputQuoteType)) && (errorMsg = this.putDate(quoteTypeToDateList, inputQuoteType, (String)inputRow.get("date"), issueTime, term)) != null) {
                    errorInfo.append(errorMsg);
                    errorInfo.append("\n");
                }
                if (terms != null && !terms.contains(term)) {
                    errorInfo.append(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\uff0c\u5bf9\u5e94\u7684\u62a5\u4ef7\u5f55\u5165\u7684\u671f\u9650\u548c\u9009\u62e9\u7684\u8fdc\u671f\u65e5\u671f\u8f74\u672a\u4fdd\u6301\u4e00\u81f4\uff0c\u65f6\u95f4\u8f74\u4e0d\u5b58\u5728{1}\u7b49\u8f74\u70b9\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_14", (String)"tmc-md-formplugin", (Object[])new Object[]{inputQuoteType, term}));
                    errorInfo.append("\n");
                    continue;
                }
                if (terms != null && terms.contains(term)) {
                    terms.remove(term);
                }
                String pointOrPrice = (String)quoteTypeToPointOrPrice.get(inputQuoteType);
                if ("Spot".equals(term) && (EmptyUtil.isNoEmpty(inputRow.get("buypoints")) || EmptyUtil.isNoEmpty(inputRow.get("sellpoints")))) {
                    errorInfo.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u5f55\u5165Spot\u884c\u53ea\u80fd\u5f55\u5165\u4e70\u5165\u4ef7\u6216\u5356\u51fa\u4ef7\uff0c\u4e0d\u80fd\u5f55\u5165\u8fdc\u671f\u70b9\u6570\u3002", (String)"ForexQuoteImport_15", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    errorInfo.append("\n");
                    continue;
                }
                if (!"Spot".equals(term) && "point".equals(pointOrPrice) && (EmptyUtil.isNoEmpty(inputRow.get("buyprice")) || EmptyUtil.isNoEmpty(inputRow.get("sellprice"))) || "exRate".equals(pointOrPrice) && (EmptyUtil.isNoEmpty(inputRow.get("buypoints")) || EmptyUtil.isNoEmpty(inputRow.get("sellpoints")))) {
                    errorInfo.append(ResManager.loadKDString((String)"\u8fdc\u671f\u6c47\u7387\u5f55\u5165\u65b9\u5f0f\u548c\u62a5\u4ef7\u5f55\u5165\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_16", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    errorInfo.append("\n");
                    continue;
                }
                if ("exRate".equals(pointOrPrice) || "Spot".equals(term)) {
                    if (EmptyUtil.isEmpty(inputRow.get("buyprice")) || EmptyUtil.isEmpty(inputRow.get("sellprice"))) {
                        errorInfo.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6570\u636e\u4e70\u5165\u4ef7\u6216\u5356\u51fa\u4ef7\u4e3a\u7a7a\uff0c\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_40", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                        errorInfo.append("\n");
                        continue;
                    }
                    BigDecimal buyPrice = BigDecimal.ZERO;
                    BigDecimal sellPrice = BigDecimal.ZERO;
                    if (EmptyUtil.isNoEmpty(inputRow.get("buyprice"))) {
                        buyPrice = new BigDecimal((String)inputRow.get("buyprice"));
                    }
                    if (EmptyUtil.isNoEmpty(inputRow.get("sellprice"))) {
                        sellPrice = new BigDecimal((String)inputRow.get("sellprice"));
                    }
                    if (buyPrice.compareTo(sellPrice) > 0) {
                        errorInfo.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6570\u636e\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_17", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                        errorInfo.append("\n");
                        continue;
                    }
                    inputRow.put("midprice", buyPrice.add(sellPrice).divide(new BigDecimal("2"), 10, 4));
                    continue;
                }
                if (!"point".equals(pointOrPrice)) continue;
                BigDecimal buyPoints = BigDecimal.ZERO;
                BigDecimal sellPoints = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty(inputRow.get("buypoints"))) {
                    buyPoints = new BigDecimal((String)inputRow.get("buypoints"));
                }
                if (EmptyUtil.isNoEmpty(inputRow.get("sellpoints"))) {
                    sellPoints = new BigDecimal((String)inputRow.get("sellpoints"));
                }
                if ((first = input.stream().filter(row -> ((Map)row).get("input_quotetype").equals(inputRow.get("input_quotetype")) && "Spot".equals(((Map)row).get("term")) && EmptyUtil.isNoEmpty(((Map)row).get("buyprice")) && EmptyUtil.isNoEmpty(((Map)row).get("sellprice"))).findFirst()).isPresent() && new BigDecimal((String)(spotRow = (Map)first.get()).get("buyprice")).add(buyPoints.divide(new BigDecimal("10000"))).compareTo(new BigDecimal((String)spotRow.get("sellprice")).add(sellPoints.divide(new BigDecimal("10000")))) > 0) {
                    errorInfo.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u6570\u636e\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_17", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    errorInfo.append("\n");
                    continue;
                }
                inputRow.put("midpoints", buyPoints.add(sellPoints).divide(new BigDecimal("2"), 10, 4));
            }
        }
        for (Map.Entry entry : quoteTypeToDateList.entrySet()) {
            String quoteType = (String)entry.getKey();
            List dateList = (List)entry.getValue();
            if (this.isOrderedAsc(dateList)) continue;
            errorInfo.append(ResManager.loadKDString((String)"{0}\u4e0a\u4f20\u7684\u6570\u636e\u4e2d\u8f93\u5165\u7684\u4e0b\u4e00\u65e5\u671f\u8981\u5927\u4e8e\u4e0a\u4e00\u65e5\u671f\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_37", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
            errorInfo.append("\n");
        }
        for (Map.Entry entry : quoteTypeToTerms.entrySet()) {
            String quoteType = (String)entry.getKey();
            terms = (List)entry.getValue();
            if (!EmptyUtil.isNoEmpty((Object)terms)) continue;
            if (terms.contains("Spot")) {
                errorInfo.append(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u5bf9\u5e94\u7684\u62a5\u4ef7\u5f55\u5165\u6ca1\u6709\u5f55\u5165\u5373\u671f\u884c(Spot\u884c)\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ForexQuoteImport_20", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                errorInfo.append("\n");
                continue;
            }
            if (defineQuoteTypeList.contains(quoteType)) {
                errorInfo.append(ResManager.loadKDString((String)"{0}\u5b9a\u4e49\u8f93\u5165\u7684\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u62a5\u4ef7\u5f55\u5165\u7684\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_21", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType}));
                errorInfo.append("\n");
                continue;
            }
            errorInfo.append(ResManager.loadKDString((String)"{0}\u8d27\u5e01\u5bf9\u62a5\u4ef7\u65b9\u5f0f\u5bf9\u5e94\u7684\u62a5\u4ef7\u5f55\u5165\u7684\u671f\u9650\u548c\u9009\u62e9\u7684\u8fdc\u671f\u65e5\u671f\u8f74\u672a\u4fdd\u6301\u4e00\u81f4\uff0c\u7f3a\u5c11\u671f\u9650{1}\u7b49\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexQuoteImport_22", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType, terms.get(0)}));
            errorInfo.append("\n");
        }
        if (errorInfo.length() > 0) {
            throw new KDBizException(errorInfo.toString());
        }
        return true;
    }

    private boolean isOrderedAsc(List<Date> dateList) {
        for (int i = 0; i < dateList.size() - 1; ++i) {
            int j = i + 1;
            if (dateList.get(j).after(dateList.get(i))) continue;
            return false;
        }
        return true;
    }

    private String putDate(Map<String, List<Date>> quoteTypeToDateList, String quoteType, String dateStr, Date issueTime, String term) {
        String errorMsg = null;
        Date date = TcDateUtils.stringToDate((String)dateStr, (String)"yyyy-MM-dd");
        if (quoteTypeToDateList.get(quoteType) == null) {
            Date maxSpotDate = TradeBusinessHelper.callSettleDelayDate(null, (Date)issueTime, (int)2);
            if ("Spot".equals(term) && (maxSpotDate.before(date) || TcDateUtils.getDataFormat((Date)issueTime, (boolean)true).after(date))) {
                errorMsg = ResManager.loadKDString((String)"{0}\u7684Spot\u884c\u8f93\u5165\u7684\u65e5\u671f\u5fc5\u987b\u5728\u5f55\u5165\u7684\u53d1\u5e03\u65e5+0,1,2\u4e2a\u5de5\u4f5c\u65e5\u5185\u3002", (String)"ForexQuoteImport_39", (String)"tmc-md-formplugin", (Object[])new Object[]{quoteType});
            }
            quoteTypeToDateList.put(quoteType, new ArrayList());
        }
        quoteTypeToDateList.get(quoteType).add(date);
        return errorMsg;
    }
}

