/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.forex;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.md.common.enums.CalMethodEnum;
import kd.tmc.md.common.enums.DateRuleEnum;
import kd.tmc.md.formplugin.forex.ForexQuoteImportService;

public class ForexQuoteOutAndViewPlugin
extends AbstractTmcBillEdit
implements ItemClickListener,
TabSelectListener {
    private static final Log logger = LogFactory.getLog(ForexQuoteOutAndViewPlugin.class);
    private DynamicObject billModel;
    private static final String OP_KEY_CUSTOM_SAVE = "customsave";
    private static final String CALLBACKID_DATE_FORM = "callbackid_date_form";
    private Map<Object, DynamicObject> mdYieldLineCache = new HashMap<Object, DynamicObject>();
    private Map<String, Object[]> dateListCache = new HashMap<String, Object[]>();

    public void registerListener(EventObject e) {
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
        this.addClickListeners(new String[]{"btninsertdate"});
        this.addItemClickListeners(new String[]{"btninsertdate"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        if (OP_KEY_CUSTOM_SAVE.equals(source.getOperateKey())) {
            if (this.validate()) {
                args.setCancel(true);
                return;
            }
            this.genOutputEntry();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "enable": 
            case "disable": {
                this.genViewEntry(false);
                this.getModel().setDataChanged(false);
                break;
            }
            case "insertdate": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("md_forexquote_date");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setStatus(OperationStatus.EDIT);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACKID_DATE_FORM);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (CALLBACKID_DATE_FORM.equals(closedCallBackEvent.getActionId()) && closedCallBackEvent.getReturnData() != null) {
            Date date = (Date)closedCallBackEvent.getReturnData();
            this.insertDataIntoViewPage(date);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("viewpage")) {
            this.genViewEntry(true);
        } else if (e.getTabKey().equals("quoteoutputpage")) {
            if (this.validate()) {
                return;
            }
            this.genOutputEntry();
            if (!this.validatePrice()) {
                this.getModel().deleteEntryData("quoteoutput");
            }
        }
    }

    private boolean validatePrice() {
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        for (int i = 0; i < this.getModel().getEntryRowCount("quoteoutput"); ++i) {
            if ("Today".equals(this.getModel().getValue("output_term", i)) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("output_buyprice", i), this.getModel().getValue("output_sellprice", i)}) || ((BigDecimal)this.getModel().getValue("output_buyprice", i)).compareTo((BigDecimal)this.getModel().getValue("output_sellprice", i)) <= 0) continue;
            map.computeIfAbsent((String)this.getModel().getValue("output_quotetype", i), k -> new ArrayList());
            ((List)map.get(this.getModel().getValue("output_quotetype", i))).add((String)this.getModel().getValue("output_term", i));
        }
        if (!map.isEmpty()) {
            int max = 9;
            StringBuilder errorMsgBuilder = new StringBuilder();
            for (Map.Entry entry : map.entrySet()) {
                StringBuilder itemsBuilder = new StringBuilder();
                List items = (List)entry.getValue();
                for (int i = 0; i < items.size() && i <= max; ++i) {
                    if (i == 0) {
                        itemsBuilder.append(" ");
                    }
                    itemsBuilder.append((String)items.get(i));
                    if (i == max || i == items.size() - 1) {
                        itemsBuilder.append(" ");
                        continue;
                    }
                    itemsBuilder.append("\u3001");
                }
                if (items.size() > max) {
                    itemsBuilder.append("... ");
                }
                errorMsgBuilder.append(ResManager.loadResFormat((String)"{0}\u671f\u9650\u4e3a {1} \u7684\u4e70\u5165\u4ef7\u5927\u4e8e\u5356\u51fa\u4ef7\uff0c\u6570\u636e\u9519\u8bef\u3002", (String)"ForexQuoteOutAndViewPlugin_1", (String)"tmc-md-formplugin", (Object[])new Object[]{entry.getKey(), itemsBuilder.toString()}));
                errorMsgBuilder.append("\n");
            }
            this.getView().showTipNotification(errorMsgBuilder.toString(), Integer.valueOf(1500));
            return false;
        }
        return true;
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        this.billModel = this.getModel().getDataEntity();
        this.billModel = (DynamicObject)OrmUtils.clone((Object)this.billModel, (IDataEntityType)this.billModel.getDataEntityType(), (boolean)true, (boolean)false);
        new ForexQuoteImportService().beforeImportData(e);
    }

    public void afterImportData(ImportDataEventArgs e) {
        this.getModel().getEntryEntity("define").removeIf(define -> EmptyUtil.isNoEmpty((Object)define.getPkValue()));
        this.getModel().getEntryEntity("quoteinput").removeIf(input -> EmptyUtil.isNoEmpty((Object)input.getPkValue()));
        this.resetSeq("define");
        this.resetSeq("quoteinput");
        this.getPageCache().put("ismodify", "true");
        this.genOutputEntry();
        if (((Boolean)this.getModel().getValue("issavehistorytip")).booleanValue()) {
            this.intoForexQuoteH();
            this.revertModel();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (propName.equals("view_dateaxis")) {
            this.genViewEntry(true);
        }
    }

    private void revertModel() {
        this.getModel().setValue("billno", this.billModel.get("billno"));
        this.getModel().setValue("issuezone", this.billModel.get("issuezone"));
        this.getModel().setValue("issuetime", this.billModel.get("issuetime"));
        this.getModel().setValue("desc", this.billModel.get("desc"));
        this.getModel().deleteEntryData("define");
        DynamicObjectCollection define = this.getModel().getEntryEntity("define");
        int seq = 1;
        for (Object defineRow : this.billModel.getDynamicObjectCollection("define")) {
            DynamicObject defineObj = define.addNew();
            defineObj.set("seq", (Object)seq);
            this.copyColumns(defineObj, (DynamicObject)defineRow, "quotetype", "spotmethod", "dateaxis", "fowardmethod", "fowardquotation", "workcalendar", "dateadjustmethod", "spotdelay", "rateaccuracy", "midcurrency", "lcuryieldcurve", "rcuryieldcurve", "daterule");
            ++seq;
        }
        this.getModel().deleteEntryData("quoteinput");
        DynamicObjectCollection input = this.getModel().getEntryEntity("quoteinput");
        seq = 1;
        for (DynamicObject inputRow : this.billModel.getDynamicObjectCollection("quoteinput")) {
            DynamicObject inputObj = input.addNew();
            inputObj.set("seq", (Object)seq);
            this.copyColumns(inputObj, inputRow, "input_quotetype", "term", "date", "buyprice", "buypoints", "sellprice", "sellpoints", "midprice", "midpoints");
            ++seq;
        }
        this.getModel().deleteEntryData("quoteoutput");
        DynamicObjectCollection output = this.getModel().getEntryEntity("quoteoutput");
        seq = 1;
        for (DynamicObject outputRow : this.billModel.getDynamicObjectCollection("quoteoutput")) {
            DynamicObject outputObj = output.addNew();
            outputObj.set("seq", (Object)seq);
            this.copyColumns(outputObj, outputRow, "output_quotetype", "output_term", "output_date", "output_buyprice", "output_sellprice", "output_midprice");
            ++seq;
        }
    }

    private void intoForexQuoteH() {
        DynamicObjectType forexQuoteHType = BusinessDataServiceHelper.newDynamicObject((String)"md_forexquote_h").getDynamicObjectType();
        DynamicObject forexQuoteH = new DynamicObject(forexQuoteHType);
        forexQuoteH.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
        forexQuoteH.set("enable", (Object)"1");
        forexQuoteH.set("billno", this.getModel().getValue("billno"));
        forexQuoteH.set("issuezone", this.getModel().getValue("issuezone"));
        forexQuoteH.set("issuetime", this.getModel().getValue("issuetime"));
        forexQuoteH.set("desc", this.getModel().getValue("desc"));
        DynamicObjectCollection defineEntry = (DynamicObjectCollection)forexQuoteH.get("define");
        int seq = 1;
        for (Object defineRow : this.getModel().getEntryEntity("define")) {
            DynamicObject defineObj = defineEntry.addNew();
            defineObj.set("seq", (Object)seq);
            this.copyColumns(defineObj, (DynamicObject)defineRow, "quotetype", "spotmethod", "dateaxis", "fowardmethod", "daterule", "fowardquotation", "workcalendar", "dateadjustmethod", "spotdelay", "rateaccuracy");
            ++seq;
        }
        DynamicObjectCollection inputEntry = (DynamicObjectCollection)forexQuoteH.get("quoteinput");
        seq = 1;
        for (DynamicObject inputRow : this.getModel().getEntryEntity("quoteinput")) {
            DynamicObject inputObj = inputEntry.addNew();
            inputObj.set("seq", (Object)seq);
            this.copyColumns(inputObj, inputRow, "input_quotetype", "term", "date", "buyprice", "buypoints", "sellprice", "sellpoints", "midprice", "midpoints");
            ++seq;
        }
        DynamicObjectCollection outputEntry = (DynamicObjectCollection)forexQuoteH.get("quoteoutput");
        seq = 1;
        for (DynamicObject outputRow : this.getModel().getEntryEntity("quoteoutput")) {
            DynamicObject outputObj = outputEntry.addNew();
            outputObj.set("seq", (Object)seq);
            this.copyColumns(outputObj, outputRow, "output_quotetype", "output_term", "output_date", "output_buyprice", "output_sellprice", "output_midprice");
            ++seq;
        }
        forexQuoteH.set("sourcebillid", this.billModel.getPkValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{forexQuoteH});
    }

    private void copyColumns(DynamicObject target, DynamicObject source, String ... keys) {
        for (String key : keys) {
            target.set(key, source.get(key));
        }
    }

    private void resetSeq(String entryKey) {
        int i = 1;
        for (DynamicObject entryRow : this.getModel().getEntryEntity(entryKey)) {
            entryRow.set("seq", (Object)i);
            ++i;
        }
    }

    private boolean validate() {
        StringBuilder tipMsg = new StringBuilder();
        DynamicObjectCollection defineRows = this.getModel().getEntryEntity("define");
        for (int rowIndex = 0; rowIndex < defineRows.size(); ++rowIndex) {
            Set<String> set;
            HashSet<String> nullColumnNames = new HashSet<String>(1);
            DynamicObject defineRow = (DynamicObject)defineRows.get(rowIndex);
            String spotMethod = defineRow.getString("spotmethod");
            String forwardMethod = defineRow.getString("fowardmethod");
            if (forwardMethod.equals(CalMethodEnum.specify.getValue())) {
                set = this.validateMustInput(rowIndex, "fowardquotation", "dateaxis");
                if (set != null) {
                    nullColumnNames.addAll(set);
                }
            } else if (forwardMethod.equals(CalMethodEnum.crossExRate.getValue())) {
                set = this.validateMustInput(rowIndex, "dateaxis");
                if (set != null) {
                    nullColumnNames.addAll(set);
                }
            } else if (forwardMethod.equals(CalMethodEnum.ycDeduction.getValue()) && (set = this.validateMustInput(rowIndex, "rcuryieldcurve", "lcuryieldcurve", "dateaxis")) != null) {
                nullColumnNames.addAll(set);
            }
            if ((spotMethod.equals(CalMethodEnum.crossExRate.getValue()) || forwardMethod.equals(CalMethodEnum.crossExRate.getValue())) && (set = this.validateMustInput(rowIndex, "midcurrency")) != null) {
                nullColumnNames.addAll(set);
            }
            if (nullColumnNames.isEmpty()) continue;
            tipMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5b9a\u4e49%2$s\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u5bf9\u5e94\u62a5\u4ef7\u8f93\u51fa\u884c\u3002", (String)"ForexQuoteOutAndViewPlugin_28", (String)"tmc-md-formplugin", (Object[])new Object[0]), rowIndex + 1, String.join((CharSequence)"\u3001", nullColumnNames)));
            tipMsg.append("\n");
        }
        DynamicObjectCollection inputRows = this.getModel().getEntryEntity("quoteinput");
        for (int rowIndex = 0; rowIndex < inputRows.size(); ++rowIndex) {
            DynamicObject inputRow = (DynamicObject)inputRows.get(rowIndex);
            if ((!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{inputRow.get("buyprice"), inputRow.get("sellprice"), inputRow.get("midprice")}) || !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{inputRow.get("buypoints"), inputRow.get("sellpoints"), inputRow.get("midpoints")})) && EmptyUtil.isNoEmpty((Object)inputRow.get("date"))) continue;
            tipMsg.append(ResManager.loadResFormat((String)"{0} {1} \u884c\u6570\u636e\u672a\u5f55\u5165\u5b8c\u6574\u3002", (String)"ForexQuoteOutAndViewPlugin_3", (String)"tmc-md-formplugin", (Object[])new Object[]{inputRow.get("input_quotetype"), inputRow.get("term")}));
            tipMsg.append("\n");
        }
        String seqString = tipMsg.toString();
        if (EmptyUtil.isNoEmpty((String)seqString)) {
            this.getView().showTipNotification(seqString, Integer.valueOf(2500));
            return true;
        }
        return false;
    }

    private Set<String> validateMustInput(int index, String ... columnKeys) {
        HashSet<String> set = null;
        for (String columnKey : columnKeys) {
            if (!EmptyUtil.isEmpty((Object)this.getModel().getValue(columnKey, index))) continue;
            EntryProp defineProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"define");
            if (set == null) {
                set = new HashSet<String>(1);
            }
            set.add("\u201c" + defineProp._collectionItemPropertyType.getProperty(columnKey).getDisplayName().getLocaleValue() + "\u201d");
        }
        return set;
    }

    private void genOutputEntry() {
        this.validateDateAxis();
        if ("true".equals(this.getPageCache().get("ismodify"))) {
            DynamicObjectCollection defineColl = this.getModel().getEntryEntity("define");
            DynamicObjectCollection inputColl = this.getModel().getEntryEntity("quoteinput");
            this.getModel().deleteEntryData("quoteoutput");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{defineColl, inputColl})) {
                this.genOutputEntry(defineColl, inputColl);
                this.setScaleForOutputPageList();
            }
            this.getPageCache().put("ismodify", "false");
        }
    }

    private void validateDateAxis() {
        Map<String, DynamicObject> pair2dateAxisMap = this.getModel().getEntryEntity("define").stream().filter(row -> EmptyUtil.isNoEmpty((Object)row.get("dateaxis"))).collect(Collectors.toMap(row -> row.getString("quotetype"), row -> row.getDynamicObject("dateaxis")));
        if (pair2dateAxisMap.isEmpty()) {
            return;
        }
        Set<String> pairs = pair2dateAxisMap.keySet();
        Map pairGroupedMap = this.getModel().getEntryEntity("quoteinput").stream().filter(row -> pairs.contains(row.getString("input_quotetype"))).collect(Collectors.groupingBy(row -> row.getString("input_quotetype"), Collectors.toSet()));
        HashSet<String> changedDateAxisNumberSet = new HashSet<String>(10);
        block0: for (Map.Entry<String, DynamicObject> e : pair2dateAxisMap.entrySet()) {
            String pair = e.getKey();
            DynamicObject dateAxis = e.getValue();
            if (!pairGroupedMap.containsKey(pair)) continue;
            Set rows = pairGroupedMap.get(pair);
            Set terms = rows.stream().filter(row -> !"Today".equals(row.getString("term")) && !"Spot".equals(row.getString("term"))).map(o -> o.getString("term")).collect(Collectors.toSet());
            if (terms.isEmpty()) {
                return;
            }
            Set points = dateAxis.getDynamicObjectCollection("entrys").stream().map(row -> row.getString("point")).collect(Collectors.toSet());
            for (String point : points) {
                if (terms.contains(point)) continue;
                changedDateAxisNumberSet.add(dateAxis.getString("number"));
                break;
            }
            for (String term : terms) {
                if (points.contains(term)) continue;
                changedDateAxisNumberSet.add(dateAxis.getString("number"));
                continue block0;
            }
        }
        if (!changedDateAxisNumberSet.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f74\u201c%s\u201d\u7684\u8f74\u70b9\u6570\u636e\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u6e05\u7a7a\u5e76\u91cd\u9009\u6b64\u65e5\u671f\u8f74\uff0c\u6216\u8005\u5207\u6362\u6210\u5176\u4ed6\u65e5\u671f\u8f74\uff0c\u6216\u8005\u8fd8\u539f\u8be5\u65e5\u671f\u8f74\u7684\u8f74\u70b9\u6570\u636e\u3002", (String)"ForexQuoteOutAndViewPlugin_5", (String)"tmc-md-formplugin", (Object[])new Object[]{String.join((CharSequence)"\u3001", changedDateAxisNumberSet)}));
        }
    }

    private void insertDataIntoViewPage(Date date) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(8);
        for (int i = 0; i < this.getModel().getEntryEntity("define").size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.getModel().getEntryEntity("define").get(i);
            map.put(dynamicObject.getString("quotetype"), i);
        }
        HashMap<String, Integer> accuracyMap = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : this.getModel().getEntryEntity("define")) {
            accuracyMap.put(dynamicObject.getString("quotetype"), dynamicObject.get("rateaccuracy") == null ? 0 : dynamicObject.getInt("rateaccuracy"));
        }
        DynamicObjectCollection quoteViewPageList = this.getModel().getEntryEntity("quoteview");
        if (quoteViewPageList.size() == 0) {
            return;
        }
        for (String quoteType : map.keySet()) {
            if (CalMethodEnum.none.getValue().equals(this.getForwardMethod(quoteType))) continue;
            DynamicObject row = new DynamicObject(((DynamicObject)quoteViewPageList.get(0)).getDynamicObjectType());
            this.generateViewPrice(quoteType, 0, date, row, accuracyMap);
            row.set("view_quotetype", (Object)quoteType);
            row.set("view_term", null);
            row.set("view_date", (Object)date);
            quoteViewPageList.add((Object)row);
        }
        this.sortViewPage(map, quoteViewPageList);
    }

    private String getForwardMethod(String quoteType) {
        for (DynamicObject dynamicObject : this.getModel().getEntryEntity("define")) {
            if (!quoteType.equals(dynamicObject.getString("quotetype"))) continue;
            return dynamicObject.getString("fowardmethod");
        }
        return null;
    }

    private void sortViewPage(Map<String, Integer> map, DynamicObjectCollection quoteViewPageList) {
        DynamicObjectCollection copyList = (DynamicObjectCollection)quoteViewPageList.clone();
        copyList.sort((row1, row2) -> {
            Date date2;
            int i = ((Integer)map.get(row1.getString("view_quotetype"))).compareTo((Integer)map.get(row2.getString("view_quotetype")));
            if (i != 0) {
                return i;
            }
            Date date1 = row1.getDate("view_date");
            if (TcDateUtils.isSameDay((Date)date1, (Date)(date2 = row2.getDate("view_date")))) {
                return 0;
            }
            return date1.after(date2) ? 1 : -1;
        });
        this.getModel().deleteEntryData("quoteview");
        for (DynamicObject dynamicObject : copyList) {
            int rowIndex = this.getModel().createNewEntryRow("quoteview");
            this.getModel().setValue("view_quotetype", dynamicObject.get("view_quotetype"), rowIndex);
            this.getModel().setValue("view_term", dynamicObject.get("view_term"), rowIndex);
            this.getModel().setValue("view_date", dynamicObject.get("view_date"), rowIndex);
            this.getModel().setValue("view_buyprice", dynamicObject.get("view_buyprice"), rowIndex);
            this.getModel().setValue("view_sellprice", dynamicObject.get("view_sellprice"), rowIndex);
            this.getModel().setValue("view_midprice", dynamicObject.get("view_midprice"), rowIndex);
        }
    }

    private HashMap<String, Integer> genInputSeqMap(DynamicObjectCollection coll) {
        HashMap<String, Integer> seqMap = new HashMap<String, Integer>(coll.size());
        for (DynamicObject inputRow : coll) {
            seqMap.put(inputRow.getString("input_quotetype") + inputRow.getString("term"), inputRow.getInt("seq"));
        }
        return seqMap;
    }

    private LinkedList<DynamicObject> sortDefineList(DynamicObjectCollection defineColl) {
        LinkedList<DynamicObject> normalList = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> crossList = new LinkedList<DynamicObject>();
        for (DynamicObject defineRow : defineColl) {
            CalMethodEnum spotEnum = CalMethodEnum.valueOf((String)defineRow.getString("spotmethod"));
            CalMethodEnum forwardEnum = CalMethodEnum.valueOf((String)defineRow.getString("fowardmethod"));
            if (spotEnum == CalMethodEnum.crossExRate || forwardEnum == CalMethodEnum.crossExRate) {
                crossList.add(defineRow);
                continue;
            }
            normalList.add(defineRow);
        }
        for (int i = 0; i < crossList.size() - 1; ++i) {
            for (int j = 0; j < crossList.size() - 1 - i; ++j) {
                DynamicObject rowJ = (DynamicObject)crossList.get(j);
                DynamicObject rowJ_1 = (DynamicObject)crossList.get(j + 1);
                String midCurrencyNumber = rowJ.getDynamicObject("midcurrency").getString("number");
                String quoteType = rowJ_1.getString("quotetype");
                if (!quoteType.contains(midCurrencyNumber)) continue;
                crossList.set(j, rowJ_1);
                crossList.set(j + 1, rowJ);
            }
        }
        normalList.addAll(crossList);
        return normalList;
    }

    private void genOutputEntry(DynamicObjectCollection defineColl, DynamicObjectCollection inputColl) {
        LinkedList<DynamicObject> defineList = this.sortDefineList(defineColl);
        HashMap<String, Integer> inputSeqMap = this.genInputSeqMap(inputColl);
        HashMap<String, Integer> outIndexMap = new HashMap<String, Integer>(defineList.size());
        Date spotDate = null;
        for (DynamicObject defineRow : defineList) {
            boolean isSpecifyDate;
            String quoteType = defineRow.getString("quotetype");
            DynamicObject dateAxis = defineRow.getDynamicObject("dateaxis");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{quoteType})) continue;
            if (CalMethodEnum.specify.getValue().equals(defineRow.getString("spotmethod")) && CalMethodEnum.none.getValue().equals(defineRow.getString("fowardmethod"))) {
                this.genOutputSpotRow_specify(outIndexMap, inputSeqMap, defineRow);
                continue;
            }
            if (CalMethodEnum.crossExRate.getValue().equals(defineRow.getString("spotmethod")) && CalMethodEnum.none.getValue().equals(defineRow.getString("fowardmethod"))) {
                this.genOutputSpotRow_crossExRate(outIndexMap, defineRow);
                continue;
            }
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateAxis}) || (isSpecifyDate = DateRuleEnum.specify.getValue().equals(defineRow.getString("daterule"))) && this.existNullDateRow(quoteType)) continue;
            DynamicObjectCollection axisPoints = dateAxis.getDynamicObjectCollection("entrys");
            int outputCount = axisPoints == null ? 0 : axisPoints.size() + 2;
            for (int i = 0; i < outputCount; ++i) {
                int rowIndex = this.getModel().createNewEntryRow("quoteoutput");
                this.getModel().setValue("output_quotetype", (Object)quoteType, rowIndex);
                String term = this.calTerm(i, axisPoints);
                this.getModel().setValue("output_term", (Object)term, rowIndex);
                outIndexMap.put(quoteType + term, rowIndex);
                Date date = null;
                if (isSpecifyDate) {
                    date = this.findDateFromInputRows(quoteType, term);
                }
                if (date == null) {
                    date = this.calDate(i, term, defineRow, spotDate);
                }
                if (i == 1) {
                    spotDate = date;
                }
                this.getModel().setValue("output_date", (Object)date, rowIndex);
            }
            this.fillAmount(outputCount, inputSeqMap, defineRow, outIndexMap);
        }
        this.removeReduplicatedRowsForPage("quoteoutput", true);
    }

    private Date findDateFromInputRows(String quoteType, String term) {
        for (DynamicObject inputRow : this.getModel().getEntryEntity("quoteinput")) {
            if (!quoteType.equals(inputRow.getString("input_quotetype")) || !term.equals(inputRow.getString("term"))) continue;
            return inputRow.getDate("date");
        }
        return null;
    }

    private boolean existNullDateRow(String quoteType) {
        for (DynamicObject input : this.getModel().getEntryEntity("quoteinput")) {
            if (!quoteType.equals(input.getString("input_quotetype")) || !EmptyUtil.isEmpty((Object)input.getDate("date"))) continue;
            return true;
        }
        return false;
    }

    private void copyOutputToView(String quoteType) {
        for (DynamicObject output : this.getModel().getEntryEntity("quoteoutput")) {
            if (!quoteType.equals(output.getString("output_quotetype"))) continue;
            int rowIndex = this.getModel().createNewEntryRow("quoteview");
            this.getModel().setValue("view_quotetype", (Object)quoteType, rowIndex);
            this.getModel().setValue("view_term", output.get("output_term"), rowIndex);
            this.getModel().setValue("view_date", output.get("output_date"), rowIndex);
            this.getModel().setValue("view_buyprice", output.get("output_buyprice"), rowIndex);
            this.getModel().setValue("view_sellprice", output.get("output_sellprice"), rowIndex);
            this.getModel().setValue("view_midprice", output.get("output_midprice"), rowIndex);
        }
    }

    private void genOutputSpotRow_crossExRate(HashMap<String, Integer> outIndexMap, DynamicObject defineRow) {
        int rowIndex = this.getModel().createNewEntryRow("quoteoutput");
        String quoteType = defineRow.getString("quotetype");
        String term = "Spot";
        outIndexMap.put(quoteType + term, rowIndex);
        Date spotDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)defineRow.getDynamicObjectCollection("workcalendar"), (Date)((Date)this.getModel().getValue("issuetime")), (int)(defineRow.get("spotdelay") == null ? 0 : defineRow.getInt("spotdelay")));
        this.getModel().setValue("output_quotetype", (Object)defineRow.getString("quotetype"), rowIndex);
        this.getModel().setValue("output_term", (Object)term, rowIndex);
        this.getModel().setValue("output_date", (Object)spotDate, rowIndex);
        DynamicObject midCurrency = defineRow.getDynamicObject("midcurrency");
        String midCurrencyNumber = midCurrency != null ? midCurrency.getString("number") : null;
        this.fillCrossAmount(outIndexMap, quoteType.split("/"), midCurrencyNumber, term, rowIndex);
    }

    private void genOutputSpotRow_specify(HashMap<String, Integer> outIndexMap, HashMap<String, Integer> inputSeqMap, DynamicObject defineRow) {
        int rowIndex = this.getModel().createNewEntryRow("quoteoutput");
        String quoteType = defineRow.getString("quotetype");
        String term = "Spot";
        int inputRowIndex = inputSeqMap.get(quoteType + term) - 1;
        outIndexMap.put(quoteType + term, rowIndex);
        Date spotDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)defineRow.getDynamicObjectCollection("workcalendar"), (Date)((Date)this.getModel().getValue("issuetime")), (int)(defineRow.get("spotdelay") == null ? 0 : defineRow.getInt("spotdelay")));
        this.getModel().setValue("output_quotetype", (Object)defineRow.getString("quotetype"), rowIndex);
        this.getModel().setValue("output_term", (Object)term, rowIndex);
        this.getModel().setValue("output_date", (Object)spotDate, rowIndex);
        this.getModel().setValue("output_buyprice", this.getModel().getValue("buyprice", inputRowIndex), rowIndex);
        this.getModel().setValue("output_sellprice", this.getModel().getValue("sellprice", inputRowIndex), rowIndex);
        this.getModel().setValue("output_midprice", this.getModel().getValue("midprice", inputRowIndex), rowIndex);
    }

    private void fillAmount(int outputCount, HashMap<String, Integer> inputSeqMap, DynamicObject defineRow, HashMap<String, Integer> outIndexMap) {
        CalMethodEnum spotEnum = CalMethodEnum.valueOf((String)defineRow.getString("spotmethod"));
        CalMethodEnum forwardEnum = CalMethodEnum.valueOf((String)defineRow.getString("fowardmethod"));
        int allCount = this.getModel().getEntryRowCount("quoteoutput");
        int out2RowIndex = allCount - outputCount + 1;
        String quoteType = defineRow.getString("quotetype");
        boolean isPoint = "point".equals(defineRow.getString("fowardquotation"));
        DynamicObject midCurrency = defineRow.getDynamicObject("midcurrency");
        String midCurrencyNumber = midCurrency != null ? midCurrency.getString("number") : "";
        String term = (String)this.getModel().getValue("output_term", out2RowIndex);
        if (CalMethodEnum.specify == spotEnum) {
            int inputRowIndex = inputSeqMap.get(quoteType + term) - 1;
            this.getModel().setValue("output_buyprice", this.getModel().getValue("buyprice", inputRowIndex), out2RowIndex);
            this.getModel().setValue("output_sellprice", this.getModel().getValue("sellprice", inputRowIndex), out2RowIndex);
            this.getModel().setValue("output_midprice", this.getModel().getValue("midprice", inputRowIndex), out2RowIndex);
        } else if (CalMethodEnum.crossExRate == spotEnum) {
            this.fillCrossAmount(outIndexMap, quoteType.split("/"), midCurrencyNumber, term, out2RowIndex);
        }
        if (spotEnum == CalMethodEnum.specify && forwardEnum == CalMethodEnum.specify || spotEnum == CalMethodEnum.crossExRate && forwardEnum == CalMethodEnum.specify) {
            this.fillByType1(allCount, out2RowIndex, quoteType, inputSeqMap, isPoint);
        } else if (spotEnum == CalMethodEnum.specify && forwardEnum == CalMethodEnum.ycDeduction || spotEnum == CalMethodEnum.crossExRate && forwardEnum == CalMethodEnum.ycDeduction) {
            this.fillByType2(allCount, out2RowIndex, defineRow);
        } else if (spotEnum == CalMethodEnum.specify && forwardEnum == CalMethodEnum.crossExRate) {
            this.fillByType3(allCount, out2RowIndex, quoteType, outIndexMap, midCurrencyNumber);
        } else if (spotEnum == CalMethodEnum.crossExRate && forwardEnum == CalMethodEnum.crossExRate) {
            this.fillByType4(allCount, out2RowIndex, quoteType, outIndexMap, midCurrencyNumber);
        }
    }

    private void fillByType1(int allCount, int out2RowIndex, String quoteType, HashMap<String, Integer> inputSeqMap, boolean isPoint) {
        BigDecimal secBuyPrice = (BigDecimal)this.getModel().getValue("output_buyprice", out2RowIndex);
        BigDecimal secSellPrice = (BigDecimal)this.getModel().getValue("output_sellprice", out2RowIndex);
        BigDecimal secMidPrice = (BigDecimal)this.getModel().getValue("output_midprice", out2RowIndex);
        for (int i = out2RowIndex + 1; i < allCount; ++i) {
            BigDecimal midPrice;
            BigDecimal sellPrice;
            BigDecimal buyPrice;
            String term = (String)this.getModel().getValue("output_term", i);
            int inputRowIndex = inputSeqMap.get(quoteType + term) - 1;
            if (isPoint) {
                buyPrice = secBuyPrice.add(((BigDecimal)this.getModel().getValue("buypoints", inputRowIndex)).divide(Constants.TEN_THOUSAND, 10, 4));
                sellPrice = secSellPrice.add(((BigDecimal)this.getModel().getValue("sellpoints", inputRowIndex)).divide(Constants.TEN_THOUSAND, 10, 4));
                midPrice = secMidPrice.add(((BigDecimal)this.getModel().getValue("midpoints", inputRowIndex)).divide(Constants.TEN_THOUSAND, 10, 4));
            } else {
                buyPrice = (BigDecimal)this.getModel().getValue("buyprice", inputRowIndex);
                sellPrice = (BigDecimal)this.getModel().getValue("sellprice", inputRowIndex);
                midPrice = (BigDecimal)this.getModel().getValue("midprice", inputRowIndex);
            }
            this.getModel().setValue("output_buyprice", (Object)buyPrice, i);
            this.getModel().setValue("output_sellprice", (Object)sellPrice, i);
            this.getModel().setValue("output_midprice", (Object)midPrice, i);
            if (i != out2RowIndex + 1) continue;
            Date date1 = TcDateUtils.truncateDate((Date)((Date)this.getModel().getValue("output_date", i - 2)));
            Date date2 = TcDateUtils.truncateDate((Date)((Date)this.getModel().getValue("output_date", i - 1)));
            Date date3 = TcDateUtils.truncateDate((Date)((Date)this.getModel().getValue("output_date", i)));
            BigDecimal days1 = new BigDecimal(this.getDiffDays(date2, date3));
            BigDecimal days2 = new BigDecimal(this.getDiffDays(date1, date2));
            BigDecimal amount = buyPrice.subtract(secBuyPrice);
            BigDecimal newAmount = secBuyPrice.subtract(amount.divide(days1, 10, 4).multiply(days2));
            this.getModel().setValue("output_buyprice", (Object)newAmount, i - 2);
            amount = sellPrice.subtract(secSellPrice);
            newAmount = secSellPrice.subtract(amount.divide(days1, 10, 4).multiply(days2));
            this.getModel().setValue("output_sellprice", (Object)newAmount, i - 2);
            amount = midPrice.subtract(secMidPrice);
            newAmount = secMidPrice.subtract(amount.divide(days1, 10, 4).multiply(days2));
            this.getModel().setValue("output_midprice", (Object)newAmount, i - 2);
        }
    }

    private void fillByType2(int allCount, int out2RowIndex, DynamicObject defineRow) {
        BigDecimal secBuyPrice = (BigDecimal)this.getModel().getValue("output_buyprice", out2RowIndex);
        BigDecimal secSellPrice = (BigDecimal)this.getModel().getValue("output_sellprice", out2RowIndex);
        BigDecimal secMidPrice = (BigDecimal)this.getModel().getValue("output_midprice", out2RowIndex);
        int defineIndex = defineRow.getInt("seq") - 1;
        Date issuTime = (Date)this.getModel().getValue("issuetime");
        for (int i = out2RowIndex - 1; i < allCount; ++i) {
            if (i == out2RowIndex) continue;
            Date furDate = null;
            BigDecimal buyAmount = BigDecimal.ZERO;
            BigDecimal sellAmount = BigDecimal.ZERO;
            BigDecimal midAmount = BigDecimal.ZERO;
            if (i == out2RowIndex - 1) {
                furDate = (Date)this.getModel().getValue("output_date", out2RowIndex);
                buyAmount = secBuyPrice;
                sellAmount = secSellPrice;
                midAmount = secMidPrice;
            } else if (i > out2RowIndex) {
                furDate = (Date)this.getModel().getValue("output_date", i);
                buyAmount = (BigDecimal)this.getModel().getValue("output_buyprice", out2RowIndex - 1);
                sellAmount = (BigDecimal)this.getModel().getValue("output_sellprice", out2RowIndex - 1);
                midAmount = (BigDecimal)this.getModel().getValue("output_midprice", out2RowIndex - 1);
            }
            DynamicObject lYcObject = (DynamicObject)this.getModel().getValue("lcuryieldcurve", defineIndex);
            DynamicObject rYcObject = (DynamicObject)this.getModel().getValue("rcuryieldcurve", defineIndex);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{lYcObject, rYcObject})) continue;
            BigDecimal lDfi = this.getDfs(lYcObject, issuTime, furDate);
            BigDecimal rDfi = this.getDfs(rYcObject, issuTime, furDate);
            if (i == out2RowIndex - 1) {
                this.getModel().setValue("output_buyprice", (Object)buyAmount.multiply(rDfi).divide(lDfi, 10, 4), i);
                this.getModel().setValue("output_sellprice", (Object)sellAmount.multiply(rDfi).divide(lDfi, 10, 4), i);
                this.getModel().setValue("output_midprice", (Object)midAmount.multiply(rDfi).divide(lDfi, 10, 4), i);
                continue;
            }
            this.getModel().setValue("output_buyprice", (Object)buyAmount.multiply(lDfi).divide(rDfi, 10, 4), i);
            this.getModel().setValue("output_sellprice", (Object)sellAmount.multiply(lDfi).divide(rDfi, 10, 4), i);
            this.getModel().setValue("output_midprice", (Object)midAmount.multiply(lDfi).divide(rDfi, 10, 4), i);
        }
    }

    private void fillByType3(int allCount, int out2RowIndex, String quoteType, HashMap<String, Integer> outIndexMap, String midCurrency) {
        String[] quoteTypeArray = quoteType.split("/");
        for (int i = out2RowIndex - 1; i < allCount; ++i) {
            if (i == out2RowIndex) continue;
            String term = (String)this.getModel().getValue("output_term", i);
            this.fillCrossAmount(outIndexMap, quoteTypeArray, midCurrency, term, i);
        }
    }

    private void fillByType4(int allCount, int out2RowIndex, String quoteType, HashMap<String, Integer> outIndexMap, String midCurrency) {
        for (int i = out2RowIndex - 1; i < allCount; ++i) {
            String term = (String)this.getModel().getValue("output_term", i);
            this.fillCrossAmount(outIndexMap, quoteType.split("/"), midCurrency, term, i);
        }
    }

    private void fillCrossAmount(HashMap<String, Integer> outIndexMap, String[] quoteTypeArray, String midCurrency, String term, int index) {
        Integer c1Key1 = outIndexMap.get(quoteTypeArray[0] + "/" + midCurrency + term);
        Integer c1Key2 = outIndexMap.get(midCurrency + "/" + quoteTypeArray[0] + term);
        Integer c2Key1 = outIndexMap.get(quoteTypeArray[1] + "/" + midCurrency + term);
        Integer c2Key2 = outIndexMap.get(midCurrency + "/" + quoteTypeArray[1] + term);
        int type = -1;
        int c1Index = -1;
        int c2Index = -1;
        if (c1Key1 != null && c2Key2 != null) {
            type = 1;
            c1Index = c1Key1;
            c2Index = c2Key2;
        } else if (c1Key1 != null && c2Key1 != null) {
            type = 2;
            c1Index = c1Key1;
            c2Index = c2Key1;
        } else if (c1Key2 != null && c2Key2 != null) {
            type = 3;
            c1Index = c1Key2;
            c2Index = c2Key2;
        } else if (c1Key2 != null && c2Key1 != null) {
            type = 4;
            c1Index = c1Key2;
            c2Index = c2Key1;
        }
        if (c1Index != -1 && c2Index != -1) {
            BigDecimal midPrice2;
            BigDecimal midPrice1;
            BigDecimal buyPrice2;
            BigDecimal buyPrice1;
            BigDecimal sellPrice2;
            BigDecimal sellPrice1 = (BigDecimal)this.getModel().getValue("output_sellprice", c1Index);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{sellPrice1, sellPrice2 = (BigDecimal)this.getModel().getValue("output_sellprice", c2Index), buyPrice1 = (BigDecimal)this.getModel().getValue("output_buyprice", c1Index), buyPrice2 = (BigDecimal)this.getModel().getValue("output_buyprice", c2Index), midPrice1 = (BigDecimal)this.getModel().getValue("output_midprice", c1Index), midPrice2 = (BigDecimal)this.getModel().getValue("output_midprice", c2Index)})) {
                this.getModel().setValue("output_buyprice", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("output_sellprice", (Object)BigDecimal.ZERO, index);
                this.getModel().setValue("output_midprice", (Object)BigDecimal.ZERO, index);
                return;
            }
            switch (type) {
                case 1: {
                    this.getModel().setValue("output_buyprice", (Object)buyPrice1.multiply(buyPrice2), index);
                    this.getModel().setValue("output_sellprice", (Object)sellPrice1.multiply(sellPrice2), index);
                    this.getModel().setValue("output_midprice", (Object)midPrice1.multiply(midPrice2), index);
                    break;
                }
                case 2: {
                    this.getModel().setValue("output_buyprice", (Object)buyPrice1.divide(sellPrice2, 10, 4), index);
                    this.getModel().setValue("output_sellprice", (Object)sellPrice1.divide(buyPrice2, 10, 4), index);
                    this.getModel().setValue("output_midprice", (Object)midPrice1.divide(midPrice2, 10, 4), index);
                    break;
                }
                case 3: {
                    this.getModel().setValue("output_buyprice", (Object)buyPrice2.divide(sellPrice1, 10, 4), index);
                    this.getModel().setValue("output_sellprice", (Object)sellPrice2.divide(buyPrice1, 10, 4), index);
                    this.getModel().setValue("output_midprice", (Object)midPrice2.divide(midPrice1, 10, 4), index);
                    break;
                }
                case 4: {
                    this.getModel().setValue("output_buyprice", (Object)BigDecimal.ONE.divide(sellPrice1, 10, 4).divide(sellPrice2, 10, 4), index);
                    this.getModel().setValue("output_sellprice", (Object)BigDecimal.ONE.divide(buyPrice1, 10, 4).divide(buyPrice2, 10, 4), index);
                    this.getModel().setValue("output_midprice", (Object)BigDecimal.ONE.divide(midPrice1, 10, 4).divide(midPrice2, 10, 4), index);
                }
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"%s\u4ea4\u53c9\u6c47\u7387\u8ba1\u7b97\u51fa\u9519\uff01\u8fdc\u671f\u6c47\u7387\u65e5\u671f\u8f74\u5fc5\u987b\u4e0e\u4e2d\u95f4\u5e01\u79cd\u5bf9\u5e94\u7684\u8fdc\u671f\u6c47\u7387\u65e5\u671f\u8f74\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ForexQuoteOutAndViewPlugin_4", (String)"tmc-md-formplugin", (Object[])new Object[]{this.getModel().getValue("output_quotetype", index)}));
        }
    }

    private BigDecimal getDfs(DynamicObject ycObject, Date referDate, Date furDate) {
        DynamicObject yieldInfo = this.loadMdYieldLineFromCache(ycObject.getPkValue(), "md_yieldline");
        Object[] object = this.getDateListFormCache(yieldInfo, referDate);
        List dateList = (List)object[0];
        Map result = (Map)object[1];
        BigDecimal df = YieldCurveHelper.zero_getDfByDate((DynamicObject)ycObject, (Date)((Date)dateList.get(0)), (Date)((Date)dateList.get(dateList.size() - 1)), (Date)TcDateUtils.truncateDate((Date)referDate), (Date)TcDateUtils.truncateDate((Date)furDate), (List)dateList, (Map)result);
        return df;
    }

    private Object[] getDateList(DynamicObject yield, Date referdate) {
        DynamicObjectCollection workcalendar = yield.getDynamicObjectCollection("workcalendar");
        DynamicObjectCollection fintoolEntry = yield.getDynamicObjectCollection("fintoolentry");
        DynamicObject[] wc = (DynamicObject[])workcalendar.toArray((Object[])new DynamicObject[workcalendar.size()]);
        Object[] Item = new Object[3];
        ArrayList dateList = new ArrayList(fintoolEntry.size());
        HashMap result = new HashMap(fintoolEntry.size());
        YieldCurveHelper.fillAllDFByFintool((DynamicObject)yield, (Date)TcDateUtils.truncateDate((Date)referdate), dateList, result);
        Item[0] = dateList;
        Item[1] = result;
        Item[2] = wc;
        return Item;
    }

    private Object[] getDateListFormCache(DynamicObject yieldInfo, Date referDate) {
        String key = yieldInfo.getString("id") + referDate.getTime();
        if (this.dateListCache.containsKey(key)) {
            return this.dateListCache.get(key);
        }
        Object[] object = this.getDateList(yieldInfo, referDate);
        this.dateListCache.put(key, object);
        return object;
    }

    private DynamicObject loadMdYieldLineFromCache(Object pkValue, String entityName) {
        if (this.mdYieldLineCache.containsKey(pkValue)) {
            return this.mdYieldLineCache.get(pkValue);
        }
        DynamicObject o = TmcDataServiceHelper.loadSingle((Object)pkValue, (String)entityName);
        this.mdYieldLineCache.put(pkValue, o);
        return o;
    }

    private Date calDate(int index, String term, DynamicObject defineRow, Date spotDate) {
        DynamicObjectCollection workCalendar = defineRow.getDynamicObjectCollection("workcalendar");
        Date issueTime = (Date)this.getModel().getValue("issuetime");
        if (index == 0) {
            return issueTime;
        }
        if (index == 1) {
            int spotDelay = defineRow.get("spotdelay") == null ? 0 : defineRow.getInt("spotdelay");
            TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workCalendar, (Date)issueTime, (int)spotDelay);
            return TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workCalendar, (Date)issueTime, (int)spotDelay);
        }
        Date date = TermUtils.getDateByTerm((String)term, (Date)(spotDate == null ? issueTime : spotDate));
        String adjMethod = defineRow.getString("dateadjustmethod");
        adjMethod = StringUtils.isBlank((CharSequence)adjMethod) ? "forward" : adjMethod;
        return TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)workCalendar, (Date)date, (AdjustMethodEnum)AdjustMethodEnum.getEnumByValue((String)adjMethod));
    }

    private String calTerm(int index, DynamicObjectCollection axisPoints) {
        if (index == 0) {
            return "Today";
        }
        if (index == 1) {
            return "Spot";
        }
        return ((DynamicObject)axisPoints.get(index - 2)).getString("point");
    }

    private void genViewEntry(boolean showTip) {
        this.validateDateAxis();
        long start = System.currentTimeMillis();
        this.getModel().deleteEntryData("quoteview");
        DynamicObject viewDateAxis = (DynamicObject)this.getModel().getValue("view_dateaxis");
        DynamicObjectCollection definePageList = this.getModel().getEntryEntity("define");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{viewDateAxis, definePageList})) {
            Date tempSpotDate = null;
            DynamicObjectCollection axisPoints = viewDateAxis.getDynamicObjectCollection("entrys");
            for (DynamicObject defineRow : definePageList) {
                String quoteType;
                if (CalMethodEnum.none.getValue().equals(defineRow.getString("fowardmethod")) || EmptyUtil.isEmpty((String)(quoteType = defineRow.getString("quotetype")))) continue;
                if (DateRuleEnum.specify.getValue().equals(defineRow.getString("daterule"))) {
                    this.copyOutputToView(quoteType);
                    continue;
                }
                for (int i = 0; i < axisPoints.size() + 2; ++i) {
                    int rowIndex = this.getModel().createNewEntryRow("quoteview");
                    this.getModel().setValue("view_quotetype", (Object)quoteType, rowIndex);
                    String term = this.calTerm(i, axisPoints);
                    this.getModel().setValue("view_term", (Object)term, rowIndex);
                    Date tempViewDate = this.calDate(i, term, defineRow, tempSpotDate);
                    if (i == 1) {
                        tempSpotDate = tempViewDate;
                    }
                    this.getModel().setValue("view_date", (Object)tempViewDate, rowIndex);
                }
                this.calViewAmount(quoteType, axisPoints.size() + 2);
            }
        }
        this.removeReduplicatedRowsForPage("quoteview", showTip);
        this.setScaleForViewPageList();
        long end = System.currentTimeMillis();
        logger.info("genViewEntry time expend [" + (end - start) + "ms]");
    }

    private void setScaleForOutputPageList() {
        DynamicObjectCollection defineEntity = this.getModel().getEntryEntity("define");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : defineEntity) {
            map.put(dynamicObject.getString("quotetype"), dynamicObject.get("rateaccuracy") == null ? 0 : dynamicObject.getInt("rateaccuracy"));
        }
        for (int index = 0; index < this.getModel().getEntryRowCount("quoteoutput"); ++index) {
            if (map.get(this.getModel().getEntryRowEntity("quoteoutput", index).getString("output_quotetype")) == null) continue;
            int scale = (Integer)map.get(this.getModel().getEntryRowEntity("quoteoutput", index).getString("output_quotetype"));
            BigDecimal v = this.getModel().getEntryRowEntity("quoteoutput", index).getBigDecimal("output_buyprice");
            if (v == null) continue;
            this.getModel().setValue("output_buyprice", (Object)v.setScale(scale, 4), index);
            v = this.getModel().getEntryRowEntity("quoteoutput", index).getBigDecimal("output_sellprice");
            if (v == null) continue;
            this.getModel().setValue("output_sellprice", (Object)v.setScale(scale, 4), index);
            v = this.getModel().getEntryRowEntity("quoteoutput", index).getBigDecimal("output_midprice");
            if (v == null) continue;
            this.getModel().setValue("output_midprice", (Object)v.setScale(scale, 4), index);
        }
    }

    private void setScaleForViewPageList() {
        DynamicObjectCollection defineEntity = this.getModel().getEntryEntity("define");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (DynamicObject dynamicObject : defineEntity) {
            map.put(dynamicObject.getString("quotetype"), dynamicObject.get("rateaccuracy") == null ? 0 : dynamicObject.getInt("rateaccuracy"));
        }
        for (int index = 0; index < this.getModel().getEntryRowCount("quoteview"); ++index) {
            if (map.get(this.getModel().getEntryRowEntity("quoteview", index).getString("view_quotetype")) == null) continue;
            int scale = (Integer)map.get(this.getModel().getEntryRowEntity("quoteview", index).getString("view_quotetype"));
            BigDecimal v = this.getModel().getEntryRowEntity("quoteview", index).getBigDecimal("view_buyprice");
            if (v == null) continue;
            this.getModel().setValue("view_buyprice", (Object)v.setScale(scale, 4), index);
            v = this.getModel().getEntryRowEntity("quoteview", index).getBigDecimal("view_sellprice");
            if (v == null) continue;
            this.getModel().setValue("view_sellprice", (Object)v.setScale(scale, 4), index);
            v = this.getModel().getEntryRowEntity("quoteview", index).getBigDecimal("view_midprice");
            if (v == null) continue;
            this.getModel().setValue("view_midprice", (Object)v.setScale(scale, 4), index);
        }
        this.getView().updateView("quoteview");
    }

    private void removeReduplicatedRowsForPage(String pageKey, boolean showTip) {
        String quoteTypeKey;
        String dateKey;
        String termKey;
        int count = this.getModel().getEntryRowCount(pageKey);
        if (count == 0) {
            return;
        }
        if ("quoteview".equals(pageKey)) {
            termKey = "view_term";
            dateKey = "view_date";
            quoteTypeKey = "view_quotetype";
        } else if ("quoteoutput".equals(pageKey)) {
            termKey = "output_term";
            dateKey = "output_date";
            quoteTypeKey = "output_quotetype";
        } else {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Map> filterData = new HashMap<String, Map>();
        ArrayList<Integer> deleteIndexList = new ArrayList<Integer>();
        Date currentDate = TcDateUtils.getCurrentDate();
        for (int index = 0; index < count; ++index) {
            Date date;
            String term = (String)this.getModel().getEntryRowEntity(pageKey, index).get(termKey);
            if ("Spot".equals(term) || "Today".equals(term) || (date = (Date)this.getModel().getEntryRowEntity(pageKey, index).get(dateKey)) == null) continue;
            String quoteType = (String)this.getModel().getEntryRowEntity(pageKey, index).get(quoteTypeKey);
            filterData.computeIfAbsent(quoteType, k -> new HashMap());
            Map filterMap = (Map)filterData.get(quoteType);
            String dateStr = dateFormat.format(date);
            if (!filterMap.containsKey(dateStr)) {
                filterMap.put(dateStr, term + "," + index);
                continue;
            }
            String[] tempArray = ((String)filterMap.get(dateStr)).split(",");
            String tempTerm = tempArray[0];
            if (TermUtils.getDateByTerm((String)tempTerm, (Date)currentDate).compareTo(TermUtils.getDateByTerm((String)term, (Date)currentDate)) < 0) {
                deleteIndexList.add(Integer.valueOf(tempArray[1]));
                filterMap.put(dateStr, term + "," + index);
                continue;
            }
            deleteIndexList.add(index);
        }
        if (!deleteIndexList.isEmpty()) {
            this.getModel().deleteEntryRows(pageKey, deleteIndexList.stream().mapToInt(i -> i).toArray());
            if (showTip) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u65e5\u671f\u7684\u6570\u636e\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u4fdd\u7559\u671f\u9650\u6700\u5927\u7684\u6570\u636e\u3002", (String)"ForexQuoteOutAndViewPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
        }
    }

    private void calViewAmount(String quoteType, int singleViewCount) {
        int allViewCount = this.getModel().getEntryRowCount("quoteview");
        int startIndex = allViewCount - singleViewCount;
        if (!this.existOutPutDataForQuoteType(quoteType)) {
            return;
        }
        for (int i = startIndex; i < allViewCount; ++i) {
            if (i < startIndex + 2) {
                DynamicObject todayOrSpotRow = this.getRowByQuoteTypeAndTerm(quoteType, i == startIndex ? "Today" : "Spot");
                if (todayOrSpotRow == null) continue;
                this.getModel().setValue("view_buyprice", todayOrSpotRow.get("output_buyprice"), i);
                this.getModel().setValue("view_sellprice", todayOrSpotRow.get("output_sellprice"), i);
                this.getModel().setValue("view_midprice", todayOrSpotRow.get("output_midprice"), i);
                continue;
            }
            Date Dm = (Date)this.getModel().getValue("view_date", i);
            this.generateViewPrice(quoteType, i, Dm, null, null);
        }
    }

    private boolean existOutPutDataForQuoteType(String quoteType) {
        DynamicObjectCollection quoteOutputPageList = this.getModel().getEntryEntity("quoteoutput");
        for (DynamicObject dynamicObject : quoteOutputPageList) {
            if (!quoteType.equals(dynamicObject.getString("output_quotetype"))) continue;
            return true;
        }
        return false;
    }

    private void generateViewPrice(String quoteType, int i, Date dm, DynamicObject row, Map<String, Integer> accuracyMap) {
        DynamicObjectCollection sortedListForOutputPage = this.getSortedOutEntry(quoteType);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)sortedListForOutputPage)) {
            return;
        }
        Date firstDate = ((DynamicObject)sortedListForOutputPage.get(0)).getDate("output_date");
        Date endDate = ((DynamicObject)sortedListForOutputPage.get(sortedListForOutputPage.size() - 1)).getDate("output_date");
        DynamicObject F1ROW = null;
        DynamicObject F2ROW = null;
        if (this.getDiffDays(firstDate, dm) > 0 && this.getDiffDays(endDate, dm) <= 0) {
            for (int j = 0; j < sortedListForOutputPage.size() - 1; ++j) {
                if (this.getDiffDays(((DynamicObject)sortedListForOutputPage.get(j)).getDate("output_date"), dm) < 0 || this.getDiffDays(((DynamicObject)sortedListForOutputPage.get(j + 1)).getDate("output_date"), dm) > 0) continue;
                F1ROW = (DynamicObject)sortedListForOutputPage.get(j);
                F2ROW = (DynamicObject)sortedListForOutputPage.get(j + 1);
                break;
            }
        } else if (this.getDiffDays(firstDate, dm) <= 0) {
            F1ROW = (DynamicObject)sortedListForOutputPage.get(0);
            F2ROW = null;
        } else {
            F1ROW = null;
            F2ROW = (DynamicObject)sortedListForOutputPage.get(sortedListForOutputPage.size() - 1);
        }
        if (F1ROW != null && F2ROW != null) {
            Date D1 = F1ROW.getDate("output_date");
            Date D2 = F2ROW.getDate("output_date");
            BigDecimal F1 = F1ROW.getBigDecimal("output_buyprice");
            BigDecimal F2 = F2ROW.getBigDecimal("output_buyprice");
            BigDecimal buyPrice = this.calAmount(F1, F2, D1, D2, dm);
            F1 = F1ROW.getBigDecimal("output_sellprice");
            F2 = F2ROW.getBigDecimal("output_sellprice");
            BigDecimal sellPrice = this.calAmount(F1, F2, D1, D2, dm);
            F1 = F1ROW.getBigDecimal("output_midprice");
            F2 = F2ROW.getBigDecimal("output_midprice");
            BigDecimal midPrice = this.calAmount(F1, F2, D1, D2, dm);
            if (row == null) {
                this.getModel().setValue("view_buyprice", (Object)buyPrice, i);
                this.getModel().setValue("view_sellprice", (Object)sellPrice, i);
                this.getModel().setValue("view_midprice", (Object)midPrice, i);
            } else {
                row.set("view_buyprice", (Object)buyPrice.setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_sellprice", (Object)sellPrice.setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_midprice", (Object)midPrice.setScale((int)accuracyMap.get(quoteType), 4));
            }
        } else if (F1ROW != null) {
            if (row == null) {
                this.getModel().setValue("view_buyprice", F1ROW.get("output_buyprice"), i);
                this.getModel().setValue("view_sellprice", F1ROW.get("output_sellprice"), i);
                this.getModel().setValue("view_midprice", F1ROW.get("output_midprice"), i);
            } else {
                row.set("view_buyprice", (Object)((BigDecimal)F1ROW.get("output_buyprice")).setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_sellprice", (Object)((BigDecimal)F1ROW.get("output_sellprice")).setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_midprice", (Object)((BigDecimal)F1ROW.get("output_midprice")).setScale((int)accuracyMap.get(quoteType), 4));
            }
        } else if (F2ROW != null) {
            if (row == null) {
                this.getModel().setValue("view_buyprice", F2ROW.get("output_buyprice"), i);
                this.getModel().setValue("view_sellprice", F2ROW.get("output_sellprice"), i);
                this.getModel().setValue("view_midprice", F2ROW.get("output_midprice"), i);
            } else {
                row.set("view_buyprice", (Object)((BigDecimal)F2ROW.get("output_buyprice")).setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_sellprice", (Object)((BigDecimal)F2ROW.get("output_sellprice")).setScale((int)accuracyMap.get(quoteType), 4));
                row.set("view_midprice", (Object)((BigDecimal)F2ROW.get("output_midprice")).setScale((int)accuracyMap.get(quoteType), 4));
            }
        }
    }

    private DynamicObject getRowByQuoteTypeAndTerm(String quoteType, String term) {
        for (int i = 0; i < this.getModel().getEntryRowCount("quoteoutput"); ++i) {
            if (!quoteType.equals(this.getModel().getEntryRowEntity("quoteoutput", i).get("output_quotetype")) || !term.equals(this.getModel().getEntryRowEntity("quoteoutput", i).get("output_term"))) continue;
            return this.getModel().getEntryRowEntity("quoteoutput", i);
        }
        logger.warn("quoteType " + quoteType + ",term " + term + " \u6ca1\u6709\u627e\u5230\u6307\u5b9a\u62a5\u4ef7\u8f93\u51fa\u884c\uff01");
        return null;
    }

    private BigDecimal calAmount(BigDecimal F1, BigDecimal F2, Date D1, Date D2, Date Dm) {
        BigDecimal param1 = F2.subtract(F1);
        BigDecimal param2 = new BigDecimal(this.getDiffDays(D1, Dm));
        BigDecimal param3 = new BigDecimal(this.getDiffDays(D1, D2));
        return F1.add(param1.multiply(param2).divide(param3, 10, 4));
    }

    private DynamicObjectCollection getSortedOutEntry(String quoteType) {
        DynamicObjectCollection quoteOutputPageList = this.getModel().getEntryEntity("quoteoutput");
        DynamicObjectCollection copyList = (DynamicObjectCollection)quoteOutputPageList.clone();
        copyList.removeIf(DynamicObject2 -> !quoteType.equals(DynamicObject2.getString("output_quotetype")));
        copyList.sort((row1, row2) -> {
            Date date2;
            Date date1 = row1.getDate("output_date");
            if (TcDateUtils.isSameDay((Date)date1, (Date)(date2 = row2.getDate("output_date")))) {
                return 0;
            }
            return date1.after(date2) ? 1 : -1;
        });
        return copyList;
    }

    private int getDiffDays(Date d1, Date d2) {
        return TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)d1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)d2, (boolean)true));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (BillOperationStatus.AUDIT == ((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus()) {
            e.setCheckDataChange(false);
        }
    }
}

