/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.home;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;

public class AppHomeYieldChartPlugin
extends AbstractLineChartEdit {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.drawChart();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        switch (key = args.getProperty().getName()) {
            case "yieldcurve": {
                super.drawChart();
            }
        }
    }

    protected String getXTitleName() {
        return ResManager.loadKDString((String)"\u65e5\u671f", (String)"AppHomeYieldChartPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]);
    }

    protected String getYTitleName() {
        return ResManager.loadKDString((String)"\u96f6\u606f\u5229\u7387(%)", (String)"AppHomeYieldChartPlugin_1", (String)"tmc-md-formplugin", (Object[])new Object[0]);
    }

    protected String[] getXValue() {
        List<Date> xDateList = this.getXDateList();
        String[] xValue = new String[xDateList.size()];
        for (int i = 0; i < xDateList.size(); ++i) {
            xValue[i] = TcDateUtils.formatString((Date)xDateList.get(i), (String)"yyyy-MM-dd");
        }
        return xValue;
    }

    protected String getChartCtlName() {
        return "pointlinechartap";
    }

    protected List<Object> getSeriesValue() {
        ArrayList<Object> allLine = new ArrayList<Object>(1);
        DynamicObject yieldcurve = this.initYieldCurve();
        if (EmptyUtil.isNoEmpty((DynamicObject)yieldcurve)) {
            Date referdate = TcDateUtils.getCurrentDate();
            DynamicObjectCollection entry_struct = yieldcurve.getDynamicObjectCollection("structentry");
            ArrayList dateList = new ArrayList(entry_struct.size());
            HashMap result = new HashMap(entry_struct.size());
            List<Date> xDateList = this.getXDateList();
            List yList = YieldCurveHelper.chart_getY(xDateList, (DynamicObject)yieldcurve, (Date)referdate, dateList, result);
            allLine.add(yList);
        }
        return allLine;
    }

    private DynamicObjectCollection getStructEntry(DynamicObject yieldcurve) {
        Date referdate = TcDateUtils.getCurrentDate();
        DynamicObjectCollection fintoolEntry = yieldcurve.getDynamicObjectCollection("fintoolentry");
        ArrayList dateList = new ArrayList(fintoolEntry.size());
        HashMap result = new HashMap(fintoolEntry.size());
        YieldCurveHelper.fillAllDFByFintool((DynamicObject)yieldcurve, (Date)referdate, dateList, result);
        DynamicObjectCollection entry_struct = yieldcurve.getDynamicObjectCollection("structentry");
        for (Date date : dateList) {
            DynamicObject entry = entry_struct.addNew();
            entry.set("date_struct", (Object)date);
            entry.set("implieddf_struct", result.get(date));
            BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate((DynamicObject)yieldcurve, (Date)referdate, (Date)date, (BigDecimal)((BigDecimal)result.get(date)));
            entry.set("zerorate_struct", (Object)zeroRate);
        }
        return entry_struct;
    }

    private DynamicObject initYieldCurve() {
        DynamicObject yieldcurve = (DynamicObject)this.getModel().getValue("yieldcurve");
        if (EmptyUtil.isNoEmpty((DynamicObject)yieldcurve)) {
            yieldcurve = TmcDataServiceHelper.loadSingle((Object)yieldcurve.getLong("id"), (String)"md_yieldline");
            this.getStructEntry(yieldcurve);
        }
        return yieldcurve;
    }

    public List<Date> getXDateList() {
        DynamicObject yieldcurve = this.initYieldCurve();
        if (EmptyUtil.isNoEmpty((DynamicObject)yieldcurve)) {
            Date referdate = TcDateUtils.getCurrentDate();
            DynamicObjectCollection fintoolentry = yieldcurve.getDynamicObjectCollection("fintoolentry");
            Date maxdate = referdate;
            for (int i = 0; i < fintoolentry.size(); ++i) {
                Date temp;
                String term = ((DynamicObject)fintoolentry.get(i)).getString("term_fin");
                if (!((DynamicObject)fintoolentry.get(i)).getBoolean("isforcurve_fin") || !(temp = TermUtils.getDateByTerm((String)term, (Date)referdate)).after(maxdate)) continue;
                maxdate = temp;
            }
            String betweenTerm = "1d";
            if (maxdate.after(TermUtils.getDateByTerm((String)"2y", (Date)referdate))) {
                betweenTerm = "1m";
            }
            Date enddate = TermUtils.getDateByTerm((String)"1y", (Date)maxdate);
            ArrayList<Date> xList = new ArrayList<Date>(fintoolentry.size());
            Date point = referdate;
            point = TermUtils.getDateByTerm((String)betweenTerm, (Date)point);
            while (point.before(enddate)) {
                xList.add(point);
                point = TermUtils.getDateByTerm((String)betweenTerm, (Date)point);
            }
            xList.add(enddate);
            return xList;
        }
        return new ArrayList<Date>();
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        chart.setMargin(Position.left, "20px");
        chart.setMargin(Position.right, "40px");
        chart.setMargin(Position.top, "30px");
        LineSeries line = (LineSeries)series;
        line.setItemColor("#9F69E2");
    }
}

