/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.ratedericative;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;
import kd.tmc.md.common.enums.RateDericTypeEnum;

public class RateDericDataTreeList
extends AbstractTmcTreeList {
    private static final TmcTreeNodeTypeProp NODE_FIRST = new TmcTreeNodeTypeProp("referrate", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_SECOND = new TmcTreeNodeTypeProp("type", NODE_FIRST, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_THIRD = new TmcTreeNodeTypeProp("third", NODE_SECOND, TmcTreeNodeTypeProp.LeafMode.LEAF);
    private static final String ADDTREE_ACTIONID = "ADDTREE_ACTIONID";
    private static final String EDITTREE_ACTIONID = "EDITTREE_ACTIONID";
    private static final String CONFIRM_BTNDEL = "CONFIRM_BTNDEL";

    public void createTreeListView(CreateTreeListViewEvent e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_FIRST, NODE_SECOND, NODE_THIRD);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        List<Object> nodeList = new ArrayList();
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (nodeType.equals((Object)TmcTreeNodeTypeProp.ROOT)) {
            nodeList = this.loadFirstNodeList();
        } else if (nodeType.equals((Object)NODE_FIRST)) {
            nodeList = this.loadSecondNodeList(currNode);
        } else if (nodeType.equals((Object)NODE_SECOND)) {
            nodeList = this.loadThirdNodeList(currNode);
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        Object qfilter = NODE_FIRST.equals((Object)nodeType) ? new QFilter("ratedericative.referrate.id", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())) : (NODE_SECOND.equals((Object)nodeType) ? new QFilter("ratedericative.type", "=", (Object)currNode.getRefEntityPkValue().toString()).and("ratedericative.referrate.id", "=", (Object)Long.valueOf(currNode.getParentRefEntityPkValue(NODE_FIRST).toString())) : (NODE_THIRD.equals((Object)nodeType) ? new QFilter("ratedericative.id", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())) : null));
        return qfilter;
    }

    public void treeToolbarClick(EventObject e) {
        String btnKey;
        Control ctl = (Control)e.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnnew": {
                this.addGoodsDataTree();
                break;
            }
            case "btnedit": {
                this.editGoodsRateTree();
                break;
            }
            case "btndel": {
                TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
                if (nodeType == TmcTreeNodeTypeProp.ROOT) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"ReferRateTreeList_2", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (nodeType == NODE_FIRST || nodeType == NODE_SECOND) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ReferRateTreeList_3", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    break;
                }
                Long dericativeId = Long.valueOf(this.getCurrentNodeModel().getRefEntityPkValue().toString());
                DynamicObject goods = BusinessDataServiceHelper.loadSingleFromCache((Object)dericativeId, (String)"tbd_ratederivative");
                if (goods.getString("enable").equals("1")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u5229\u7387\u884d\u751f\u54c1\u5b9a\u4e49\u5df2\u7ecf\u542f\u7528\uff0c\u662f\u5426\u7981\u7528\u540c\u65f6\u5220\u9664\uff1f", (String)"RateDericDataTreeList_0", (String)"tmc-md-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_BTNDEL));
                    break;
                }
                this.delGoodsTree();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals(ADDTREE_ACTIONID) || evt.getActionId().equals(EDITTREE_ACTIONID)) {
            this.refreshTree();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)event.getCallBackId(), (CharSequence)CONFIRM_BTNDEL) && event.getResult() == MessageBoxResult.Yes) {
            this.delGoodsTree();
        }
    }

    private void addGoodsDataTree() {
        FormShowParameter showParam = new FormShowParameter();
        showParam.setFormId("tbd_ratederivative_batch");
        this.initShowParam(showParam);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDTREE_ACTIONID));
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParam);
    }

    private void editGoodsRateTree() {
        TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
        if (nodeType == TmcTreeNodeTypeProp.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"MarketDataTreeList_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
        } else if (nodeType == NODE_FIRST || nodeType == NODE_SECOND) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"MarketDataTreeList_1", (String)"tmc-md-formplugin", (Object[])new Object[0]));
        } else {
            Object dericativeId = this.getCurrentNodeModel().getRefEntityPkValue();
            BaseShowParameter showParam = new BaseShowParameter();
            showParam.setStatusValue(OperationStatus.EDIT.getValue());
            showParam.setFormId("tbd_ratederivative");
            showParam.setPkId(dericativeId);
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITTREE_ACTIONID));
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    private void delGoodsTree() {
        Long dericativeId = Long.valueOf(this.getCurrentNodeModel().getRefEntityPkValue().toString());
        boolean exists = TmcDataServiceHelper.exists((String)"md_dataratederic", (QFilter[])new QFilter[]{new QFilter("ratedericative", "=", (Object)dericativeId)});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5229\u7387\u884d\u751f\u54c1\u5b9a\u4e49\u4e0b\u6e38\u5df2\u5b58\u5728\u5229\u7387\u884d\u751f\u54c1\u4ef7\u683c\u6570\u636e\uff0c\u5220\u9664\u5931\u8d25\u3002", (String)"RateDericDataTreeList_1", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject dericative = BusinessDataServiceHelper.loadSingle((Object)dericativeId, (String)"tbd_ratederivative");
        dericative.set("enable", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dericative});
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"tbd_ratederivative", (Object[])new Object[]{dericativeId}, (OperateOption)OperateOption.create());
        if (result != null && result.isSuccess()) {
            this.refreshTree();
        }
    }

    private void initShowParam(FormShowParameter showParam) {
        String nodeId = this.getCurrentNodeModel().getNodeId();
        List<TmcTreeNodeTypeProp> parentNode = Arrays.asList(NODE_FIRST, NODE_SECOND);
        for (TmcTreeNodeTypeProp typeProp : parentNode) {
            int pTypeIndex;
            String pTypeName = typeProp.getName() + '#';
            boolean containParent = nodeId.contains(pTypeName);
            if (!containParent || (pTypeIndex = nodeId.lastIndexOf(pTypeName)) == -1) continue;
            String substring = nodeId.substring(pTypeIndex);
            int endIndex = substring.contains(String.valueOf('/')) ? substring.indexOf(47) : substring.length();
            showParam.getCustomParams().put(typeProp.getName(), substring.substring(pTypeName.length(), endIndex));
        }
    }

    private List<TmcTreeNodeRefProp> loadFirstNodeList() {
        DynamicObject[] derivatives = TmcDataServiceHelper.load((String)"tbd_ratederivative", (String)"referrate", null);
        Set referrates = Arrays.stream(derivatives).map(v -> v.getDynamicObject("referrate")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(referrates.size());
        for (DynamicObject referrate : referrates) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(referrate.getString("number"));
            node.setNodeType(NODE_FIRST);
            node.setRefEntityPkValue((Object)referrate.getLong("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadSecondNodeList(TmcTreeNodeProp currNode) {
        DynamicObjectCollection derivatives = QueryServiceHelper.query((String)"tbd_ratederivative", (String)"type", (QFilter[])new QFilter[]{new QFilter("referrate", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString()))});
        Set types = derivatives.stream().map(v -> v.getString("type")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(types.size());
        for (String type : types) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            switch (type) {
                case "forward": {
                    node.setNodeName(RateDericTypeEnum.getName((String)"forward"));
                    break;
                }
                case "futures": {
                    node.setNodeName(RateDericTypeEnum.getName((String)"futures"));
                    break;
                }
                case "swap": {
                    node.setNodeName(RateDericTypeEnum.getName((String)"swap"));
                }
            }
            node.setNodeType(NODE_SECOND);
            node.setRefEntityPkValue((Object)type);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadThirdNodeList(TmcTreeNodeProp currNode) {
        String type = currNode.getRefEntityPkValue().toString();
        DynamicObjectCollection derivatives = QueryServiceHelper.query((String)"tbd_ratederivative", (String)"id,type,term,fra,contract", (QFilter[])new QFilter[]{new QFilter("referrate", "=", (Object)Long.valueOf(currNode.getParentRefEntityPkValue(NODE_FIRST).toString())), new QFilter("type", "=", (Object)type)});
        Set thirds = derivatives.stream().map(v -> {
            if (type.equals("forward")) {
                return v.getString("fra");
            }
            if (type.equals("futures")) {
                return v.getString("contract");
            }
            return RateTermEnum.getName((String)v.getString("term")).toUpperCase();
        }).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(derivatives.size());
        List dericativeIds = null;
        for (String third : thirds) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(third);
            node.setNodeType(NODE_THIRD);
            switch (type) {
                case "forward": {
                    dericativeIds = derivatives.stream().filter(f -> f.getString("fra").equals(third)).map(m -> m.getLong("id")).collect(Collectors.toList());
                    break;
                }
                case "futures": {
                    dericativeIds = derivatives.stream().filter(f -> f.getString("contract").equals(third)).map(m -> m.getLong("id")).collect(Collectors.toList());
                    break;
                }
                case "swap": {
                    dericativeIds = derivatives.stream().filter(f -> f.getString("term").equals(RateTermEnum.getValue((String)third.toLowerCase()))).map(m -> m.getLong("id")).collect(Collectors.toList());
                }
            }
            if (dericativeIds != null) {
                node.setRefEntityPkValue(dericativeIds.get(0));
            }
            nodeList.add(node);
        }
        return nodeList;
    }

    private void refreshTree() {
        this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        this.getCurrentNode().setChildren(null);
        this.getTreeListView().refreshTreeView();
    }
}

