/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.referdata.referindex;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.property.TmcTreeNodeProp;
import kd.tmc.fbp.common.property.TmcTreeNodeRefProp;
import kd.tmc.fbp.common.property.TmcTreeNodeTypeProp;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.tree.AbstractTmcTreeList;
import kd.tmc.md.common.enums.IndexTypeEnum;

public class ReferIndexTreeList
extends AbstractTmcTreeList {
    private static final TmcTreeNodeTypeProp NODE_INDEXTYPE = new TmcTreeNodeTypeProp("type", TmcTreeNodeTypeProp.ROOT, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_INDEXCURRENCY = new TmcTreeNodeTypeProp("currency", NODE_INDEXTYPE, TmcTreeNodeTypeProp.LeafMode.NON_LEAF);
    private static final TmcTreeNodeTypeProp NODE_INDEXNUMBER = new TmcTreeNodeTypeProp("number", NODE_INDEXCURRENCY, TmcTreeNodeTypeProp.LeafMode.LEAF);
    private static final String ADDTREE_ACTIONID = "ADDTREE_ACTIONID";
    private static final String EDITTREE_ACTIONID = "EDITTREE_ACTIONID";
    private static final String CONFIRM_BTNDEL = "CONFIRM_BTNDEL";

    public void createTreeListView(CreateTreeListViewEvent e) {
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap11"});
    }

    protected List<TmcTreeNodeTypeProp> getTreeNodeTypeList() {
        return Arrays.asList(NODE_INDEXTYPE, NODE_INDEXCURRENCY, NODE_INDEXNUMBER);
    }

    protected List<TmcTreeNodeRefProp> loadTreeNodeList(TmcTreeNodeProp currNode) {
        List<Object> nodeList = new ArrayList();
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        if (nodeType.equals((Object)TmcTreeNodeTypeProp.ROOT)) {
            nodeList = this.loadTypeNodeList();
        } else if (nodeType.equals((Object)NODE_INDEXTYPE)) {
            nodeList = this.loadCurrencyNodeList(currNode);
        } else if (nodeType.equals((Object)NODE_INDEXCURRENCY)) {
            nodeList = this.loadNumberNodeList(currNode);
        }
        return nodeList;
    }

    protected QFilter getBillListFilter(TmcTreeNodeProp currNode) {
        TmcTreeNodeTypeProp nodeType = currNode.getNodeType();
        Object qfilter = NODE_INDEXTYPE.equals((Object)nodeType) ? new QFilter("referindex.type", "=", (Object)currNode.getRefEntityPkValue().toString()) : (NODE_INDEXCURRENCY.equals((Object)nodeType) ? new QFilter("referindex.currency.id", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())).and("referindex.type", "=", (Object)currNode.getParentRefEntityPkValue(NODE_INDEXTYPE).toString()) : (NODE_INDEXNUMBER.equals((Object)nodeType) ? new QFilter("referindex", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString())) : null));
        return qfilter;
    }

    public void treeToolbarClick(EventObject e) {
        String btnKey;
        Control ctl = (Control)e.getSource();
        switch (btnKey = ctl.getKey()) {
            case "btnnew": {
                this.addReferIndexTree();
                break;
            }
            case "btnedit": {
                this.editReferIndexTree();
                break;
            }
            case "btndel": {
                TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
                if (nodeType == TmcTreeNodeTypeProp.ROOT) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u6839\u8282\u70b9\u3002", (String)"ReferRateTreeList_2", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (nodeType == NODE_INDEXTYPE || nodeType == NODE_INDEXCURRENCY) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5220\u9664\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ReferRateTreeList_3", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    break;
                }
                Long indexDataId = Long.valueOf(this.getCurrentNodeModel().getRefEntityPkValue().toString());
                DynamicObject index = BusinessDataServiceHelper.loadSingleFromCache((Object)indexDataId, (String)"tbd_referindex");
                if (index.getString("enable").equals("1")) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u6307\u6570\u5b9a\u4e49\u5df2\u7ecf\u542f\u7528\uff0c\u662f\u5426\u7981\u7528\u540c\u65f6\u5220\u9664\uff1f", (String)"ReferIndexTreeList_0", (String)"tmc-md-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(CONFIRM_BTNDEL));
                    break;
                }
                this.delReferIndexTree();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (evt.getActionId().equals(ADDTREE_ACTIONID) || evt.getActionId().equals(EDITTREE_ACTIONID)) {
            this.refreshTree();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (StringUtils.equals((CharSequence)event.getCallBackId(), (CharSequence)CONFIRM_BTNDEL) && event.getResult() == MessageBoxResult.Yes) {
            this.delReferIndexTree();
        }
    }

    private void addReferIndexTree() {
        BaseShowParameter showParam = new BaseShowParameter();
        showParam.setFormId("tbd_referindex");
        this.initShowParam((FormShowParameter)showParam);
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDTREE_ACTIONID));
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private void editReferIndexTree() {
        TmcTreeNodeTypeProp nodeType = this.getCurrentNodeModel().getNodeType();
        if (nodeType == TmcTreeNodeTypeProp.ROOT) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u6839\u8282\u70b9\u3002", (String)"MarketDataTreeList_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
        } else if (nodeType == NODE_INDEXTYPE || nodeType == NODE_INDEXCURRENCY) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u7f16\u8f91\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"MarketDataTreeList_1", (String)"tmc-md-formplugin", (Object[])new Object[0]));
        } else {
            Object indexDataId = this.getCurrentNodeModel().getRefEntityPkValue();
            BaseShowParameter showParam = new BaseShowParameter();
            showParam.setStatusValue(OperationStatus.EDIT.getValue());
            showParam.setFormId("tbd_referindex");
            showParam.setPkId(indexDataId);
            showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EDITTREE_ACTIONID));
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    private void delReferIndexTree() {
        Long indexDataId = Long.valueOf(this.getCurrentNodeModel().getRefEntityPkValue().toString());
        boolean exists = TmcDataServiceHelper.exists((String)"md_dataindex", (QFilter[])new QFilter[]{new QFilter("referindex", "=", (Object)indexDataId)});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9a\u4e49\u7f16\u7801\u4e2d\u5b58\u5728\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"ReferRateTreeList_4", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject index = BusinessDataServiceHelper.loadSingle((Object)indexDataId, (String)"tbd_referindex");
        index.set("enable", (Object)"0");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{index});
        OperationResult result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"tbd_referindex", (Object[])new Object[]{indexDataId}, (OperateOption)OperateOption.create());
        if (result != null && result.isSuccess()) {
            this.refreshTree();
        }
    }

    private void initShowParam(FormShowParameter showParam) {
        String nodeId = this.getCurrentNodeModel().getNodeId();
        List<TmcTreeNodeTypeProp> parentNode = Arrays.asList(NODE_INDEXTYPE, NODE_INDEXCURRENCY);
        for (TmcTreeNodeTypeProp typeProp : parentNode) {
            int pTypeIndex;
            String pTypeName = typeProp.getName() + '#';
            boolean containParent = nodeId.contains(pTypeName);
            if (!containParent || (pTypeIndex = nodeId.lastIndexOf(pTypeName)) == -1) continue;
            String substring = nodeId.substring(pTypeIndex);
            int endIndex = substring.contains(String.valueOf('/')) ? substring.indexOf(47) : substring.length();
            showParam.getCustomParams().put(typeProp.getName(), substring.substring(pTypeName.length(), endIndex));
        }
    }

    private List<TmcTreeNodeRefProp> loadTypeNodeList() {
        DynamicObjectCollection indexs = QueryServiceHelper.query((String)"tbd_referindex", (String)"type", null);
        Set types = indexs.stream().map(v -> v.getString("type")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(types.size());
        for (String type : types) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            switch (type) {
                case "stock": {
                    node.setNodeName(IndexTypeEnum.getName((String)"stock"));
                    break;
                }
                case "bond": {
                    node.setNodeName(IndexTypeEnum.getName((String)"bond"));
                    break;
                }
                case "fund": {
                    node.setNodeName(IndexTypeEnum.getName((String)"fund"));
                    break;
                }
                case "futures": {
                    node.setNodeName(IndexTypeEnum.getName((String)"futures"));
                    break;
                }
                case "commodity": {
                    node.setNodeName(IndexTypeEnum.getName((String)"commodity"));
                }
            }
            node.setNodeType(NODE_INDEXTYPE);
            node.setRefEntityPkValue((Object)type);
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadCurrencyNodeList(TmcTreeNodeProp currNode) {
        DynamicObject[] indexs = TmcDataServiceHelper.load((String)"tbd_referindex", (String)"currency", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)currNode.getRefEntityPkValue().toString())});
        Set currencys = Arrays.stream(indexs).map(v -> v.getDynamicObject("currency")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(currencys.size());
        for (DynamicObject currency : currencys) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(currency.getString("number"));
            node.setNodeType(NODE_INDEXCURRENCY);
            node.setRefEntityPkValue((Object)currency.getLong("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private List<TmcTreeNodeRefProp> loadNumberNodeList(TmcTreeNodeProp currNode) {
        DynamicObjectCollection indexs = QueryServiceHelper.query((String)"tbd_referindex", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("type", "=", (Object)currNode.getParentRefEntityPkValue(NODE_INDEXTYPE).toString()), new QFilter("currency", "=", (Object)Long.valueOf(currNode.getRefEntityPkValue().toString()))});
        ArrayList<TmcTreeNodeRefProp> nodeList = new ArrayList<TmcTreeNodeRefProp>(indexs.size());
        for (DynamicObject index : indexs) {
            TmcTreeNodeRefProp node = new TmcTreeNodeRefProp();
            node.setNodeName(index.getString("number"));
            node.setNodeType(NODE_INDEXNUMBER);
            node.setRefEntityPkValue((Object)index.getLong("id"));
            nodeList.add(node);
        }
        return nodeList;
    }

    private void refreshTree() {
        this.getTreeModel().setCurrentNodeId((Object)this.getTreeModel().getRoot().getId());
        this.getCurrentNode().setChildren(null);
        this.getTreeListView().refreshTreeView();
    }
}

