/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.yieldcurve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.enums.TradeToolEnum;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class YieldCurveCommonPlugin
extends AbstractTmcBillEdit {
    protected boolean generateStructEntry() {
        List dfDateList;
        boolean dataChanged = this.getModel().getDataChanged();
        Date referdate = (Date)this.getModel().getValue("referdate");
        DynamicObjectCollection fintoolEntry = this.getModel().getEntryEntity("fintoolentry");
        block4: for (int i = 0; i < fintoolEntry.size(); ++i) {
            Boolean isForCurve = ((DynamicObject)fintoolEntry.get(i)).getBoolean("isforcurve_fin");
            if (!isForCurve.booleanValue()) continue;
            String fintool = ((DynamicObject)fintoolEntry.get(i)).getString("fintool_fin");
            boolean isMidRate = ((DynamicObject)fintoolEntry.get(i)).getBoolean("ismidrate_fin");
            if (isMidRate) {
                if (EmptyUtil.isEmpty((Object)((DynamicObject)fintoolEntry.get(i)).get("midrate_fin"))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u4e2d\u95f4\u5229\u7387\u4e0d\u80fd\u4e3a0\u3002", (String)"YieldCurveValid_0", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                    return true;
                }
            } else if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{((DynamicObject)fintoolEntry.get(i)).get("buyrate_fin"), ((DynamicObject)fintoolEntry.get(i)).get("sellrate_fin")})) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u4e70\u5165\u5229\u7387\u3001\u5356\u51fa\u5229\u7387\u4e0d\u80fd\u4e3a0\u3002", (String)"YieldCurveValid_4", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                return true;
            }
            if (EmptyUtil.isEmpty((Object)((DynamicObject)fintoolEntry.get(i)).get("adjmethod_fin"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u65e5\u671f\u8c03\u6574\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YieldCurveValid_5", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                return true;
            }
            TradeToolEnum fintoolEnum = TradeToolEnum.valueOf((String)fintool);
            switch (fintoolEnum) {
                case Future: {
                    if (EmptyUtil.isEmpty((Object)((DynamicObject)fintoolEntry.get(i)).get("futureenddate_fin"))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u671f\u8d27\u5230\u671f\u65e5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YieldCurveValid_1", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                        return true;
                    }
                    if (!EmptyUtil.isEmpty((Object)((DynamicObject)fintoolEntry.get(i)).get("price_fin"))) continue block4;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u4ef7\u683c\u4e0d\u80fd\u4e3a0\u3002", (String)"YieldCurveValid_2", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                    return true;
                }
                case Bond: {
                    if (EmptyUtil.isEmpty((Object)((DynamicObject)fintoolEntry.get(i)).get("price_fin"))) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u4ef7\u683c\u4e0d\u80fd\u4e3a0\u3002", (String)"YieldCurveValid_2", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                        return true;
                    }
                    if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{((DynamicObject)fintoolEntry.get(i)).get("issuedate_fin"), ((DynamicObject)fintoolEntry.get(i)).get("enddate_fin")})) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u503a\u5238\u53d1\u884c\u65e5\u3001\u503a\u5238\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YieldCurveValid_3", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                        return true;
                    }
                    String finFreq = ((DynamicObject)fintoolEntry.get(i)).getString("freq_fin");
                    BigDecimal couponrate = ((DynamicObject)fintoolEntry.get(i)).getBigDecimal("couponrate_fin");
                    if (couponrate.compareTo(BigDecimal.ZERO) <= 0 || !EmptyUtil.isEmpty((String)finFreq)) continue block4;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u7b2c%d\u884c\uff1a\u8ba1\u606f\u9891\u7387\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YieldCurveValid_6", (String)"tmc-md-formplugin", (Object[])new Object[0]), i + 1));
                    return true;
                }
            }
        }
        ArrayList dateList = new ArrayList(fintoolEntry.size());
        HashMap result = new HashMap(fintoolEntry.size());
        YieldCurveHelper.fillAllDFByFintool((DynamicObject)this.getModel().getDataEntity(), (Date)referdate, dateList, result);
        this.getModel().deleteEntryData("structentry");
        if (EmptyUtil.isNoEmpty(dateList) && EmptyUtil.isNoEmpty(dfDateList = dateList.stream().filter(v -> referdate.compareTo((Date)v) < 0).collect(Collectors.toList()))) {
            this.getModel().batchCreateNewEntryRow("structentry", dfDateList.size());
            int rowIndex = 0;
            for (Date date : dfDateList) {
                if (referdate.compareTo(date) >= 0) continue;
                this.getModel().setValue("date_struct", (Object)date, rowIndex);
                this.getModel().setValue("implieddf_struct", result.get(date), rowIndex);
                BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate((DynamicObject)this.getModel().getDataEntity(), (Date)referdate, (Date)date, (BigDecimal)((BigDecimal)result.get(date)));
                this.getModel().setValue("zerorate_struct", (Object)zeroRate, rowIndex);
                this.getModel().setValue("assiskey_struct", (Object)rowIndex, rowIndex);
                ++rowIndex;
            }
        }
        this.getModel().setDataChanged(dataChanged);
        return false;
    }
}

