/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.yieldcurve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BondDealTypeEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.TradeToolEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class YieldCurveTabFinToolPlugin
extends AbstractTmcBillEdit {
    protected static final String[] contract = new String[]{"Mar", "Jun", "Sep", "Dec"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlAllFinToolFields();
        this.controlFinFreq();
    }

    public void afterCopyData(EventObject e) {
        int rowCount = this.getModel().getEntryRowCount("fintoolentry");
        if (rowCount > 0) {
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                BigDecimal cprate;
                String fintool = (String)this.getModel().getValue("fintool_fin", rowIndex);
                if (!TradeToolEnum.isBond((String)fintool) && !TradeToolEnum.isSwap((String)fintool)) {
                    this.getModel().setValue("freq_fin", null, rowIndex);
                }
                if (!TradeToolEnum.isBond((String)fintool) || !EmptyUtil.isEmpty((BigDecimal)(cprate = (BigDecimal)this.getModel().getValue("couponrate_fin", rowIndex)))) continue;
                this.getModel().setValue("freq_fin", null, rowIndex);
            }
        }
        this.rebuildFutureContract();
    }

    private void controlAllFinToolFields() {
        this.controlFinToolFields(TradeToolEnum.Bond.getValue(), "bondendroll", "bonddealtype");
        this.controlFinToolFields(TradeToolEnum.Future.getValue(), "futurecontract_fin", "futureenddate_fin");
        this.controlFinToolFields(TradeToolEnum.FRA.getValue(), "fra_fin");
    }

    private void controlFinToolFields(String fintool, String ... fields) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fintool, fields})) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fintoolentry");
        if (entryEntity.size() == 0) {
            this.getView().setVisible(Boolean.FALSE, fields);
        } else {
            boolean hasFintool = entryEntity.stream().anyMatch(e -> fintool.equals(e.getString("fintool_fin")));
            this.getView().setVisible(Boolean.valueOf(hasFintool), fields);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "referdate": {
                this.referdate_Change();
                break;
            }
            case "bonddealtype": {
                DynamicObjectCollection fintoolEntry = this.getModel().getEntryEntity("fintoolentry");
                for (int i = 0; i < fintoolEntry.size(); ++i) {
                    if (!TradeToolEnum.isBond((String)((DynamicObject)fintoolEntry.get(i)).getString("fintool_fin"))) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)this.bond_calPriceOrMidRate("price", i), (int)i);
                    Date referdate = (Date)this.getModel().getValue("referdate");
                    this.controlIsForCurve(referdate, i);
                }
                break;
            }
            case "rateoffset_fin": {
                if (!this.isBondEntry(e)) break;
                int currentRowIndex = e.getChangeSet()[0].getRowIndex();
                this.calcBondPrice(currentRowIndex);
                Date referdate = (Date)this.getModel().getValue("referdate");
                this.controlIsForCurve(referdate, currentRowIndex);
                break;
            }
            case "issuedate_fin": {
                this.issuedate_Change(e);
                break;
            }
            case "enddate_fin": {
                this.endDate_Change(e);
                break;
            }
            case "midrate_fin": {
                this.midRate_Change(e);
                break;
            }
            case "buyrate_fin": 
            case "sellrate_fin": {
                this.calMidRate_NoBond(e.getChangeSet()[0].getRowIndex());
                break;
            }
            case "price_fin": {
                this.price_Change(e);
                break;
            }
            case "couponrate_fin": {
                int rowIndex = e.getChangeSet()[0].getRowIndex();
                this.initFreq(rowIndex);
                this.calcBondPrice(rowIndex);
                this.controlFinFreq(rowIndex);
                break;
            }
            case "freq_fin": {
                this.finFReqChgEvt(e);
                break;
            }
            case "ismidrate_fin": {
                int curRowIndex = e.getChangeSet()[0].getRowIndex();
                boolean isMidRate = (Boolean)this.getModel().getValue("ismidrate_fin", curRowIndex);
                if (!isMidRate) break;
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buyrate_fin", null, (int)curRowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sellrate_fin", null, (int)curRowIndex);
                break;
            }
            case "bondendroll": {
                boolean bondendroll = (Boolean)this.getModel().getValue("bondendroll");
                if (!bondendroll) break;
                Date referdate = (Date)this.getModel().getValue("referdate");
                DynamicObjectCollection fintoolEntries = this.getModel().getEntryEntity("fintoolentry");
                for (int i = 0; i < fintoolEntries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)fintoolEntries.get(i);
                    if (!TradeToolEnum.isBond((String)((DynamicObject)fintoolEntries.get(i)).getString("fintool_fin"))) continue;
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate_fin", (Object)referdate, (int)i);
                    String term = entry.getString("term_fin");
                    Date enddate = TermUtils.getDateByTerm((String)term, (Date)referdate);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate_fin", (Object)enddate, (int)i);
                    this.controlIsForCurve(referdate, i);
                }
                break;
            }
            case "basis_fin": {
                this.basisChgEvt(e);
            }
        }
    }

    private void initFreq(int rowIndex) {
        String fintool = (String)this.getModel().getValue("fintool_fin", rowIndex);
        if (TradeToolEnum.isBond((String)fintool)) {
            String freq = (String)this.getModel().getValue("freq_fin", rowIndex);
            BigDecimal couponrate = (BigDecimal)this.getModel().getValue("couponrate_fin", rowIndex);
            if (EmptyUtil.isEmpty((String)freq) && couponrate.compareTo(BigDecimal.ZERO) > 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"freq_fin", (Object)PayFrequeEnum.year.getValue(), (int)rowIndex);
            }
            if (EmptyUtil.isNoEmpty((String)freq) && couponrate.compareTo(BigDecimal.ZERO) == 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"freq_fin", (Object)"", (int)rowIndex);
            }
        }
    }

    private void finFReqChgEvt(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        this.calcBondPrice(currentRowIndex);
    }

    private void calcBondPrice(int currentRowIndex) {
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        if (TradeToolEnum.isBond((String)fintool)) {
            BigDecimal price = this.bond_calPriceOrMidRate("price", currentRowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)price, (int)currentRowIndex);
        }
    }

    private void basisChgEvt(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        this.calcBondPrice(currentRowIndex);
    }

    private boolean isBondEntry(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        return TradeToolEnum.isBond((String)fintool);
    }

    private void controlFinFreq() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fintoolentry");
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.controlFinFreq(i);
        }
    }

    private void controlFinFreq(int rowIndex) {
        String finTool = (String)this.getModel().getValue("fintool_fin", rowIndex);
        if (TradeToolEnum.isBond((String)finTool)) {
            BigDecimal couponrate = (BigDecimal)this.getModel().getValue("couponrate_fin", rowIndex);
            this.getView().setEnable(Boolean.valueOf(couponrate.compareTo(BigDecimal.ZERO) > 0), rowIndex, new String[]{"freq_fin"});
        }
    }

    private void price_Change(PropertyChangedArgs e) {
        BigDecimal midRate;
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price_fin", currentRowIndex);
        if (TradeToolEnum.Future.getValue().equals(fintool)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"midrate_fin", (Object)Constants.ONE_HUNDRED.subtract(price), (int)currentRowIndex);
        }
        if (TradeToolEnum.Bond.getValue().equals(fintool) && (midRate = this.bond_calPriceOrMidRate("midrate", currentRowIndex)).compareTo(BigDecimal.ZERO) != 0) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"midrate_fin", (Object)midRate, (int)currentRowIndex);
        }
    }

    private void endDate_Change(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        Date enddate = (Date)this.getModel().getValue("enddate_fin", currentRowIndex);
        Date referdate = (Date)this.getModel().getValue("referdate");
        String term = (String)this.getModel().getValue("term_fin", currentRowIndex);
        String bonddealtype = (String)this.getModel().getValue("bonddealtype");
        if (TradeToolEnum.isBond((String)fintool)) {
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{enddate, term})) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate_fin", (Object)TermUtils.getLastDateByBaseDate4ymd((String)term, (Date)enddate), (int)currentRowIndex);
            }
            if (BondDealTypeEnum.isBond((String)bonddealtype)) {
                BigDecimal price = this.bond_calPriceOrMidRate("price", currentRowIndex);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)price, (int)currentRowIndex);
            }
            this.controlIsForCurve(referdate, currentRowIndex);
        }
    }

    private void controlIsForCurve(Date referdate, int currentRowIndex) {
        String fintool = (String)this.getModel().getValue("fintool_fin");
        if (!TradeToolEnum.isBond((String)fintool)) {
            return;
        }
        String bondDealtype = (String)this.getModel().getValue("bonddealtype");
        Date enddate = (Date)this.getModel().getValue("enddate_fin", currentRowIndex);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{enddate, referdate})) {
            int rateOffset;
            DynamicObjectCollection workcalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            Date referdateOffset = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workcalendar, (Date)referdate, (int)(rateOffset = ((Integer)this.getModel().getValue("rateoffset_fin", currentRowIndex)).intValue()));
            if (referdateOffset.compareTo(enddate) >= 0 && BondDealTypeEnum.isBond((String)bondDealtype)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isforcurve_fin", (Object)false, (int)currentRowIndex);
                this.getView().setEnable(Boolean.FALSE, currentRowIndex, new String[]{"isforcurve_fin"});
            } else {
                this.getView().setEnable(Boolean.TRUE, currentRowIndex, new String[]{"isforcurve_fin"});
            }
        }
    }

    private void issuedate_Change(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        Date issuedate = (Date)this.getModel().getValue("issuedate_fin", currentRowIndex);
        String term = (String)this.getModel().getValue("term_fin", currentRowIndex);
        if (TradeToolEnum.isBond((String)fintool) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{issuedate, term})) {
            this.getModel().setValue("enddate_fin", (Object)TermUtils.getDateByTerm((String)term, (Date)issuedate), currentRowIndex);
        }
    }

    private void midRate_Change(PropertyChangedArgs e) {
        int currentRowIndex = e.getChangeSet()[0].getRowIndex();
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        BigDecimal midRate = (BigDecimal)this.getModel().getValue("midrate_fin", currentRowIndex);
        if (TradeToolEnum.isFuture((String)fintool)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)Constants.ONE_HUNDRED.subtract(midRate), (int)currentRowIndex);
        }
        if (TradeToolEnum.isBond((String)fintool)) {
            BigDecimal price = this.bond_calPriceOrMidRate("price", currentRowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)price, (int)currentRowIndex);
        }
    }

    private BigDecimal bond_calPriceOrMidRate(String priceOrMidRate, int currentRowIndex) {
        String fintool = (String)this.getModel().getValue("fintool_fin", currentRowIndex);
        if (!TradeToolEnum.isBond((String)fintool)) {
            return BigDecimal.ZERO;
        }
        Date referdate = (Date)this.getModel().getValue("referdate");
        BigDecimal midRate = (BigDecimal)this.getModel().getValue("midrate_fin", currentRowIndex);
        BigDecimal price = (BigDecimal)this.getModel().getValue("price_fin", currentRowIndex);
        BigDecimal couponRate = (BigDecimal)this.getModel().getValue("couponrate_fin", currentRowIndex);
        String term = (String)this.getModel().getValue("term_fin", currentRowIndex);
        String basis = (String)this.getModel().getValue("basis_fin", currentRowIndex);
        BasisEnum basisEnum = BasisEnum.valueOf((String)basis);
        String freq = (String)this.getModel().getValue("freq_fin", currentRowIndex);
        String bondDealType = (String)this.getModel().getValue("bonddealtype");
        Date endDate = (Date)this.getModel().getValue("enddate_fin", currentRowIndex);
        DynamicObjectCollection workcalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        int rateOffset = (Integer)this.getModel().getValue("rateoffset_fin", currentRowIndex);
        Date referdateOffset = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)workcalendar, (Date)referdate, (int)rateOffset);
        PayFrequeEnum payFrequeEnum = EmptyUtil.isEmpty((String)freq) ? null : PayFrequeEnum.valueOf((String)freq);
        if ("price".equals(priceOrMidRate)) {
            couponRate = couponRate.divide(Constants.ONE_HUNDRED);
            midRate = midRate.divide(Constants.ONE_HUNDRED);
            price = YieldCurveHelper.bond_CalBondPrice((String)bondDealType, (BigDecimal)couponRate, (BigDecimal)midRate, (PayFrequeEnum)payFrequeEnum, (BasisEnum)basisEnum, (String)term, (Date)referdateOffset, (Date)endDate);
            return price;
        }
        couponRate = couponRate.divide(Constants.ONE_HUNDRED);
        midRate = YieldCurveHelper.bond_CalMidRate((String)bondDealType, (BigDecimal)price, (BigDecimal)couponRate, (PayFrequeEnum)payFrequeEnum, (BasisEnum)basisEnum, (String)term, (Date)referdateOffset, (Date)endDate);
        return midRate;
    }

    private void calMidRate_NoBond(int currentRowIndex) {
        boolean isMidRate = (Boolean)this.getModel().getValue("ismidrate_fin", currentRowIndex);
        if (!isMidRate) {
            BigDecimal buyrate = (BigDecimal)this.getModel().getValue("buyrate_fin", currentRowIndex);
            BigDecimal sellrate = (BigDecimal)this.getModel().getValue("sellrate_fin", currentRowIndex);
            this.getModel().setValue("midrate_fin", (Object)buyrate.add(sellrate).divide(new BigDecimal("2"), 10, 4), currentRowIndex);
        }
    }

    private void referdate_Change() {
        Date referdate = (Date)this.getModel().getValue("referdate");
        if (referdate == null) {
            return;
        }
        this.rebuildFutureContract();
        DynamicObjectCollection fintoolEntry = this.getModel().getEntryEntity("fintoolentry");
        boolean bondEndRoll = (Boolean)this.getModel().getValue("bondendroll");
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            if (!TradeToolEnum.isBond((String)((DynamicObject)fintoolEntry.get(i)).getString("fintool_fin"))) continue;
            Date enddate = ((DynamicObject)fintoolEntry.get(i)).getDate("enddate_fin");
            if (bondEndRoll) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate_fin", (Object)referdate, (int)i);
                String term = ((DynamicObject)fintoolEntry.get(i)).getString("term_fin");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate_fin", (Object)TermUtils.getDateByTerm((String)term, (Date)referdate), (int)i);
            } else if (EmptyUtil.isNoEmpty((Object)enddate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"price_fin", (Object)this.bond_calPriceOrMidRate("price", i), (int)i);
            }
            this.controlIsForCurve(referdate, i);
        }
    }

    private void rebuildFutureContract() {
        Date referdate = (Date)this.getModel().getValue("referdate");
        if (referdate == null) {
            return;
        }
        Calendar temp = Calendar.getInstance();
        temp.setTime(referdate);
        int year = temp.get(1);
        int month = temp.get(2);
        int index = 0;
        index = month < 2 ? 0 : (month < 5 ? 1 : (month < 8 ? 2 : (month < 12 ? 3 : 0)));
        DynamicObjectCollection fintoolEntry = this.getModel().getEntryEntity("fintoolentry");
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            if (!TradeToolEnum.isFuture((String)((DynamicObject)fintoolEntry.get(i)).getString("fintool_fin"))) continue;
            String futureContract = contract[index] + Integer.toString(year);
            this.getModel().setValue("futurecontract_fin", (Object)futureContract, i);
            if (++index != 4) continue;
            index = 0;
            ++year;
        }
    }

    private String getNewFutureContract(String fintool, String lastContract) {
        if (!TradeToolEnum.isFuture((String)fintool)) {
            return null;
        }
        String newContract = null;
        ArrayList<String> contract = new ArrayList<String>(4);
        contract.add("Mar");
        contract.add("Jun");
        contract.add("Sep");
        contract.add("Dec");
        int index = contract.indexOf(lastContract.substring(0, 3));
        int year = Integer.parseInt(lastContract.substring(3));
        newContract = index == 3 ? "Mar" + ++year : (String)contract.get(index + 1) + year;
        return newContract;
    }

    private String getFirstFutureContract(String fintool) {
        if (!TradeToolEnum.isFuture((String)fintool)) {
            return null;
        }
        Date referdate = (Date)this.getModel().getValue("referdate");
        Calendar temp = Calendar.getInstance();
        temp.setTime(referdate);
        int year = temp.get(1);
        int month = temp.get(2);
        int index = 0;
        index = month < 2 ? 0 : (month < 5 ? 1 : (month < 8 ? 2 : (month < 12 ? 3 : 0)));
        return contract[index] + year;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((CharSequence)"insertterm", (CharSequence)operateKey)) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "insertterm");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("md_yieldcurve_term");
            param.setCloseCallBack(closeCallBack);
            param.setCustomParam("fintoolentry", (Object)this.getModel().getEntryEntity("fintoolentry"));
            this.getView().showForm(param);
        }
        if (StringUtils.equals((CharSequence)"delfintoolentry", (CharSequence)operateKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("fintoolentry");
            int[] selectRows = entryGrid.getSelectRows();
            int length = selectRows.length;
            if (length > 0) {
                List fintool_fin;
                DynamicObject lastOne;
                int selectRow = selectRows[0];
                DynamicObjectCollection fintoolentry = this.getModel().getEntryEntity("fintoolentry");
                DynamicObject curr = (DynamicObject)fintoolentry.get(selectRow);
                String fintool = curr.getString("fintool_fin");
                if ((TradeToolEnum.isFuture((String)fintool) || TradeToolEnum.isFra((String)fintool)) && curr != (lastOne = (DynamicObject)(fintool_fin = fintoolentry.stream().filter(e -> Objects.equals(fintool, e.getString("fintool_fin"))).collect(Collectors.toList())).get(fintool_fin.size() - 1))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u5408\u7ea6\u7684\u8fde\u8d2f\u6027\uff0c\u5220\u9664\u65f6\u8bf7\u4ece\u6700\u540e\u4e00\u4e2a\u5408\u7ea6\u5f80\u524d\u5220\u9664\u3002", (String)"YieldCurveTabFinToolPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
            }
            this.getView().invokeOperation("deleteentry");
            this.controlAllFinToolFields();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        DynamicObject data;
        super.closedCallBack(event);
        if ("insertterm".equals(event.getActionId()) && EmptyUtil.isNoEmpty((DynamicObject)(data = (DynamicObject)event.getReturnData()))) {
            String fintool_insert = data.getString("fintool");
            String term_insert = data.getString("term");
            String fra_insert = data.getString("fra");
            String contract_insert = null;
            TradeToolEnum fintool_insertEnum = TradeToolEnum.valueOf((String)fintool_insert);
            int rowIndex = 0;
            DynamicObjectCollection fintoolEntry = this.getModel().getEntryEntity("fintoolentry");
            Date current = TcDateUtils.getCurrentDate();
            Date insert = TermUtils.getDateByTerm((String)data.getString("term"), (Date)current);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)fintoolEntry)) {
                rowIndex = this.getModel().createNewEntryRow("fintoolentry");
                contract_insert = this.getFirstFutureContract(fintool_insert);
            } else {
                for (int i = 0; i < fintoolEntry.size(); ++i) {
                    DynamicObject row = (DynamicObject)fintoolEntry.get(i);
                    String fintool_fin = row.getString("fintool_fin");
                    TradeToolEnum fintool_finEnum = TradeToolEnum.valueOf((String)fintool_fin);
                    if (fintool_insertEnum.getSeq() > fintool_finEnum.getSeq()) {
                        if (i != fintoolEntry.size() - 1) continue;
                        rowIndex = this.getModel().createNewEntryRow("fintoolentry");
                        contract_insert = this.getFirstFutureContract(fintool_insert);
                        break;
                    }
                    if (fintool_insertEnum.getSeq() == fintool_finEnum.getSeq()) {
                        String term_fin;
                        Date temp;
                        if (TradeToolEnum.isFra((String)fintool_insert)) {
                            String fra_fin = row.getString("fra_fin");
                            if (fra_insert.split("-")[1].equals(fra_fin.split("-")[0])) {
                                rowIndex = this.getModel().insertEntryRow("fintoolentry", i);
                                break;
                            }
                        } else if (!TradeToolEnum.isFuture((String)fintool_insert) && (temp = TermUtils.getDateByTerm((String)(term_fin = row.getString("term_fin")), (Date)current)).after(insert)) {
                            rowIndex = this.getModel().insertEntryRow("fintoolentry", i);
                            break;
                        }
                        if (i == fintoolEntry.size() - 1) {
                            rowIndex = this.getModel().createNewEntryRow("fintoolentry");
                            contract_insert = this.getNewFutureContract(fintool_insert, row.getString("futurecontract_fin"));
                            break;
                        }
                        DynamicObject nextRow = (DynamicObject)fintoolEntry.get(i + 1);
                        String nextfintool_fin = nextRow.getString("fintool_fin");
                        TradeToolEnum nextfintool_finEnum = TradeToolEnum.valueOf((String)nextfintool_fin);
                        if (nextfintool_finEnum.getSeq() == fintool_insertEnum.getSeq()) continue;
                        rowIndex = this.getModel().insertEntryRow("fintoolentry", i + 1);
                        contract_insert = this.getNewFutureContract(fintool_insert, row.getString("futurecontract_fin"));
                        break;
                    }
                    rowIndex = this.getModel().insertEntryRow("fintoolentry", i);
                    contract_insert = this.getFirstFutureContract(fintool_insert);
                    break;
                }
            }
            this.getModel().setValue("fintool_fin", (Object)fintool_insert, rowIndex);
            this.getModel().setValue("term_fin", (Object)term_insert, rowIndex);
            this.getModel().setValue("fra_fin", (Object)fra_insert, rowIndex);
            this.getModel().setValue("futurecontract_fin", (Object)contract_insert, rowIndex);
            TradeToolEnum fintoolEnum = TradeToolEnum.valueOf((String)fintool_insert);
            switch (fintoolEnum) {
                case Future: {
                    this.getModel().setValue("ismidrate_fin", (Object)true, rowIndex);
                    this.getModel().setValue("futureenddate_fin", (Object)"thirdWednesday", rowIndex);
                    this.getModel().setValue("price_fin", (Object)Constants.ONE_HUNDRED, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ismidrate_fin"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"futurecontract_fin", "futureenddate_fin"});
                    break;
                }
                case Bond: {
                    this.getModel().setValue("ismidrate_fin", (Object)true, rowIndex);
                    this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"ismidrate_fin"});
                    Date issuedate = (Date)this.getModel().getValue("referdate");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate_fin", (Object)issuedate, (int)rowIndex);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"enddate_fin", (Object)TermUtils.getDateByTerm((String)term_insert, (Date)issuedate), (int)rowIndex);
                    BigDecimal price = this.bond_calPriceOrMidRate("price", rowIndex);
                    this.getModel().setValue("price_fin", (Object)price, rowIndex);
                    BigDecimal midrate = this.bond_calPriceOrMidRate("midrate", rowIndex);
                    this.getModel().setValue("midrate_fin", (Object)midrate, rowIndex);
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bondendroll", "bonddealtype"});
                    this.controlFinFreq(rowIndex);
                    break;
                }
                case FRA: {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"fra_fin"});
                }
            }
        }
    }
}

