/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.yieldcurve;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.login.actions.SerializationUtils;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.helper.YieldCurveHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.md.formplugin.yieldcurve.YieldCurveCommonPlugin;

public class YieldCurveTabZeroPlugin
extends YieldCurveCommonPlugin
implements TabSelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null && "tabzerorate".equals(tabap.getCurrentTab())) {
            TabSelectEvent evt = new TabSelectEvent((Object)this, "tabzerorate");
            this.tabSelected(evt);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "dateaxis": 
            case "workcalendar": 
            case "adjustmethod": {
                this.buildZeroEntry();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"insertdate", (CharSequence)formOperate.getOperateKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "insertdate");
            FormShowParameter param = new FormShowParameter();
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setFormId("md_yieldcurve_date");
            param.setCloseCallBack(closeCallBack);
            param.setCustomParam("referdate", (Object)SerializationUtils.toJsonString((Object)this.getModel().getValue("referdate")));
            this.getView().showForm(param);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if ("insertdate".equals(event.getActionId())) {
            Object[] wc;
            Date date = (Date)event.getReturnData();
            if (EmptyUtil.isEmpty((Object)date)) {
                return;
            }
            DynamicObjectCollection zeroEntry = this.getModel().getEntryEntity("zeroentry");
            Date referdate = (Date)this.getModel().getValue("referdate");
            String basis = (String)this.getModel().getValue("basis");
            String freq = (String)this.getModel().getValue("frequency");
            String interptype = (String)this.getModel().getValue("interptype");
            String bondDealType = (String)this.getModel().getValue("bonddealtype");
            String adjustmethod = (String)this.getModel().getValue("adjustmethod");
            DynamicObjectCollection workcalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)workcalendar)) {
                wc = null;
            } else {
                wc = new DynamicObject[workcalendar.size()];
                wc = (DynamicObject[])workcalendar.toArray(wc);
            }
            BasisEnum basisEnum = null;
            if (EmptyUtil.isNoEmpty((String)basis)) {
                basisEnum = BasisEnum.valueOf((String)basis);
            }
            PayFrequeEnum payFrequeEnum = null;
            if (EmptyUtil.isNoEmpty((String)freq)) {
                payFrequeEnum = PayFrequeEnum.valueOf((String)freq);
            }
            AdjustMethodEnum adjustMethodEnum = null;
            if (EmptyUtil.isNoEmpty((String)adjustmethod)) {
                adjustMethodEnum = AdjustMethodEnum.valueOf((String)adjustmethod);
            }
            DynamicObjectCollection entry_struct = this.getModel().getEntryEntity("structentry");
            ArrayList<Date> dateList = new ArrayList<Date>(entry_struct.size());
            HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>(entry_struct.size());
            for (int i = 0; i < entry_struct.size(); ++i) {
                if (!((DynamicObject)entry_struct.get(i)).getBoolean("isforcurve_struct")) continue;
                Date date_i = ((DynamicObject)entry_struct.get(i)).getDate("date_struct");
                BigDecimal df_i = ((DynamicObject)entry_struct.get(i)).getBigDecimal("implieddf_struct");
                dateList.add(date_i);
                result.put(date_i, df_i);
            }
            if (EmptyUtil.isEmpty(dateList) || dateList.size() <= 1) {
                return;
            }
            int index = 0;
            if (EmptyUtil.isEmpty((DynamicObjectCollection)zeroEntry)) {
                index = this.getModel().createNewEntryRow("zeroentry");
            } else {
                for (int i = 0; i < zeroEntry.size(); ++i) {
                    Date temp = ((DynamicObject)zeroEntry.get(i)).getDate("date_zero");
                    if (date.compareTo(temp) == 0) {
                        return;
                    }
                    if (date.before(temp)) {
                        index = this.getModel().insertEntryRow("zeroentry", i);
                        break;
                    }
                    if (i != zeroEntry.size() - 1) continue;
                    index = this.getModel().createNewEntryRow("zeroentry");
                    break;
                }
            }
            DynamicObjectCollection entry_fin = this.getModel().getEntryEntity("fintoolentry");
            DynamicObject firstRow = null;
            for (int i = 0; i < entry_fin.size(); ++i) {
                if (!((DynamicObject)entry_fin.get(i)).getBoolean("isforcurve_fin")) continue;
                firstRow = (DynamicObject)entry_fin.get(i);
                break;
            }
            this.getModel().setValue("date_zero", (Object)date, index);
            BigDecimal df = YieldCurveHelper.zero_getDfByDate((Date)((Date)dateList.get(0)), (Date)((Date)dateList.get(dateList.size() - 1)), (Date)referdate, (Date)date, (String)interptype, (String)bondDealType, (DynamicObjectCollection)workcalendar, (DynamicObject[])wc, (DynamicObject)firstRow, dateList, result, (BasisEnum)basisEnum);
            this.getModel().setValue("disfactor_zero", (Object)df, index);
            BigDecimal zeroRate = YieldCurveHelper.struct_calZeroRate((Date)referdate, (PayFrequeEnum)payFrequeEnum, (BasisEnum)basisEnum, (DynamicObject[])wc, (Date)date, (BigDecimal)df);
            this.getModel().setValue("zerorate_zero", (Object)zeroRate, index);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        boolean isFail;
        if (tabSelectEvent.getTabKey().equals("tabzerorate") && !(isFail = this.generateStructEntry())) {
            this.buildZeroEntry();
        }
    }

    protected void buildZeroEntry() {
        Object[] wc;
        boolean dataChanged = this.getModel().getDataChanged();
        DynamicObject dateaxis = (DynamicObject)this.getModel().getValue("dateaxis");
        Date referdate = (Date)this.getModel().getValue("referdate");
        String basis = (String)this.getModel().getValue("basis");
        String freq = (String)this.getModel().getValue("frequency");
        String interptype = (String)this.getModel().getValue("interptype");
        String bondDealType = (String)this.getModel().getValue("bonddealtype");
        String adjustmethod = (String)this.getModel().getValue("adjustmethod");
        this.getModel().setValue("basis_a", (Object)basis);
        this.getModel().setValue("frequency_a", (Object)freq);
        this.getModel().setValue("interptype_a", (Object)interptype);
        if (EmptyUtil.isEmpty((DynamicObject)dateaxis)) {
            return;
        }
        DynamicObjectCollection workcalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)workcalendar)) {
            wc = null;
        } else {
            wc = new DynamicObject[workcalendar.size()];
            wc = (DynamicObject[])workcalendar.toArray(wc);
        }
        BasisEnum basisEnum = null;
        if (EmptyUtil.isNoEmpty((String)basis)) {
            basisEnum = BasisEnum.valueOf((String)basis);
        }
        PayFrequeEnum payFrequeEnum = null;
        if (EmptyUtil.isNoEmpty((String)freq)) {
            payFrequeEnum = PayFrequeEnum.valueOf((String)freq);
        }
        AdjustMethodEnum adjustMethodEnum = null;
        if (EmptyUtil.isNoEmpty((String)adjustmethod)) {
            adjustMethodEnum = AdjustMethodEnum.valueOf((String)adjustmethod);
        }
        DynamicObjectCollection entry_struct = this.getModel().getEntryEntity("structentry");
        ArrayList<Date> dateList = new ArrayList<Date>(entry_struct.size());
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>(entry_struct.size());
        for (int i = 0; i < entry_struct.size(); ++i) {
            if (!((DynamicObject)entry_struct.get(i)).getBoolean("isforcurve_struct")) continue;
            Date date_i = ((DynamicObject)entry_struct.get(i)).getDate("date_struct");
            BigDecimal df_i = ((DynamicObject)entry_struct.get(i)).getBigDecimal("implieddf_struct");
            dateList.add(date_i);
            result.put(date_i, df_i);
        }
        this.getModel().deleteEntryData("zeroentry");
        if (EmptyUtil.isEmpty(dateList) || dateList.size() <= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6536\u76ca\u7387\u66f2\u7ebf\u6784\u9020\u53ca\u8ba1\u7b97\u81f3\u5c11\u9700\u8981\u4e24\u4e2a\u6298\u73b0\u56e0\u5b50\uff0c\u8bf7\u6dfb\u52a0\u91d1\u878d\u5de5\u5177\u3002", (String)"YieldCurveTabZeroPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection entry_fin = this.getModel().getEntryEntity("fintoolentry");
        DynamicObject firstRow = null;
        for (int i = 0; i < entry_fin.size(); ++i) {
            if (!((DynamicObject)entry_fin.get(i)).getBoolean("isforcurve_fin")) continue;
            firstRow = (DynamicObject)entry_fin.get(i);
            break;
        }
        List zeroList = YieldCurveHelper.zero_getZeroEntry((Long)dateaxis.getLong("id"), (String)interptype, (String)bondDealType, (Date)referdate, (PayFrequeEnum)payFrequeEnum, (BasisEnum)basisEnum, (DynamicObjectCollection)workcalendar, (AdjustMethodEnum)adjustMethodEnum, (DynamicObject[])wc, (DynamicObject)firstRow, dateList, result);
        this.getModel().deleteEntryData("zeroentry");
        for (int i = 0; i < zeroList.size(); ++i) {
            int rowIndex = this.getModel().createNewEntryRow("zeroentry");
            this.getModel().setValue("date_zero", ((Map)zeroList.get(i)).get("date_zero"), rowIndex);
            this.getModel().setValue("disfactor_zero", ((Map)zeroList.get(i)).get("disfactor_zero"), rowIndex);
            this.getModel().setValue("zerorate_zero", ((Map)zeroList.get(i)).get("zerorate_zero"), rowIndex);
        }
        this.getModel().setDataChanged(dataChanged);
    }
}

