/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.md.formplugin.yieldcurve;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.enums.TradeToolEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TermUtils;

public class YieldCurveTermEditPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "fintool": {
                this.fintoolChange();
                break;
            }
            case "fra": {
                this.checkFRA();
            }
        }
    }

    private void fintoolChange() {
        String finTool = (String)this.getModel().getValue("fintool");
        if (TradeToolEnum.isFra((String)finTool)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"fra"});
            List<String> col = this.getFRA_Col();
            if (EmptyUtil.isEmpty(col)) {
                this.getModel().setValue("fra", (Object)"1-4");
                this.getModel().setValue("term", (Object)"3m");
            } else {
                int M_last;
                String fra_last = col.get(col.size() - 1);
                int N_last = Integer.parseInt(fra_last.split("-")[0]);
                int N = M_last = Integer.parseInt(fra_last.split("-")[1]);
                int M = 2 * M_last - N_last;
                this.getModel().setValue("fra", (Object)(N + "-" + M));
                this.getModel().setValue("term", (Object)(M - N + "m"));
            }
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"fra"});
            this.getModel().setValue("fra", null);
        }
        if (TradeToolEnum.isFuture((String)finTool)) {
            this.getModel().setValue("term", (Object)"3m");
        }
        if (TradeToolEnum.isCash((String)finTool) || TradeToolEnum.isSwap((String)finTool) || TradeToolEnum.isBond((String)finTool)) {
            this.getModel().setValue("term", null);
        }
    }

    private void checkFRA() {
        String FRA = (String)this.getModel().getValue("fra");
        if (EmptyUtil.isNoEmpty((String)FRA)) {
            String pattern = "^(\\d+)-(\\d+)$";
            Pattern r = Pattern.compile(pattern);
            Matcher matcher = r.matcher(FRA);
            if (matcher.find()) {
                int N = Integer.parseInt(matcher.group(1));
                int M = Integer.parseInt(matcher.group(2));
                if (N <= 0) {
                    this.getModel().setValue("fra", null);
                    this.getModel().setValue("term", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"FRA\u7684\u6570\u636e\u9700\u5927\u4e8e0\u3002", (String)"YieldCurveTerm_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                } else if (N >= M) {
                    this.getModel().setValue("fra", null);
                    this.getModel().setValue("term", null);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"FRA\u7684\u6570\u636e\u9700\u6ee1\u8db3\u540e\u4e00\u4f4d\u6570\u5b57\u5927\u4e8e\u524d\u4e00\u4f4d\u6570\u5b57\u3002", (String)"YieldCurveTerm_1", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                } else {
                    this.getModel().setValue("term", (Object)(M - N + "m"));
                }
            } else {
                this.getModel().setValue("fra", null);
                this.getModel().setValue("term", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"FRA\u7684\u6570\u636e\u9700\u6ee1\u8db3i-j\u7684\u683c\u5f0f\u3002", (String)"YieldCurveTerm_2", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private List<String> getFRA_Col() {
        JSONArray fintoolEntry = (JSONArray)this.getView().getFormShowParameter().getCustomParam("fintoolentry");
        ArrayList<String> FRA_Col = new ArrayList<String>(fintoolEntry.size());
        if (!fintoolEntry.isEmpty()) {
            for (int i = 0; i < fintoolEntry.size(); ++i) {
                JSONObject cur = fintoolEntry.getJSONObject(i);
                if (!TradeToolEnum.isFra((String)cur.getString("fintool_fin"))) continue;
                FRA_Col.add(cur.getString("fra_fin"));
            }
        }
        return FRA_Col;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button source = (Button)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            String term;
            String fintool = (String)this.getModel().getValue("fintool");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fintool, term = (String)this.getModel().getValue("term")})) {
                TradeToolEnum fintoolEnum = TradeToolEnum.valueOf((String)fintool);
                JSONArray fintoolEntry = (JSONArray)this.getView().getFormShowParameter().getCustomParam("fintoolentry");
                switch (fintoolEnum) {
                    case FRA: {
                        for (int i = 0; i < fintoolEntry.size(); ++i) {
                            if (!"Future".equals(fintoolEntry.getJSONObject(i).getString("fintool_fin"))) continue;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdc\u671f\u5229\u7387\u534f\u8bae\u548c\u671f\u8d27\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"YieldCurveTerm_5", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (!this.checkFRA_CanInsert()) break;
                        this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                        this.getView().invokeOperation("close");
                        return;
                    }
                    case Future: {
                        for (int i = 0; i < fintoolEntry.size(); ++i) {
                            if (!"FRA".equals(fintoolEntry.getJSONObject(i).getString("fintool_fin"))) continue;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8fdc\u671f\u5229\u7387\u534f\u8bae\u548c\u671f\u8d27\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u3002", (String)"YieldCurveTerm_5", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        if (this.checkFuture_CanInsert()) {
                            this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                            this.getView().invokeOperation("close");
                            break;
                        }
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u5141\u8bb8\u5f55\u516510\u4e2a\u671f\u8d27\u3002", (String)"YieldCurveTerm_4", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    case Cash: 
                    case Swap: 
                    case Bond: {
                        if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)term)) break;
                        Map tm = TermUtils.getYMD((String)term);
                        if (fintoolEnum == TradeToolEnum.Bond && ((Integer)tm.get("m") > 12 || (Integer)tm.get("d") > 30)) {
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u671f\u9650\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165\u3002", (String)"YieldCurveTerm_8", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        for (int i = 0; i < fintoolEntry.size(); ++i) {
                            String iterm;
                            if (!TradeToolEnum.isCash((String)fintoolEntry.getJSONObject(i).getString("fintool_fin")) && !TradeToolEnum.isSwap((String)fintoolEntry.getJSONObject(i).getString("fintool_fin")) && !TradeToolEnum.isBond((String)fintoolEntry.getJSONObject(i).getString("fintool_fin")) || !term.equals(iterm = fintoolEntry.getJSONObject(i).getString("term_fin")) && !this.isTermEqual(tm, iterm)) continue;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u671f\u9650\u7684\u91d1\u878d\u5de5\u5177\u3002", (String)"YieldCurveTerm_6", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                            return;
                        }
                        this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
                        this.getView().invokeOperation("close");
                        return;
                    }
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91d1\u878d\u5de5\u5177\u548c\u671f\u9650\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"YieldCurveTerm_3", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private boolean isTermEqual(Map<String, Integer> tm, String iterm) {
        Map itm = TermUtils.getYMD((String)iterm);
        if ((Integer)itm.get("d") == 0 && tm.get("d") == 0) {
            int ms;
            int im = (Integer)itm.get("m") + (Integer)itm.get("y") * 12;
            return im == (ms = tm.get("m") + tm.get("y") * 12);
        }
        return false;
    }

    private boolean checkFuture_CanInsert() {
        JSONArray fintoolEntry = (JSONArray)this.getView().getFormShowParameter().getCustomParam("fintoolentry");
        if (fintoolEntry.isEmpty() || fintoolEntry.size() < 10) {
            return true;
        }
        int count = 0;
        for (int i = 0; i < fintoolEntry.size(); ++i) {
            if (!TradeToolEnum.isFuture((String)fintoolEntry.getJSONObject(i).getString("fintool_fin")) || ++count < 10) continue;
            return false;
        }
        return true;
    }

    private boolean checkFRA_CanInsert() {
        String fra_last;
        String fra_first;
        List<String> col = this.getFRA_Col();
        if (EmptyUtil.isEmpty(col)) {
            return true;
        }
        String FRA = (String)this.getModel().getValue("fra");
        if (col.size() == 1) {
            fra_first = col.get(0);
            fra_last = col.get(0);
        } else {
            fra_first = col.get(0);
            fra_last = col.get(col.size() - 1);
        }
        int N_first = Integer.parseInt(fra_first.split("-")[0]);
        int M_first = Integer.parseInt(fra_first.split("-")[1]);
        int N_last = Integer.parseInt(fra_last.split("-")[0]);
        int M_last = Integer.parseInt(fra_last.split("-")[1]);
        int N_Min = N_first - (M_first - N_first);
        int M_MIn = N_first;
        int N_Max = M_last;
        int M_Max = 2 * M_last - N_last;
        String Max = N_Max + "-" + M_Max;
        String Min = N_Min + "-" + M_MIn;
        if (N_Min > 0) {
            if (!Max.equals(FRA) && !Min.equals(FRA)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d2\u5165\u76f8\u90bb\u4e14\u671f\u9650\u76f8\u540c\u7684\u8fdc\u671f\u5229\u7387\u534f\u8bae\u3002", (String)"YieldCurveTermEditPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (!Max.equals(FRA)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u63d2\u5165\u76f8\u90bb\u4e14\u671f\u9650\u76f8\u540c\u7684\u8fdc\u671f\u5229\u7387\u534f\u8bae\u3002", (String)"YieldCurveTermEditPlugin_0", (String)"tmc-md-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

