/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.ext.tmc.balancemodel.BalanceValue;
import kd.tmc.mon.business.balance.DealDsService;

public class BuildDataSet {
    private static final int iniSize = 16;

    public DataSet buildBalanceDataSet(List<BalanceValue> balValues) {
        DataSetBuilder dsBuilder = this.createDsBuilder();
        BuildDataSet buildDs = new BuildDataSet();
        for (BalanceValue value : balValues) {
            dsBuilder.append(buildDs.buildRowData(value.getOrgId(), value.getType(), value.getAccountId(), value.getCurrencyId(), value.getStartDate(), value.getMonthStart(), value.getRevenueAmount(), value.getPayAmount(), value.getPeriodId(), value.getPeriodName(), value.getYearStart(), value.getYearRecAmount(), value.getYearPayAmount()).toArray(new Object[0]));
        }
        DataSet ds = dsBuilder.build().groupBy(new String[]{"fperiod", "fperiodname", "fstartdate", "forgid", "ftype", "facctid", "fcurrencyid", "sumlevel"}).sum("fbalance").sum("fdebitamount").sum("fcreditamount").sum("fyearbalance").sum("fyeardebitamount").sum("fyearcreditamount").finish();
        return DealDsService.getInstance().dealDs(ds);
    }

    private List<Object> buildRowData(Long orgid, String type, Long cashAcctId, Long currencyId, Date startDate, BigDecimal balance, BigDecimal debitAmt, BigDecimal creditAmt, Long period, String periodName, BigDecimal yearBalance, BigDecimal yearDebitAmt, BigDecimal yearCreditAmt) {
        ArrayList<Object> rowData = new ArrayList<Object>(16);
        rowData.add(orgid);
        rowData.add(type);
        rowData.add(cashAcctId);
        rowData.add(currencyId);
        rowData.add(startDate);
        rowData.add(balance);
        rowData.add(debitAmt);
        rowData.add(creditAmt);
        rowData.add(0);
        rowData.add(period);
        rowData.add(periodName);
        rowData.add(yearBalance);
        rowData.add(yearDebitAmt);
        rowData.add(yearCreditAmt);
        return rowData;
    }

    private DataSetBuilder createDsBuilder() {
        return Algo.create((String)"ReportBalanceService.createDataSetBuilder").createDataSetBuilder(new RowMeta(this.buildFields().toArray(new Field[0])));
    }

    private List<Field> buildFields() {
        ArrayList<Field> fields = new ArrayList<Field>(16);
        fields.add(new Field("forgid", (DataType)DataType.LongType));
        fields.add(new Field("ftype", (DataType)DataType.StringType));
        fields.add(new Field("facctid", (DataType)DataType.LongType));
        fields.add(new Field("fcurrencyid", (DataType)DataType.LongType));
        fields.add(new Field("fstartdate", (DataType)DataType.DateType));
        fields.add(new Field("fbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fdebitamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fcreditamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("sumlevel", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fperiod", (DataType)DataType.LongType));
        fields.add(new Field("fperiodname", (DataType)DataType.StringType));
        fields.add(new Field("fyearbalance", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fyeardebitamount", (DataType)DataType.BigDecimalType));
        fields.add(new Field("fyearcreditamount", (DataType)DataType.BigDecimalType));
        return fields;
    }
}

