/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.calbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.entity.property.AmountProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.common.enums.CalculationsEnum;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public abstract class AbstractCalBalance {
    protected List<DynamicObject> bankJournals;
    protected LinkedHashMap<String, AccountBalanceMode> accountMap;
    protected List<AccountBalanceMode> accountLst;
    protected Map<Long, Date> beginDateMap = new HashMap<Long, Date>();

    public AbstractCalBalance() {
        this(null, null);
    }

    public AbstractCalBalance(List<AccountBalanceMode> accountLst) {
        this(null, accountLst);
    }

    public AbstractCalBalance(LinkedHashMap<String, AccountBalanceMode> accountMap, List<AccountBalanceMode> accountLst) {
        this.accountMap = accountMap;
        this.accountLst = accountLst;
    }

    public abstract void updataAccountMap(List<AccountBalanceMode> var1, CalculationsEnum var2);

    public List<AccountBalanceMode> getCasInitAcc(QFilter ... filters) {
        if (MonHelper.isEmpty((Object)filters) || filters.length == 0) {
            filters = new QFilter[]{new QFilter("id", "!=", (Object)0L)};
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org,startperiod.begindate,entrybank.bank_accountbank,entrybank.bank_currency,entrybank.bank_journalbalance,entrybank.bank_journaldebit,entrybank.bank_journalcredit", (QFilter[])filters);
        List<AccountBalanceMode> accountInit = query.stream().filter(p -> MonHelper.isNotEmpty((Object)p.getDate("startperiod.begindate"))).map(t -> {
            AccountBalanceMode account = new AccountBalanceMode();
            account.setOrgId(t.getLong("org"));
            account.setBankAccount(t.getLong("entrybank.bank_accountbank"));
            account.setCurrency(t.getLong("entrybank.bank_currency"));
            account.setBookDate(MonDateUtils.getLastDay((Date)t.getDate("startperiod.begindate"), (int)1));
            account.setCreditAmount(t.getBigDecimal("entrybank.bank_journalcredit"));
            account.setDebitAmount(t.getBigDecimal("entrybank.bank_journaldebit"));
            account.setAmount(t.getBigDecimal("entrybank.bank_journalbalance"));
            account.setDayBalance(account.getCalDayBalance());
            this.beginDateMap.put(account.getOrgId(), t.getDate("startperiod.begindate"));
            return account;
        }).collect(Collectors.toList());
        return accountInit;
    }

    public LinkedHashMap<String, AccountBalanceMode> accountMapAll() {
        QFilter[] filters = new QFilter[]{new QFilter("id", ">", (Object)0L)};
        return this.accountMap(filters);
    }

    public LinkedHashMap<String, AccountBalanceMode> accountMap(QFilter ... filters) {
        DynamicObjectCollection accounts = QueryServiceHelper.query((String)"mon_accountbalance", (String)"id,org,bankaccount,amount,daybalance,daytradenum,daytradeamount,debitamount,creditamount,currency,bookdate,acctgroup,issubaccount", (QFilter[])filters, (String)"bookdate asc");
        LinkedHashMap<String, AccountBalanceMode> accountMap = new LinkedHashMap<String, AccountBalanceMode>(accounts.size());
        AccountBalanceMode mode = null;
        for (DynamicObject account : accounts) {
            mode = new AccountBalanceMode();
            mode.setId(account.getLong("id"));
            mode.setOrgId(account.getLong("org"));
            mode.setBankAccount(account.getLong("bankaccount"));
            mode.setCurrency(account.getLong("currency"));
            mode.setDayTradeNum(account.getInt("daytradenum"));
            mode.setDayTradeAmount(account.getBigDecimal("daytradeamount"));
            mode.setCreditAmount(account.getBigDecimal("creditamount"));
            mode.setDebitAmount(account.getBigDecimal("debitamount"));
            mode.setDayBalance(account.getBigDecimal("daybalance"));
            mode.setAmount(account.getBigDecimal("amount"));
            mode.setBookDate(account.getDate("bookdate"));
            String key = this.getKey(mode);
            accountMap.put(key, mode);
        }
        return accountMap;
    }

    public void saveAccounts() {
        if (this.accountMap.size() > 0) {
            ArrayList<DynamicObject> accountAddLst = new ArrayList<DynamicObject>(10);
            ArrayList<DynamicObject> accountUpdateLst = new ArrayList<DynamicObject>(10);
            AccountBalanceMode mode = null;
            DynamicObject account = null;
            for (Map.Entry<String, AccountBalanceMode> entry : this.accountMap.entrySet()) {
                mode = entry.getValue();
                account = BusinessDataServiceHelper.newDynamicObject((String)"mon_accountbalance");
                account.set("id", (Object)mode.getId());
                account.set("org", (Object)mode.getOrgId());
                account.set("bankaccount", (Object)mode.getBankAccount());
                account.set("currency", (Object)mode.getCurrency());
                account.set("daytradenum", (Object)mode.getDayTradeNum());
                account.set("daytradeamount", (Object)mode.getDayTradeAmount());
                account.set("creditamount", (Object)mode.getCreditAmount());
                account.set("debitamount", (Object)mode.getDebitAmount());
                account.set("daybalance", (Object)mode.getDayBalance());
                account.set("amount", (Object)mode.getAmount());
                account.set("bookdate", (Object)mode.getBookDate());
                this.setDirty(account, "daybalance");
                this.setDirty(account, "debitamount");
                this.setDirty(account, "creditamount");
                this.setDirty(account, "amount");
                if (mode.getId() > 0L) {
                    accountUpdateLst.add(account);
                    continue;
                }
                accountAddLst.add(account);
            }
            if (accountAddLst.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])accountAddLst.toArray(new DynamicObject[0]));
            }
            if (accountUpdateLst.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])accountUpdateLst.toArray(new DynamicObject[0]));
            }
        }
    }

    private void setDirty(DynamicObject account, String field) {
        AmountProp fieldProp = (AmountProp)account.getDataEntityType().getProperties().get((Object)field);
        account.getDataEntityState().setDirty((ISimpleProperty)fieldProp, true);
    }

    public void clearAccountBalance() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
        this.deleteAccountBalance(filters);
    }

    public void deleteAccountBalance(QFilter ... filters) {
        DeleteServiceHelper.delete((String)"mon_accountbalance", (QFilter[])filters);
    }

    public String getKey(AccountBalanceMode mode) {
        Long accbankaccount = mode.getBankAccount();
        Long acccurrency = mode.getCurrency();
        return String.format("%s_%s_%s", accbankaccount, acccurrency, MonDateUtils.getFormatDate((Date)mode.getBookDate()));
    }

    public synchronized BigDecimal getPreDayAmount(AccountBalanceMode account) {
        Date bookdate = null;
        BigDecimal daybalance = BigDecimal.ZERO;
        long abankaccount = account.getBankAccount();
        long acurrency = account.getCurrency();
        Date abookdate = MonDateUtils.getCSTToDate((Date)account.getBookDate());
        for (Map.Entry<String, AccountBalanceMode> entry : this.accountMap.entrySet()) {
            AccountBalanceMode mode = entry.getValue();
            Long mbankaccount = mode.getBankAccount();
            Long mcurrency = mode.getCurrency();
            Date mbookdate = MonDateUtils.getCSTToDate((Date)mode.getBookDate());
            if (!mbankaccount.equals(abankaccount) || !mcurrency.equals(acurrency) || mbookdate.compareTo(abookdate) >= 0 || bookdate != null && mbookdate.compareTo(bookdate) <= 0) continue;
            daybalance = mode.getAmount();
            bookdate = mbookdate;
        }
        return daybalance;
    }

    public void close() {
        this.bankJournals = null;
        this.accountMap = null;
        this.accountLst = null;
    }
}

