/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.calbalance;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.tmc.mon.business.calbalance.AbstractCalBalance;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.common.enums.CalculationsEnum;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public class DiffCalBalance
extends AbstractCalBalance {
    public DiffCalBalance() {
        super(null);
    }

    public DiffCalBalance(List<AccountBalanceMode> accountLst) {
        super(accountLst);
    }

    public DiffCalBalance(LinkedHashMap<String, AccountBalanceMode> accountMap, List<AccountBalanceMode> accountLst) {
        super(accountMap, accountLst);
    }

    @Override
    public synchronized void updataAccountMap(List<AccountBalanceMode> accountLst, CalculationsEnum calEnum) {
        if (MonHelper.isEmpty((Object)this.accountMap)) {
            this.accountMap = this.accountMapAll();
        }
        for (AccountBalanceMode account : accountLst) {
            String key = this.getKey(account);
            AccountBalanceMode oldBalance = (AccountBalanceMode)this.accountMap.get(key);
            if (CalculationsEnum.Sub == calEnum) {
                if (MonHelper.isEmpty((Object)oldBalance)) continue;
                oldBalance.setCreditAmount(oldBalance.getCreditAmount().subtract(account.getCreditAmount()));
                oldBalance.setDebitAmount(oldBalance.getDebitAmount().subtract(account.getDebitAmount()));
                oldBalance.setAmount(oldBalance.getCalAmount());
            } else if (MonHelper.isEmpty((Object)oldBalance)) {
                oldBalance = account;
                oldBalance.setDayBalance(this.getPreDayAmount(oldBalance));
                oldBalance.setAmount(oldBalance.getCalAmount());
                this.accountMap.put(key, oldBalance);
            } else if (CalculationsEnum.Add == calEnum) {
                oldBalance.setCreditAmount(oldBalance.getCreditAmount().add(account.getCreditAmount()));
                oldBalance.setDebitAmount(oldBalance.getDebitAmount().add(account.getDebitAmount()));
                oldBalance.setAmount(oldBalance.getCalAmount());
            }
            this.updateLastAmount(this.accountMap, account, calEnum);
        }
    }

    private void updateLastAmount(Map<String, AccountBalanceMode> accountMap, AccountBalanceMode account, CalculationsEnum calEnum) {
        long abankaccount = account.getBankAccount();
        long acurrency = account.getCurrency();
        Date abookdate = MonDateUtils.getCSTToDate((Date)account.getBookDate());
        for (Map.Entry<String, AccountBalanceMode> entry : accountMap.entrySet()) {
            AccountBalanceMode mode = entry.getValue();
            Long mbankaccount = mode.getBankAccount();
            Long mcurrency = mode.getCurrency();
            Date mbookdate = MonDateUtils.getCSTToDate((Date)mode.getBookDate());
            if (!mbankaccount.equals(abankaccount) || !mcurrency.equals(acurrency) || mbookdate.compareTo(abookdate) <= 0) continue;
            if (CalculationsEnum.Sub == calEnum) {
                mode.setDayBalance(mode.getDayBalance().add(account.getCreditAmount()).subtract(account.getDebitAmount()));
            } else if (CalculationsEnum.Add == calEnum) {
                mode.setDayBalance(mode.getDayBalance().subtract(account.getCreditAmount()).add(account.getDebitAmount()));
            }
            mode.setAmount(mode.getCalAmount());
        }
    }
}

