/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.calbalance;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.tmc.mon.business.calbalance.AbstractCalBalance;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.common.enums.CalculationsEnum;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public class InitCalBalance
extends AbstractCalBalance {
    public InitCalBalance() {
        super(null);
    }

    public InitCalBalance(List<AccountBalanceMode> account) {
        super(account);
    }

    public InitCalBalance(LinkedHashMap<String, AccountBalanceMode> accountMap, List<AccountBalanceMode> accountLst) {
        super(accountMap, accountLst);
    }

    @Override
    public void updataAccountMap(List<AccountBalanceMode> accountLst, CalculationsEnum calEnum) {
    }

    public void getCasInitAccount(QFilter ... filters) {
        List<AccountBalanceMode> accountLst = this.getCasInitAcc(filters);
        this.initAccountMap(accountLst, CalculationsEnum.Add);
    }

    public void getCasDeInitAccount(QFilter ... filters) {
        List<AccountBalanceMode> accountLst = this.getCasInitAcc(filters);
        this.initAccountMap(accountLst, CalculationsEnum.Sub);
    }

    public synchronized void initAccountMap(List<AccountBalanceMode> accountlst, CalculationsEnum calEnum) {
        if (MonHelper.isEmpty((Object)this.accountMap)) {
            this.accountMap = this.accountMapAll();
        }
        for (AccountBalanceMode account : accountlst) {
            String key = this.getKey(account);
            AccountBalanceMode oldBalance = (AccountBalanceMode)this.accountMap.get(key);
            BigDecimal diffAmount = BigDecimal.ZERO;
            BigDecimal diffCreditAmount = BigDecimal.ZERO;
            BigDecimal diffDebitAmount = BigDecimal.ZERO;
            if (CalculationsEnum.Sub == calEnum) {
                if (MonHelper.isEmpty((Object)oldBalance)) continue;
                diffDebitAmount = oldBalance.getDebitAmount().subtract(account.getDebitAmount());
                oldBalance.setDebitAmount(diffDebitAmount);
                diffCreditAmount = oldBalance.getCreditAmount().subtract(account.getCreditAmount());
                oldBalance.setCreditAmount(diffCreditAmount);
                diffAmount = oldBalance.getAmount().subtract(account.getAmount());
                oldBalance.setAmount(diffAmount);
                oldBalance.setDayBalance(oldBalance.getCalDayBalance());
            } else if (MonHelper.isEmpty((Object)oldBalance)) {
                this.accountMap.put(key, account);
            } else if (CalculationsEnum.Add == calEnum) {
                diffDebitAmount = oldBalance.getDebitAmount().add(account.getDebitAmount());
                oldBalance.setDebitAmount(diffDebitAmount);
                diffCreditAmount = oldBalance.getCreditAmount().add(account.getCreditAmount());
                oldBalance.setCreditAmount(diffCreditAmount);
                diffAmount = oldBalance.getAmount().add(account.getAmount());
                oldBalance.setAmount(diffAmount);
                oldBalance.setDayBalance(oldBalance.getCalDayBalance());
            }
            long abankaccount = account.getBankAccount();
            long acurrency = account.getCurrency();
            Date abookdate = MonDateUtils.getCSTToDate((Date)account.getBookDate());
            for (Map.Entry entry : this.accountMap.entrySet()) {
                AccountBalanceMode mode = (AccountBalanceMode)entry.getValue();
                Long mbankaccount = mode.getBankAccount();
                Long mcurrency = mode.getCurrency();
                Date mbookdate = MonDateUtils.getCSTToDate((Date)mode.getBookDate());
                if (!mbankaccount.equals(abankaccount) || !mcurrency.equals(acurrency) || mbookdate.compareTo(abookdate) <= 0) continue;
                if (CalculationsEnum.Sub == calEnum) {
                    mode.setDayBalance(mode.getDayBalance().subtract(account.getAmount()));
                } else if (CalculationsEnum.Add == calEnum) {
                    mode.setDayBalance(mode.getDayBalance().add(account.getAmount()));
                }
                mode.setAmount(mode.getCalAmount());
            }
        }
    }
}

