/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.match;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.mon.common.builder.FormulaGetHandle;
import kd.tmc.mon.common.builder.ISingleTaskContext;
import kd.tmc.mon.common.builder.SingleTaskContext;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonDateUtils;

public class TradeMatchHelper {
    public static Map<Long, DynamicObject> getMetchResult(DynamicObject info, List<DynamicObject> dbbills) {
        long orgId = info.getLong("org");
        QFilter qFilter = new QFilter(String.format("%s.%s", "entryentity", "e_org"), "=", (Object)orgId);
        List<String> lstFiled = Arrays.asList("amountconditon_real_Tag", "sensitivecondition_real_Tag", "focusconditon_real_Tag", "questionconditon");
        DynamicObject tradeObject = QueryServiceHelper.queryOne((String)"mon_transactionplan", (String)String.join((CharSequence)",", lstFiled), (QFilter[])new QFilter[]{qFilter});
        if (MonHelper.isNotEmpty((Object)tradeObject)) {
            Map<String, DynamicProperty> fldProperties = TradeMatchHelper.getFilterProperties(info);
            boolean isMatch = TradeMatchHelper.isMatch(info, tradeObject.getString("amountconditon_real_Tag"), fldProperties);
            info.set("islargeamount", (Object)(isMatch ? "1" : "0"));
            isMatch = TradeMatchHelper.isMatch(info, tradeObject.getString("sensitivecondition_real_Tag"), fldProperties);
            info.set("issensitive", (Object)(isMatch ? "1" : "0"));
            isMatch = TradeMatchHelper.isMatch(info, tradeObject.getString("focusconditon_real_Tag"), fldProperties);
            info.set("isattention", (Object)(isMatch ? "1" : "0"));
            int days = tradeObject.getInt("questionconditon");
            if (MonHelper.isEmpty((Object)info.getDate("bookdate"))) {
                return null;
            }
            Date beginDate = MonDateUtils.getLastDay((Date)info.getDate("bookdate"), (int)days);
            Date endDate = MonDateUtils.getNextDay((Date)info.getDate("bookdate"), (int)days);
            List collDB = dbbills.stream().filter(v -> info.getLong("bankjournalid") != v.getLong("bankjournalid") && (TradeMatchHelper.isDiffDays(v.getDate("bookdate"), beginDate, days) || TradeMatchHelper.isDiffDays(endDate, v.getDate("bookdate"), days)) && v.getLong("accountbank_id") == info.getLong("accountbank") && v.getString("oppacctnumber").equals(info.getString("oppacctnumber")) && v.getLong("direction") == info.getLong("direction") && v.getLong("creditamount") == info.getLong("creditamount") && v.getLong("debitamount") == info.getLong("debitamount")).collect(Collectors.toList());
            int count = collDB.size();
            info.set("isdoubt", (Object)(count > 0 ? "1" : "0"));
            LinkedHashMap<Long, DynamicObject> resultMap = new LinkedHashMap<Long, DynamicObject>(10);
            for (DynamicObject bill : collDB) {
                bill.set("isdoubt", (Object)"1");
                resultMap.put(bill.getLong("bankjournalid"), bill);
            }
            return resultMap;
        }
        return null;
    }

    private static Map<String, DynamicProperty> getFilterProperties(DynamicObject info) {
        HashMap<String, DynamicProperty> fldProperties = new HashMap<String, DynamicProperty>(10);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"mon_bankjournal");
        ArrayList<String> selProps = new ArrayList<String>();
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propName;
            if (StringUtils.isBlank((CharSequence)property.getAlias()) || (propName = property.getName()).contains("_id")) continue;
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                DataEntityPropertyCollection bdProperties = bdProp.getComplexType().getProperties();
                for (IDataEntityProperty prop : bdProperties) {
                    if (StringUtils.isBlank((CharSequence)prop.getAlias())) continue;
                    String secPropName = propName + "." + prop.getName();
                    if (prop instanceof BasedataProp) {
                        BasedataProp tProp = (BasedataProp)prop;
                        DataEntityPropertyCollection tProperties = tProp.getComplexType().getProperties();
                        for (IDataEntityProperty tp : tProperties) {
                            if (StringUtils.isBlank((CharSequence)tp.getAlias())) continue;
                            selProps.add(secPropName + "." + tp.getName());
                        }
                        continue;
                    }
                    selProps.add(secPropName);
                }
                continue;
            }
            selProps.add(propName);
        }
        DynamicObjectType dType = info.getDynamicObjectType();
        for (String prop : selProps) {
            fldProperties.put(prop, dType.getProperty(prop));
        }
        return fldProperties;
    }

    private static boolean isMatch(DynamicObject object, String filterStr, Map<String, DynamicProperty> fldProperties) {
        boolean isMatch = false;
        if (MonHelper.isNotEmpty((Object)filterStr)) {
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)"mon_bankjournal");
            String baseFilterStr = filterObj.buildFullFormula(mainEntityType);
            SingleTaskContext taskContext = new SingleTaskContext();
            taskContext.setSrcEntityType(mainEntityType);
            if (MonHelper.isNotEmpty((Object)baseFilterStr)) {
                FormulaGetHandle basebillFilterHandle = new FormulaGetHandle((ISingleTaskContext)taskContext, baseFilterStr, (Object)Boolean.FALSE);
                isMatch = (Boolean)basebillFilterHandle.GetVchFldValue(fldProperties, object, null);
            }
        }
        return isMatch;
    }

    private static boolean isDiffDays(Date beginDate, Date endDate, int days) {
        if (MonHelper.isEmpty((Object)beginDate) || MonHelper.isEmpty((Object)endDate)) {
            return false;
        }
        int diffDays = MonDateUtils.getDiffDays((Date)(beginDate = MonDateUtils.getDataFormat((Date)beginDate, (boolean)true)), (Date)(endDate = MonDateUtils.getDataFormat((Date)endDate, (boolean)true)));
        return Math.abs(diffDays) <= days;
    }
}

