/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.query;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.dataset.groupby.GroupByRow;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.tmc.balancemodel.BalanceValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.business.balance.BuildDataSet;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.ExtendConfigHelper;

public class AccountMoneyService {
    private static Log logger = LogFactory.getLog(AccountMoneyService.class);
    private static final String[] FIELDS = new String[]{"rankfield", "reportamt", "currency", "org", "orgid", "bank", "acctid", "openorg", "acctnumber", "accttype", "acctprop", "acctuser", "amount", "sort", "color", "bookdate", "cur"};
    private static final DataType[] DATA_TYPES = new DataType[]{DataType.IntegerType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.BigDecimalType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.LongType};
    private static final String BANK_JOURNAL_REPORT_FIELDS = "3 rankfield,0.00 reportamt,currency.name as currency,org.name as org,org.id as orgid,bankaccount.bank.bank_cate.name as bank,bankaccount.id as acctid,bankaccount.openorg.name as openorg,bankaccount.bankaccountnumber as acctnumber,bankaccount.acctstyle as accttype, bankaccount.accttype as acctprop,bankaccount.acctproperty.name as acctuser,amount,'1' sort,0 color,bookdate,currency.id as cur";
    private static final String BANK_BALANCE_REPORT_FIELDS = "3 rankfield,0.00 reportamt,currency.name as currency,company.name as org,company.id as orgid,accountbank.bank.bank_cate.name as bank,accountbank.id as acctid,accountbank.openorg.name as openorg,accountbank.bankaccountnumber as acctnumber,accountbank.acctstyle as accttype, accountbank.accttype as acctprop,accountbank.acctproperty.name as acctuser,amount,'1' sort,0 color,bizdate as bookdate,currency.id as cur";

    public static List<Long> getAcctIds(DynamicObjectCollection balanceCurrency, DynamicObjectCollection bankFi, String acctPropFi, String acctTypeFi, DynamicObjectCollection acctUserFi, List<Long> orgFiList, boolean statsInnerAcct) {
        ArrayList<QFilter> acctFilters = new ArrayList<QFilter>();
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", orgFiList, (boolean)true);
        acctFilters.add(orgFilter);
        acctFilters.add(new QFilter("acctstatus", "!=", (Object)"closed"));
        acctFilters.add(new QFilter("isvirtual", "=", (Object)"0"));
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceCurrency)) {
            Long[] curIds = (Long[])balanceCurrency.stream().map(e -> e.getLong("id")).toArray(Long[]::new);
            acctFilters.add(new QFilter("currency.fbasedataid", "in", (Object)curIds));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bankFi)) {
            Long[] bankCateIds = (Long[])bankFi.stream().map(e -> e.getLong("id")).toArray(Long[]::new);
            acctFilters.add(new QFilter("bank.bank_cate", "in", (Object)bankCateIds));
        }
        if (acctPropFi != null && !"".equals(acctPropFi)) {
            String[] acctTypes = acctPropFi.substring(1, acctPropFi.length()).split(",");
            acctFilters.add(new QFilter("accttype", "in", (Object)acctTypes));
        }
        if (acctTypeFi != null && !"".equals(acctTypeFi)) {
            String[] accStyles = acctTypeFi.substring(1, acctTypeFi.length()).split(",");
            acctFilters.add(new QFilter("acctstyle", "in", (Object)accStyles));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)acctUserFi)) {
            Long[] ids = (Long[])acctUserFi.stream().map(e -> e.getLong("id")).toArray(Long[]::new);
            acctFilters.add(new QFilter("acctproperty", "in", (Object)ids));
        }
        if (!statsInnerAcct) {
            acctFilters.add(new QFilter("inneracct", "=", (Object)0L));
        }
        DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])acctFilters.toArray(new QFilter[0]));
        return accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    public static QFilter[] getQFilters(String datesource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if ("bankbalance".equals(datesource)) {
            qFilters.add(new QFilter("company", "in", orgIds));
            qFilters.add(new QFilter("bizdate", "<=", (Object)balanceDate));
            qFilters.add(new QFilter("accountbank", "in", acctIds));
        } else {
            qFilters.add(new QFilter("org", "in", orgIds));
            qFilters.add(new QFilter("bookdate", "<=", (Object)balanceDate));
            qFilters.add(new QFilter("bankaccount", "in", acctIds));
        }
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)balanceCurrency)) {
            Long[] curIds = (Long[])balanceCurrency.stream().map(e -> e.getLong("id")).toArray(Long[]::new);
            qFilters.add(new QFilter("currency", "in", (Object)curIds));
        }
        return qFilters.toArray(new QFilter[0]);
    }

    public static DataSet queryFromBankJournal(String fileds, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)"AccountMoneyService", (String)"cas_accountbalance", (String)fileds, (QFilter[])filters, (String)"");
    }

    public static DataSet queryFromBankBalance(String fileds, QFilter[] filters) {
        return QueryServiceHelper.queryDataSet((String)"AccountMoneyService", (String)"bei_bankbalance", (String)fileds, (QFilter[])filters, (String)"");
    }

    public static DataSet queryCurrencyData(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        DataSet currencyData = null;
        switch (datasource) {
            case "bankjournal": {
                QFilter[] jFilters = AccountMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                currencyData = AccountMoneyService.queryFromBankJournal("currency", jFilters);
                break;
            }
            case "bankbalance": {
                QFilter[] bFilters = AccountMoneyService.getQFilters(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
                currencyData = AccountMoneyService.queryFromBankBalance("currency", bFilters);
                break;
            }
            case "directconnacct": {
                DynamicObjectCollection acctColls = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : acctColls) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                DataSet journal = null;
                if (EmptyUtil.isNoEmpty(noDirectIds)) {
                    QFilter[] journalFilter = AccountMoneyService.getQFilters("bankjournal", balanceDate, balanceCurrency, orgIds, noDirectIds);
                    journal = AccountMoneyService.queryFromBankJournal("currency", journalFilter);
                }
                DataSet balance = null;
                if (EmptyUtil.isNoEmpty(directIds)) {
                    QFilter[] balanceFilter = AccountMoneyService.getQFilters("bankbalance", balanceDate, balanceCurrency, orgIds, directIds);
                    balance = AccountMoneyService.queryFromBankBalance("currency", balanceFilter);
                }
                currencyData = null != journal && null != balance ? journal.union(balance) : (null != journal ? journal : balance);
            }
        }
        return currencyData;
    }

    public static DataSet queryBalanceData(String datesource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        DataSet dataset = null;
        switch (datesource) {
            case "bankjournal": {
                dataset = AccountMoneyService.getBankJournalBal(datesource, balanceDate, balanceCurrency, orgIds, acctIds);
                break;
            }
            case "bankbalance": {
                QFilter[] bFilters = AccountMoneyService.getQFilters("bankbalance", balanceDate, balanceCurrency, orgIds, acctIds);
                dataset = AccountMoneyService.queryFromBankBalance(BANK_BALANCE_REPORT_FIELDS, bFilters);
                break;
            }
            case "directconnacct": {
                DynamicObjectCollection acctColls = QueryServiceHelper.query((String)"am_accountbank", (String)"id,finorgtype,issetbankinterface", (QFilter[])new QFilter[]{new QFilter("id", "in", acctIds)});
                ArrayList<Long> directIds = new ArrayList<Long>();
                ArrayList<Long> noDirectIds = new ArrayList<Long>();
                for (DynamicObject acct : acctColls) {
                    Long id = acct.getLong("id");
                    String finorgtype = acct.getString("finorgtype");
                    boolean issetbankinterface = acct.getBoolean("issetbankinterface");
                    if ("1".equals(finorgtype) || "3".equals(finorgtype) || issetbankinterface) {
                        directIds.add(id);
                        continue;
                    }
                    noDirectIds.add(id);
                }
                QFilter[] balanceFilter = AccountMoneyService.getQFilters("bankbalance", balanceDate, balanceCurrency, orgIds, directIds);
                DataSet journalDataSet = AccountMoneyService.getBankJournalBal(datesource, balanceDate, balanceCurrency, orgIds, noDirectIds);
                DataSet balanceDataSet = AccountMoneyService.queryFromBankBalance(BANK_BALANCE_REPORT_FIELDS, balanceFilter);
                dataset = journalDataSet.union(balanceDataSet);
            }
        }
        return dataset;
    }

    public static DataSet getDetailDataSet(DataSet dataSet, Long rptCurId, Date balanceDate) {
        return AccountMoneyService.getDetailDataSet(dataSet, rptCurId, balanceDate, 0L, "1");
    }

    public static DataSet getDetailDataSet(DataSet dataSet, Long rptCurId, Date balanceDate, long exchangeRateTableId, String currUnit) {
        if (dataSet == null) {
            return AccountMoneyService.createEmptyDataSet();
        }
        long orgId = RequestContext.get().getOrgId();
        DataSet maxData = dataSet.copy().groupBy(new String[]{"acctid", "orgid", "cur"}).max("bookdate").finish();
        HashSet<String> maxKeySet = new HashSet<String>();
        HashSet<Long> srcCurIds = new HashSet<Long>();
        for (Row row : maxData) {
            Long rowCurId = row.getLong("cur");
            String maxRowKey = String.valueOf(row.getLong("acctid")) + String.valueOf(row.getLong("orgid")) + String.valueOf(rowCurId) + String.valueOf(row.getDate("bookdate").getTime());
            maxKeySet.add(maxRowKey);
            srcCurIds.add(rowCurId);
        }
        Map exRateMap = BaseDataHelper.getExchangeRate(new ArrayList(srcCurIds), (Long)rptCurId, (Long)orgId, (Date)balanceDate);
        Iterator iterator = dataSet.iterator();
        ArrayList<Object[]> detailList = new ArrayList<Object[]>();
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        while (iterator.hasNext()) {
            String rowKey;
            Row row = (Row)iterator.next();
            Long rowAcctId = row.getLong("acctid");
            Long rowOrgId = row.getLong("orgid");
            Long rowCurId = row.getLong("cur");
            Date rowBookDate = row.getDate("bookdate");
            if (null == rowAcctId || null == rowOrgId || null == rowCurId || null == rowBookDate || !maxKeySet.contains(rowKey = String.valueOf(rowAcctId) + String.valueOf(rowOrgId) + String.valueOf(rowCurId) + String.valueOf(rowBookDate.getTime()))) continue;
            BigDecimal rowAmt = row.getBigDecimal("amount");
            Object[] arr = new Object[fields.length];
            block40: for (int i = 0; i < fields.length; ++i) {
                String filedName;
                switch (filedName = fields[i].getName()) {
                    case "rankfield": {
                        arr[i] = row.get("rankfield");
                        continue block40;
                    }
                    case "currency": {
                        arr[i] = row.get("currency");
                        continue block40;
                    }
                    case "org": {
                        arr[i] = row.get("org");
                        continue block40;
                    }
                    case "bank": {
                        arr[i] = row.get("bank");
                        continue block40;
                    }
                    case "acctnumber": {
                        arr[i] = row.get("acctnumber");
                        continue block40;
                    }
                    case "accttype": {
                        arr[i] = row.get("accttype");
                        continue block40;
                    }
                    case "acctprop": {
                        arr[i] = row.get("acctprop");
                        continue block40;
                    }
                    case "acctuser": {
                        arr[i] = row.get("acctuser");
                        continue block40;
                    }
                    case "amount": {
                        arr[i] = rowAmt.divide(new BigDecimal(currUnit), RoundingMode.HALF_UP);
                        continue block40;
                    }
                    case "sort": {
                        arr[i] = row.get("sort");
                        continue block40;
                    }
                    case "color": {
                        arr[i] = row.get("color");
                        continue block40;
                    }
                    case "cur": {
                        arr[i] = rowCurId;
                        continue block40;
                    }
                    case "bookdate": {
                        arr[i] = rowBookDate;
                        continue block40;
                    }
                    case "orgid": {
                        arr[i] = rowOrgId;
                        continue block40;
                    }
                    case "reportamt": {
                        BigDecimal exRate;
                        if (exchangeRateTableId > 0L) {
                            exRate = BigDecimal.ZERO;
                            if (row.getLong("cur").equals(rptCurId)) {
                                exRate = BigDecimal.ONE;
                            } else {
                                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)row.getLong("cur"), (Long)rptCurId, (Date)balanceDate);
                                if (exRate == null) {
                                    exRate = BigDecimal.ZERO;
                                }
                            }
                            arr[i] = rowAmt.multiply(exRate).divide(new BigDecimal(currUnit), RoundingMode.HALF_UP);
                            continue block40;
                        }
                        exRate = (BigDecimal)exRateMap.get(rowCurId);
                        arr[i] = rowAmt.multiply(exRate).divide(new BigDecimal(currUnit), RoundingMode.HALF_UP);
                        continue block40;
                    }
                    case "acctid": {
                        arr[i] = rowAcctId;
                        continue block40;
                    }
                    case "openorg": {
                        arr[i] = row.getString("openorg");
                    }
                }
            }
            detailList.add(arr);
        }
        return Algo.create((String)"AccountMoneyService").createDataSet(detailList, rowMeta);
    }

    /*
     * WARNING - void declaration
     */
    public static DataSet queryByOthers(String calculateStyle, DynamicObject reportCurrency, Date balanceDate, DataSet dataSet, String[] sortFields, long exchangeRateTableId) {
        void var16_19;
        Long rptCurId = reportCurrency.getLong("id");
        DataSet copy2 = dataSet.copy();
        DataSet calcGroup = copy2.groupBy(AccountMoneyService.getGroupFields(calculateStyle)).sum("amount").finish();
        Iterator calcIter = calcGroup.iterator();
        HashMap<String, BigDecimal> calcAmtMap = new HashMap<String, BigDecimal>();
        Field[] fields = dataSet.getRowMeta().getFields();
        ArrayList<Object[]> calcTotalList = new ArrayList<Object[]>(10);
        while (calcIter.hasNext()) {
            Row row = (Row)calcIter.next();
            Long rowCurId = row.getLong("cur");
            String string = row.getString(calculateStyle);
            BigDecimal rowAmt = row.getBigDecimal("amount");
            Object[] calcArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "currency": {
                        calcArr[i] = row.get("currency") + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
                        break;
                    }
                    case "amount": {
                        calcArr[i] = rowAmt;
                        break;
                    }
                    case "sort": {
                        calcArr[i] = "1";
                        break;
                    }
                    case "color": {
                        calcArr[i] = 1;
                        break;
                    }
                    case "cur": {
                        calcArr[i] = rowCurId;
                        break;
                    }
                    case "org": {
                        if (!Arrays.stream(((GroupByRow)row).getRowMeta().getFields()).anyMatch(o -> o.equals((Object)name))) break;
                        calcArr[i] = row.get("org");
                        break;
                    }
                    case "orgid": {
                        if (!Arrays.asList(((GroupByRow)row).getRowMeta().getFieldNames()).contains(name)) break;
                        calcArr[i] = row.get("orgid");
                    }
                }
                if (!calculateStyle.equals(name)) continue;
                calcArr[i] = string;
            }
            calcTotalList.add(calcArr);
            BigDecimal calcAmt = calcAmtMap.containsKey(string) ? (BigDecimal)calcAmtMap.get(string) : BigDecimal.ZERO;
            BigDecimal exRate = BigDecimal.ZERO;
            if (row.getLong("cur").equals(rptCurId)) {
                exRate = BigDecimal.ONE;
            } else {
                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)row.getLong("cur"), (Long)rptCurId, (Date)balanceDate);
                if (exRate == null) {
                    exRate = BigDecimal.ZERO;
                }
            }
            calcAmt = calcAmt.add(rowAmt.multiply(exRate));
            calcAmtMap.put(string, calcAmt);
        }
        BigDecimal totalAmt = BigDecimal.ZERO;
        for (Map.Entry entry : calcAmtMap.entrySet()) {
            String styleVal = (String)entry.getKey();
            BigDecimal styleAmt = (BigDecimal)entry.getValue();
            totalAmt = totalAmt.add(styleAmt);
            Object[] styleArr = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "amount": {
                        styleArr[i] = styleAmt;
                        break;
                    }
                    case "sort": {
                        styleArr[i] = "1";
                        break;
                    }
                    case "color": {
                        styleArr[i] = 2;
                        break;
                    }
                    case "cur": {
                        styleArr[i] = rptCurId;
                    }
                }
                if (!calculateStyle.equals(name)) continue;
                styleArr[i] = styleVal == null ? " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]) : styleVal + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
            }
            calcTotalList.add(styleArr);
        }
        Object[] reportArr = new Object[fields.length];
        boolean bl = false;
        while (var16_19 < fields.length) {
            String name;
            switch (name = fields[var16_19].getName()) {
                case "currency": {
                    reportArr[var16_19] = ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd", (String)"AccountMoneySumListDataPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]) + " " + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountMoneySumListDataPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                    break;
                }
                case "amount": {
                    reportArr[var16_19] = totalAmt;
                    break;
                }
                case "sort": {
                    reportArr[var16_19] = "2";
                    break;
                }
                case "color": {
                    reportArr[var16_19] = 3;
                    break;
                }
                case "cur": {
                    reportArr[var16_19] = rptCurId;
                }
            }
            ++var16_19;
        }
        calcTotalList.add(reportArr);
        DataSet dataSet2 = Algo.create((String)"AccountMoneyService").createDataSet(calcTotalList, dataSet.getRowMeta());
        DataSet union = dataSet.union(dataSet2);
        return union.orderBy(new String[]{"sort", calculateStyle, "cur", "currency asc", sortFields[1], sortFields[2]});
    }

    public static DataSet queryByCurrency(DynamicObject reportCurrency, Date balanceDate, DataSet detailDataSet, String[] sortFields, long exchangeRateTableId) {
        ArrayList<Object[]> curList = new ArrayList<Object[]>();
        RowMeta rowMeta = detailDataSet.getRowMeta();
        Field[] fields = detailDataSet.getRowMeta().getFields();
        BigDecimal totalAmt = BigDecimal.ZERO;
        Long rptCurId = reportCurrency.getLong("id");
        DataSet curGroup = detailDataSet.copy().groupBy(new String[]{"cur", "currency"}).sum("amount").finish();
        for (Row row : curGroup) {
            Long rowCurId = row.getLong("cur");
            BigDecimal rowAmt = row.getBigDecimal("amount");
            Object[] curArr = new Object[fields.length];
            block29: for (int i = 0; i < fields.length; ++i) {
                String name;
                switch (name = fields[i].getName()) {
                    case "currency": {
                        curArr[i] = row.get("currency") + " " + ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"AccountMoneySumListDataPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
                        continue block29;
                    }
                    case "amount": {
                        curArr[i] = rowAmt;
                        continue block29;
                    }
                    case "sort": {
                        curArr[i] = "1";
                        continue block29;
                    }
                    case "color": {
                        curArr[i] = 1;
                        continue block29;
                    }
                    case "cur": {
                        curArr[i] = rowCurId;
                    }
                }
            }
            curList.add(curArr);
            BigDecimal exRate = BigDecimal.ZERO;
            if (rowCurId.equals(rptCurId)) {
                exRate = BigDecimal.ONE;
            } else {
                exRate = BaseDataServiceHelper.getExchangeRate((Long)exchangeRateTableId, (Long)rowCurId, (Long)rptCurId, (Date)balanceDate);
                if (exRate == null) {
                    exRate = BigDecimal.ZERO;
                }
            }
            BigDecimal exAmt = rowAmt.multiply(exRate);
            totalAmt = totalAmt.add(exAmt);
        }
        Object[] rptArr = new Object[fields.length];
        block30: for (int i = 0; i < fields.length; ++i) {
            String name;
            switch (name = fields[i].getName()) {
                case "currency": {
                    rptArr[i] = ResManager.loadKDString((String)"\u7edf\u8ba1\u5e01\u79cd", (String)"AccountMoneySumListDataPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]) + " " + ResManager.loadKDString((String)"\u5408\u8ba1", (String)"AccountMoneySumListDataPlugin_2", (String)"tmc-mon-report", (Object[])new Object[0]);
                    continue block30;
                }
                case "amount": {
                    rptArr[i] = totalAmt;
                    continue block30;
                }
                case "sort": {
                    rptArr[i] = "2";
                    continue block30;
                }
                case "color": {
                    rptArr[i] = 3;
                    continue block30;
                }
                case "cur": {
                    rptArr[i] = rptCurId;
                }
            }
        }
        curList.add(rptArr);
        DataSet totalDataSet = Algo.create((String)"AccountMoneyService").createDataSet(curList, rowMeta);
        DataSet allData = detailDataSet.union(totalDataSet);
        return allData.orderBy(new String[]{"sort", "cur", "currency asc", sortFields[0], sortFields[1], sortFields[2]});
    }

    public static DataSet createEmptyDataSet() {
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELDS, (DataType[])DATA_TYPES);
        return Algo.create((String)"AccountMoneyService.createEmptyDataSet").createDataSet(new ArrayList(), rowMeta);
    }

    private static DataSet getBankJournalBal(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        if (ExtendConfigHelper.useBalanceModel()) {
            acctIds.add(-11111L);
            return AccountMoneyService.newBankJournalBal(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
        }
        QFilter[] jFilters = AccountMoneyService.getQFilters("bankjournal", balanceDate, balanceCurrency, orgIds, acctIds);
        return AccountMoneyService.queryFromBankJournal(BANK_JOURNAL_REPORT_FIELDS, jFilters);
    }

    private static DataSet newBankJournalBal(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        List<BalanceValue> values = AccountMoneyService.queryFromBankJournal(datasource, balanceDate, balanceCurrency, orgIds, acctIds);
        DataSet ds = new BuildDataSet().buildBalanceDataSet(values);
        return AccountMoneyService.getSpecFieldDs(ds);
    }

    private static List<BalanceValue> queryFromBankJournal(String datasource, Date balanceDate, DynamicObjectCollection balanceCurrency, List<Long> orgIds, List<Long> acctIds) {
        HashSet<Long> orgs = new HashSet<Long>(orgIds);
        HashSet<Long> accts = new HashSet<Long>(acctIds);
        Set<Long> currencys = AccountMoneyService.filterSet(balanceCurrency);
        return (List)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cas", (String)"BalanceCountService", (String)"getBankJournalBal", (Object[])new Object[]{2, 2, 3, balanceDate, balanceDate, 0L, 0L, null, accts, currencys, orgs});
    }

    private static DataSet getSpecFieldDs(DataSet ds) {
        return ds.select(new String[]{"3 rankfield", "0.00 reportamt", "fcurrencyname as currency", "forgname as org", "forgid as orgid", "frptbanktype as bank", "facctid as acctid", "forgname as openorg", "facctnumber as acctnumber", "facctstyle as accttype", "faccttype as acctprop", "facctpurpose as acctuser", "fbalance as amount", "'1' as sort", "0 as color", "fstartdate as bookdate", "fcurrencyid as cur"});
    }

    private static Set<Long> filterSet(DynamicObjectCollection cols) {
        if (cols != null) {
            return cols.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>();
    }

    private static String[] getGroupFields(String calculateStyle) {
        String[] groupFields;
        switch (calculateStyle) {
            case "org": {
                groupFields = new String[]{"cur", calculateStyle, "orgid", "currency"};
                break;
            }
            case "bank": 
            case "acctprop": 
            case "accttype": 
            case "acctuser": {
                groupFields = new String[]{"cur", calculateStyle, "currency"};
                break;
            }
            default: {
                groupFields = new String[]{""};
            }
        }
        return groupFields;
    }
}

