/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.business.task;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.mon.business.convert.BankJournalCopyConverter;
import kd.tmc.mon.business.match.TradeMatchHelper;
import kd.tmc.mon.business.mode.AccountBalanceMode;
import kd.tmc.mon.business.task.SynDataFacade;
import kd.tmc.mon.common.helper.MonHelper;

public class BankJournalHelper {
    private static Log logger = LogFactory.getLog(SynDataFacade.class);

    public static Map<Long, DynamicObject> convertor(List<DynamicObject> bills) {
        BankJournalCopyConverter converter = new BankJournalCopyConverter();
        LinkedHashMap<Long, DynamicObject> monJournaMap = new LinkedHashMap<Long, DynamicObject>(10);
        for (DynamicObject object : bills) {
            monJournaMap.put(object.getLong("id"), converter.convertToTargetBill(object));
        }
        return monJournaMap;
    }

    public static List<AccountBalanceMode> journalToAccounts(List<DynamicObject> journalLst) {
        List<AccountBalanceMode> accountLst = journalLst.stream().map(t -> {
            AccountBalanceMode model = new AccountBalanceMode();
            model.setOrgId(t.getLong("org"));
            model.setBookDate(t.getDate("bookdate"));
            model.setBankAccount(t.getLong("accountbank"));
            model.setCurrency(t.getLong("currency"));
            model.setCreditAmount(t.getBigDecimal("creditamount"));
            model.setDebitAmount(t.getBigDecimal("debitamount"));
            return model;
        }).collect(Collectors.toList());
        return accountLst;
    }

    public static List<DynamicObject> casFetchAll() {
        Set<Long> bankJournalIds = BankJournalHelper.getBankJournalIds();
        QFilter qFilter = new QFilter("id", "not in", bankJournalIds);
        List<DynamicObject> fetch = BankJournalHelper.casFetch(qFilter);
        return fetch;
    }

    public static List<DynamicObject> casFetch(QFilter ... qFilters) {
        DynamicObjectCollection casBankJournal = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,bizdate,bookdate,period,accountbank,debitamount,creditamount,direction,source,exchangerate,localamount,settlementnumber,oppunit,oppbank,oppacctnumber,cashier,sourcebillnumber,settlementtype,sourcebillid,sourcebilltype,relatedbizdate,ticketnumber,lineno,batchno,bankcheckflag,description,currency,basecurrency,creator_id,modifier_id,auditor_id ,org_id,period_id,accountbank_id,cashier_id,settlementtype_id,currency_id,basecurrency_id", (QFilter[])qFilters, (String)"bookdate asc");
        return casBankJournal;
    }

    public static List<Long> casFetch(String fields, QFilter ... filters) {
        if (MonHelper.isEmpty((Object)filters)) {
            filters = new QFilter[]{new QFilter("id", "not in", (Object)0L), new QFilter("bookdate", "is not null", null)};
        }
        DynamicObjectCollection casBankJournal = QueryServiceHelper.query((String)"cas_bankjournal", (String)fields, (QFilter[])filters, (String)"bookdate asc");
        return casBankJournal.stream().map(vaule -> vaule.getLong("id")).collect(Collectors.toList());
    }

    public static List<DynamicObject> monFetchAll() {
        QFilter qFilter = new QFilter("id", "not in", (Object)0L);
        List<DynamicObject> fetch = BankJournalHelper.monFetch(qFilter);
        return fetch;
    }

    public static List<DynamicObject> monFetch(QFilter ... qFilters) {
        DynamicObjectCollection monBankJournal = QueryServiceHelper.query((String)"mon_bankjournal", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,bizdate,bookdate,period,accountbank,debitamount,creditamount,direction,source,exchangerate,localamount,settlementnumber,oppunit,oppbank,oppacctnumber,cashier,sourcebillnumber,settlementtype,sourcebillid,sourcebilltype,relatedbizdate,ticketnumber,lineno,batchno,bankcheckflag,description,currency,basecurrency,creator_id,modifier_id,auditor_id ,org_id,period_id,accountbank_id,cashier_id,settlementtype_id,currency_id,basecurrency_id,bankjournalid,acctgroup_id,isinternal,recpaytype,recpaytypeid_id,recpayertype,recpayer_id,islargeamount,issensitive,isattention,isdoubt,isupdatebalance", (QFilter[])qFilters, (String)"bookdate asc");
        return monBankJournal;
    }

    public static List<Long> monFetch(String fields, QFilter ... filters) {
        if (MonHelper.isEmpty((Object)filters)) {
            filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
        }
        DynamicObjectCollection monJournals = QueryServiceHelper.query((String)"mon_bankjournal", (String)fields, (QFilter[])filters, (String)"bookdate asc");
        return monJournals.stream().map(vaule -> vaule.getLong("id")).collect(Collectors.toList());
    }

    public static Set<Long> getBankJournalIds() {
        QFilter upFilter = new QFilter("isupdatebalance", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection monBankJournal = QueryServiceHelper.query((String)"mon_bankjournal", (String)"bankjournalid", (QFilter[])new QFilter[]{upFilter});
        Set<Long> bankJournalIds = monBankJournal.stream().map(v -> v.getLong("bankjournalid")).collect(Collectors.toSet());
        return bankJournalIds;
    }

    public static void updateBillValue(Map<Long, DynamicObject> rangJournal, List<DynamicObject> journalAll) {
        if (MonHelper.isNotEmpty(rangJournal)) {
            logger.info("BankJournalHelper-updateBillValue:rangJournal:" + rangJournal.size());
        }
        LinkedHashMap<Long, DynamicObject> dbUpdateBill = new LinkedHashMap<Long, DynamicObject>(10);
        for (Map.Entry<Long, DynamicObject> entry : rangJournal.entrySet()) {
            DynamicObject bill = entry.getValue();
            bill.set("isupdatebalance", (Object)Boolean.FALSE);
            BankJournalHelper.updateRecPayInfo(bill);
            bill.set("isinternal", (Object)BankJournalHelper.isInternal(bill));
            Map<Long, DynamicObject> result = TradeMatchHelper.getMetchResult(bill, journalAll);
            if (MonHelper.isNotEmpty(result)) {
                dbUpdateBill.putAll(result);
            }
            logger.info("BankJournalHelper-updateBillValue:updateBill");
        }
        rangJournal.putAll(dbUpdateBill);
        List<DynamicObject> journalLst = rangJournal.values().stream().map(journal -> {
            DynamicObject mode = BusinessDataServiceHelper.newDynamicObject((String)"mon_bankjournal");
            mode.set("id", (Object)journal.getLong("id"));
            mode.set("isinternal", (Object)journal.getString("isinternal"));
            mode.set("islargeamount", (Object)journal.getString("islargeamount"));
            mode.set("issensitive", (Object)journal.getString("issensitive"));
            mode.set("isattention", (Object)journal.getString("isattention"));
            mode.set("isdoubt", (Object)journal.getString("isdoubt"));
            mode.set("recpaytype", (Object)journal.getString("recpaytype"));
            mode.set("recpaytypeid_id", (Object)journal.getLong("recpaytypeid_id"));
            mode.set("recpayertype", (Object)journal.getString("recpayertype"));
            mode.set("recpayer_id", (Object)journal.getLong("recpayer_id"));
            return mode;
        }).collect(Collectors.toList());
        SaveServiceHelper.update((DynamicObject[])journalLst.toArray(new DynamicObject[0]));
    }

    private static void updateRecPayInfo(DynamicObject bill) {
        if (MonHelper.isNotEmpty((Object)bill.getString("sourcebilltype")) && MonHelper.isNotEmpty((Object)bill.getString("sourcebillnumber"))) {
            DynamicObject billInfo = null;
            String billType = bill.getString("sourcebilltype");
            String billId = bill.getString("sourcebillid");
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", (Object)billId)};
            switch (billType) {
                case "cas_paybill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"paymenttype,payeetype,payee", (QFilter[])qFilters);
                    if (!MonHelper.isNotEmpty((Object)billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_paymentbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("payee"));
                    break;
                }
                case "cas_recbill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_recbill", (String)"receivingtype,payertype,payer", (QFilter[])qFilters);
                    if (!MonHelper.isNotEmpty((Object)billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_receivingbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("receivingtype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payertype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("payer"));
                    break;
                }
                case "cas_agentpaybill": {
                    billInfo = QueryServiceHelper.queryOne((String)"cas_agentpaybill", (String)"paymenttype,payeetype,entry.payee", (QFilter[])qFilters);
                    if (!MonHelper.isNotEmpty((Object)billInfo)) break;
                    bill.set("recpaytype", (Object)"cas_paymentbilltype");
                    bill.set("recpaytypeid_id", (Object)billInfo.getLong("paymenttype"));
                    bill.set("recpayertype", (Object)billInfo.getString("payeetype"));
                    bill.set("recpayer_id", (Object)billInfo.getLong("entry.payee"));
                    break;
                }
            }
        }
    }

    private static boolean isInternal(DynamicObject bill) {
        String recpayertype = bill.getString("recpayertype");
        Long recpayer = bill.getLong("recpayer_id");
        if (recpayer == 0L || MonHelper.isEmpty((Object)recpayertype)) {
            return false;
        }
        if (!recpayertype.equals("bd_supplier") && !recpayertype.equals("bd_customer")) {
            return false;
        }
        try {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)recpayer, (String)recpayertype);
            if (MonHelper.isNotEmpty((Object)object)) {
                return object.getLong("internal_company_id") > 0L;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static void clearBankJournal() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "not in", (Object)0L)};
        BankJournalHelper.deleteBankJournal(filters);
    }

    public static void deleteBankJournal(QFilter ... filters) {
        DeleteServiceHelper.delete((String)"mon_bankjournal", (QFilter[])filters);
    }
}

