/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.common.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.EntityMetadataUtils;
import kd.tmc.mon.common.util.MonStringUtils;

public class DynamicObjectHelper {
    public static Object getValue(DynamicObject obj, String filedName) {
        if (MonHelper.isEmpty(obj)) {
            return null;
        }
        boolean isEntryProp = obj.getDataEntityType() instanceof EntryType;
        boolean isContainsSubAttribute = false;
        String[] segmentedFields = filedName.split("[.]");
        String realFieldName = segmentedFields[0];
        if (isEntryProp && segmentedFields[0].equalsIgnoreCase(obj.getDataEntityType().getName())) {
            realFieldName = segmentedFields[1];
            isContainsSubAttribute = segmentedFields.length > 2;
        } else {
            boolean bl = isContainsSubAttribute = segmentedFields.length > 1;
        }
        if (!EntityMetadataUtils.containsProperty(obj.getDataEntityType(), realFieldName)) {
            obj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)obj.getDataEntityType().getName(), (String)realFieldName);
        }
        Object temValue = obj.get(realFieldName);
        if (isContainsSubAttribute) {
            return DynamicObjectHelper.getValue((DynamicObject)temValue, MonStringUtils.getSubfix(filedName));
        }
        if (temValue instanceof ILocaleString) {
            return ((ILocaleString)temValue).getLocaleValue();
        }
        return temValue;
    }

    public static String getBasedataNumber(DynamicObject basedata) {
        if (basedata == null) {
            return null;
        }
        BasedataEntityType dataEntityType = (BasedataEntityType)basedata.getDataEntityType();
        String numberProperty = dataEntityType.getNumberProperty();
        return basedata.getString(numberProperty);
    }

    public static void setValue(DynamicObject obj, String prop, Object value) {
        if (value instanceof DynamicObject) {
            obj.set(prop, ((DynamicObject)value).getPkValue());
        } else {
            obj.set(prop, value);
        }
    }

    public static DynamicObject wapDynamic(String entityKey, Object id) {
        if (id instanceof DynamicObject) {
            return (DynamicObject)id;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
        dynamicObject.set("id", id);
        return dynamicObject;
    }

    public static Long getPk(DynamicObject obj, String prop) {
        Object value = obj.get(prop);
        if (value instanceof DynamicObject) {
            return (Long)((DynamicObject)value).getPkValue();
        }
        return (Long)value;
    }

    private static String getSubfix(String str) {
        int index = str.indexOf(46);
        index = index > 0 ? ++index : 0;
        return str.substring(index);
    }

    public static void subStringPropMaxLenth(DynamicObject obj, String prop) {
        String value = obj.getString(prop);
        TextProp property = (TextProp)obj.getDataEntityType().getProperties().get((Object)prop);
        int maxLenth = property.getMaxLenth();
        if (value != null && value.length() > maxLenth) {
            value = value.substring(0, maxLenth);
        }
        obj.set(prop, (Object)value);
    }

    public static boolean checkPropLenth(DynamicObject obj, String prop) {
        String value = obj.getString(prop);
        TextProp property = (TextProp)obj.getDataEntityType().getProperties().get((Object)prop);
        int maxLenth = property.getMaxLenth();
        if (value != null && value.length() > maxLenth) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

