/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.common.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.AccSysHelper;
import kd.tmc.mon.common.helper.MonHelper;

public class OrgHelper {
    private static String selectFields = "basecurrency.id baseCurrencyID,exratetable.id exratetable";
    public static final String ORGTYPE_ACCOUNTING = "fisaccounting";
    public static final String ORGTYPE_BANKROLL = "fisbankroll";

    public static Set<Long> getSubOrg(Long orgId, Set<Long> orgIds) {
        return orgIds;
    }

    public static Long getMainCurrency(long orgId) {
        return Optional.ofNullable(OrgHelper.getBankInfo(orgId)).map(v -> (Long)v.get("baseCurrencyID")).orElse(0L);
    }

    public static Long getExrateTable(long orgId) {
        return Optional.ofNullable(OrgHelper.getBankInfo(orgId)).map(v -> (Long)v.get("exchangeRateTableID")).orElse(0L);
    }

    public static Map<String, Long> getBankInfo(long orgId) {
        Map<String, Long> baseAccountingInfo = OrgHelper.getBookInfoByAccSys(orgId);
        if (baseAccountingInfo.size() < 1) {
            baseAccountingInfo = AccSysHelper.getBaseAccountingInfo(orgId);
        }
        return baseAccountingInfo;
    }

    public static Long getFisBankRollOrg(Long orgId, String appId, Long userId, String permission, String entityName) {
        DynamicObject currentOrg = OrgHelper.checkCurrentBankOrg(orgId);
        if (currentOrg != null && currentOrg.getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg.getLong("id");
        }
        List<Long> authorizedBankOrgId = OrgHelper.getAuthorizedBankOrgId(userId, appId = EmptyUtil.isNotEmpty((CharSequence)appId) ? AppMetadataCache.getAppInfo((String)appId).getId() : AppMetadataCache.getAppInfo((String)"mon").getId(), entityName, permission);
        if (authorizedBankOrgId != null && !authorizedBankOrgId.isEmpty()) {
            return authorizedBankOrgId.get(0);
        }
        return null;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String appid, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, appid, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static DynamicObject checkCurrentBankOrg(long orgId) {
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject currentOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (DynamicObjectType)orgType);
        if (currentOrg.getBoolean(ORGTYPE_BANKROLL)) {
            return currentOrg;
        }
        return null;
    }

    public static Map<String, Long> getBookInfoByAccSys(long accorg) {
        QFilter h = new QFilter("org.id", "=", (Object)accorg);
        QFilter k = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObject accountBooksInfo = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)selectFields, (QFilter[])new QFilter[]{k, h});
        HashMap<String, Long> map = new HashMap<String, Long>();
        if (!MonHelper.isEmpty(accountBooksInfo)) {
            map.put("baseCurrencyID", accountBooksInfo.getLong("baseCurrencyID"));
            map.put("exchangeRateTableID", accountBooksInfo.getLong("exratetable"));
        }
        return map;
    }

    public static QFilter getQFilterOrg(DynamicObjectCollection orgCollection, String entityID, String property) {
        QFilter qFilterOrg = null;
        List orgIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), null, (String)entityID, (String)"47150e89000000ac");
        if (!EmptyUtil.isEmpty((DynamicObjectCollection)orgCollection) && !EmptyUtil.isEmpty((Collection)orgIdList)) {
            List orgCollList = orgCollection.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            orgIdList = orgIdList.stream().filter(e -> !EmptyUtil.isEmpty((Long)e) && orgCollList.contains(e)).collect(Collectors.toList());
        }
        qFilterOrg = new QFilter(property, "in", (Object)orgIdList);
        return qFilterOrg;
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedBankOrg(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, ORGTYPE_BANKROLL);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    public static DynamicObjectCollection getAuthorizedAcctOrg(Long userID, String appId, String entityID, String permissionItem) {
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, ORGTYPE_ACCOUNTING);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String entityID, String permissionItem, String funType) {
        String appId = AppMetadataCache.getAppInfo((String)"cas").getId();
        return OrgHelper.getAuthorizedOrg(userID, appId, entityID, permissionItem, funType);
    }

    private static DynamicObjectCollection getAuthorizedOrg(Long userID, String appId, String entityID, String permissionItem, String funType) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((Long)userID, (String)appId, (String)entityID, (String)permissionItem);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter functionFilter = new QFilter(funType, "=", (Object)"1");
        Map orgs = new HashMap();
        if (allPermOrgs.hasAllOrgPerm()) {
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter});
        } else {
            List orgIdList = allPermOrgs.getHasPermOrgs();
            QFilter pkFilter = new QFilter("id", "in", (Object)orgIdList);
            orgs = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{enableFilter, functionFilter, pkFilter});
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObjectCollection orgColl = new DynamicObjectCollection((DynamicObjectType)orgType, null);
        for (DynamicObject org : orgs.values()) {
            orgColl.add((Object)org);
        }
        return orgColl;
    }

    public static List<Long> getAuthorizedBankOrgId(Long userID, String entityID, String permissionItem) {
        DynamicObjectCollection orgColl = OrgHelper.getAuthorizedBankOrg(userID, entityID, permissionItem);
        return OrgHelper.getIdList(orgColl);
    }

    public static List<Long> getIdList(DynamicObjectCollection orgList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject org : orgList) {
            idList.add(org.getLong("id"));
        }
        return idList;
    }
}

