/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.common.util;

import java.util.Collection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.tmc.mon.common.helper.MonHelper;
import kd.tmc.mon.common.util.MonStringUtils;

public class EntityMetadataUtils {
    public static boolean containsProperty(IDataEntityType dataEntityType, String filedName) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty p : properties) {
            if (!p.getName().equalsIgnoreCase(filedName)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsEntryField(MainEntityType dataEntityType, Collection<String> fields) {
        for (String field : fields) {
            if (!EntityMetadataUtils.isEntryField(dataEntityType, field)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntryField(MainEntityType dataEntityType, String propName) {
        EntryProp entryProp = EntityMetadataUtils.getEntryProp(dataEntityType);
        if (MonHelper.isEmpty(entryProp)) {
            return false;
        }
        String profix = MonStringUtils.getSubfix(propName);
        if (entryProp.getName().equalsIgnoreCase(profix)) {
            return true;
        }
        DynamicProperty property = dataEntityType.getProperty(propName);
        return property == null;
    }

    public static EntryProp getEntryProp(MainEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
            return (EntryProp)pro;
        }
        return null;
    }
}

