/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.index;

import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.mon.business.query.AccountMoneyService;
import kd.tmc.mon.business.query.PoolMoneyService;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.formplugin.index.CommonMethodsPlugin;

public class CapitalInformationPlugin
extends CommonMethodsPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(CapitalInformationPlugin.class);
    private String cardName = ResManager.loadKDString((String)"\u8d44\u91d1\u4fe1\u606f", (String)"CapitalInformationPlugin_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"summoney"});
        this.getView().getFormShowParameter().setListentimerElapsed(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSumMoney();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String itemKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if ((itemKey.equals("datasource") || itemKey.equals("datarange")) && newValue != null && newValue != oldValue) {
            this.getSumMoney();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("summoney".equals(key)) {
            this.showFormCapitalSumrpt();
        }
    }

    private void getSumMoney() {
        List<Long> orgList = super.getOrgList();
        if (orgList == null) {
            return;
        }
        Long mainCurId = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        if (mainCurId == null || "0".equals(String.valueOf(mainCurId))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7\u672c\u4f4d\u5e01\u79cd", (String)"CapitalInformationPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            return;
        }
        String datasource = (String)this.getModel().getValue("datasource");
        String datarange = (String)this.getModel().getValue("datarange");
        boolean statInnerAcct = "inneracct".equals(datarange);
        Date queryDate = new Date();
        List acctIds = AccountMoneyService.getAcctIds(null, null, null, null, null, orgList, (boolean)statInnerAcct);
        Map<String, Object> sumAmtMap = this.sumMoney(datasource, statInnerAcct, queryDate, mainCurId, orgList, acctIds);
        BigDecimal sumMoney = (BigDecimal)sumAmtMap.get("sumMoney");
        BigDecimal mainCurMoney = (BigDecimal)sumAmtMap.get("mainCurMoney");
        BigDecimal diffCurMoney = (BigDecimal)sumAmtMap.get("diffCurMoney");
        Long diffCur = (Long)sumAmtMap.get("diffCur");
        BigDecimal sumValue = sumMoney.divide(TEN_THOUSAND, 2, 4);
        Label label = (Label)this.getView().getControl("summoney");
        label.setText(String.format(super.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumValue), new Object[0]));
        super.drawPiechart(mainCurId, mainCurMoney, diffCur, diffCurMoney, sumMoney, "capital", this.cardName);
        Label ticketnameLabel = (Label)this.getView().getControl("ticketname");
        Label ticketmoneyLabel = (Label)this.getView().getControl("ticketmoney");
        Label ticketcountLabel = (Label)this.getView().getControl("ticketcount");
        Label poolnameLabel = (Label)this.getView().getControl("poolname");
        Label countLabel = (Label)this.getView().getControl("count");
        Label moneyPoolLabel = (Label)this.getView().getControl("moneypool");
        Label cashAcctNameLabel = (Label)this.getView().getControl("cashacctname");
        Label cashAcctBalanceLabel = (Label)this.getView().getControl("cashacctbalance");
        QFilter fcompanyidFilter = new QFilter("fcompanyid", "in", orgList);
        Map<String, Object> dataMap = this.sumMoneyBill(fcompanyidFilter, mainCurId);
        if (dataMap == null) {
            return;
        }
        BigDecimal sumPoolMoney = this.sumPoolMoney(datasource, statInnerAcct, queryDate, mainCurId, orgList, acctIds);
        BigDecimal sumCashAcct = this.sumCashAcctMoney(mainCurId);
        if (!"0".equals(dataMap.get("sheets"))) {
            BigDecimal sumTicket = (BigDecimal)dataMap.get("sumMoney");
            BigDecimal divide = sumTicket.divide(TEN_THOUSAND, 2, 4);
            ticketnameLabel.setText(ResManager.loadKDString((String)"\u7968\u636e\u8d44\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            ticketcountLabel.setText(ResManager.loadKDString((String)"\u7968\u636e\u5f20\u6570(\u5f20)", (String)"CapitalInformationPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            ticketmoneyLabel.setText(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(divide));
            countLabel.setText(dataMap.get("sheets") + "");
            if (BigDecimal.ZERO.compareTo(sumPoolMoney) != 0) {
                poolnameLabel.setText(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60\u8d44\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_4", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                BigDecimal divideMoney = sumPoolMoney.divide(TEN_THOUSAND, 2, 4);
                moneyPoolLabel.setText(String.format(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(divideMoney), new Object[0]));
                if (sumCashAcct != null && sumCashAcct.compareTo(BigDecimal.ZERO) != 0) {
                    cashAcctNameLabel.setText(ResManager.loadKDString((String)"\u73b0\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                    cashAcctBalanceLabel.setText(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumCashAcct.divide(TEN_THOUSAND, 2, 4)));
                }
            } else if (sumCashAcct != null && sumCashAcct.compareTo(BigDecimal.ZERO) != 0) {
                poolnameLabel.setText(ResManager.loadKDString((String)"\u73b0\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                moneyPoolLabel.setText(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumCashAcct.divide(TEN_THOUSAND, 2, 4)));
            }
        } else if (BigDecimal.ZERO.compareTo(sumPoolMoney) != 0) {
            ticketnameLabel.setText(ResManager.loadKDString((String)"\u8d44\u91d1\u6c60(\u6298\u7b97)", (String)"CapitalInformationPlugin_6", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            BigDecimal divide = sumPoolMoney.divide(TEN_THOUSAND, 2, 4);
            ticketmoneyLabel.setText(String.format(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(divide), new Object[0]));
            if (sumCashAcct != null && sumCashAcct.compareTo(BigDecimal.ZERO) != 0) {
                ticketcountLabel.setText(ResManager.loadKDString((String)"\u73b0\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                countLabel.setText(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumCashAcct.divide(TEN_THOUSAND, 2, 4)));
            }
        } else if (sumCashAcct != null && sumCashAcct.compareTo(BigDecimal.ZERO) != 0) {
            ticketnameLabel.setText(ResManager.loadKDString((String)"\u73b0\u91d1(\u6298\u7b97)", (String)"CapitalInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            ticketmoneyLabel.setText(this.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumCashAcct.divide(TEN_THOUSAND, 2, 4)));
        }
    }

    private Map<String, Object> sumMoneyBill(QFilter orgFilter, Long aimCurrency) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        String querySql = "SELECT fid, fcurrencyid, famount FROM t_cdm_draftbill A \nWHERE A.fdraftbillstatus in ('pledged','registered','collocated') AND A.fbillstatus = 'C' AND A.frptype = 'receivebill' AND " + orgFilter.toString();
        ArrayList ids = new ArrayList(100);
        DB.query((DBRoute)DBRouteConst.TMC, (String)querySql, rs -> {
            while (rs.next()) {
                ids.add(rs.getLong("fid"));
            }
            return ids;
        });
        MainEntityType recBillEntityType = EntityMetadataCache.getDataEntityType((String)"cdm_receivablebill");
        long[] pkIds = DB.genLongIds((String)recBillEntityType.getAlias(), (int)ids.size());
        ArrayList list = new ArrayList(100);
        DB.query((DBRoute)DBRouteConst.TMC, (String)querySql, rs -> {
            int index = 0;
            while (rs.next()) {
                long pkId = pkIds[index];
                DynamicObject receivableBill = new DynamicObject((DynamicObjectType)recBillEntityType, (Object)pkId);
                receivableBill.set("id", (Object)rs.getLong("fid"));
                DynamicObject currency = BusinessDataServiceHelper.loadSingle((Object)rs.getLong("fcurrencyid"), (String)"bd_currency");
                receivableBill.set("currency", (Object)currency);
                receivableBill.set("amount", (Object)rs.getBigDecimal("famount"));
                list.add(receivableBill);
                ++index;
            }
            return list;
        });
        DynamicObject[] receivableBills = list.toArray(new DynamicObject[0]);
        if (receivableBills == null || receivableBills.length < 1) {
            dataMap.put("sheets", "0");
            dataMap.put("sumMoney", BigDecimal.ZERO);
            return dataMap;
        }
        Map<String, Object> returnData = this.diffCurrencySumMoney(receivableBills, aimCurrency, Boolean.FALSE, this.cardName);
        if (returnData == null) {
            return null;
        }
        returnData.put("sheets", receivableBills.length + "");
        return returnData;
    }

    private void showFormCapitalSumrpt() {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("mon_accountmoney");
        HashMap params = new HashMap();
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long currencyId = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("calculatestyle", (Object)"currency");
        filter.addFilterItem("balancedate", (Object)new Date());
        filter.addFilterItem("reportcurrency", (Object)currencyId);
        filter.addFilterItem("filter_queryway", (Object)"org");
        filter.addFilterItem("filter_org", this.getOrgList());
        filter.addFilterItem("exratetable", (Object)OrgHelper.getExrateTable((long)RequestContext.get().getOrgId()));
        filter.addFilterItem("filter_currencyunit", (Object)"10000");
        filter.addFilterItem("datasource", this.getModel().getValue("datasource"));
        boolean statsinneracct = "inneracct".equals(this.getModel().getValue("datarange"));
        filter.addFilterItem("statsinneracct", (Object)statsinneracct);
        queryParam.setFilter(filter);
        showParameter.setQueryParam(queryParam);
        showParameter.setPageId(this.getView().getPageId() + "fromcapital");
        showParameter.setCustomParam("frompage", (Object)"mon_capital_card");
        showParameter.setCustomParam("exratetable", (Object)OrgHelper.getExrateTable((long)RequestContext.get().getOrgId()));
        showParameter.setLinkQuery(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private Map<String, Object> sumMoney(String datasource, boolean statInnerAcct, Date queryDate, Long mainCurId, List<Long> orgIds, List<Long> acctIds) {
        DataSet balanceData = AccountMoneyService.queryBalanceData((String)datasource, (Date)queryDate, null, orgIds, acctIds);
        DataSet detailDataSet = AccountMoneyService.getDetailDataSet((DataSet)balanceData, (Long)mainCurId, (Date)queryDate);
        Iterator iterator = detailDataSet.iterator();
        HashMap<Long, BigDecimal[]> curAmtMap = new HashMap<Long, BigDecimal[]>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long rowCurId = row.getLong("cur");
            BigDecimal rowAmt = row.getBigDecimal("amount");
            BigDecimal rowRptAmt = row.getBigDecimal("reportamt");
            BigDecimal[] curAmt = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
            if (curAmtMap.containsKey(rowCurId)) {
                curAmt = (BigDecimal[])curAmtMap.get(rowCurId);
                curAmt[0] = curAmt[0].add(rowAmt);
                curAmt[1] = curAmt[1].add(rowRptAmt);
            } else {
                curAmt[0] = rowAmt;
                curAmt[1] = rowRptAmt;
            }
            curAmtMap.put(rowCurId, curAmt);
        }
        BigDecimal sumMoney = BigDecimal.ZERO;
        BigDecimal mainCurMoney = BigDecimal.ZERO;
        Long maxDiffCurId = 0L;
        BigDecimal maxDiffRptAmt = BigDecimal.ZERO;
        BigDecimal maxDiffSrcAmt = BigDecimal.ZERO;
        for (Map.Entry curAmt : curAmtMap.entrySet()) {
            Long curId = (Long)curAmt.getKey();
            BigDecimal[] amtValue = (BigDecimal[])curAmt.getValue();
            BigDecimal srcAmt = amtValue[0];
            BigDecimal rptAmt = amtValue[1];
            logger.info("sumMoney(): curId={},srtAmt={},rptAmt={}", new Object[]{curId, srcAmt, rptAmt});
            sumMoney = sumMoney.add(rptAmt);
            if (Objects.equals(curId, mainCurId)) {
                mainCurMoney = mainCurMoney.add(rptAmt);
                continue;
            }
            if (maxDiffRptAmt.compareTo(rptAmt) >= 0) continue;
            maxDiffCurId = curId;
            maxDiffRptAmt = rptAmt;
            maxDiffSrcAmt = srcAmt;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("sumMoney", sumMoney);
        map.put("mainCurMoney", mainCurMoney);
        map.put("diffCurMoney", maxDiffSrcAmt);
        map.put("diffCur", maxDiffCurId);
        return map;
    }

    private BigDecimal sumPoolMoney(String datasource, boolean statInnerAcct, Date queryDate, Long bizCurId, List<Long> orgIds, List<Long> acctIds) {
        Map acctGroupMap = PoolMoneyService.queryAcctGroups(null, null, orgIds, (boolean)statInnerAcct);
        Set groupAcctIds = acctGroupMap.keySet().stream().map(e -> e.getDynamicObject("accountbank").getLong("id")).collect(Collectors.toSet());
        Set subAcctIds = acctGroupMap.values().stream().collect(HashSet::new, AbstractCollection::addAll, AbstractCollection::addAll);
        DataSet groupBalance = PoolMoneyService.queryBalanceDataSet((String)datasource, (Date)queryDate, null, null, orgIds, new ArrayList(groupAcctIds));
        DataSet subAcctBalance = PoolMoneyService.queryBalanceDataSet((String)datasource, (Date)queryDate, null, null, orgIds, new ArrayList(subAcctIds));
        DataSet groupDetail = PoolMoneyService.getDetailDataSet((DataSet)groupBalance, groupAcctIds);
        DataSet subDetail = PoolMoneyService.getDetailDataSet((DataSet)subAcctBalance, (Set)subAcctIds);
        DataSet acctAmtData = PoolMoneyService.getAcctGroupDataSet((boolean)true, (Map)acctGroupMap, (DataSet)groupDetail, (DataSet)subDetail);
        long orgId = RequestContext.get().getOrgId();
        Iterator iterator = acctAmtData.iterator();
        BigDecimal sumAmt = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> exRateMap = new HashMap<Long, BigDecimal>();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            Long rowCurId = row.getLong("cur");
            BigDecimal amt = row.getBigDecimal("amount");
            BigDecimal exRate = BigDecimal.ZERO;
            if (exRateMap.containsKey(rowCurId)) {
                exRate = (BigDecimal)exRateMap.get(rowCurId);
            } else {
                exRate = BaseDataHelper.getExchangeRate((Long)rowCurId, (Long)bizCurId, (Long)orgId, (Date)queryDate);
                exRateMap.put(rowCurId, exRate);
            }
            sumAmt = sumAmt.add(amt.multiply(exRate));
        }
        return sumAmt;
    }

    private BigDecimal sumCashAcctMoney(Long curId) {
        List authOrgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), null, (String)"cas_bankjournalformrpt", (String)"47150e89000000ac");
        QFilter[] initQFilters = new QFilter[]{new QFilter("id", "in", (Object)authOrgIds), new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection list = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"org.id,entrycash.cash_currency.id,entrycash.cash_balance", (QFilter[])initQFilters);
        HashMap<Long, BigDecimal> balanceMap = new HashMap<Long, BigDecimal>();
        HashSet<Long> orgIds = new HashSet<Long>();
        for (DynamicObject entryCash : list) {
            Long orgId = entryCash.getLong("org.id");
            Long eCur = entryCash.getLong("entrycash.cash_currency.id");
            BigDecimal eBalance = entryCash.getBigDecimal("entrycash.cash_balance");
            if (balanceMap.containsKey(eCur)) {
                BigDecimal tmpBalance = balanceMap.get(eCur) != null ? (BigDecimal)balanceMap.get(eCur) : BigDecimal.ZERO;
                eBalance = eBalance.add(tmpBalance);
            }
            orgIds.add(orgId);
            balanceMap.put(eCur, eBalance);
        }
        authOrgIds.retainAll(orgIds);
        DynamicObjectCollection cashAccts = QueryServiceHelper.query((String)"cas_accountcash", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)authOrgIds)});
        List cashAcctIds = cashAccts.stream().map(a -> a.getLong("id")).collect(Collectors.toList());
        QFilter[] qFilters = new QFilter[]{new QFilter("accountcash", "in", cashAcctIds), new QFilter("org", "in", (Object)authOrgIds)};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"cas_cashjournal", (String)"currency.id,debitamount,creditamount", (QFilter[])qFilters, null);
        if (dataSet != null) {
            DataSet curSum = dataSet.groupBy(new String[]{"currency.id"}).sum("debitamount").sum("creditamount").finish();
            for (Row row : curSum) {
                Long rowCur = row.getLong("currency.id");
                BigDecimal rowDebitAmt = row.getBigDecimal("debitamount") == null ? BigDecimal.ZERO : row.getBigDecimal("debitamount");
                BigDecimal rowCreditAmt = row.getBigDecimal("creditamount") == null ? BigDecimal.ZERO : row.getBigDecimal("creditamount");
                BigDecimal balance = balanceMap.get(rowCur) == null ? BigDecimal.ZERO : balanceMap.get(rowCur);
                balance = balance.add(rowDebitAmt).subtract(rowCreditAmt);
                balanceMap.put(rowCur, balance);
            }
        }
        BigDecimal total = super.diffCurrencyToMainCurrency(balanceMap, curId, this.cardName);
        return total;
    }
}

