/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.formplugin.index.CommonMethodsPlugin;

public class DebtInformationPlugin
extends CommonMethodsPlugin
implements ClickListener {
    private String cardName = ResManager.loadKDString((String)"\u8d1f\u503a\u4fe1\u606f", (String)"DebtInformationPlugin_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final BigDecimal TEN_THOUSAND = new BigDecimal(10000);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getView().getFormShowParameter().setListentimerElapsed(true);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getSumMoney();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        Object oldValue = changeSet[0].getOldValue();
        if (propName.equals("querycycle") && newValue != null && newValue != oldValue) {
            this.getSumMoney();
        }
    }

    private Date getQueryCycle() {
        String querycycle = (String)this.getModel().getValue("querycycle");
        Date beginDate = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        if ("1".equals(querycycle)) {
            calendar.add(1, -1);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            beginDate = new Date(calendar.getTimeInMillis() / 1000L * 1000L);
        } else {
            if ("0".equals(querycycle)) {
                return null;
            }
            calendar.add(1, -3);
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
            beginDate = new Date(calendar.getTimeInMillis() / 1000L * 1000L);
        }
        return beginDate;
    }

    private void getSumMoney() {
        Label poolnameLabel = (Label)this.getView().getControl("ticketname");
        Label moneypoolLabel = (Label)this.getView().getControl("ticketmoney");
        List<Long> orgList = this.getOrgList();
        if (orgList == null) {
            return;
        }
        Long mainCurId = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        if (EmptyUtil.isEmpty((Long)mainCurId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7\u672c\u4f4d\u5e01\u79cd", (String)"DebtInformationPlugin_4", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            return;
        }
        String queryCycle = (String)this.getModel().getValue("querycycle");
        Date beginDate = this.getQueryCycle();
        QFilter orgFilter = new QFilter("org", "in", orgList);
        DynamicObjectCollection lcs = QueryServiceHelper.query((String)"cfm_loancontractbill", (String)"id", (QFilter[])new QFilter[]{orgFilter});
        List<Long> lcIds = lcs.stream().map(lc -> lc.getLong("id")).collect(Collectors.toList());
        ArrayList<QFilter> cdmFitlers = new ArrayList<QFilter>();
        cdmFitlers.add(new QFilter("company", "in", orgList));
        cdmFitlers.add(new QFilter("draftbillstatus", "=", (Object)"registered"));
        cdmFitlers.add(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        cdmFitlers.add(new QFilter("rptype", "=", (Object)"paybill"));
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            cdmFitlers.add(new QFilter("bizdate", ">=", (Object)beginDate));
        }
        DynamicObject[] cmdPayBills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,currency,amount", (QFilter[])cdmFitlers.toArray(new QFilter[0]));
        Map<String, Object> sumAmtMap = this.sumMoney(beginDate, orgList, mainCurId, lcIds, cmdPayBills);
        BigDecimal sumMoney = (BigDecimal)sumAmtMap.get("sumMoney");
        BigDecimal mainCurMoney = (BigDecimal)sumAmtMap.get("mainCurMoney");
        BigDecimal diffCurMoney = (BigDecimal)sumAmtMap.get("diffCurMoney");
        Long diffCur = (Long)sumAmtMap.get("diffCur");
        Label label = (Label)this.getView().getControl("summoney");
        BigDecimal sumMoneyValue = sumMoney.divide(TEN_THOUSAND, 2, 4);
        label.setText(super.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumMoneyValue));
        super.drawPiechart(mainCurId, mainCurMoney, diffCur, diffCurMoney, sumMoney, "debt", this.cardName);
        Map<String, Object> cdmAmtMap = this.sumCdmBillMoney(beginDate, orgList, mainCurId, cmdPayBills);
        if (cdmAmtMap == null) {
            return;
        }
        Label ticketnameLabel = (Label)this.getView().getControl("ticketname");
        Label ticketcountLabel = (Label)this.getView().getControl("ticketcount");
        poolnameLabel = (Label)this.getView().getControl("poolname");
        Label ticketmoneyLabel = (Label)this.getView().getControl("ticketmoney");
        Label countLabel = (Label)this.getView().getControl("count");
        moneypoolLabel = (Label)this.getView().getControl("moneypool");
        BigDecimal finCostRate = this.getFinCostRate(beginDate, orgList, mainCurId, lcIds);
        int sheets = (Integer)cdmAmtMap.get("sheets");
        if (sheets > 0) {
            ticketnameLabel.setText(ResManager.loadKDString((String)"\u5f85\u89e3\u4ed8\u7968\u636e(\u6298\u7b97)", (String)"DebtInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            ticketcountLabel.setText(ResManager.loadKDString((String)"\u7968\u636e\u5f20\u6570(\u5f20)", (String)"DebtInformationPlugin_6", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            BigDecimal sumTicket = (BigDecimal)cdmAmtMap.get("sumMoney");
            ticketmoneyLabel.setText(super.getCurrencyName(mainCurId, "sign") + super.getNumberFormat(sumTicket.divide(TEN_THOUSAND, 2, 4)));
            String sheetsValue = String.valueOf(cdmAmtMap.get("sheets"));
            countLabel.setText(super.getNumberFormatAccount(new BigDecimal(sheetsValue)));
            if (finCostRate == null) {
                return;
            }
            if (finCostRate.compareTo(BigDecimal.ZERO) == 0) {
                poolnameLabel.setText(null);
                moneypoolLabel.setText(null);
            } else {
                poolnameLabel.setText(ResManager.loadKDString((String)"\u878d\u8d44\u6210\u672c\u7387", (String)"DebtInformationPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                String tip = ResManager.loadKDString((String)"\u8d44\u91d1\u4f7f\u7528\u8d39/\u878d\u8d44\u603b\u989d", (String)"DebtInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
                poolnameLabel.addTips(new Tips("text", null, new LocaleString(tip), false, null));
                moneypoolLabel.setText(String.format(ResManager.loadKDString((String)" %s", (String)"DebtInformationPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0]), finCostRate) + "%");
            }
        } else {
            if (finCostRate == null) {
                return;
            }
            if (finCostRate.compareTo(BigDecimal.ZERO) == 0) {
                ticketnameLabel.setText(null);
                ticketcountLabel.setText(null);
                poolnameLabel.setText(null);
                ticketmoneyLabel.setText(null);
                countLabel.setText(null);
                moneypoolLabel.setText(null);
            } else {
                poolnameLabel = ticketnameLabel;
                moneypoolLabel = ticketmoneyLabel;
                poolnameLabel.setText(ResManager.loadKDString((String)"\u878d\u8d44\u6210\u672c\u7387", (String)"DebtInformationPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
                String tip = ResManager.loadKDString((String)"\u8d44\u91d1\u4f7f\u7528\u8d39/\u878d\u8d44\u603b\u989d", (String)"DebtInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
                poolnameLabel.addTips(new Tips("text", null, new LocaleString(tip), false, null));
                moneypoolLabel.setText(String.format(ResManager.loadKDString((String)" %s", (String)"DebtInformationPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0]), finCostRate) + "%");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> sumMoney(Date beginDate, List<Long> orgList, Long mainCurId, List<Long> lcIds, DynamicObject[] cdmPayBills) {
        void var12_16;
        Long orgId = RequestContext.get().getOrgId();
        HashSet<Object> curIds = new HashSet<Object>();
        HashMap<Long, BigDecimal> loanAmtMap = new HashMap<Long, BigDecimal>();
        if (EmptyUtil.isNoEmpty(lcIds)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(new QFilter("sourcebillid", "in", lcIds));
            qFilters.add(new QFilter("drawtype", "in", (Object)new String[]{"drawed", "partpayment"}));
            if (EmptyUtil.isNoEmpty((Object)beginDate)) {
                qFilters.add(new QFilter("bizdate", ">=", (Object)beginDate));
            }
            DynamicObjectCollection loans = QueryServiceHelper.query((String)"cfm_loanbill", (String)"currency.id,amount,drawamount,repayamount", (QFilter[])qFilters.toArray(new QFilter[0]));
            for (DynamicObject dynamicObject : loans) {
                Long curId = dynamicObject.getLong("currency.id");
                BigDecimal drawAmount = EmptyUtil.isEmpty((BigDecimal)dynamicObject.getBigDecimal("drawamount")) ? BigDecimal.ZERO : dynamicObject.getBigDecimal("drawamount");
                BigDecimal repayamount = EmptyUtil.isEmpty((BigDecimal)dynamicObject.getBigDecimal("repayamount")) ? BigDecimal.ZERO : dynamicObject.getBigDecimal("repayamount");
                BigDecimal curDebtAmt = loanAmtMap.containsKey(curId) ? (BigDecimal)loanAmtMap.get(curId) : BigDecimal.ZERO;
                curDebtAmt = drawAmount.subtract(repayamount).add(curDebtAmt);
                loanAmtMap.put(curId, curDebtAmt);
            }
            curIds.addAll(loanAmtMap.keySet());
        }
        Map<Object, Object> cdmPayCurAmtMap = new HashMap();
        if (EmptyUtil.isNoEmpty((Object[])cdmPayBills)) {
            cdmPayCurAmtMap = Arrays.stream(cdmPayBills).collect(Collectors.groupingBy(c -> c.getDynamicObject("currency").getLong("id"), Collectors.mapping(e -> e.getBigDecimal("amount"), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            curIds.addAll(cdmPayCurAmtMap.keySet());
        }
        if (EmptyUtil.isEmpty(curIds)) {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("sumMoney", BigDecimal.ZERO);
            return map;
        }
        HashMap<Long, BigDecimal> curAmtMap = new HashMap<Long, BigDecimal>(curIds.size());
        for (Long l : curIds) {
            BigDecimal loanDebtAmt = loanAmtMap.containsKey(l) ? (BigDecimal)loanAmtMap.get(l) : BigDecimal.ZERO;
            BigDecimal cdmPayAmt = cdmPayCurAmtMap.containsKey(l) ? (BigDecimal)cdmPayCurAmtMap.get(l) : BigDecimal.ZERO;
            curAmtMap.put(l, loanDebtAmt.add(cdmPayAmt));
        }
        BigDecimal sumMoney = BigDecimal.ZERO;
        BigDecimal bigDecimal = BigDecimal.ZERO;
        Long maxDiffCurId = 0L;
        BigDecimal maxDiffRptAmt = BigDecimal.ZERO;
        BigDecimal maxDiffSrcAmt = BigDecimal.ZERO;
        Map exRateMap = BaseDataHelper.getExchangeRate(new ArrayList(curIds), (Long)mainCurId, (Long)orgId, (Date)new Date());
        for (Map.Entry curAmt : curAmtMap.entrySet()) {
            Long curId = (Long)curAmt.getKey();
            BigDecimal srcAmt = (BigDecimal)curAmt.getValue();
            BigDecimal exRate = (BigDecimal)exRateMap.get(curId);
            BigDecimal rptAmt = srcAmt.multiply(exRate);
            sumMoney = sumMoney.add(rptAmt);
            if (Objects.equals(curId, mainCurId)) {
                BigDecimal bigDecimal2 = var12_16.add(rptAmt);
                continue;
            }
            if (maxDiffRptAmt.compareTo(rptAmt) >= 0) continue;
            maxDiffCurId = curId;
            maxDiffRptAmt = rptAmt;
            maxDiffSrcAmt = srcAmt;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("sumMoney", sumMoney);
        map.put("mainCurMoney", var12_16);
        map.put("diffCurMoney", maxDiffSrcAmt);
        map.put("diffCur", maxDiffCurId);
        return map;
    }

    private Map<String, Object> sumCdmBillMoney(Date beginDate, List<Long> orgList, Long mainCurId, DynamicObject[] cmdPayBills) {
        if (EmptyUtil.isEmpty((Object[])cmdPayBills)) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put("sheets", 0);
            dataMap.put("sumMoney", BigDecimal.ZERO);
            return dataMap;
        }
        Map<String, Object> returnData = super.diffCurrencySumMoney(cmdPayBills, mainCurId, Boolean.FALSE, this.cardName);
        if (returnData == null) {
            return null;
        }
        returnData.put("sheets", cmdPayBills.length);
        return returnData;
    }

    private BigDecimal getFinCostRate(Date beginDate, List<Long> orgList, Long mainCurId, List<Long> lcIds) {
        BigDecimal[] amtArr;
        if (EmptyUtil.isEmpty(lcIds)) {
            return BigDecimal.ZERO;
        }
        Long orgId = RequestContext.get().getOrgId();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("sourcebillid", "in", lcIds));
        qFilters.add(new QFilter("drawtype", "=", (Object)"closeout"));
        if (EmptyUtil.isNoEmpty((Object)beginDate)) {
            qFilters.add(new QFilter("bizdate", ">=", (Object)beginDate));
        }
        DynamicObjectCollection loanbills = QueryServiceHelper.query((String)"cfm_loanbill", (String)"id,currency.id,amount,payinterestamount,sourcebillid", (QFilter[])qFilters.toArray(new QFilter[0]));
        Set curIds = loanbills.stream().map(l -> l.getLong("currency.id")).collect(Collectors.toSet());
        HashMap<Long, BigDecimal[]> curAmtMap = new HashMap<Long, BigDecimal[]>(curIds.size());
        HashMap curSrcIdMap = new HashMap(curIds.size());
        HashMap curLoadIdMap = new HashMap(curIds.size());
        for (DynamicObject loanbill : loanbills) {
            BigDecimal[] bigDecimalArray;
            Long id = loanbill.getLong("id");
            Long curId = loanbill.getLong("currency.id");
            Long srcId = loanbill.getLong("sourcebillid");
            BigDecimal amt = loanbill.getBigDecimal("amount");
            BigDecimal intAmt = loanbill.getBigDecimal("payinterestamount");
            if (curAmtMap.containsKey(curId)) {
                bigDecimalArray = (BigDecimal[])curAmtMap.get(curId);
            } else {
                BigDecimal[] bigDecimalArray2 = new BigDecimal[4];
                bigDecimalArray2[0] = BigDecimal.ZERO;
                bigDecimalArray2[1] = BigDecimal.ZERO;
                bigDecimalArray2[2] = BigDecimal.ZERO;
                bigDecimalArray = bigDecimalArray2;
                bigDecimalArray2[3] = BigDecimal.ZERO;
            }
            BigDecimal[] amtArr2 = bigDecimalArray;
            amtArr2[0] = amtArr2[0].add(amt);
            amtArr2[1] = amtArr2[1].add(intAmt);
            amtArr2[2] = BigDecimal.ZERO;
            amtArr2[3] = BigDecimal.ZERO;
            curAmtMap.put(curId, amtArr2);
            List<Long> loanIds = curLoadIdMap.containsKey(curId) ? (List)curLoadIdMap.get(curId) : new ArrayList();
            loanIds.add(id);
            curSrcIdMap.put(curId, loanIds);
            List<Long> srcIds = curSrcIdMap.containsKey(curId) ? (List)curSrcIdMap.get(curId) : new ArrayList();
            srcIds.add(srcId);
            curSrcIdMap.put(curId, srcIds);
        }
        if (EmptyUtil.isEmpty(curAmtMap)) {
            return BigDecimal.ZERO;
        }
        for (Long curId : curIds) {
            List loanIds = (List)curLoadIdMap.get(curId);
            List srcIds = (List)curSrcIdMap.get(curId);
            BigDecimal loanSumFee = this.getSumFee(loanIds);
            BigDecimal srcSumFee = this.getSumFee(srcIds);
            amtArr = (BigDecimal[])curAmtMap.get(curId);
            amtArr[2] = loanSumFee;
            amtArr[3] = srcSumFee;
            curAmtMap.put(curId, amtArr);
        }
        Map exRateMap = BaseDataHelper.getExchangeRate(new ArrayList(curIds), (Long)mainCurId, (Long)orgId, (Date)new Date());
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal intFeeSumAmt = BigDecimal.ZERO;
        for (Map.Entry entry : curAmtMap.entrySet()) {
            Long curId = (Long)entry.getKey();
            amtArr = (BigDecimal[])entry.getValue();
            BigDecimal exRate = (BigDecimal)exRateMap.get(curId);
            BigDecimal exAmt = amtArr[0].multiply(exRate);
            BigDecimal exIntAmt = amtArr[1].multiply(exRate);
            BigDecimal exLoanFeeAmt = amtArr[2].multiply(exRate);
            BigDecimal exSrcFeeAmt = amtArr[2].multiply(exRate);
            sumAmt = sumAmt.add(exAmt);
            intFeeSumAmt = intFeeSumAmt.add(exIntAmt).add(exLoanFeeAmt).add(exSrcFeeAmt);
        }
        if (BigDecimal.ZERO.compareTo(sumAmt) == 0) {
            return BigDecimal.ZERO;
        }
        return intFeeSumAmt.multiply(HUNDRED).divide(sumAmt, 2, 4);
    }

    private BigDecimal getSumFee(List<Long> ids) {
        if (EmptyUtil.isEmpty(ids)) {
            return BigDecimal.ZERO;
        }
        QFilter feeIdFilter = new QFilter("entry.srcbillid", "in", ids);
        QFilter dataIsoRateFilter = new QFilter("feesource", "=", (Object)"linkgen").or(new QFilter("billstatus", "=", (Object)"C").and(new QFilter("feesource", "in", Arrays.asList("hand", "batchinput", "bizpatch"))));
        DynamicObjectCollection feeBills = QueryServiceHelper.query((String)"cfm_feebill", (String)"id,entry.srcbillid,entry.feedetailamt,entry.excrate", (QFilter[])new QFilter[]{feeIdFilter, dataIsoRateFilter});
        BigDecimal sumAmount = BigDecimal.ZERO;
        Iterator iterator = feeBills.iterator();
        for (DynamicObject feeBill : feeBills) {
            BigDecimal exRate = feeBill.getBigDecimal("entry.excrate");
            BigDecimal feeAmt = feeBill.getBigDecimal("entry.feedetailamt");
            BigDecimal exAmt = EmptyUtil.isEmpty((BigDecimal)exRate) ? feeAmt : feeAmt.multiply(exRate);
            sumAmount = sumAmount.add(exAmt);
        }
        return sumAmount;
    }
}

