/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.index;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.mon.common.helper.BaseDataHelper;
import kd.tmc.mon.common.helper.OrgHelper;
import kd.tmc.mon.common.helper.PeriodHelper;
import kd.tmc.mon.formplugin.index.CommonMethodsPlugin;

public class TraceInformationPlugin
extends CommonMethodsPlugin
implements ClickListener {
    private String cardName = ResManager.loadKDString((String)"\u4ea4\u6613\u4fe1\u606f", (String)"TraceInformationPlugin_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"summoney"});
        this.getView().getFormShowParameter().setListentimerElapsed(true);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        super.propertyChanged(e);
        switch (propName = e.getProperty().getName()) {
            case "querycycle": 
            case "statsinneracct": 
            case "exratetable": 
            case "datasource": {
                String queryCycle = (String)this.getView().getModel().getValue("querycycle");
                Date beginDate = this.getDateByQueryCycle(queryCycle);
                this.getSumMoney(beginDate);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection queryFisBankRollOrg;
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = RequestContext.get().getOrgId();
        Long fisBankRollOrg = OrgHelper.getFisBankRollOrg((Long)orgId, (String)appId, (Long)RequestContext.get().getCurrUserId(), (String)"47150e89000000ac", (String)"mon_fundflow");
        if (fisBankRollOrg != null && !(queryFisBankRollOrg = QueryServiceHelper.query((String)"queryCashInit", (String)"cas_cashmgtinit", (String)"org as id", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)new Long[]{fisBankRollOrg}), new QFilter("isfinishinit", "=", (Object)"1")}, null)).isEmpty()) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)fisBankRollOrg);
            this.getModel().setValue("exratetable", initObj.getDynamicObject("exratetable").getPkValue());
        }
        Date beginDate = this.getDateByQueryCycle("month");
        this.getSumMoney(beginDate);
    }

    private void getSumMoney(Date beginDate) {
        List<Long> orgList = this.getOrgList();
        if (orgList == null) {
            return;
        }
        QFilter orgFilter = new QFilter("company", "in", (Object)orgList.toArray());
        Long currency = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        if (currency == null || "0".equals(String.valueOf(currency))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u7ec4\u7ec7\u672c\u4f4d\u5e01\u79cd", (String)"TraceInformationPlugin_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, Object> returnData = this.sumMoney(orgList, currency, beginDate);
        if (returnData == null) {
            return;
        }
        BigDecimal sumMoneyUnit = (BigDecimal)returnData.get("sumMoney");
        BigDecimal sumMoney = null;
        if (null != sumMoneyUnit && sumMoneyUnit.compareTo(BigDecimal.ZERO) != 0) {
            sumMoney = sumMoneyUnit.divide(new BigDecimal(10000), 2, 4);
        }
        if (sumMoney == null) {
            sumMoneyUnit = sumMoney = BigDecimal.ZERO;
        }
        Label label = (Label)this.getView().getControl("summoney");
        if (sumMoney == null) {
            sumMoney = BigDecimal.ZERO;
        }
        label.setText(this.getCurrencyName(currency, "sign") + this.getNumberFormat(sumMoney));
        Object mainCurrencyMoney = returnData.get("MainCurrencyMoney");
        if (mainCurrencyMoney == null) {
            mainCurrencyMoney = BigDecimal.ZERO;
        }
        BigDecimal sumMoneyMainCurrency = (BigDecimal)mainCurrencyMoney;
        BigDecimal sumMoneyNotMainCurrency = (BigDecimal)returnData.get("maxCurrencyMoney");
        if (sumMoneyNotMainCurrency == null) {
            sumMoneyNotMainCurrency = BigDecimal.ZERO;
        }
        Object currencyPk = returnData.get("currencyMaxId");
        this.drawPiechart(currency, sumMoneyMainCurrency, currencyPk, sumMoneyNotMainCurrency, sumMoneyUnit, "trace", this.cardName);
        BigDecimal incount = (BigDecimal)returnData.get("incount");
        BigDecimal outcount = (BigDecimal)returnData.get("outcount");
        BigDecimal inTotal = (BigDecimal)returnData.get("inTotal");
        BigDecimal outTotal = (BigDecimal)returnData.get("outTotal");
        Label intotal = (Label)this.getView().getControl("intotal");
        Label outtotal = (Label)this.getView().getControl("outtotal");
        Label inticket = (Label)this.getView().getControl("inticket");
        Label outticket = (Label)this.getView().getControl("outticket");
        Label[] labels = new Label[]{intotal, outtotal, inticket, outticket};
        Label intotalsum = (Label)this.getView().getControl("intotalsum");
        Label outtotalsum = (Label)this.getView().getControl("outtotalsum");
        Label inticketsum = (Label)this.getView().getControl("inticketsum");
        Label outticketsum = (Label)this.getView().getControl("outticketsum");
        Label[] labelsums = new Label[]{intotalsum, outtotalsum, inticketsum, outticketsum};
        String unit = ResManager.loadKDString((String)"\u5f20", (String)"TraceInformationPlugin_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
        String unitCapital = ResManager.loadKDString((String)"\u7b14", (String)"TraceInformationPlugin_3", (String)"tmc-mon-formplugin", (Object[])new Object[0]);
        int flag = 0;
        if (incount != null && incount.compareTo(BigDecimal.ZERO) != 0) {
            labels[flag].setText(ResManager.loadKDString((String)"\u6536\u5165\u8d44\u91d1", (String)"TraceInformationPlugin_4", (String)"tmc-mon-formplugin", (Object[])new Object[0]) + "(" + incount + unitCapital + ")");
            labelsums[flag].setText(this.getCurrencyName(currency, "sign") + this.getNumberFormat(inTotal.divide(new BigDecimal(10000), 2, 4)));
            ++flag;
        }
        if (outcount != null && outcount.compareTo(BigDecimal.ZERO) != 0) {
            labels[flag].setText(ResManager.loadKDString((String)"\u652f\u51fa\u8d44\u91d1", (String)"TraceInformationPlugin_5", (String)"tmc-mon-formplugin", (Object[])new Object[0]) + "(" + outcount + unitCapital + ")");
            labelsums[flag].setText(this.getCurrencyName(currency, "sign") + this.getNumberFormat(outTotal.divide(new BigDecimal(10000), 2, 4)));
            ++flag;
        }
        HashMap<String, BigDecimal> dataMap = this.inOutMoneyCountBill(orgFilter, currency, beginDate);
        BigDecimal payCount = dataMap.get("payCount");
        BigDecimal recCount = dataMap.get("recCount");
        BigDecimal payTotal = dataMap.get("payTotal");
        BigDecimal recTotal = dataMap.get("recTotal");
        if (payCount != null && payCount.compareTo(BigDecimal.ZERO) != 0) {
            labels[flag].setText(ResManager.loadKDString((String)"\u6536\u5165\u7968\u636e", (String)"TraceInformationPlugin_6", (String)"tmc-mon-formplugin", (Object[])new Object[0]) + "(" + payCount + unit + ")");
            labelsums[flag].setText(this.getCurrencyName(currency, "sign") + this.getNumberFormat(payTotal.divide(new BigDecimal(10000), 2, 4)));
            ++flag;
        }
        if (recCount != null && recCount.compareTo(BigDecimal.ZERO) != 0) {
            labels[flag].setText(ResManager.loadKDString((String)"\u652f\u51fa\u7968\u636e", (String)"TraceInformationPlugin_7", (String)"tmc-mon-formplugin", (Object[])new Object[0]) + "(" + recCount + unit + ")");
            labelsums[flag].setText(this.getCurrencyName(currency, "sign") + this.getNumberFormat(recTotal.divide(new BigDecimal(10000), 2, 4)));
            ++flag;
        }
        while (flag <= 3) {
            labels[flag].setText(null);
            labelsums[flag].setText(null);
            ++flag;
        }
    }

    private HashMap<String, BigDecimal> inOutMoneyCountBill(QFilter orgFilter, Long currency, Date beginDate) {
        QFilter receiveQf;
        DynamicObject[] receivebills;
        QFilter begQf = new QFilter("issuedate", ">", (Object)beginDate).or(new QFilter("issuedate", "=", (Object)beginDate));
        QFilter endQf = new QFilter("issuedate", "<", (Object)this.getCalendarEndTime());
        DynamicObject[] payablebills = BusinessDataServiceHelper.load((String)"cdm_payablebill", (String)"id,currency,amount", (QFilter[])new QFilter[]{orgFilter, begQf.and(endQf)});
        HashMap<Long, BigDecimal> payTotalMoney = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> recTotalMoney = new HashMap<Long, BigDecimal>();
        BigDecimal recCount = BigDecimal.ZERO;
        BigDecimal payCount = BigDecimal.ZERO;
        if (payablebills != null && payablebills.length > 0) {
            for (DynamicObject payablebill : payablebills) {
                DynamicObject currencyData = payablebill.getDynamicObject("currency");
                if (currencyData == null) continue;
                Long currencyId = (Long)payablebill.getDynamicObject("currency").getPkValue();
                BigDecimal amount = payablebill.getBigDecimal("amount");
                BigDecimal sumMoney = payTotalMoney.get(currencyId);
                if (sumMoney == null) {
                    sumMoney = amount;
                    payTotalMoney.put(currencyId, sumMoney);
                } else {
                    sumMoney = sumMoney.add(amount);
                    payTotalMoney.put(currencyId, sumMoney);
                }
                payCount = payCount.add(BigDecimal.ONE);
            }
        }
        if ((receivebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,currency,amount", (QFilter[])new QFilter[]{orgFilter, receiveQf = new QFilter("draftbillstatus", "=", (Object)"endorsed"), begQf.and(endQf)})) != null && receivebills.length > 0) {
            for (DynamicObject receivebill : receivebills) {
                DynamicObject currencyData = receivebill.getDynamicObject("currency");
                if (currencyData == null) continue;
                Long currencyId = (Long)receivebill.getDynamicObject("currency").getPkValue();
                BigDecimal amount = receivebill.getBigDecimal("amount");
                BigDecimal sumMoney = recTotalMoney.get(currencyId);
                if (sumMoney == null) {
                    sumMoney = amount;
                    recTotalMoney.put(currencyId, sumMoney);
                } else {
                    sumMoney = sumMoney.add(amount);
                    recTotalMoney.put(currencyId, sumMoney);
                }
                recCount = recCount.add(BigDecimal.ONE);
            }
        }
        BigDecimal payTotal = this.diffCurrencyToMainCurrency(payTotalMoney, currency, this.cardName);
        BigDecimal recTotal = this.diffCurrencyToMainCurrency(recTotalMoney, currency, this.cardName);
        HashMap<String, BigDecimal> returnData = new HashMap<String, BigDecimal>();
        returnData.put("payCount", payCount);
        returnData.put("recCount", recCount);
        returnData.put("payTotal", payTotal);
        returnData.put("recTotal", recTotal);
        return returnData;
    }

    private Date getCalendarEndTime() {
        Object querycycle = this.getModel().getValue("querycycle");
        Date endDate = null;
        Date currDate = DateUtils.getCurrentDate();
        endDate = "date".equals(String.valueOf(querycycle)) ? DateUtils.getNextDay((Date)currDate, (int)1) : DateUtils.getFirstDayOfMonth((Date)DateUtils.getNextMonth((Date)currDate, (int)1));
        return endDate;
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, Object> sumMoney(List<Long> orgList, Long aimCurrency, Date beginDate) {
        void var25_41;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal mainCurrencyMoney = BigDecimal.ZERO;
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>(2);
        QFilter begindateQf = null;
        QFilter enddateQf = null;
        Object querycycle = this.getModel().getValue("querycycle");
        if (querycycle != null && "date".equals((String)querycycle)) {
            begindateQf = new QFilter("createtime", ">=", (Object)beginDate);
            enddateQf = new QFilter("createtime", "<", (Object)this.getCalendarEndTime());
        } else {
            begindateQf = new QFilter("bookdate", ">=", (Object)beginDate);
            enddateQf = new QFilter("bookdate", "<", (Object)this.getCalendarEndTime());
        }
        boolean statsInnerAcct = (Boolean)this.getModel().getValue("statsinneracct");
        if (!statsInnerAcct) {
            QFilter acctFilter = new QFilter("inneracct", "=", (Object)0L);
            DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])new QFilter[]{acctFilter});
            List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter innerAcctFilter = new QFilter("accountbank", "in", acctIds);
            baseFilters.add(innerAcctFilter);
        }
        long exRateTable = Optional.ofNullable((DynamicObject)this.getModel().getValue("exratetable")).map(v -> v.getLong("id")).orElse(0L);
        String dataSource = (String)this.getView().getModel().getValue("datasource");
        ArrayList<DynamicObject> finalData = new ArrayList<DynamicObject>(10);
        switch (dataSource) {
            case "bankjournal": {
                DynamicObject[] bankjournals = this.queryBankJournal(dataSource, baseFilters, begindateQf, enddateQf);
                finalData.addAll(Arrays.asList(bankjournals));
                break;
            }
            case "bankbalance": {
                DynamicObject[] transDetailsDo = this.queryTransDetail(dataSource, baseFilters, beginDate);
                finalData.addAll(Arrays.asList(transDetailsDo));
                break;
            }
            case "directconnacct": {
                DynamicObject[] queryBankJournal = this.queryBankJournal(dataSource, baseFilters, begindateQf, enddateQf);
                finalData.addAll(Arrays.asList(queryBankJournal));
                DynamicObject[] queryTransDetail = this.queryTransDetail(dataSource, baseFilters, beginDate);
                finalData.addAll(Arrays.asList(queryTransDetail));
            }
        }
        HashMap<Long, BigDecimal> currencyTotalMoney = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> notMaincurrencyTotalMoney = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> inTotalMoney = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> outTotalMoney = new HashMap<Long, BigDecimal>();
        BigDecimal inCount = BigDecimal.ZERO;
        BigDecimal outCount = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : finalData) {
            void var27_46;
            void var27_50;
            DynamicObject dynamicObject2 = dynamicObject.getDynamicObject("currency");
            if (dynamicObject2 == null) continue;
            Long l = (Long)dynamicObject.getDynamicObject("currency").getPkValue();
            BigDecimal debitamount = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            if ("cas_bankjournal".equals(dynamicObject.getDataEntityType().getName())) {
                debitamount = dynamicObject.getBigDecimal("debitamount");
                BigDecimal bigDecimal2 = dynamicObject.getBigDecimal("creditamount");
            } else if ("bei_transdetail".equals(dynamicObject.getDataEntityType().getName())) {
                debitamount = dynamicObject.getBigDecimal("creditamount");
                BigDecimal bigDecimal3 = dynamicObject.getBigDecimal("debitamount");
            }
            BigDecimal sumMoney = (BigDecimal)currencyTotalMoney.get(l);
            if (debitamount == null) {
                debitamount = BigDecimal.ZERO;
            }
            if (var27_50 == null) {
                BigDecimal bigDecimal4 = BigDecimal.ZERO;
            }
            if (sumMoney == null) {
                sumMoney = debitamount.add((BigDecimal)var27_46);
                currencyTotalMoney.put(l, sumMoney);
            } else {
                sumMoney = sumMoney.add(debitamount).add((BigDecimal)var27_46);
                currencyTotalMoney.put(l, sumMoney);
            }
            if (l.compareTo(aimCurrency) == 0) {
                mainCurrencyMoney = mainCurrencyMoney.add(debitamount.add((BigDecimal)var27_46));
            } else {
                BigDecimal notMainsumMoney = (BigDecimal)notMaincurrencyTotalMoney.get(l);
                if (notMainsumMoney == null) {
                    notMainsumMoney = debitamount.add((BigDecimal)var27_46);
                    notMaincurrencyTotalMoney.put(l, notMainsumMoney);
                } else {
                    notMainsumMoney = notMainsumMoney.add(debitamount).add((BigDecimal)var27_46);
                    notMaincurrencyTotalMoney.put(l, notMainsumMoney);
                }
            }
            if (debitamount.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal sumAcctMoney = (BigDecimal)outTotalMoney.get(l);
                if (sumAcctMoney == null) {
                    outTotalMoney.put(l, debitamount);
                } else {
                    sumAcctMoney = sumAcctMoney.add(debitamount);
                    outTotalMoney.put(l, sumAcctMoney);
                }
                outCount = outCount.add(BigDecimal.ONE);
            }
            if (var27_46.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal sumAcctOutMoney = (BigDecimal)inTotalMoney.get(l);
            if (sumAcctOutMoney == null) {
                inTotalMoney.put(l, (BigDecimal)var27_46);
            } else {
                sumAcctOutMoney = sumAcctOutMoney.add((BigDecimal)var27_46);
                inTotalMoney.put(l, sumAcctOutMoney);
            }
            inCount = inCount.add(BigDecimal.ONE);
        }
        ArrayList longRates = new ArrayList(currencyTotalMoney.size());
        for (Map.Entry entry : currencyTotalMoney.entrySet()) {
            longRates.add(entry.getKey());
        }
        boolean bl = BaseDataHelper.verifyExchangeRateCard(longRates, (Long)aimCurrency, (Long)TmcOrgDataHelper.getCurrentOrgId(), (Date)new Date(), (String)this.cardName, (AbstractFormPlugin)this);
        if (!bl) {
            return null;
        }
        for (Map.Entry entry : currencyTotalMoney.entrySet()) {
            Long id = (Long)entry.getKey();
            BigDecimal bigDecimal = BaseDataServiceHelper.getExchangeRate((Long)exRateTable, (Long)id, (Long)aimCurrency, (Date)new Date());
            if (null == bigDecimal) continue;
            BigDecimal totalMoney = (BigDecimal)entry.getValue();
            totalMoney = totalMoney.multiply(bigDecimal);
            total = total.add(totalMoney);
        }
        Object var24_32 = null;
        Object var25_40 = null;
        for (Map.Entry entry : notMaincurrencyTotalMoney.entrySet()) {
            void var25_43;
            void var24_35;
            void var24_33;
            Long id = (Long)entry.getKey();
            BigDecimal exchangeRate = BaseDataHelper.getExchangeRate((Long)id, (Long)aimCurrency, (Long)TmcOrgDataHelper.getCurrentOrgId(), (Date)new Date());
            if (null == exchangeRate) continue;
            BigDecimal totalMoney = (BigDecimal)entry.getValue();
            totalMoney = totalMoney.multiply(exchangeRate);
            if (var24_33 == null) {
                BigDecimal bigDecimal = totalMoney;
                Long l = id;
            }
            BigDecimal bigDecimal = var24_35.compareTo(totalMoney) > 0 ? var24_35 : totalMoney;
            Long l = bigDecimal.compareTo(totalMoney) > 0 ? var25_43 : id;
        }
        BigDecimal maxCurrencyMoney = (BigDecimal)currencyTotalMoney.get(var25_41);
        returnMap.put("currencyMaxId", var25_41);
        returnMap.put("maxCurrencyMoney", maxCurrencyMoney);
        returnMap.put("sumMoney", total);
        returnMap.put("MainCurrencyMoney", mainCurrencyMoney);
        BigDecimal bigDecimal = this.diffCurrencyToMainCurrency(inTotalMoney, aimCurrency, this.cardName);
        BigDecimal outTotal = this.diffCurrencyToMainCurrency(outTotalMoney, aimCurrency, this.cardName);
        returnMap.put("incount", outCount);
        returnMap.put("outcount", inCount);
        returnMap.put("inTotal", outTotal);
        returnMap.put("outTotal", bigDecimal);
        return returnMap;
    }

    private DynamicObject[] queryTransDetail(String dataSource, List<QFilter> baseFilters, Date beginDate) {
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"mon", (String)"mon_fundflow", (String)"47150e89000000ac");
        QFilter companyFilter = new QFilter("company", "in", (Object)authorizedBankOrgId);
        QFilter begindateQf = new QFilter("bizdate", ">=", (Object)beginDate);
        QFilter enddateQf = new QFilter("bizdate", "<", (Object)this.getCalendarEndTime());
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(10);
        queryFilter.addAll(baseFilters);
        queryFilter.add(companyFilter);
        queryFilter.add(begindateQf);
        queryFilter.add(enddateQf);
        if ("directconnacct".equals(dataSource)) {
            ArrayList<QFilter> acctBankFilter = new ArrayList<QFilter>(2);
            ArrayList<String> typeList = new ArrayList<String>(2);
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter = new QFilter("issetbankinterface", "=", (Object)"1");
            QFilter qFilter1 = new QFilter("finorgtype", "in", typeList);
            acctBankFilter.add(qFilter.or(qFilter1));
            if (acctBankFilter.size() > 0) {
                DynamicObjectCollection accts = QueryServiceHelper.query((String)"am_accountbank", (String)"id", (QFilter[])acctBankFilter.toArray(new QFilter[acctBankFilter.size()]));
                List acctIds = accts.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                QFilter acctFilter = new QFilter("accountbank.id", "in", acctIds);
                queryFilter.add(acctFilter);
            }
        }
        DynamicObject[] transDetailsDo = BusinessDataServiceHelper.load((String)"bei_transdetail", (String)"id,accountbank,currency,debitamount,creditamount", (QFilter[])queryFilter.toArray(new QFilter[queryFilter.size()]));
        return transDetailsDo;
    }

    private DynamicObject[] queryBankJournal(String dataSource, List<QFilter> baseFilters, QFilter begindateQf, QFilter enddateQf) {
        List authorizedBankOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"mon", (String)"mon_fundflow", (String)"47150e89000000ac");
        QFilter bankaccount = new QFilter("org", "in", (Object)authorizedBankOrgId);
        ArrayList<QFilter> queryFilter = new ArrayList<QFilter>(10);
        queryFilter.addAll(baseFilters);
        queryFilter.add(bankaccount);
        queryFilter.add(begindateQf);
        queryFilter.add(enddateQf);
        if ("directconnacct".equals(dataSource)) {
            ArrayList<String> typeList = new ArrayList<String>(2);
            QFilter qFilter = new QFilter("accountbank.issetbankinterface", "=", (Object)"0");
            typeList.add("1");
            typeList.add("3");
            QFilter qFilter1 = new QFilter("accountbank.finorgtype", "not in", typeList);
            queryFilter.add(qFilter.and(qFilter1));
        }
        DynamicObject[] bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,accountbank,currency,debitamount,creditamount", (QFilter[])queryFilter.toArray(new QFilter[queryFilter.size()]));
        return bankjournals;
    }

    private Date getDateByQueryCycle(String queryCycle) {
        Date beginDate = null;
        switch (queryCycle) {
            case "month": {
                beginDate = DateUtils.getFirstDayOfCurMonth();
                break;
            }
            default: {
                beginDate = DateUtils.getCurrentDate();
            }
        }
        return beginDate;
    }

    private void showFormCapitalSumrpt() {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("mon_fundflow");
        HashMap params = new HashMap();
        showParameter.setCustomParams(params);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long currencyId = OrgHelper.getMainCurrency((long)TmcOrgDataHelper.getCurrentOrgId());
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        filter.addFilterItem("filter_stadimension", (Object)"01");
        String value = (String)this.getModel().getValue("querycycle");
        if (value.equals("date")) {
            filter.addFilterItem("filter_staperiod", (Object)"05");
        } else {
            filter.addFilterItem("filter_staperiod", (Object)"04");
        }
        filter.addFilterItem("filter_queryway", (Object)"org");
        filter.addFilterItem("filter_org", this.getOrgList());
        filter.addFilterItem("filter_repcurrency", (Object)currencyId);
        long exRateTable = this.getModel().getValue("exratetable") != null ? ((DynamicObject)this.getModel().getValue("exratetable")).getLong("id") : 0L;
        filter.addFilterItem("exratetable", (Object)exRateTable);
        filter.addFilterItem("datasource", this.getModel().getValue("datasource"));
        filter.addFilterItem("statsinneracct", this.getModel().getValue("statsinneracct"));
        queryParam.setFilter(filter);
        showParameter.setQueryParam(queryParam);
        showParameter.setLinkQuery(true);
        showParameter.setPageId(this.getView().getPageId() + "fromtrace");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("summoney".equals(key)) {
            this.showFormCapitalSumrpt();
        }
    }
}

