/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.formplugin.trade;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.mon.common.helper.MonHelper;

public class MonPlanEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.filterOrgF7();
        this.addClickListeners(new String[]{"amountconditon", "sensitivecondition", "focusconditon"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long orgId = RequestContext.get().getOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgId, (String)"bos_org");
        dataEntity.set("createorg", (Object)org);
        dataEntity.set("status", (Object)BillStatusEnum.AUDIT.getValue());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        ArrayList<String> lst = new ArrayList<String>(3);
        lst.add("amountconditon");
        lst.add("sensitivecondition");
        lst.add("focusconditon");
        if (lst.contains(key)) {
            this.showForm(key);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey)) {
            IDataModel model = this.getModel();
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            boolean flag = false;
            for (DynamicObject entry : entryEntity) {
                DynamicObject org = entry.getDynamicObject("e_org");
                if (org == null) continue;
                flag = true;
                break;
            }
            if (!flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u4e2a\u9002\u7528\u7684\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"MonPlanEdit_0", (String)"tmc-mon-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                evt.setCancel(true);
                return;
            }
            Object amountconditon = model.getValue("amountconditon");
            Object sensitivecondition = model.getValue("sensitivecondition");
            Object focusconditon = model.getValue("focusconditon");
            Object questionconditon = model.getValue("questionconditon");
            if (StringUtils.isEmpty((CharSequence)amountconditon.toString()) && StringUtils.isEmpty((CharSequence)sensitivecondition.toString()) && StringUtils.isEmpty((CharSequence)focusconditon.toString()) && (Integer)questionconditon == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u4ea4\u6613\u76d1\u63a7\u6761\u4ef6\u3002", (String)"MonPlanEdit_1", (String)"tmc-mon-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                evt.setCancel(true);
                return;
            }
            HashSet<Long> orgSet = new HashSet<Long>();
            DynamicObjectCollection entrys = entryEntity;
            for (DynamicObject entry : entrys) {
                Long pkValue;
                DynamicObject org = entry.getDynamicObject("e_org");
                if (org == null || orgSet.add(pkValue = (Long)org.getPkValue())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u9002\u7528\u7684\u8d44\u91d1\u7ec4\u7ec7:", (String)"MonPlanEdit_2", (String)"tmc-mon-formplugin", (Object[])new Object[0]) + org.getString("name"), Integer.valueOf(3000));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void showForm(String condition) {
        FormShowParameter formShowParameter = new FormShowParameter();
        String conditionStr = (String)this.getModel().getValue(condition + "_real_TAG");
        formShowParameter.setFormId("mon_condition");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, condition));
        Object datasource = this.getModel().getValue("datasource");
        if ("bankbalance".equals(datasource)) {
            formShowParameter.setCustomParam("entitynumber", (Object)"bei_transdetail");
        } else {
            formShowParameter.setCustomParam("entitynumber", (Object)"cas_bankjournal");
        }
        formShowParameter.setCustomParam("formula", (Object)conditionStr);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        ArrayList<String> lst = new ArrayList<String>(3);
        lst.add("amountconditon");
        lst.add("sensitivecondition");
        lst.add("focusconditon");
        if (returnData != null && lst.contains(actionId)) {
            this.receiveExpressionSet(e, actionId);
        }
    }

    private void filterOrgF7() {
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("e_org");
        orgF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgIdCollection = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            QFilter fisbankrollQf = new QFilter("fisbankroll", "=", (Object)Boolean.TRUE);
            QFilter qFilter = new QFilter("id", "in", (Object)orgIdCollection.toArray());
            listShowParameter.getListFilterParameter().setFilter(qFilter.and(fisbankrollQf));
        });
    }

    private void receiveExpressionSet(ClosedCallBackEvent e, String filedName) {
        if (MonHelper.isNotEmpty((Object)e.getReturnData())) {
            String str = (String)e.getReturnData();
            CRCondition filterObj = (CRCondition)SerializationUtils.fromJsonString((String)str, CRCondition.class);
            this.getModel().setValue(filedName + "_real_TAG", (Object)str);
            String desp = "";
            if (StringUtils.isNotEmpty((CharSequence)filterObj.getExprTran().trim())) {
                desp = filterObj.getExprTran();
            }
            if (desp.length() > 1000) {
                desp = desp.substring(0, 999);
            }
            this.getModel().setValue(filedName, (Object)desp);
        }
    }
}

