/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.property.AcceptanceBillProp;
import kd.tmc.mon.report.helper.AcceptanceBillCurrencyEnum;
import kd.tmc.mon.report.helper.AcceptanceBillDataHelper;
import kd.tmc.mon.report.helper.AcceptanceBillFilterParamHelper;
import org.apache.commons.lang3.tuple.Pair;

public class AcceptanceBillReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private String radixStr = "/1";
    private static final Map<String, String> PROPERTY_MAPPING_MAP = new HashMap<String, String>(4);
    private static final Map<String, String> AMOUNT_MAPPING_MAP = new HashMap<String, String>(1);
    private static String groupType;
    private static String sumNameField;
    private static List<String> sumAmountFields;
    private static List<String> groupFields;
    private static final List<String> needTreeDisplayList;
    public static final String SELECT = "id,company.id as companyid,company.name as company, draftbillexpiredate as expiredate, acceptercompany.name as acceptername,currency, amount as totalamount";
    private static final Map<String, AcceptanceBillCurrencyEnum> CURRENCY_UNIT_MAP;

    public DataSet queryDataSet(ReportQueryParam param) {
        Map<String, Object> paramMap = AcceptanceBillDataHelper.transQueryParam(param);
        QFilter filter = this.initAcceptanceBillFilter(paramMap, PROPERTY_MAPPING_MAP);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(filter);
        String currencyUnit = (String)paramMap.get("filter_cnyunit");
        if (StringUtils.isNotEmpty((CharSequence)currencyUnit)) {
            this.radixStr = "/" + CURRENCY_UNIT_MAP.get(currencyUnit).getRadix();
        }
        DataSet dataSet = null;
        groupType = (String)paramMap.get("filter_grouptype");
        this.initFields();
        switch (groupType) {
            case "organization": {
                dataSet = this.groupByOrganization(paramMap, filters);
                break;
            }
            case "acceptor": {
                dataSet = this.groupByAcceptor(paramMap, filters);
                break;
            }
            case "currency": {
                dataSet = this.groupByCurrency(paramMap, filters);
                break;
            }
            case "paybilltype": {
                dataSet = this.groupByPaybilltype(paramMap, filters);
                break;
            }
            case "finance": {
                dataSet = this.groupByFinance(paramMap, filters);
            }
        }
        return dataSet;
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        if (needTreeDisplayList.contains(groupType)) {
            return bizDs;
        }
        return super.addSumRowDataSet(bizDs, paramMap);
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedOrgTree() {
        return needTreeDisplayList.contains(groupType);
    }

    public String sumNameField() {
        return sumNameField;
    }

    public List<String> sumAmountFields() {
        return sumAmountFields;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"companyid", (Object)"company");
    }

    public List<String> groupFields() {
        return groupFields;
    }

    public List<String> amountFields() {
        return sumAmountFields;
    }

    private void initFields() {
        groupFields = Collections.singletonList("company");
        switch (groupType) {
            case "acceptor": {
                sumNameField = "acceptername";
                groupFields = Collections.singletonList("acceptername");
                sumAmountFields = Arrays.asList(AcceptanceBillProp.fieldArr_acceptor_sum_key);
                break;
            }
            case "currency": {
                sumNameField = "currencyname";
                groupFields = Collections.singletonList("currencyname");
                sumAmountFields = Arrays.asList(AcceptanceBillProp.fieldArr_currency_sum_key);
                break;
            }
            case "organization": {
                sumAmountFields = Arrays.asList("sgroupa_report", "egroupa_report", "egroupa_minus");
                break;
            }
            case "finance": {
                sumAmountFields = Arrays.asList("sdbank_d_report", "sdbusiness_d_report", "sdsum_d_report", "edbank_d_report", "edbusiness_d_report", "edsum_d_report");
                break;
            }
            case "paybilltype": {
                sumAmountFields = Arrays.asList("sgroupc_surety", "sgroupc_credit", "sgroupc_other", "sgroupc_mortgage", "sgroupc_pledge", "sgroupc_guarantee", "sgroupc_sum", "egroupc_surety", "egroupc_credit", "egroupc_other", "egroupc_mortgage", "egroupc_pledge", "egroupc_guarantee", "egroupc_sum");
                break;
            }
        }
    }

    public QFilter initAcceptanceBillFilter(Map<String, Object> paramMap, Map<String, String> propertyMapping) {
        QFilter billMediumFilter;
        QFilter accepterFilter;
        QFilter filter = this.initOrgFilter(propertyMapping);
        QFilter billTypeFilter = AcceptanceBillFilterParamHelper.initBillTypeFilter(paramMap, propertyMapping);
        if (billTypeFilter != null) {
            filter = filter.and(billTypeFilter);
        }
        QFilter settlementtypeFilter = new QFilter("draftbilltype.settlementtype", "!=", (Object)"1").and(new QFilter("draftbilltype.settlementtype", "!=", (Object)"2"));
        filter = filter.and(settlementtypeFilter);
        QFilter currencyFilter = AcceptanceBillFilterParamHelper.initCurrencyFilter(paramMap, propertyMapping);
        if (currencyFilter != null) {
            filter = filter.and(currencyFilter);
        }
        if ((accepterFilter = AcceptanceBillFilterParamHelper.accepterFiFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(accepterFilter);
        }
        if ((billMediumFilter = AcceptanceBillFilterParamHelper.initBillMediumFilter(paramMap, propertyMapping)) != null) {
            filter = filter.and(billMediumFilter);
        }
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        filter = filter.and(billstatusFilter);
        QFilter draftbilltranstatusFilter = new QFilter("draftbilltranstatus", "=", (Object)"success");
        filter = filter.and(draftbilltranstatusFilter);
        QFilter draftbillStatusFilter = new QFilter("draftbillstatus", "=", (Object)"registered");
        filter = filter.and(draftbillStatusFilter);
        QFilter rptypeFilter = new QFilter("rptype", "=", (Object)"paybill");
        filter = filter.and(rptypeFilter);
        return filter;
    }

    private QFilter initOrgFilter(Map<String, String> propertyMapping) {
        String property = "org.id";
        if (propertyMapping != null && propertyMapping.containsKey("filter_company")) {
            property = propertyMapping.get("filter_company");
        }
        List orgIds = this.getQueryOrgIds(this.getQueryParam());
        return new QFilter(property, "in", (Object)orgIds);
    }

    private DataSet groupByOrganization(Map<String, Object> paramMap, List<QFilter> filters) {
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
        baseFilters.addAll(filters);
        baseFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap).or(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap)));
        DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,company.id as companyid,company.name as company, currency, amount" + this.radixStr + " as amountbase"), (QFilter[])baseFilters.toArray(new QFilter[0]), null);
        GroupbyDataSet baseGroup = baseDataSet.groupBy(new String[]{"companyid", "company"});
        baseDataSet = baseGroup.sum("amountbase").finish();
        ArrayList<QFilter> startDatefilters = new ArrayList<QFilter>();
        startDatefilters.addAll(filters);
        startDatefilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        DataSet startDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,company.id as companyid1,company.name as company1,currency, amount" + this.radixStr + " as sgroupa_amount"), (QFilter[])startDatefilters.toArray(new QFilter[0]), null);
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupa_amount", "sgroupa_report");
        startDateDataSet = AcceptanceBillDataHelper.exchangeRate(startDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateGroup = startDateDataSet.groupBy(new String[]{"company1"});
        startDateDataSet = startDateGroup.sum("sgroupa_amount").sum("sgroupa_report").finish();
        String[] dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] dataSetRightSelector = (String[])Arrays.stream(startDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateDataSet, JoinType.LEFT).on("company", "company1").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> endDatefilters = new ArrayList<QFilter>();
        endDatefilters.addAll(filters);
        endDatefilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        DataSet endDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,company.id as companyid2,company.name as company2, currency, amount" + this.radixStr + " as egroupa_amount"), (QFilter[])endDatefilters.toArray(new QFilter[0]), null);
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupa_amount", "egroupa_report");
        endDateDataSet = AcceptanceBillDataHelper.exchangeRate(endDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateGroup = endDateDataSet.groupBy(new String[]{"company2"});
        endDateDataSet = endDateGroup.sum("egroupa_amount").sum("egroupa_report").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateDataSet, JoinType.LEFT).on("company", "company2").select(dataSetLeftSelector, dataSetRightSelector).finish();
        GroupbyDataSet groupbyCompanyId = baseDataSet.groupBy(new String[]{"companyid", "company"});
        groupbyCompanyId = groupbyCompanyId.sum("sgroupa_report");
        baseDataSet = groupbyCompanyId.sum("egroupa_report").finish();
        baseDataSet = baseDataSet.addField("case when egroupa_report = null then 0 else egroupa_report end - case when sgroupa_report = null then 0 else sgroupa_report end", "egroupa_minus");
        return baseDataSet;
    }

    private DataSet groupByAcceptor(Map<String, Object> paramMap, List<QFilter> filters) {
        String[] dataSetRightSelector;
        String[] dataSetLeftSelector;
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
        baseFilters.addAll(filters);
        baseFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap).or(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap)));
        baseFilters.add(new QFilter("acceptername", "is not null", null));
        DataSet originDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as accepternamebase,currency, amount" + this.radixStr + " as amountbase"), (QFilter[])baseFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet baseDataSetCopy = null;
        DataSet idCopyDataSet = originDataSet.copy().select("id as idCopy");
        DataSet baseDataSet = originDataSet.copy();
        for (Row row : originDataSet) {
            Long id = row.getLong("id");
            String accepterName = row.getString("accepternamebase");
            DataSet filterBaseDataSet = null;
            if (EmptyUtil.isNotEmpty((CharSequence)accepterName)) {
                filterBaseDataSet = idCopyDataSet.filter("idCopy = " + id).addField("'" + accepterName.trim() + "'", "acceptername");
            }
            if (EmptyUtil.isEmpty(filterBaseDataSet)) continue;
            if (baseDataSetCopy == null) {
                baseDataSetCopy = filterBaseDataSet;
                continue;
            }
            baseDataSetCopy = baseDataSetCopy.union(filterBaseDataSet);
        }
        if (EmptyUtil.isEmpty(baseDataSetCopy)) {
            return baseDataSet;
        }
        if (baseDataSetCopy != null) {
            dataSetLeftSelector = (String[])Arrays.stream(baseDataSetCopy.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            dataSetRightSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            baseDataSet = baseDataSetCopy.join(baseDataSet, JoinType.LEFT).on("idCopy", "id").select(dataSetLeftSelector, dataSetRightSelector).finish();
        }
        GroupbyDataSet baseGroup = baseDataSet.groupBy(new String[]{"acceptername"});
        baseDataSet = baseGroup.sum("amountbase").finish();
        ArrayList<QFilter> startDatefilters = new ArrayList<QFilter>();
        startDatefilters.addAll(filters);
        startDatefilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDatefilters.add(new QFilter("acceptername", "is not null", null));
        DataSet startDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername1,currency, amount" + this.radixStr + " as sgroupa_amount"), (QFilter[])startDatefilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupa_amount", "sgroupa_report");
        startDateDataSet = AcceptanceBillDataHelper.exchangeRate(startDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateGroup = startDateDataSet.groupBy(new String[]{"acceptername1"});
        startDateDataSet = startDateGroup.sum("sgroupa_amount").sum("sgroupa_report").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateDataSet, JoinType.LEFT).on("acceptername", "acceptername1").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> endDatefilters = new ArrayList<QFilter>();
        endDatefilters.addAll(filters);
        endDatefilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDatefilters.add(new QFilter("acceptername", "is not null", null));
        DataSet endDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id as idCopy,billno as billnoCopy,company.id as companyidCopy,company.name as companyCopy, issuedate as issuedateCopy, draftbillexpiredate as expiredateCopy, acceptername as acceptername2,currency,amount" + this.radixStr + " as egroupa_amount"), (QFilter[])endDatefilters.toArray(new QFilter[0]), null);
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupa_amount", "egroupa_report");
        endDateDataSet = AcceptanceBillDataHelper.exchangeRate(endDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateGroup = endDateDataSet.groupBy(new String[]{"acceptername2"});
        endDateDataSet = endDateGroup.sum("egroupa_amount").sum("egroupa_report").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateDataSet, JoinType.LEFT).on("acceptername", "acceptername2").select(dataSetLeftSelector, dataSetRightSelector).finish();
        GroupbyDataSet groupbyDataSet = baseDataSet.groupBy(new String[]{"acceptername"});
        groupbyDataSet = groupbyDataSet.sum("sgroupa_report");
        baseDataSet = groupbyDataSet.sum("egroupa_report").finish();
        baseDataSet = baseDataSet.addField("case when egroupa_report = null then 0 else egroupa_report end - case when sgroupa_report = null then 0 else sgroupa_report end", "egroupa_minus");
        return baseDataSet;
    }

    private DataSet groupByCurrency(Map<String, Object> paramMap, List<QFilter> filters) {
        String[] dataSetRightSelector;
        String[] dataSetLeftSelector;
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
        baseFilters.addAll(filters);
        baseFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap).or(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap)));
        baseFilters.add(new QFilter("currency", "is not null", null));
        DataSet originDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as accepternamebase,currency, currency.name as currencynamebase, amount" + this.radixStr + " as amountbase"), (QFilter[])baseFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet baseDataSetCopy = null;
        DataSet idCopyDataSet = originDataSet.copy().select("id as idCopy");
        DataSet baseDataSet = originDataSet.copy();
        for (Row row : originDataSet) {
            Long id = row.getLong("id");
            String currencyName = row.getString("currencynamebase");
            DataSet filterBaseDataSet = null;
            if (EmptyUtil.isNotEmpty((CharSequence)currencyName)) {
                filterBaseDataSet = idCopyDataSet.filter("idCopy = " + id).addField("'" + currencyName.trim() + "'", "currencyname");
            }
            if (EmptyUtil.isEmpty(filterBaseDataSet)) continue;
            if (baseDataSetCopy == null) {
                baseDataSetCopy = filterBaseDataSet;
                continue;
            }
            baseDataSetCopy = baseDataSetCopy.union(filterBaseDataSet);
        }
        if (EmptyUtil.isEmpty(baseDataSetCopy)) {
            return baseDataSet;
        }
        if (baseDataSetCopy != null) {
            dataSetLeftSelector = (String[])Arrays.stream(baseDataSetCopy.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            dataSetRightSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
            baseDataSet = baseDataSetCopy.join(baseDataSet, JoinType.LEFT).on("idCopy", "id").select(dataSetLeftSelector, dataSetRightSelector).finish();
        }
        GroupbyDataSet baseGroup = baseDataSet.groupBy(new String[]{"currency", "currencyname"});
        baseDataSet = baseGroup.sum("amountbase").finish();
        ArrayList<QFilter> startDatefilters = new ArrayList<QFilter>();
        startDatefilters.addAll(filters);
        startDatefilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDatefilters.add(new QFilter("currency", "is not null", null));
        DataSet startDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, currency.name as currencyname1, amount" + this.radixStr + " as sgroupb_amount"), (QFilter[])startDatefilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupb_amount", "sgroupb_report");
        startDateDataSet = AcceptanceBillDataHelper.exchangeRate(startDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateGroup = startDateDataSet.groupBy(new String[]{"currencyname1"});
        startDateDataSet = startDateGroup.sum("sgroupb_amount").sum("sgroupb_report").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateDataSet, JoinType.LEFT).on("currencyname", "currencyname1").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> endDatefilters = new ArrayList<QFilter>();
        endDatefilters.addAll(filters);
        endDatefilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDatefilters.add(new QFilter("currency", "is not null", null));
        DataSet endDateDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id as idCopy,billno as billnoCopy,company.id as companyidCopy,company.name as companyCopy, issuedate as issuedateCopy, draftbillexpiredate as expiredateCopy, currency, currency.name as currencyname2,amount" + this.radixStr + " as egroupb_amount"), (QFilter[])endDatefilters.toArray(new QFilter[0]), null);
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupb_amount", "egroupb_report");
        endDateDataSet = AcceptanceBillDataHelper.exchangeRate(endDateDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateGroup = endDateDataSet.groupBy(new String[]{"currencyname2"});
        endDateDataSet = endDateGroup.sum("egroupb_amount").sum("egroupb_report").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateDataSet, JoinType.LEFT).on("currencyname", "currencyname2").select(dataSetLeftSelector, dataSetRightSelector).finish();
        GroupbyDataSet groupbyDataSet = baseDataSet.groupBy(new String[]{"currency", "currencyname"});
        groupbyDataSet = groupbyDataSet.sum("sgroupb_amount");
        groupbyDataSet = groupbyDataSet.sum("sgroupb_report");
        groupbyDataSet = groupbyDataSet.sum("egroupb_amount");
        baseDataSet = groupbyDataSet.sum("egroupb_report").finish();
        baseDataSet = baseDataSet.addField("case when egroupb_report = null then 0 else egroupb_report end - case when sgroupb_report = null then 0 else sgroupb_report end", "egroupb_minus");
        return baseDataSet;
    }

    private DataSet groupByPaybilltype(Map<String, Object> paramMap, List<QFilter> filters) {
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
        baseFilters.addAll(filters);
        baseFilters.add(new QFilter("paybilltype", "is not null", null));
        baseFilters.add(new QFilter("paybilltype", "!=", (Object)""));
        baseFilters.add(new QFilter("paybilltype", "!=", (Object)" "));
        baseFilters.add(new QFilter("paybilltype", "!=", (Object)",,"));
        DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_baseamount"), (QFilter[])baseFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        GroupbyDataSet startDateBaseGroup = baseDataSet.groupBy(new String[]{"company", "companyid"});
        baseDataSet = startDateBaseGroup.sum("sgroupc_baseamount").finish();
        ArrayList<QFilter> startDateGuaranteeFilters = new ArrayList<QFilter>();
        startDateGuaranteeFilters.addAll(filters);
        startDateGuaranteeFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDateGuaranteeFilters.add(new QFilter("paybilltype", "like", (Object)"%guarantee%"));
        DataSet startDateGuaranteeDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid1,company.name as company1, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sdbank_d_amount"), (QFilter[])startDateGuaranteeFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet idsDataSet = startDateGuaranteeDataSet.copy().select("id").distinct();
        Iterator itIds = idsDataSet.iterator();
        ArrayList<Long> allGuaranteeIds = new ArrayList<Long>();
        while (itIds.hasNext()) {
            Row data = (Row)itIds.next();
            Long id = data.getLong("id");
            allGuaranteeIds.add(id);
        }
        QFilter suretyDetailFilter = new QFilter("entry.debtbillid", "in", (Object)allGuaranteeIds.toArray());
        DataSet suretyDetailData = QueryServiceHelper.queryDataSet((String)"fbd_suretybill", (String)"fbd_suretybill", (String)("entry.debtamt" + this.radixStr + " as totaldebtamt, entry.debtbillid as debtbillid"), (QFilter[])new QFilter[]{suretyDetailFilter}, null);
        DataSet suretyDetailDataSum = suretyDetailData.copy().select(new String[]{"debtbillid", "totaldebtamt"}).groupBy(new String[]{"debtbillid"}).sum("totaldebtamt").finish();
        DataSet debtbillidsDataSet = suretyDetailDataSum.copy().select("debtbillid").distinct();
        Iterator itDebtbillids = debtbillidsDataSet.iterator();
        ArrayList<Long> debtBillIds = new ArrayList<Long>();
        while (itDebtbillids.hasNext()) {
            Row data = (Row)itDebtbillids.next();
            Long id = data.getLong("debtbillid");
            debtBillIds.add(id);
        }
        ArrayList<QFilter> startDateSuretyFilters = new ArrayList<QFilter>();
        startDateSuretyFilters.add(new QFilter("id", "in", debtBillIds));
        DataSet startDateSuretyDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid1,company.name as company1, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_amount"), (QFilter[])startDateSuretyFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_amount", "sgroupc_surety");
        startDateSuretyDataSet = AcceptanceBillDataHelper.exchangeRate(startDateSuretyDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateSuretyGroup = startDateSuretyDataSet.groupBy(new String[]{"company1", "companyid1"});
        startDateSuretyDataSet = startDateSuretyGroup.sum("sgroupc_amount").sum("sgroupc_surety").finish();
        String[] dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] dataSetRightSelector = (String[])Arrays.stream(startDateSuretyDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateSuretyDataSet, JoinType.LEFT).on("companyid", "companyid1").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> notDebtBillIds = new ArrayList<Long>();
        allGuaranteeIds.removeAll(debtBillIds);
        notDebtBillIds.addAll(allGuaranteeIds);
        QFilter pledgeDetailFilter = new QFilter("gsrcbillid", "in", (Object)notDebtBillIds.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%pledge%"));
        DataSet pledgeDetailData = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{pledgeDetailFilter}, null);
        DataSet pledgeDetailDataSum = pledgeDetailData.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet gsrcbillidsDataSet = pledgeDetailDataSum.copy().select("gsrcbillid").distinct();
        Iterator itPledgeBillIds = gsrcbillidsDataSet.iterator();
        ArrayList<Long> pledgeBillids = new ArrayList<Long>();
        while (itPledgeBillIds.hasNext()) {
            Row data = (Row)itPledgeBillIds.next();
            Long id = data.getLong("gsrcbillid");
            pledgeBillids.add(id);
        }
        ArrayList<QFilter> startDatePledgeFilters = new ArrayList<QFilter>();
        startDatePledgeFilters.add(new QFilter("id", "in", pledgeBillids));
        DataSet startDatePledgeDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid2,company.name as company2, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_pledgeamount"), (QFilter[])startDatePledgeFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_pledgeamount", "sgroupc_pledge");
        startDatePledgeDataSet = AcceptanceBillDataHelper.exchangeRate(startDatePledgeDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDatePledgeGroup = startDatePledgeDataSet.groupBy(new String[]{"company2", "companyid2"});
        startDatePledgeDataSet = startDatePledgeGroup.sum("sgroupc_pledgeamount").sum("sgroupc_pledge").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDatePledgeDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDatePledgeDataSet, JoinType.LEFT).on("companyid", "companyid2").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> notDebtPledgeBillIds = new ArrayList<Long>();
        notDebtBillIds.removeAll(pledgeBillids);
        notDebtPledgeBillIds.addAll(notDebtBillIds);
        QFilter mortgageDetailFilter = new QFilter("gsrcbillid", "in", (Object)notDebtPledgeBillIds.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%mortgage%"));
        DataSet mortgageDetailData = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{mortgageDetailFilter}, null);
        DataSet mortgageDetailDataSum = mortgageDetailData.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet mortgageIdsDataSet = mortgageDetailDataSum.copy().select("gsrcbillid").distinct();
        Iterator itMortgageBillIds = mortgageIdsDataSet.iterator();
        ArrayList<Long> mortgageBillids = new ArrayList<Long>();
        while (itMortgageBillIds.hasNext()) {
            Row data = (Row)itMortgageBillIds.next();
            Long id = data.getLong("gsrcbillid");
            mortgageBillids.add(id);
        }
        ArrayList<QFilter> startDateMortgageFilters = new ArrayList<QFilter>();
        startDateMortgageFilters.add(new QFilter("id", "in", mortgageBillids));
        DataSet startDateMortgageDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid3,company.name as company3, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_mortgageamount"), (QFilter[])startDateMortgageFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_mortgageamount", "sgroupc_mortgage");
        startDateMortgageDataSet = AcceptanceBillDataHelper.exchangeRate(startDateMortgageDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateMortgageGroup = startDateMortgageDataSet.groupBy(new String[]{"company3", "companyid3"});
        startDateMortgageDataSet = startDateMortgageGroup.sum("sgroupc_mortgageamount").sum("sgroupc_mortgage").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateMortgageDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateMortgageDataSet, JoinType.LEFT).on("companyid", "companyid3").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> ensureBillIds = new ArrayList<Long>();
        notDebtPledgeBillIds.removeAll(mortgageBillids);
        ensureBillIds.addAll(notDebtPledgeBillIds);
        QFilter ensureDetailFilter = new QFilter("gsrcbillid", "in", (Object)ensureBillIds.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%ensure%"));
        DataSet ensureDetailData = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{ensureDetailFilter}, null);
        DataSet ensureDetailDataSum = ensureDetailData.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet ensureIdsDataSet = ensureDetailDataSum.copy().select("gsrcbillid").distinct();
        Iterator itEnsureBillIds = ensureIdsDataSet.iterator();
        ArrayList<Long> ensureBillids = new ArrayList<Long>();
        while (itEnsureBillIds.hasNext()) {
            Row data = (Row)itEnsureBillIds.next();
            Long id = data.getLong("gsrcbillid");
            ensureBillids.add(id);
        }
        ArrayList<QFilter> startDateEnsureFilters = new ArrayList<QFilter>();
        startDateEnsureFilters.add(new QFilter("id", "in", ensureBillids));
        DataSet startDateEnsureDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid4,company.name as company4, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_guaranteeamount"), (QFilter[])startDateEnsureFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_guaranteeamount", "sgroupc_guarantee");
        startDateEnsureDataSet = AcceptanceBillDataHelper.exchangeRate(startDateEnsureDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateEnsureGroup = startDateEnsureDataSet.groupBy(new String[]{"company4", "companyid4"});
        startDateEnsureDataSet = startDateEnsureGroup.sum("sgroupc_guaranteeamount").sum("sgroupc_guarantee").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateEnsureDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateEnsureDataSet, JoinType.LEFT).on("companyid", "companyid4").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> startDateCreditFilters = new ArrayList<QFilter>();
        startDateCreditFilters.addAll(filters);
        startDateCreditFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDateCreditFilters.add(new QFilter("paybilltype", "not like", (Object)"%guarantee%"));
        startDateCreditFilters.add(new QFilter("paybilltype", "like", (Object)"%credit%"));
        DataSet startDateCreditDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid5,company.name as company5, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_creditamount"), (QFilter[])startDateCreditFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_creditamount", "sgroupc_credit");
        startDateCreditDataSet = AcceptanceBillDataHelper.exchangeRate(startDateCreditDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateCreditGroup = startDateCreditDataSet.groupBy(new String[]{"company5", "companyid5"});
        startDateCreditDataSet = startDateCreditGroup.sum("sgroupc_creditamount").sum("sgroupc_credit").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateCreditDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateCreditDataSet, JoinType.LEFT).on("companyid", "companyid5").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> startDateOtherFilters = new ArrayList<QFilter>();
        startDateOtherFilters.addAll(filters);
        startDateOtherFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDateOtherFilters.add(new QFilter("paybilltype", "=", (Object)",other,"));
        DataSet startDateOtherDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid6,company.name as company6, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sgroupc_otheramount"), (QFilter[])startDateOtherFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sgroupc_otheramount", "sgroupc_other");
        startDateOtherDataSet = AcceptanceBillDataHelper.exchangeRate(startDateOtherDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateOtherGroup = startDateOtherDataSet.groupBy(new String[]{"company6", "companyid6"});
        startDateOtherDataSet = startDateOtherGroup.sum("sgroupc_otheramount").sum("sgroupc_other").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateOtherDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateOtherDataSet, JoinType.LEFT).on("companyid", "companyid6").select(dataSetLeftSelector, dataSetRightSelector).finish();
        baseDataSet = baseDataSet.addField("sgroupc_surety + sgroupc_credit + sgroupc_other + sgroupc_mortgage + sgroupc_pledge + sgroupc_guarantee", "sgroupc_sum");
        ArrayList<QFilter> endDateGuaranteeFilters = new ArrayList<QFilter>();
        endDateGuaranteeFilters.addAll(filters);
        endDateGuaranteeFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDateGuaranteeFilters.add(new QFilter("paybilltype", "like", (Object)"%guarantee%"));
        DataSet endDateGuaranteeDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid1,company.name as company1, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_amount"), (QFilter[])endDateGuaranteeFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        DataSet idsDataSet1 = endDateGuaranteeDataSet.copy().select("id").distinct();
        Iterator itIds1 = idsDataSet1.iterator();
        ArrayList<Long> allGuaranteeIds1 = new ArrayList<Long>();
        while (itIds1.hasNext()) {
            Row data = (Row)itIds1.next();
            Long id = data.getLong("id");
            allGuaranteeIds1.add(id);
        }
        QFilter suretyDetailFilter1 = new QFilter("entry.debtbillid", "in", (Object)allGuaranteeIds1.toArray());
        DataSet suretyDetailData1 = QueryServiceHelper.queryDataSet((String)"fbd_suretybill", (String)"fbd_suretybill", (String)("entry.debtamt" + this.radixStr + " as totaldebtamt, entry.debtbillid as debtbillid"), (QFilter[])new QFilter[]{suretyDetailFilter1}, null);
        DataSet suretyDetailDataSum1 = suretyDetailData1.copy().select(new String[]{"debtbillid", "totaldebtamt"}).groupBy(new String[]{"debtbillid"}).sum("totaldebtamt").finish();
        DataSet debtbillidsDataSet1 = suretyDetailDataSum1.copy().select("debtbillid").distinct();
        Iterator itDebtbillids1 = debtbillidsDataSet1.iterator();
        ArrayList<Long> debtBillIds1 = new ArrayList<Long>();
        while (itDebtbillids1.hasNext()) {
            Row data = (Row)itDebtbillids1.next();
            Long id = data.getLong("debtbillid");
            debtBillIds1.add(id);
        }
        ArrayList<QFilter> endDateSuretyFilters = new ArrayList<QFilter>();
        endDateSuretyFilters.add(new QFilter("id", "in", debtBillIds1));
        DataSet endDateSuretyDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid7,company.name as company7, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_suretyamount"), (QFilter[])endDateSuretyFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_suretyamount", "egroupc_surety");
        endDateSuretyDataSet = AcceptanceBillDataHelper.exchangeRate(endDateSuretyDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateSuretyGroup = endDateSuretyDataSet.groupBy(new String[]{"company7", "companyid7"});
        endDateSuretyDataSet = endDateSuretyGroup.sum("egroupc_suretyamount").sum("egroupc_surety").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateSuretyDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateSuretyDataSet, JoinType.LEFT).on("companyid", "companyid7").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> notDebtBillIds1 = new ArrayList<Long>();
        allGuaranteeIds1.removeAll(debtBillIds1);
        notDebtBillIds1.addAll(allGuaranteeIds1);
        QFilter pledgeDetailFilter1 = new QFilter("gsrcbillid", "in", (Object)notDebtBillIds1.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%pledge%"));
        DataSet pledgeDetailData1 = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{pledgeDetailFilter1}, null);
        DataSet pledgeDetailDataSum1 = pledgeDetailData1.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet gsrcbillidsDataSet1 = pledgeDetailDataSum1.copy().select("gsrcbillid").distinct();
        Iterator itPledgeBillIds1 = gsrcbillidsDataSet1.iterator();
        ArrayList<Long> pledgeBillids1 = new ArrayList<Long>();
        while (itPledgeBillIds1.hasNext()) {
            Row data = (Row)itPledgeBillIds1.next();
            Long id = data.getLong("gsrcbillid");
            pledgeBillids1.add(id);
        }
        ArrayList<QFilter> endDatePledgeFilters = new ArrayList<QFilter>();
        endDatePledgeFilters.add(new QFilter("id", "in", pledgeBillids1));
        DataSet endDatePledgeDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid8,company.name as company8, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_pledgeamount"), (QFilter[])endDatePledgeFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_pledgeamount", "egroupc_pledge");
        endDatePledgeDataSet = AcceptanceBillDataHelper.exchangeRate(endDatePledgeDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDatePledgeGroup = endDatePledgeDataSet.groupBy(new String[]{"company8", "companyid8"});
        endDatePledgeDataSet = endDatePledgeGroup.sum("egroupc_pledgeamount").sum("egroupc_pledge").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDatePledgeDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDatePledgeDataSet, JoinType.LEFT).on("companyid", "companyid8").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> notDebtPledgeBillIds1 = new ArrayList<Long>();
        notDebtBillIds1.removeAll(pledgeBillids1);
        notDebtPledgeBillIds1.addAll(notDebtBillIds1);
        QFilter mortgageDetailFilter1 = new QFilter("gsrcbillid", "in", (Object)notDebtPledgeBillIds1.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%mortgage%"));
        DataSet mortgageDetailData1 = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{mortgageDetailFilter1}, null);
        DataSet mortgageDetailDataSum1 = mortgageDetailData1.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet mortgageIdsDataSet1 = mortgageDetailDataSum1.copy().select("gsrcbillid").distinct();
        Iterator itMortgageBillIds1 = mortgageIdsDataSet1.iterator();
        ArrayList<Long> mortgageBillids1 = new ArrayList<Long>();
        while (itMortgageBillIds1.hasNext()) {
            Row data = (Row)itMortgageBillIds1.next();
            Long id = data.getLong("gsrcbillid");
            mortgageBillids1.add(id);
        }
        ArrayList<QFilter> endDateMortgageFilters = new ArrayList<QFilter>();
        endDateMortgageFilters.add(new QFilter("id", "in", mortgageBillids1));
        DataSet endDateMortgageDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid9,company.name as company9, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_mortgageamount"), (QFilter[])endDateMortgageFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_mortgageamount", "egroupc_mortgage");
        endDateMortgageDataSet = AcceptanceBillDataHelper.exchangeRate(endDateMortgageDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateMortgageGroup = endDateMortgageDataSet.groupBy(new String[]{"company9", "companyid9"});
        endDateMortgageDataSet = endDateMortgageGroup.sum("egroupc_mortgageamount").sum("egroupc_mortgage").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateMortgageDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateMortgageDataSet, JoinType.LEFT).on("companyid", "companyid9").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<Long> ensureBillIds1 = new ArrayList<Long>();
        notDebtPledgeBillIds1.removeAll(mortgageBillids1);
        ensureBillIds1.addAll(notDebtPledgeBillIds1);
        QFilter ensureDetailFilter1 = new QFilter("gsrcbillid", "in", (Object)ensureBillIds1.toArray()).and(new QFilter("gcontract.guaranteeway", "like", (Object)"%ensure%"));
        DataSet ensureDetailData1 = QueryServiceHelper.queryDataSet((String)"gm_guaranteeuse", (String)"gm_guaranteeuse", (String)("gdebtamount" + this.radixStr + " as totalgdebtamount, gsrcbillid"), (QFilter[])new QFilter[]{ensureDetailFilter1}, null);
        DataSet ensureDetailDataSum1 = ensureDetailData1.copy().select(new String[]{"gsrcbillid", "totalgdebtamount"}).groupBy(new String[]{"gsrcbillid"}).sum("totalgdebtamount").finish();
        DataSet ensureIdsDataSet1 = ensureDetailDataSum1.copy().select("gsrcbillid").distinct();
        Iterator itEnsureBillIds1 = ensureIdsDataSet1.iterator();
        ArrayList<Long> ensureBillids1 = new ArrayList<Long>();
        while (itEnsureBillIds1.hasNext()) {
            Row data = (Row)itEnsureBillIds1.next();
            Long id = data.getLong("gsrcbillid");
            ensureBillids1.add(id);
        }
        ArrayList<QFilter> endDateEnsureFilters = new ArrayList<QFilter>();
        endDateEnsureFilters.add(new QFilter("id", "in", ensureBillids1));
        DataSet endDateEnsureDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid10,company.name as company10, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_guaranteeamount"), (QFilter[])endDateEnsureFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_guaranteeamount", "egroupc_guarantee");
        endDateEnsureDataSet = AcceptanceBillDataHelper.exchangeRate(endDateEnsureDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateEnsureGroup = endDateEnsureDataSet.groupBy(new String[]{"company10", "companyid10"});
        endDateEnsureDataSet = endDateEnsureGroup.sum("egroupc_guaranteeamount").sum("egroupc_guarantee").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateEnsureDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateEnsureDataSet, JoinType.LEFT).on("companyid", "companyid10").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> endDateCreditFilters = new ArrayList<QFilter>();
        endDateCreditFilters.addAll(filters);
        endDateCreditFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDateCreditFilters.add(new QFilter("paybilltype", "not like", (Object)"%guarantee%"));
        endDateCreditFilters.add(new QFilter("paybilltype", "like", (Object)"%credit%"));
        DataSet endDateCreditDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid11,company.name as company11, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_creditamount"), (QFilter[])endDateCreditFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_creditamount", "egroupc_credit");
        endDateCreditDataSet = AcceptanceBillDataHelper.exchangeRate(endDateCreditDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateCreditGroup = endDateCreditDataSet.groupBy(new String[]{"company11", "companyid11"});
        endDateCreditDataSet = endDateCreditGroup.sum("egroupc_creditamount").sum("egroupc_credit").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateCreditDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateCreditDataSet, JoinType.LEFT).on("companyid", "companyid11").select(dataSetLeftSelector, dataSetRightSelector).finish();
        ArrayList<QFilter> endDateOtherFilters = new ArrayList<QFilter>();
        endDateOtherFilters.addAll(filters);
        endDateOtherFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDateOtherFilters.add(new QFilter("paybilltype", "=", (Object)",other,"));
        DataSet endDateOtherDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid12,company.name as company12, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as egroupc_otheramount"), (QFilter[])endDateOtherFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("egroupc_otheramount", "egroupc_other");
        endDateOtherDataSet = AcceptanceBillDataHelper.exchangeRate(endDateOtherDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateOtherGroup = endDateOtherDataSet.groupBy(new String[]{"company12", "companyid12"});
        endDateOtherDataSet = endDateOtherGroup.sum("egroupc_otheramount").sum("egroupc_other").finish();
        dataSetLeftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(endDateOtherDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateOtherDataSet, JoinType.LEFT).on("companyid", "companyid12").select(dataSetLeftSelector, dataSetRightSelector).finish();
        baseDataSet = baseDataSet.addField("egroupc_surety + egroupc_credit + egroupc_other + egroupc_mortgage + egroupc_pledge + egroupc_guarantee", "egroupc_sum");
        return baseDataSet;
    }

    private DataSet groupByFinance(Map<String, Object> paramMap, List<QFilter> filters) {
        DynamicObjectCollection filterCurrencies = !EmptyUtil.isEmpty((Object)paramMap.get("filter_currencies")) ? (DynamicObjectCollection)paramMap.get("filter_currencies") : QueryServiceHelper.query((String)"bd_currency", (String)"id", null);
        DynamicObject reportCurrency = (DynamicObject)paramMap.get("filter_statcurrency");
        DynamicObject rateTable = (DynamicObject)paramMap.get("filter_exratetable");
        ArrayList<QFilter> startDateBankFilters = new ArrayList<QFilter>();
        startDateBankFilters.addAll(filters);
        startDateBankFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDateBankFilters.add(new QFilter("draftbilltype.settlementtype", "=", (Object)"6"));
        DataSet startDateBankDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid1,company.name as company1, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sdbank_d_amount"), (QFilter[])startDateBankFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sdbank_d_amount", "sdbank_d_report");
        startDateBankDataSet = AcceptanceBillDataHelper.exchangeRate(startDateBankDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateBankGroup = startDateBankDataSet.groupBy(new String[]{"company1", "companyid1"});
        startDateBankDataSet = startDateBankGroup.sum("sdbank_d_amount").sum("sdbank_d_report").finish();
        ArrayList<QFilter> startDateBusinessFilters = new ArrayList<QFilter>();
        startDateBusinessFilters.addAll(filters);
        startDateBusinessFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        startDateBusinessFilters.add(new QFilter("draftbilltype.settlementtype", "=", (Object)"5"));
        DataSet startDateBusinessDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid2,company.name as company2, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sdbusiness_d_amount"), (QFilter[])startDateBusinessFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sdbusiness_d_amount", "sdbusiness_d_report");
        startDateBusinessDataSet = AcceptanceBillDataHelper.exchangeRate(startDateBusinessDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateBusinessGroup = startDateBusinessDataSet.groupBy(new String[]{"company2", "companyid2"});
        startDateBusinessDataSet = startDateBusinessGroup.sum("sdbusiness_d_amount").sum("sdbusiness_d_report").finish();
        ArrayList<QFilter> startDateSumFilters = new ArrayList<QFilter>();
        startDateSumFilters.addAll(filters);
        startDateSumFilters.add(AcceptanceBillFilterParamHelper.getStartDateFilter(paramMap));
        DataSet startDateSumDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid3,company.name as company3, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as sdbusiness_d_sum"), (QFilter[])startDateSumFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("sdbusiness_d_sum", "sdsum_d_report");
        startDateSumDataSet = AcceptanceBillDataHelper.exchangeRate(startDateSumDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet startDateSumGroup = startDateSumDataSet.groupBy(new String[]{"company3", "companyid3"});
        startDateSumDataSet = startDateSumGroup.sum("sdbusiness_d_sum").sum("sdsum_d_report").finish();
        String[] dataSetLeftSelector = (String[])Arrays.stream(startDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] dataSetRightSelector = (String[])Arrays.stream(startDateBankDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        startDateSumDataSet = startDateSumDataSet.join(startDateBankDataSet, JoinType.LEFT).on("companyid3", "companyid1").select(dataSetLeftSelector, dataSetRightSelector).finish();
        dataSetLeftSelector = (String[])Arrays.stream(startDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        dataSetRightSelector = (String[])Arrays.stream(startDateBusinessDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        startDateSumDataSet = startDateSumDataSet.join(startDateBusinessDataSet, JoinType.LEFT).on("companyid3", "companyid2").select(dataSetLeftSelector, dataSetRightSelector).finish();
        startDateSumDataSet = startDateSumDataSet.addField("concat( sdbank_d_report * 100  / sdsum_d_report,\"%\")", "sdbank_d_ratio");
        startDateSumDataSet = startDateSumDataSet.addField("concat( sdbusiness_d_report * 100  / sdsum_d_report,\"%\")", "sdbusiness_d_ratio");
        startDateSumDataSet = startDateSumDataSet.addField("'100%'", "sdsum_d_ratio");
        ArrayList<QFilter> endDateBankFilters = new ArrayList<QFilter>();
        endDateBankFilters.addAll(filters);
        endDateBankFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDateBankFilters.add(new QFilter("draftbilltype.settlementtype", "=", (Object)"6"));
        DataSet endDateBankDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid4,company.name as company4, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as edbank_d_amount"), (QFilter[])endDateBankFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("edbank_d_amount", "edbank_d_report");
        endDateBankDataSet = AcceptanceBillDataHelper.exchangeRate(endDateBankDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateBankGroup = endDateBankDataSet.groupBy(new String[]{"company4", "companyid4"});
        endDateBankDataSet = endDateBankGroup.sum("edbank_d_amount").sum("edbank_d_report").finish();
        ArrayList<QFilter> endDateBusinessFilters = new ArrayList<QFilter>();
        endDateBusinessFilters.addAll(filters);
        endDateBusinessFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        endDateBusinessFilters.add(new QFilter("draftbilltype.settlementtype", "=", (Object)"5"));
        DataSet endDateBusinessDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid5,company.name as company5, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as edbusiness_d_amount"), (QFilter[])endDateBusinessFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("edbusiness_d_amount", "edbusiness_d_report");
        endDateBusinessDataSet = AcceptanceBillDataHelper.exchangeRate(endDateBusinessDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateBusinessGroup = endDateBusinessDataSet.groupBy(new String[]{"company5", "companyid5"});
        endDateBusinessDataSet = endDateBusinessGroup.sum("edbusiness_d_amount").sum("edbusiness_d_report").finish();
        ArrayList<QFilter> endDateSumFilters = new ArrayList<QFilter>();
        endDateSumFilters.addAll(filters);
        endDateSumFilters.add(AcceptanceBillFilterParamHelper.getEndDateFilter(paramMap));
        DataSet endDateSumDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid6,company.name as company6, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as edsum_d_sum"), (QFilter[])endDateSumFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        AMOUNT_MAPPING_MAP.clear();
        AMOUNT_MAPPING_MAP.put("edsum_d_sum", "edsum_d_report");
        endDateSumDataSet = AcceptanceBillDataHelper.exchangeRate(endDateSumDataSet, filterCurrencies, reportCurrency, rateTable, AMOUNT_MAPPING_MAP);
        GroupbyDataSet endDateSumGroup = endDateSumDataSet.groupBy(new String[]{"company6", "companyid6"});
        endDateSumDataSet = endDateSumGroup.sum("edsum_d_sum").sum("edsum_d_report").finish();
        String[] leftSelector = (String[])Arrays.stream(endDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        String[] rightSelector = (String[])Arrays.stream(endDateBankDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        endDateSumDataSet = endDateSumDataSet.join(endDateBankDataSet, JoinType.LEFT).on("companyid6", "companyid4").select(leftSelector, rightSelector).finish();
        leftSelector = (String[])Arrays.stream(endDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        rightSelector = (String[])Arrays.stream(endDateBusinessDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        endDateSumDataSet = endDateSumDataSet.join(endDateBusinessDataSet, JoinType.LEFT).on("companyid6", "companyid5").select(leftSelector, rightSelector).finish();
        endDateSumDataSet = endDateSumDataSet.addField("concat( edbank_d_report * 100  / edsum_d_report,\"%\")", "edbank_d_ratio");
        endDateSumDataSet = endDateSumDataSet.addField("concat( edbusiness_d_report * 100  / edsum_d_report,\"%\")", "edbusiness_d_ratio");
        endDateSumDataSet = endDateSumDataSet.addField("'100%'", "edsum_d_ratio");
        ArrayList<QFilter> baseFilters = new ArrayList<QFilter>();
        baseFilters.addAll(filters);
        DataSet baseDataSet = QueryServiceHelper.queryDataSet((String)"cdm_payablebill", (String)"cdm_payablebill", (String)("id,billno,company.id as companyid,company.name as company, issuedate, draftbillexpiredate as expiredate, ispayinterest,draftbilltype.name as billtype,draftbillno,acceptername as acceptername,currency, amount" + this.radixStr + " as amountbase"), (QFilter[])baseFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"expiredate DESC"});
        GroupbyDataSet baseGroup = baseDataSet.groupBy(new String[]{"company", "companyid"});
        baseDataSet = baseGroup.sum("amountbase").finish();
        leftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        rightSelector = (String[])Arrays.stream(startDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(startDateSumDataSet, JoinType.LEFT).on("companyid", "companyid1").select(leftSelector, rightSelector).finish();
        leftSelector = (String[])Arrays.stream(baseDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        rightSelector = (String[])Arrays.stream(endDateSumDataSet.getRowMeta().getFields()).map(Field::getAlias).toArray(String[]::new);
        baseDataSet = baseDataSet.join(endDateSumDataSet, JoinType.LEFT).on("companyid", "companyid6").select(leftSelector, rightSelector).finish();
        baseDataSet = baseDataSet.addField("concat( case when edbank_d_report = null then 0 else edbank_d_report end - case when sdbank_d_report = null then 0 else sdbank_d_report end , \"\")", "edbank_d_minus");
        baseDataSet = baseDataSet.addField("concat( case when edbusiness_d_report = null then 0 else edbusiness_d_report end - case when sdbusiness_d_report = null then 0 else sdbusiness_d_report end ,\"\")", "edbusiness_d_minus");
        return baseDataSet;
    }

    static {
        needTreeDisplayList = Arrays.asList(AcceptanceBillProp.fieldArr_need_treedisplay_key);
        PROPERTY_MAPPING_MAP.put("filter_company", "company.id");
        PROPERTY_MAPPING_MAP.put("filter_billtypebase", "draftbilltype.id");
        PROPERTY_MAPPING_MAP.put("filter_billmedium", "draftbilltype.billmedium");
        CURRENCY_UNIT_MAP = Collections.unmodifiableMap(new HashMap<String, AcceptanceBillCurrencyEnum>(8){
            {
                this.put(AcceptanceBillCurrencyEnum.BILLION.getRadix(), AcceptanceBillCurrencyEnum.BILLION);
                this.put(AcceptanceBillCurrencyEnum.MILLION.getRadix(), AcceptanceBillCurrencyEnum.MILLION);
                this.put(AcceptanceBillCurrencyEnum.TENTHOUSAND.getRadix(), AcceptanceBillCurrencyEnum.TENTHOUSAND);
                this.put(AcceptanceBillCurrencyEnum.THOUSAND.getRadix(), AcceptanceBillCurrencyEnum.THOUSAND);
                this.put(AcceptanceBillCurrencyEnum.ORIGINAL.getRadix(), AcceptanceBillCurrencyEnum.ORIGINAL);
            }
        });
    }
}

