/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.business.query.AccountMoneyService;
import kd.tmc.mon.report.helper.AccountMoneyDataHelper;

public class AccountMoneySumListDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static Log logger = LogFactory.getLog(AccountMoneySumListDataPlugin.class);
    private static Map<String, String> vTreeBaseMap = new HashMap<String, String>(2);

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam, Object paramObject) throws Throwable {
        FilterInfo filter = queryParam.getFilter();
        Map paramMap = this.transQueryParam(queryParam);
        String calcStyle = filter.getString("calculatestyle");
        Date balanceDate = filter.getDate("balancedate");
        DynamicObject rptCur = filter.getDynamicObject("filter_statcurrency");
        Long rptCurId = rptCur.getLong("id");
        String datasource = filter.getString("datasource");
        String[] sortFields = (String[])filter.getValue("sortFields");
        long orgId = RequestContext.get().getOrgId();
        DynamicObjectCollection balanceCurrency = filter.getDynamicObjectCollection("balancecurrency");
        DynamicObjectCollection bankFi = filter.getDynamicObjectCollection("bankfi");
        String acctPropFi = filter.getString("acctpropfi");
        String acctTypeFi = filter.getString("accttypefi");
        DynamicObjectCollection acctUserFi = filter.getDynamicObjectCollection("acctuserfi");
        String showType = filter.getString("showtype");
        boolean statsInnerAcct = filter.getBoolean("statsinneracct");
        boolean showTypeA = "org".equalsIgnoreCase(calcStyle) && "A".equalsIgnoreCase(showType);
        List orgIds = this.getQueryOrgIds(queryParam);
        String currUnit = filter.getString("filter_currencyunit");
        List acctIds = AccountMoneyService.getAcctIds((DynamicObjectCollection)balanceCurrency, (DynamicObjectCollection)bankFi, (String)acctPropFi, (String)acctTypeFi, (DynamicObjectCollection)acctUserFi, (List)orgIds, (boolean)statsInnerAcct);
        DataSet balanceData = AccountMoneyService.queryBalanceData((String)datasource, (Date)balanceDate, (DynamicObjectCollection)balanceCurrency, (List)orgIds, (List)acctIds);
        if (balanceData != null) {
            if (acctIds.isEmpty()) {
                return this.createEmptyDataSet(balanceData);
            }
            Long exchangeRateTableId = ((DynamicObject)paramMap.get("exratetable")).getLong("id");
            DataSet detailData = AccountMoneyService.getDetailDataSet((DataSet)balanceData, (Long)rptCurId, (Date)balanceDate, (long)exchangeRateTableId, (String)currUnit);
            if ("currency".equals(calcStyle)) {
                DataSet curData = AccountMoneyService.queryByCurrency((DynamicObject)rptCur, (Date)balanceDate, (DataSet)detailData, (String[])sortFields, (long)exchangeRateTableId);
                return AccountMoneyDataHelper.getBizDsUpOrgTree(curData);
            }
            DataSet noCurData = AccountMoneyService.queryByOthers((String)calcStyle, (DynamicObject)rptCur, (Date)balanceDate, (DataSet)detailData, (String[])sortFields, (long)exchangeRateTableId);
            if (showTypeA) {
                DataSet dataSet = this.getTreeDataSet(noCurData, orgIds, rptCur);
                return dataSet;
            }
            return AccountMoneyDataHelper.getBizDsUpOrgTree(noCurData);
        }
        return null;
    }

    private DataSet getTreeDataSet(DataSet detailDataSet, List<Long> orgIdList, DynamicObject rptCurrency) {
        DataSet bizData = detailDataSet.copy();
        ArrayList<String> statField = new ArrayList<String>(2);
        statField.add("reportamt");
        String rptCurName = EmptyUtil.isNoEmpty((DynamicObject)rptCurrency) ? rptCurrency.getString("name") : "";
        Map<String, String> vbizBaseMap = AccountMoneyDataHelper.getBizBaseMap(bizData, statField, vTreeBaseMap);
        vbizBaseMap.put("amount", "0.00");
        vbizBaseMap.put("currency", "'" + rptCurName + "'");
        bizData = AccountMoneyDataHelper.getBizDsWithOrgTree(bizData, "rowid", "orgid", statField, vTreeBaseMap, vbizBaseMap, orgIdList);
        bizData = AccountMoneyDataHelper.getSumDataSet(bizData, statField, true, (AbstractTmcListDataPlugin)this);
        bizData = bizData.updateField("amount", "case when amount = 0 then reportamt+0.00 else amount+0.00 end");
        bizData = bizData.orderBy(new String[]{"currency asc"});
        bizData = bizData.filter("amount !=0.00");
        return bizData;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        return super.getColumns(columns);
    }

    static {
        vTreeBaseMap.put("org", "orgname");
        vTreeBaseMap.put("orgid", "rowid");
    }
}

