/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.QueryTypeEnum;
import kd.tmc.mon.report.helper.AcctBalanceServiceHelper;
import kd.tmc.mon.report.helper.FinReportHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BankDepositDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String CURRENCYID = "currency.id";
    private static final String ACCOUNTBANKID = "accountbank.id";
    private static final String REGION = "region";
    private static final String FINORGTYPE = "finorgtype";
    private static final String ROWID = "rowid";
    private static final String ORGIDS = "orgids";
    private static final String ORGNAME = "orgname";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        paramMap.put(ORGIDS, this.getQueryOrgIds(queryParam));
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        String statDim = (String)paramMap.get("filter_statdim");
        DataSet dataSet = this.queryBankDataSet(paramMap);
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        dataSet = dataSet.addFields(new String[]{tarCurrencyId + "L", "0"}, new String[]{"statcurrency", "sumlevel"});
        if ("org".equals(statDim)) {
            String showType = (String)paramMap.get("filter_showttype");
            if ("step".equals(showType)) {
                dataSet = this.addOrgViewTree(dataSet, paramMap, queryParam);
            } else {
                dataSet = dataSet.filter("baseamt != 0.0 or endamt != 0.0");
                dataSet = dataSet.addFields(new String[]{"sumlevel + '_' + org", "'0'", "1", "'0'"}, new String[]{ROWID, "pid", "level", "isgroupnode"});
            }
        } else {
            dataSet = dataSet.updateFields(new String[]{ROWID, "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"});
        }
        dataSet = this.addSubRowDataSet(dataSet, paramMap);
        dataSet = this.addSumRowDataSet(dataSet, paramMap);
        dataSet = dataSet.updateField("statcurrency", tarCurrencyId + "L");
        return this.reDealResultDataSet(dataSet, queryParam);
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        dataSet = dataSet.addField("endamt-baseamt", "changeamount");
        dataSet = dataSet.addField("case when baseamt=0 then 0.00 else changeamount*100/abs(baseamt) end", "changerate");
        dataSet = this.calculationAddRate(dataSet);
        return dataSet;
    }

    private DataSet queryBankDataSet(Map<String, Object> paramMap) {
        DataSet resultDs;
        DataSet acctBankDs = this.getAcctBankDs(paramMap);
        acctBankDs = acctBankDs.where("finorgtype IS NOT NULL");
        List<DataSet> dataSets = this.getDateBalanceDs(paramMap, (Date)paramMap.get("filter_basedate"), (Date)paramMap.get("filter_cutoffdate"));
        if (EmptyUtil.isEmpty(dataSets)) {
            RowMeta rowMeta = new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType});
            return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
        }
        DataSet baseDateBalanceDs = dataSets.get(0);
        DataSet endDateBalanceDs = dataSets.get(1);
        DataSet baseJoinDs = baseDateBalanceDs.leftJoin(acctBankDs.copy()).on(ACCOUNTBANKID, "id").select(new String[]{"org.id org", "org.name orgname", "currency.id currency", "currency.id currencyid", "currency currencyname", "endBalance amount"}, new String[]{"id", "bank", FINORGTYPE, REGION, "company.name company"}).finish();
        DataSet endJoinDs = endDateBalanceDs.leftJoin(acctBankDs).on(ACCOUNTBANKID, "id").select(new String[]{"org.id org", "org.name orgname", "currency.id currency", "currency.id currencyid", "currency currencyname", "endBalance amount"}, new String[]{"id", "bank", FINORGTYPE, REGION, "company.name company"}).finish();
        baseJoinDs = this.filterRegion(baseJoinDs, paramMap);
        endJoinDs = this.filterRegion(endJoinDs, paramMap);
        baseJoinDs = this.filterCurrency(baseJoinDs, paramMap);
        endJoinDs = this.filterCurrency(endJoinDs, paramMap);
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        String statDim = (String)paramMap.get("filter_statdim");
        if ("org".equals(statDim)) {
            resultDs = this.getDsByStatDimOrg(baseJoinDs, endJoinDs, paramMap);
        } else if ("finorgname".equals(statDim)) {
            DataSet dsFromGroup = this.getDsByStatDimBank(baseJoinDs, endJoinDs, paramMap);
            resultDs = this.dealDataSetByBank(dsFromGroup, tarCurrencyId);
            resultDs = resultDs.isEmpty() ? resultDs : resultDs.removeFields(new String[]{this.sumField});
        } else {
            DataSet dsFromGroup = this.getDsByStatDimCurrency(baseJoinDs, endJoinDs, paramMap);
            resultDs = this.dealDataSetByCurrency(dsFromGroup, tarCurrencyId);
        }
        return resultDs;
    }

    private DataSet dealDataSetByBank(DataSet dataSet, Long tarCurrencyId) {
        dataSet = dataSet.addField(tarCurrencyId + "L", "currency");
        DataSet[] dataSets = dataSet.splitByFilter(new String[]{"finorgtype = '0'"}, true);
        DataSet bankTreeDs = this.createBankTree(dataSets[0].removeFields(new String[]{FINORGTYPE}), tarCurrencyId);
        DataSet finOrgTreeDs = this.createFinOrgTree(dataSets[1].removeFields(new String[]{FINORGTYPE}), tarCurrencyId);
        if (bankTreeDs.isEmpty() && finOrgTreeDs.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        DataSet allDataSets = finOrgTreeDs.isEmpty() ? bankTreeDs : (bankTreeDs.isEmpty() ? finOrgTreeDs : bankTreeDs.union(finOrgTreeDs));
        return allDataSets;
    }

    private DataSet dealDataSetByCurrency(DataSet dataSet, Long tarCurrencyId) {
        Set<Long> currencyIds = this.getDataSetFieldIds(dataSet, "currency");
        DataSet currencyDs = FinReportHelper.getBaseDataDs(currencyIds, "bd_currency");
        currencyDs = currencyDs.updateField("isgroupnode", "'0'");
        return dataSet.leftJoin(currencyDs).on("currency", "id").select(new String[]{"name orgname", "basechinamt", "basegatamt", "baseabroadamt", "baseamt", "endchinamt", "endgatamt", "endabroadamt", "endamt", ROWID, "pid", "isgroupnode", "level", "'" + tarCurrencyId + "'currency"}).finish();
    }

    private DataSet getDsByStatDimOrg(DataSet baseJoinDs, DataSet endJoinDs, Map<String, Object> paramMap) {
        DataSet baseGroupDs = baseJoinDs.groupBy(new String[]{"org", ORGNAME, "currency", REGION}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, true, new String[]{"org", ORGNAME, REGION});
        DataSet endGroupDs = endJoinDs.groupBy(new String[]{"org", ORGNAME, "currency", REGION}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endGroupDs, paramMap, false, new String[]{"org", ORGNAME, REGION}).select(new String[]{"org org1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("org", "org1").on(REGION, "region1").select(new String[]{"( case when org=null then org1 else org end ) org", "( case when region=null then region1 else region end ) region", "amount", "amount1", ORGNAME}).finish();
        return this.getDsFromGroupOrg(baseAndEndDs).select(new String[]{"org", ORGNAME, "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
    }

    private DataSet getDsByStatDimBank(DataSet baseJoinDs, DataSet endJoinDs, Map<String, Object> paramMap) {
        DataSet baseGroupDs = baseJoinDs.groupBy(new String[]{"bank", REGION, FINORGTYPE, "currency"}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, true, new String[]{"bank", REGION, FINORGTYPE});
        DataSet endGroupDs = endJoinDs.groupBy(new String[]{"bank", REGION, FINORGTYPE, "currency"}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endGroupDs, paramMap, false, new String[]{"bank", REGION, FINORGTYPE}).select(new String[]{"bank bank1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("bank", "bank1").on(REGION, "region1").select(new String[]{"( case when bank=null then bank1 else bank end ) bank ", "( case when region=null then region1 else region end ) region", "amount", "amount1", FINORGTYPE}).finish();
        DataSet dsFromGroup = this.getDsFromGroupCreditor(baseAndEndDs).select(new String[]{"bank", FINORGTYPE, "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
        return dsFromGroup.filter("baseamt!=0 or endamt!=0");
    }

    private DataSet getDsByStatDimCurrency(DataSet baseJoinDs, DataSet endJoinDs, Map<String, Object> paramMap) {
        DataSet baseGroupDs = baseJoinDs.groupBy(new String[]{"currency", REGION}).sum("amount").finish();
        DataSet baseSumDs = this.getDsConverEx(baseGroupDs, paramMap, true, new String[]{REGION, "currency"});
        DataSet endGroupDs = endJoinDs.groupBy(new String[]{"currency", REGION}).sum("amount").finish();
        DataSet endSumDs = this.getDsConverEx(endGroupDs, paramMap, false, new String[]{REGION, "currency"}).select(new String[]{"currency currency1", "region region1", "amount amount1"});
        DataSet baseAndEndDs = baseSumDs.fullJoin(endSumDs).on("currency", "currency1").on(REGION, "region1").select(new String[]{"( case when currency=null then currency1 else currency end ) currency ", "( case when region=null then region1 else region end ) region", "amount", "amount1"}).finish();
        DataSet dsFromGroupCurrency = this.getDsFromGroupCurrency(baseAndEndDs).select(new String[]{"currency", "basechinamt", "basegatamt", "baseabroadamt", "basechinamt+basegatamt+baseabroadamt baseamt", "endchinamt", "endgatamt", "endabroadamt", "endchinamt+endgatamt+endabroadamt endamt"});
        return dsFromGroupCurrency.filter("baseamt!=0 or endamt!=0");
    }

    private DataSet createBankTree(DataSet bankDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(bankDs, "bank");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, "bank_cate");
        String[] fieldNames = bankDs.getRowMeta().getFieldNames();
        Set<Long> bankTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet bankcgSettingDs = FinReportHelper.getBaseDataDs(bankTypeIds, "bd_bankcgsetting").addField(tarCurrencyId + "L", "currency").select("0 bank,0 basechinamt,0 basegatamt,0 baseabroadamt,0 baseamt,0 endchinamt,0 endgatamt,0 endabroadamt,0 endamt,currency,0 changeamount,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = bankDs.leftJoin(bdFinorgInfoDs).on("bank", "id").select(fieldNames, new String[]{"endamt-baseamt as changeamount", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish().filter("pid!=0");
        DataSet bankTreeDs = creditorDs.union(bankcgSettingDs);
        return this.getSumDataSet(bankTreeDs);
    }

    private DataSet createFinOrgTree(DataSet finorgDs, Long tarCurrencyId) {
        Set<Long> bankIds = this.getDataSetFieldIds(finorgDs, "bank");
        DataSet bdFinorgInfoDs = FinReportHelper.getBdFinorgInfo(bankIds, FINORGTYPE);
        String[] fieldNames = finorgDs.getRowMeta().getFieldNames();
        Set<Long> finTypeIds = this.getDataSetFieldIds(bdFinorgInfoDs, "pid");
        DataSet finorgTypeds = FinReportHelper.getBaseDataDs(finTypeIds, "bd_finorgtype").addField(tarCurrencyId + "L", "currency").select("0 bank,0 basechinamt,0 basegatamt,0 baseabroadamt,0 baseamt,0 endchinamt,0 endgatamt,0 endabroadamt,0 endamt,currency,0 changeamount,id,rowid,name orgname,pid,isgroupnode,level,0 sumlevel");
        DataSet creditorDs = finorgDs.leftJoin(bdFinorgInfoDs).on("bank", "id").select(fieldNames, new String[]{"endamt-baseamt as changeamount", "id", ROWID, "name orgname", "pid", "isgroupnode", "level", "0 sumlevel"}).finish();
        DataSet finOrgTreeDs = creditorDs.union(finorgTypeds);
        DataSet sumDataSet = this.getSumDataSet(finOrgTreeDs);
        return sumDataSet.select(new String[]{ROWID, "pid", "isgroupnode", "level", "sumlevel", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "changeamount", ORGNAME, "currency", "changerate"});
    }

    private Set<Long> getDataSetFieldIds(DataSet dataSet, String field) {
        HashSet<Long> ids = new HashSet<Long>(16);
        dataSet.copy().forEach(o -> ids.add(o.getLong(field)));
        return ids;
    }

    private DataSet getDsFromGroupOrg(DataSet loanBillDs) {
        DataSet regionR1Group = loanBillDs.filter("region='R1'").select(new String[]{"org org1", "amount basechinamt", "amount1 endchinamt", ORGNAME});
        DataSet regionR2Group = loanBillDs.filter("region='R2'").select(new String[]{"org org2", "amount basegatamt", "amount1 endgatamt", ORGNAME});
        DataSet regionR3Group = loanBillDs.filter("region='R3'").select(new String[]{"org org3", "amount baseabroadamt", "amount1 endabroadamt", ORGNAME});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("org1", "org2").select(new String[]{"(case when org1=null then org2 else org1 end ) org12", "basechinamt", "basegatamt", "endchinamt", "endgatamt", ORGNAME}).finish();
        groupR12Ds = this.updateFieldDs(groupR12Ds);
        DataSet ds = groupR12Ds.fullJoin(regionR3Group).on("org12", "org3").select(new String[]{"( case when org12=null then org3 else org12 end ) org", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt", ORGNAME}).finish();
        return this.updateRegionField(ds);
    }

    private DataSet getDsFromGroupCreditor(DataSet loanBillDs) {
        DataSet regionR1Group = loanBillDs.filter("region='R1'").select(new String[]{"bank bank1", "amount basechinamt", "amount1 endchinamt", FINORGTYPE});
        DataSet regionR2Group = loanBillDs.filter("region='R2'").select(new String[]{"bank bank2", "amount basegatamt", "amount1 endgatamt", FINORGTYPE});
        DataSet regionR3Group = loanBillDs.filter("region='R3'").select(new String[]{"bank bank3", "amount baseabroadamt", "amount1 endabroadamt", FINORGTYPE});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("bank1", "bank2").select(new String[]{"(case when bank1=null then bank2 else bank1 end ) bank12", "basechinamt", "basegatamt", "endchinamt", "endgatamt", FINORGTYPE}).finish();
        groupR12Ds = this.updateFieldDs(groupR12Ds);
        DataSet ds = groupR12Ds.fullJoin(regionR3Group).on("bank12", "bank3").select(new String[]{"( case when bank12=null then bank3 else bank12 end ) bank", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt", FINORGTYPE}).finish();
        return this.updateRegionField(ds);
    }

    private DataSet getDsFromGroupCurrency(DataSet baseAndEndDs) {
        DataSet regionR1Group = baseAndEndDs.filter("region='R1'").select(new String[]{"currency currency1", "amount basechinamt", "amount1 endchinamt"});
        DataSet regionR2Group = baseAndEndDs.filter("region='R2'").select(new String[]{"currency currency2", "amount basegatamt", "amount1 endgatamt"});
        DataSet regionR3Group = baseAndEndDs.filter("region='R3'").select(new String[]{"currency currency3", "amount baseabroadamt", "amount1 endabroadamt"});
        DataSet groupR12Ds = regionR1Group.fullJoin(regionR2Group).on("currency1", "currency2").select(new String[]{"(case when currency1=null then currency2 else currency1 end ) currency12", "basechinamt", "basegatamt", "endchinamt", "endgatamt"}).finish().updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end ").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ");
        return groupR12Ds.fullJoin(regionR3Group).on("currency12", "currency3").select(new String[]{"( case when currency12=null then currency3 else currency12 end ) currency", "basechinamt", "basegatamt", "baseabroadamt", "endchinamt", "endgatamt", "endabroadamt"}).finish().updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end").updateField("baseabroadamt", "case when baseabroadamt=null then 0 else baseabroadamt end").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ").updateField("endabroadamt", "case when endabroadamt=null then 0 else endabroadamt end ");
    }

    private DataSet updateFieldDs(DataSet groupR12Ds) {
        return groupR12Ds.updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end ").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ");
    }

    private DataSet updateRegionField(DataSet ds) {
        return ds.updateField("basechinamt", "case when basechinamt=null then 0 else basechinamt end ").updateField("basegatamt", "case when basegatamt=null then 0 else basegatamt end").updateField("baseabroadamt", "case when baseabroadamt=null then 0 else baseabroadamt end").updateField("endchinamt", "case when endchinamt=null then 0 else endchinamt end ").updateField("endgatamt", "case when endgatamt=null then 0 else endgatamt end ").updateField("endabroadamt", "case when endabroadamt=null then 0 else endabroadamt end ");
    }

    private DataSet getDsConverEx(DataSet srcGroupDs, Map<String, Object> paramMap, boolean isBase, String[] strArr) {
        Long tarCurrencyId = (Long)paramMap.get("filter_statcurrency");
        DataSet currencyDataSet = srcGroupDs.copy().groupBy(new String[]{"currency"}).finish();
        Date baseDate = (Date)paramMap.get("filter_basedate");
        Date endDate = (Date)paramMap.get("filter_cutoffdate");
        long orgId = Long.parseLong(String.valueOf(paramMap.get("org")));
        ArrayList currencyIdList = new ArrayList(10);
        currencyDataSet.iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)paramMap.get("filter_queryway");
        DataSet exChangeDataSet = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)tarCurrencyId, (long)orgId, (Date)(isBase ? baseDate : endDate), (!QueryTypeEnum.isOrgview((String)queryWay) ? 1 : 0) != 0);
        String unit = (String)paramMap.get("filter_currencyunit");
        return srcGroupDs.leftJoin(exChangeDataSet).on("currency", "tarcurrency").select(strArr, new String[]{"tarcurrency", String.format("amount*rate/%s", unit) + " amount"}).finish().groupBy(strArr).sum("amount").finish();
    }

    private DataSet filterRegion(DataSet dataSet, Map<String, Object> paramMap) {
        String regionsStr = (String)paramMap.get("filter_region");
        if (EmptyUtil.isNoEmpty((String)regionsStr)) {
            List regions = Arrays.stream(regionsStr.split(",")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
            StringBuilder expr = new StringBuilder();
            expr.append(" region in (");
            for (int i = 0; i < regions.size(); ++i) {
                if (i == regions.size() - 1) {
                    expr.append("'").append((String)regions.get(i)).append("'");
                    continue;
                }
                expr.append("'").append((String)regions.get(i)).append("',");
            }
            expr.append(") ");
            dataSet = dataSet.where(expr.toString());
        }
        return dataSet;
    }

    private DataSet filterCurrency(DataSet dataSet, Map<String, Object> paramMap) {
        DynamicObjectCollection currencyDoc;
        if (paramMap.get("filter_currency") != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(currencyDoc = (DynamicObjectCollection)paramMap.get("filter_currency")))) {
            StringBuilder expr = new StringBuilder();
            expr.append(" currencyid in (");
            for (int i = 0; i < currencyDoc.size(); ++i) {
                if (i == currencyDoc.size() - 1) {
                    expr.append(((DynamicObject)currencyDoc.get(i)).getString("id"));
                    continue;
                }
                expr.append(((DynamicObject)currencyDoc.get(i)).getString("id")).append(',');
            }
            expr.append(") ");
            dataSet = dataSet.where(expr.toString());
        }
        return dataSet.where("currencyid != 0");
    }

    private DataSet getAcctBankDs(Map<String, Object> paramMap) {
        QFilter queryQFilter = this.getAccountBankFilter(paramMap);
        DataSet acctBankDs = QueryServiceHelper.queryDataSet((String)"query_accountbank", (String)"bd_accountbanks", (String)"id, company.id, company.name, bank, bank.name, finorgtype, bank.country.number as region", (QFilter[])new QFilter[]{queryQFilter}, null);
        return acctBankDs.updateField(REGION, "case when region = '001' or region = null then 'R1' when region in ('003','004','005') then 'R2' else 'R3' end");
    }

    private QFilter getAccountBankFilter(Map<String, Object> paramMap) {
        QFilter queryQFilter = new QFilter("company", "in", paramMap.get(ORGIDS));
        boolean isInclude = (Boolean)paramMap.get("filter_includeclose");
        if (!isInclude) {
            queryQFilter = queryQFilter.and(new QFilter("acctstatus", "!=", (Object)"closed"));
        }
        return queryQFilter;
    }

    private DataSet getAccountBankDs(Map<String, Object> paramMap) {
        QFilter queryQFilter = this.getAccountBankFilter(paramMap);
        String selectFields = "id accountbank.id, company org.id, company.name org.name, currency.fbasedataid currency.id, currency.fbasedataid.name currency";
        return QueryServiceHelper.queryDataSet((String)"getAccountBankIds", (String)"bd_accountbanks", (String)selectFields, (QFilter[])queryQFilter.toArray(), null);
    }

    private List<DataSet> getDateBalanceDs(Map<String, Object> paramMap, Date beginDate, Date endDate) {
        String dataSource = (String)paramMap.get("filter_datasource");
        if ("bankbalance".equals(dataSource)) {
            return this.getBankBalanceDs(paramMap, beginDate, endDate);
        }
        List allOrgIds = (List)paramMap.get(ORGIDS);
        return AcctBalanceServiceHelper.getJournalBalanceTimeRange(allOrgIds, this.getAccountBankDs(paramMap), this.getCurrencyIs(paramMap), beginDate, endDate);
    }

    private List<DataSet> getBankBalanceDs(Map<String, Object> paramMap, Date beginDate, Date endDate) {
        List allOrgIds = (List)paramMap.get(ORGIDS);
        QFilter qFilter = new QFilter("company", "in", (Object)allOrgIds);
        qFilter = qFilter.and(new QFilter("bizdate", "<=", (Object)DateUtils.getDataFormat((Date)endDate, (boolean)true)));
        qFilter = this.getOtherFilter(paramMap, qFilter);
        String selectFields = "id, company.id org.id, company.name org.name, company.name, accountbank.id, currency.id, currency, lstbalance, amount endBalance, bizdate";
        DataSet endDataSet = QueryServiceHelper.queryDataSet((String)"getBankBalanceDs", (String)"bei_bankbalance", (String)selectFields, (QFilter[])qFilter.toArray(), null);
        DataSet beginDataSet = endDataSet.filter("to_char(bizdate, 'yyyyMMdd')<=" + DateUtils.formatString((Date)beginDate, (String)"yyyyMMdd"));
        endDataSet = this.groupByBankAccountDataSet(endDataSet);
        beginDataSet = this.groupByBankAccountDataSet(beginDataSet);
        return Arrays.asList(beginDataSet, endDataSet);
    }

    private DataSet groupByBankAccountDataSet(DataSet endDataSet) {
        DataSet balanceDataSetLastGroup = endDataSet.groupBy(new String[]{ACCOUNTBANKID, CURRENCYID}).max("bizdate").finish();
        return balanceDataSetLastGroup.join(endDataSet, JoinType.LEFT).on(ACCOUNTBANKID, ACCOUNTBANKID).on(CURRENCYID, CURRENCYID).on("bizdate", "bizdate").select(new String[]{"id", "org.id", "org.name", "company.name", ACCOUNTBANKID, CURRENCYID, "currency", "endBalance", "bizdate"}).finish();
    }

    private QFilter getOtherFilter(Map<String, Object> paramMap, QFilter qFilter) {
        qFilter = this.getAccountBankFilter(paramMap, qFilter);
        List<Long> currencyIds = this.getCurrencyIs(paramMap);
        if (!CollectionUtils.isEmpty(currencyIds)) {
            qFilter.and(new QFilter(CURRENCYID, "in", currencyIds));
        }
        return qFilter;
    }

    private QFilter getAccountBankFilter(Map<String, Object> paramMap, QFilter qFilter) {
        boolean isInclude = (Boolean)paramMap.get("filter_includeclose");
        if (!isInclude) {
            qFilter = qFilter.and(new QFilter("accountbank.acctstatus", "!=", (Object)"closed"));
        }
        return qFilter;
    }

    private List<Long> getCurrencyIs(Map<String, Object> paramMap) {
        DynamicObjectCollection currencyDoc = (DynamicObjectCollection)paramMap.get("filter_currency");
        if (!CollectionUtils.isEmpty((Collection)currencyDoc)) {
            return currencyDoc.stream().map(b -> b.getLong("id")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private DataSet getSumDataSet(DataSet treeData) {
        treeData = this.getSumDataSetByLevel(treeData, this.sumFields(), "orgname,currency");
        return treeData.addField("case when baseamt=0 then 0.00 else round(changeamount*100/abs(baseamt), 2) end ", "changerate");
    }

    private DataSet calculationAddRate(DataSet sumDataSet) {
        DataSet[] dataSets = sumDataSet.splitByFilter(new String[]{"sumlevel = 2"}, true);
        DataSet totalAmtds = dataSets[0];
        if (totalAmtds.isEmpty()) {
            return dataSets[1];
        }
        Row row = totalAmtds.copy().next();
        sumDataSet = dataSets[1].union(totalAmtds).select(new String[]{ROWID, "pid", "isgroupnode", "level", "basechinamt", "baseabroadamt", "basegatamt", "baseamt", "endchinamt", "endabroadamt", "endgatamt", "endamt", "changeamount", ORGNAME, "changerate", "sumlevel", "statcurrency", this.converfield("basechinamt", "basechinrate", row.getBigDecimal("basechinamt")), this.converfield("basegatamt", "basegatrate", row.getBigDecimal("basegatamt")), this.converfield("baseabroadamt", "baseabroadrate", row.getBigDecimal("baseabroadamt")), this.converfield("baseamt", "baserate", row.getBigDecimal("baseamt")), this.converfield("endchinamt", "endchinrate", row.getBigDecimal("endchinamt")), this.converfield("endgatamt", "endgatrate", row.getBigDecimal("endgatamt")), this.converfield("endabroadamt", "endabroadrate", row.getBigDecimal("endabroadamt")), this.converfield("endamt", "endrate", row.getBigDecimal("endamt"))}).orderBy(this.orderByFields().toArray(new String[0]));
        return this.formatDsRate(sumDataSet);
    }

    private String converfield(String field, String fieldRate, BigDecimal total) {
        if (total == null || "0".equals(total.toPlainString().split("\\.")[0])) {
            return "0.0 " + fieldRate;
        }
        return field + "*100/" + total.toPlainString() + " " + fieldRate;
    }

    private List<String> sumFields() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("basechinamt");
        fields.add("baseabroadamt");
        fields.add("basegatamt");
        fields.add("baseamt");
        fields.add("endchinamt");
        fields.add("endabroadamt");
        fields.add("endgatamt");
        fields.add("endamt");
        fields.add("changeamount");
        return fields;
    }

    private DataSet formatDsRate(DataSet unionDs) {
        return unionDs.updateField("basechinrate", " case when basechinrate=0 or basechinrate=null then 0.00 else round(basechinrate,2) end ").updateField("basegatrate", " case when basegatrate=0 or basegatrate=null then 0.00 else round(basegatrate,2) end ").updateField("baseabroadrate", " case when baseabroadrate=0 or baseabroadrate=null then 0.00 else round(baseabroadrate,2) end ").updateField("baserate", " case when baserate=0 or baserate=null then 0.00 else round(baserate,2) end ").updateField("endchinrate", " case when endchinrate=0 or endchinrate=null then 0.00 else round(endchinrate,2) end ").updateField("endgatrate", " case when endgatrate=0 or endgatrate=null then 0.00 else round(endgatrate,2) end ").updateField("endabroadrate", " case when endabroadrate=0 or endabroadrate=null then 0.00 else round(endabroadrate,2) end").updateField("endrate", " case when endrate=0 or endrate=null then 0.00 else round(endrate,2) end").updateField("changerate", " case when changerate=0 or changerate=null then 0.00 else round(changerate,2) end ");
    }

    protected boolean isNeedOrgTree() {
        String statdim = (String)this.getQueryParam().getCustomParam().get("filter_statdim");
        return "org".equals(statdim);
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected List<String> orinalAmountField() {
        return Collections.emptyList();
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(10);
        sumFields.add("basechinamt");
        sumFields.add("baseabroadamt");
        sumFields.add("basegatamt");
        sumFields.add("baseamt");
        sumFields.add("endchinamt");
        sumFields.add("endabroadamt");
        sumFields.add("endgatamt");
        sumFields.add("endamt");
        return sumFields;
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)ORGNAME);
    }

    protected String getReportField(String field) {
        return field + "_report";
    }
}

