/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.common.enums.QueryTypeEnum;
import kd.tmc.mon.report.helper.BalanceQueryServiceHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class DepositLiabDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final Log logger = LogFactory.getLog(DepositLiabDataPlugin.class);
    private boolean isNeedOrgTree = false;
    private String sumNameField = "";
    private boolean containInner = false;
    private static final String LOAN_FIELDS = "id,billno,org,org.name as orgname,drawamount as liab_balance,creditor as finorginfo, textcreditor as finorginfoname,currency, 1 as percent";
    private static final String SL_FIELDS = "id,billno,org,org.name as orgname,banksyndicate_entry.e_shareamount as liab_balance,case when banksyndicate_entry.e_bank >0  then banksyndicate_entry.e_bank else banksyndicate_entry.id end as finorginfo,banksyndicate_entry.e_bank.name as finorginfoname, currency,banksyndicate_entry.e_shareamount/drawamount as percent";
    private static final String BOND_FIELDS = "id,billno,org,org.name as orgname,investor_entry.e_investamount as liab_balance,investor_entry.e_investorid as finorginfo, investor_entry.e_investorname as  finorginfoname,currency,investor_entry.e_investamount/drawamount as percent";
    private static final String[] LIAB_FIELDS = new String[]{"finorginfo", "finorginfoname", "liab_balance", "dpt_balance", "statcurrency", "isgroupnode", "sumlevel", "rowid", "pid"};

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map customParam = this.transQueryParam(queryParam);
        this.init(customParam, queryParam);
        logger.info(String.format("all query param%s", customParam));
        DataSet assetsBalanceDS = this.queryAssetsBalance(customParam);
        DataSet liabBalanceDS = this.queryLiabBalance(customParam);
        String statDim = (String)customParam.get("filter_statdim");
        DataSet resultDS = this.mergeBalanceResult(assetsBalanceDS, liabBalanceDS, statDim);
        if (this.isEmpty(resultDS)) {
            return MonReportHelper.createEmptyDs();
        }
        DynamicObject statCurrency = (DynamicObject)customParam.get("filter_statcurrency");
        Long statCurrencyId = null == statCurrency ? 0L : statCurrency.getLong("id");
        resultDS = resultDS.addField(String.valueOf(statCurrencyId), "currency");
        return resultDS;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        Map customParam = this.transQueryParam(queryParam);
        dataSet = this.addTreeStructure(dataSet, customParam);
        dataSet = this.addPercentCols(dataSet);
        return dataSet;
    }

    private DataSet queryAssetsBalance(Map<String, Object> customParam) {
        DataSet assetsBalance = null;
        String dptRanges = (String)customParam.get("filter_dptrange");
        DataSet acctBalance = null;
        for (String dptRange : dptRanges.split(",")) {
            if (EmptyUtil.isEmpty((String)dptRange)) continue;
            if (StringUtils.equals((CharSequence)dptRange, (CharSequence)"acctbalance")) {
                acctBalance = BalanceQueryServiceHelper.queryAcctBalance(customParam);
                assetsBalance = this.unionDataSet(assetsBalance, acctBalance);
                continue;
            }
            acctBalance = this.queryDepositBalance(customParam, dptRange);
            assetsBalance = this.unionDataSet(assetsBalance, acctBalance);
        }
        if (assetsBalance != null) {
            assetsBalance = assetsBalance.filter("dpt_balance != 0 and currency != 0");
            return this.doExchangeRate(assetsBalance, customParam, "dpt_balance");
        }
        return this.createEmptyDs(new String[]{"org", "orgname", "dpt_balance", "finorginfo", "finorginfoname", "currency"});
    }

    private DataSet queryLiabBalance(Map<String, Object> customParam) {
        DataSet liabBalance = this.createEmptyDs(new String[]{"org", "orgname", "liab_balance", "finorginfo", "finorginfoname", "currency"});
        String liabRanges = (String)customParam.get("filter_liabrange");
        for (String liabRange : liabRanges.split(",")) {
            DataSet tmpDs;
            if (EmptyUtil.isEmpty((String)liabRange)) continue;
            if (StringUtils.equals((CharSequence)liabRange, (CharSequence)"draft")) {
                tmpDs = this.queryDraftBalance(customParam);
                liabBalance = this.unionDataSet(liabBalance, tmpDs);
                continue;
            }
            if (StringUtils.equals((CharSequence)liabRange, (CharSequence)"credit")) {
                tmpDs = this.queryCreditBalance(customParam);
                liabBalance = this.unionDataSet(liabBalance, tmpDs);
                continue;
            }
            if (StringUtils.equals((CharSequence)liabRange, (CharSequence)"loan")) {
                tmpDs = this.queryLoanBalance(customParam);
                liabBalance = this.unionDataSet(liabBalance, tmpDs);
                continue;
            }
            if (!StringUtils.equals((CharSequence)liabRange, (CharSequence)"bonds")) continue;
            tmpDs = this.queryBondsBalance(customParam);
            liabBalance = this.unionDataSet(liabBalance, tmpDs);
        }
        liabBalance = this.doExchangeRate(liabBalance, customParam, "liab_balance");
        return liabBalance;
    }

    private DataSet queryDepositBalance(Map<String, Object> customParam, String billType) {
        Object orgIds;
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Object finOrgInfoIds = customParam.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qfilter.and(new QFilter("finorginfo", "in", finOrgInfoIds));
        }
        if (!this.containInner) {
            qfilter.and(new QFilter("finorginfo.finorgtype.type", "!=", (Object)"1"));
        }
        if (EmptyUtil.isNoEmpty((Object)(orgIds = customParam.get("filter_org")))) {
            qfilter.and(new QFilter("org", "in", orgIds));
        } else {
            qfilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        qfilter.and(new QFilter("investvarieties.investtype", "=", (Object)billType));
        Date queryDate = (Date)customParam.get("filter_querydate");
        DataSet releaseBalance = this.queryReleaseBalance(qfilter.copy(), queryDate);
        qfilter.and(new QFilter("intdate", "<=", (Object)queryDate));
        qfilter.and(new QFilter("isresubmit", "=", (Object)"0"));
        logger.info(String.format("depositBalance query param:%s", qfilter.toString()));
        DataSet depositBalance = QueryServiceHelper.queryDataSet((String)"queryDepositBalance", (String)"cim_deposit", (String)"id,org,org.name as orgname,amount as dpt_balance,finorginfo,finorginfo.name as finorginfoname,currency", (QFilter[])qfilter.toArray(), null);
        if (!this.isEmpty(releaseBalance)) {
            String[] fieldNames = depositBalance.getRowMeta().getFieldNames();
            depositBalance = depositBalance.leftJoin(releaseBalance).on("id", "finbillno").select(fieldNames, new String[]{"amount"}).finish().updateField("amount", "case when amount is null then 0 else amount end").updateField("dpt_balance", String.format("%s-amount", "dpt_balance")).select(fieldNames);
        }
        return depositBalance.select(new String[]{"org", "orgname", "dpt_balance", "finorginfo", "finorginfoname", "currency"});
    }

    private DataSet queryDraftBalance(Map<String, Object> customParam) {
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("draftbillstatus", "!=", (Object)"splited"));
        qfilter.and(new QFilter("rptype", "=", (Object)"paybill"));
        Date queryDate = (Date)customParam.get("filter_querydate");
        qfilter.and(new QFilter("issuedate", "<=", (Object)queryDate));
        Object orgIds = customParam.get("filter_org");
        if (EmptyUtil.isNoEmpty((Object)orgIds)) {
            qfilter.and(new QFilter("company", "in", orgIds));
        } else {
            qfilter.and(QFilter.of((String)"1!=1", (Object[])new Object[0]));
        }
        Object finOrgInfoIds = customParam.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qfilter.and(new QFilter("draweraccount.bank", "in", finOrgInfoIds));
        }
        qfilter.and(new QFilter("draftbillexpiredate", ">", (Object)queryDate));
        logger.info(String.format("draftBalance query param:%s", qfilter.toString()));
        return QueryServiceHelper.queryDataSet((String)"queryDraftBalance", (String)"cdm_payablebill", (String)"company as org,company.name as orgname, amount as liab_balance,draweraccount.bank as finorginfo,draweraccount.bank.name as finorginfoname, currency", (QFilter[])qfilter.toArray(), null);
    }

    private DataSet queryCreditBalance(Map<String, Object> customParam) {
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("arrivaltype", "not in", (Object)new String[]{"da", "dp"}));
        Date queryDate = (Date)customParam.get("filter_querydate");
        qfilter.and(new QFilter("arrivaldate", "<=", (Object)queryDate));
        Object orgIds = customParam.get("filter_org");
        qfilter.and(new QFilter("org", "in", orgIds));
        Object finOrgInfoIds = customParam.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qfilter.and(new QFilter("lettercredit.bank", "in", finOrgInfoIds));
        }
        logger.info(String.format("creditBalance query param:%s", qfilter.toString()));
        DataSet dataResult = QueryServiceHelper.queryDataSet((String)"queryCreditBalance", (String)"lc_arrival", (String)"id,billno,org,org.name as orgname, arrivalamount as liab_balance,lettercredit.bank as finorginfo,lettercredit.bank.name as finorginfoname,arrivalcurrency as currency", (QFilter[])qfilter.toArray(), null);
        if (this.isEmpty(dataResult)) {
            return dataResult;
        }
        ArrayList<Object> ids = new ArrayList<Object>(16);
        for (Row row : dataResult.copy()) {
            ids.add(row.get("id"));
        }
        QFilter payFilter = QFilter.isNotNull((String)"entrys.realpaydate").and(new QFilter("entrys.realpaydate", "<=", (Object)queryDate));
        payFilter.and("id", "in", ids);
        DataSet payInfo = QueryServiceHelper.queryDataSet((String)"queryCreditPayBalance", (String)"lc_arrival", (String)"id,entrys.arrpayamount as arrpayamount, entrys.arrpaycurrency as currency", (QFilter[])payFilter.toArray(), null);
        if (!this.isEmpty(payInfo)) {
            String[] fieldNames = dataResult.getRowMeta().getFieldNames();
            dataResult = dataResult.leftJoin(payInfo).on("id", "id").select(fieldNames, new String[]{"arrpayamount"}).finish();
            dataResult = dataResult.updateField("arrpayamount", "case when arrpayamount is null then 0 else arrpayamount end");
            dataResult = dataResult.updateField("liab_balance", "liab_balance - arrpayamount");
        }
        return dataResult.select(new String[]{"org", "orgname", "liab_balance", "finorginfo", "finorginfoname", "currency"}).filter("liab_balance != 0");
    }

    private DataSet queryLoanBalance(Map<String, Object> customParam) {
        QFilter qfilter = this.getLoanBillFilter(customParam, new String[]{"loan", "entrust", "ec"});
        Object finOrgInfoIds = customParam.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qfilter.and(new QFilter("creditor", "in", finOrgInfoIds));
        }
        DataSet loanDS = QueryServiceHelper.queryDataSet((String)"queryLoanBalance", (String)"cfm_loanbill", (String)LOAN_FIELDS, (QFilter[])qfilter.toArray(), null);
        String otherName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InDebtsAnalysisDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
        loanDS = loanDS.select(new String[]{"id", "billno", "org", "orgname", "liab_balance", "case when finorginfo >0 then finorginfo else 999 end as finorginfo", "case when finorginfo >0 then finorginfoname else '" + otherName + "' end  as finorginfoname", "currency", "percent"});
        qfilter = this.getLoanBillFilter(customParam, new String[]{"sl"});
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qfilter.and(new QFilter("banksyndicate_entry.e_bank", "in", finOrgInfoIds));
        }
        DataSet slDS = QueryServiceHelper.queryDataSet((String)"queryLoanBalance", (String)"cfm_loanbill", (String)SL_FIELDS, (QFilter[])qfilter.toArray(), null);
        return this.dealPayInfo(this.unionDataSet(loanDS, slDS), customParam);
    }

    private DataSet queryBondsBalance(Map<String, Object> customParam) {
        QFilter qFilter = this.getLoanBillFilter(customParam, new String[]{"bond"});
        Object finOrgInfoIds = customParam.get("filter_finorginfo");
        if (EmptyUtil.isNoEmpty((Object)finOrgInfoIds)) {
            qFilter.and(new QFilter("investor_entry.e_investorid", "in", finOrgInfoIds));
            qFilter.and(new QFilter("investor_entry.e_investorname", "!=", (Object)" ").or(new QFilter("investor_entry.e_investorname", "!=", (Object)"")));
        }
        DataSet bondsBalance = QueryServiceHelper.queryDataSet((String)"queryBondsBalance", (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])qFilter.toArray(), null);
        String otherName = ResManager.loadKDString((String)"\u5176\u4ed6", (String)"InDebtsAnalysisDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
        bondsBalance = bondsBalance.select(new String[]{"id", "billno", "org", "orgname", "liab_balance", "case when finorginfo >0 then finorginfo else 999 end as finorginfo", "case when finorginfo >0 then finorginfoname else '" + otherName + "' end  as finorginfoname", "currency", "percent"});
        return this.dealPayInfo(bondsBalance, customParam);
    }

    private DataSet mergeBalanceResult(DataSet assetsBalanceDS, DataSet liabBalanceDS, String statDim) {
        String[] groupFields = new String[]{statDim, String.format("%sname", statDim)};
        String[] columns = new String[]{statDim, String.format("%sname", statDim), "liab_balance", "dpt_balance"};
        assetsBalanceDS = assetsBalanceDS.addBalanceField("0", "liab_balance").select(columns);
        liabBalanceDS = liabBalanceDS.addBalanceField("0", "dpt_balance").select(columns);
        return assetsBalanceDS.union(liabBalanceDS).groupBy(groupFields).sum("liab_balance").sum("dpt_balance").finish();
    }

    private DataSet addTreeStructure(DataSet resultSet, Map<String, Object> customParam) {
        String statDim = (String)customParam.get("filter_statdim");
        if (StringUtils.equals((CharSequence)statDim, (CharSequence)"finorginfo")) {
            resultSet = this.addFinTreeStructure(resultSet);
        }
        return resultSet;
    }

    private DataSet addFinTreeStructure(DataSet dataSet) {
        if (dataSet == null || dataSet.isEmpty()) {
            return MonReportHelper.createEmptyDs();
        }
        String statCurrencyId = dataSet.copy().next().getString("statcurrency");
        DataSet sumDS = dataSet.copy().filter("sumlevel = 2");
        DataSet otherDS = dataSet.copy().filter("finorginfo = 999");
        dataSet = dataSet.filter("sumlevel != 2 and finorginfo != 999");
        dataSet = dataSet.filter("finorginfo is not null");
        Set<String> types = this.getFinOrgTypes();
        if (EmptyUtil.isEmpty(types)) {
            return dataSet;
        }
        HashSet<Object> finOrgIds = new HashSet<Object>();
        for (Row row : dataSet.copy()) {
            finOrgIds.add(row.get("finorginfo"));
        }
        DataSet finOrgIDS = QueryServiceHelper.queryDataSet((String)"addFinTreeStructure", (String)"bd_finorginfo", (String)"id, finorgtype.type as finorgtype", (QFilter[])new QFilter[]{new QFilter("id", "in", finOrgIds)}, null);
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        dataSet = dataSet.leftJoin(finOrgIDS).on("finorginfo", "id").select(fieldNames, new String[]{"finorgtype"}).finish();
        DataSet otherTypeDS = dataSet.copy().filter("finorgtype is null").select(otherDS.getRowMeta().getFieldNames());
        dataSet = dataSet.filter("finorgtype is not null");
        HashMap<String, DataSet> dataMap = new HashMap<String, DataSet>(types.size());
        for (String type : types) {
            dataMap.put(type, dataSet.filter(String.format("finorgtype = '%s'", type)));
        }
        DataSet result = this.dealBankTypeData((DataSet)dataMap.remove("0"));
        if (EmptyUtil.isNoEmpty(dataMap)) {
            for (Map.Entry map : dataMap.entrySet()) {
                DataSet data = ((DataSet)map.getValue()).select("finorginfo, finorginfoname, finorgtype, liab_balance, dpt_balance, 0 as isgroupnode,concat(finorginfo,'') as rowid, '0' as pid, '' as pname");
                result = result == null ? data : result.union(data);
            }
        }
        if (this.isEmpty(result)) {
            return MonReportHelper.createEmptyDs();
        }
        result = result.addFields(new String[]{this.getOrderFieldSql(), "0"}, new String[]{"orderfield", "sumlevel"}).orderBy(new String[]{"orderfield"}).addField("0", "sumlevel").addField(statCurrencyId, "statcurrency").select(LIAB_FIELDS);
        return result.union(otherDS.union(otherTypeDS).copy().updateField("rowid", "concat(finorginfo,'') as rowid").updateField("isgroupnode", "1").union(sumDS).addField("0", "isgroupnode").select(LIAB_FIELDS)).filter("concat(pid,'') != rowid");
    }

    private Set<String> getFinOrgTypes() {
        DynamicObjectCollection finOrgTypes = QueryServiceHelper.query((String)"bd_finorgtype", (String)"type", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)finOrgTypes)) {
            return new HashSet<String>();
        }
        return finOrgTypes.stream().map(v -> v.getString("type")).collect(Collectors.toSet());
    }

    private String getOrderFieldSql() {
        int i = RandomUtils.nextInt();
        StringBuilder sb = new StringBuilder();
        sb.append("case ");
        int cardinal = 101;
        for (String finOrgType : this.getFinOrgTypes()) {
            sb.append(String.format("when finorgtype = '%s' then %s ", finOrgType, i + cardinal));
            ++cardinal;
        }
        sb.append("end as orderfield");
        return sb.toString();
    }

    private DataSet dealBankTypeData(DataSet bankDS) {
        if (this.isEmpty(bankDS)) {
            return null;
        }
        HashSet<Object> bankInfoIds = new HashSet<Object>();
        for (Row row : bankDS.copy()) {
            bankInfoIds.add(row.getLong("finorginfo"));
        }
        DataSet banInfoDataSet = QueryServiceHelper.queryDataSet((String)"bd_finorginfo_tree", (String)"bd_finorginfo", (String)"id,bank_cate,bank_cate.name pcatename ,finorgtype,finorgtype.name ptypename", (QFilter[])new QFilter("id", "in", bankInfoIds).toArray(), (String)"createtime");
        if (EmptyUtil.isNoEmpty(bankInfoIds)) {
            bankDS = this.addBankTypeCol(banInfoDataSet, bankDS, bankInfoIds);
        }
        return bankDS;
    }

    private DataSet addBankTypeCol(DataSet allFinDataSets, DataSet dataSet, Set<Object> ids) {
        DataSet thirdsFinDataSet = allFinDataSets.copy().filter(String.format("id in (%s)", this.getIdStr(ids)));
        dataSet = dataSet.join(thirdsFinDataSet.copy(), JoinType.LEFT).on("finorginfo", "id").select(new String[]{"finorginfo", "finorginfoname", "finorgtype", "liab_balance", "dpt_balance", "0 as isgroupnode"}, new String[]{"concat(id,'') as rowid", "cast(bank_cate as String) as pid", "pcatename as pname"}).finish();
        DataSet pidGroupDataSet = dataSet.copy().filter("cast(pid as Long) > 0").groupBy(new String[]{"pid", "pname"}).sum("dpt_balance").sum("liab_balance").finish();
        DataSet parentSumDs = pidGroupDataSet.select("cast(pid as Long) as finorginfo, pname as finorginfoname, '0' as finorgtype,liab_balance,dpt_balance, 1 as isgroupnode,concat(pid,'') as rowid, '0' as pid, pname");
        return dataSet.union(parentSumDs);
    }

    private String getIdStr(Set<Object> banks) {
        StringJoiner stringJoiner = new StringJoiner(",");
        banks.stream().map(String::valueOf).forEach(stringJoiner::add);
        return stringJoiner.toString();
    }

    private DataSet addPercentCols(DataSet resultSet) {
        if (this.isEmpty(resultSet)) {
            return resultSet;
        }
        DataSet summaryRow = resultSet.copy().filter("sumlevel = 2");
        if (this.isEmpty(summaryRow)) {
            return resultSet;
        }
        Row row = (Row)summaryRow.iterator().next();
        BigDecimal dptBalance = row.getBigDecimal("dpt_balance");
        resultSet = EmptyUtil.isNoEmpty((BigDecimal)dptBalance) ? resultSet.addField(String.format("100*%s/%s", "dpt_balance", dptBalance), "dpt_percent") : resultSet.addField("dpt_balance", "dpt_percent");
        BigDecimal liabBalance = row.getBigDecimal("liab_balance");
        resultSet = EmptyUtil.isNoEmpty((BigDecimal)liabBalance) ? resultSet.addField(String.format("100*%s/%s", "liab_balance", liabBalance), "liab_percent") : resultSet.addField("liab_balance", "liab_percent");
        resultSet = resultSet.addField("case when liab_balance == 0 then '0' when dpt_balance == 0 then cast(round(100*0/liab_balance,10) as string) else cast(round(100*dpt_balance/liab_balance,10) as string) end", "percent");
        summaryRow.close();
        return resultSet;
    }

    private DataSet doExchangeRate(DataSet resultSet, Map<String, Object> customParam, String exchangeField) {
        Long exRateOrgId = (Long)customParam.get("exRateOrgId");
        DynamicObject statCurrency = (DynamicObject)customParam.get("filter_statcurrency");
        Long statCurrencyId = null == statCurrency ? 0L : statCurrency.getLong("id");
        ArrayList currencyIdList = new ArrayList(10);
        resultSet.copy().iterator().forEachRemaining(v -> currencyIdList.add(v.getLong("currency")));
        String queryWay = (String)customParam.get("filter_queryway");
        DataSet exchangeRateDS = TmcBusinessBaseHelper.getExChangeDataSet(currencyIdList, (Long)statCurrencyId, (long)exRateOrgId, (Date)new Date(), (!QueryTypeEnum.isOrgview((String)queryWay) ? 1 : 0) != 0);
        String unit = (String)customParam.get("filter_currencyunit");
        String[] fieldNames = resultSet.getRowMeta().getFieldNames();
        resultSet = resultSet.leftJoin(exchangeRateDS).on("currency", "tarcurrency").select(fieldNames, new String[]{"rate exchrate"}).finish().addField(String.valueOf(statCurrencyId), "fromcurrency").updateField(exchangeField, String.format("%s*exchrate/%s", exchangeField, unit)).select(fieldNames);
        return resultSet;
    }

    private DataSet queryReleaseBalance(QFilter qFilter, Date queryDate) {
        qFilter.and(new QFilter("redeemdate", "<=", (Object)queryDate));
        logger.info(String.format("releaseBalance query param:%s", qFilter.toString()));
        DataSet releaseBalance = QueryServiceHelper.queryDataSet((String)"queryReleaseBalance", (String)"cim_release", (String)"finbillno,amount", (QFilter[])qFilter.toArray(), null);
        if (!this.isEmpty(releaseBalance)) {
            releaseBalance = releaseBalance.groupBy(new String[]{"finbillno"}).sum("amount").finish();
        }
        return releaseBalance;
    }

    private QFilter getLoanBillFilter(Map<String, Object> customParam, String[] loanType) {
        QFilter qfilter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qfilter.and(new QFilter("loantype", "in", (Object)loanType));
        Date queryDate = (Date)customParam.get("filter_querydate");
        qfilter.and(QFilter.of((String)"cleardate is null", (Object[])new Object[0]).or(QFilter.of((String)"cleardate is not null", (Object[])new Object[0]).and("cleardate", ">", (Object)queryDate)));
        qfilter.and(new QFilter("bizdate", "<=", (Object)queryDate));
        Object orgIds = customParam.get("filter_org");
        qfilter.and(new QFilter("org", "in", orgIds));
        if (!this.containInner) {
            qfilter.and(new QFilter("lendernature", "!=", (Object)"ingroup"));
        }
        return qfilter;
    }

    private DataSet dealPayInfo(DataSet balanceDS, Map<String, Object> customParam) {
        if (this.isEmpty(balanceDS)) {
            return balanceDS;
        }
        HashSet<Object> loanBillIds = new HashSet<Object>();
        for (Row row : balanceDS.copy()) {
            loanBillIds.add(row.get("id"));
        }
        DataSet payDataSet = this.queryPayInfo(customParam, loanBillIds);
        if (this.isEmpty(payDataSet)) {
            return balanceDS.select(new String[]{"org", "orgname", "liab_balance", "finorginfo", "finorginfoname", "currency"});
        }
        String[] fieldNames = balanceDS.getRowMeta().getFieldNames();
        balanceDS = balanceDS.leftJoin(payDataSet).on("id", "loanbillid").select(fieldNames, new String[]{"repayamount"}).finish();
        balanceDS = balanceDS.updateField("repayamount", "case when repayamount is null then 0 else repayamount end");
        return balanceDS.updateField("liab_balance", "liab_balance-(repayamount*percent)").select(new String[]{"org", "orgname", "liab_balance", "finorginfo", "finorginfoname", "currency"});
    }

    private DataSet queryPayInfo(Map<String, Object> customParam, Set<Object> loanBillIds) {
        QFilter filter = new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Date queryDate = (Date)customParam.get("filter_querydate");
        filter.and(new QFilter("bizdate", "<=", (Object)queryDate));
        filter.and(new QFilter("loans.e_loanbill", "in", loanBillIds));
        logger.info(String.format("payInfo query param:%s", filter));
        return QueryServiceHelper.queryDataSet((String)"queryBondsPayBalance", (String)"cfm_repaymentbill", (String)"loans.e_loanbill as loanbillid,case when loans.e_repayamount is null then 0 else loans.e_repayamount end as repayamount", (QFilter[])filter.toArray(), null);
    }

    private void init(Map<String, Object> customParam, ReportQueryParam queryParam) {
        customParam.put("filter_org", this.getQueryOrgIds(queryParam));
        customParam.put("filter_finorginfo", queryParam.getCustomParam().get("filter_finorginfo"));
        String statDim = (String)customParam.get("filter_statdim");
        this.isNeedOrgTree = StringUtils.equals((CharSequence)statDim, (CharSequence)"org");
        this.sumNameField = String.format("%sname", statDim);
        this.containInner = (Boolean)customParam.get("filter_containinner");
    }

    public List<String> groupFields() {
        List groupFields = super.groupFields();
        groupFields.add(this.sumNameField.replace("name", ""));
        return groupFields;
    }

    protected boolean isNeedOrgTree() {
        return this.isNeedOrgTree;
    }

    public List<String> sumAmountFields() {
        return Arrays.asList("dpt_balance", "liab_balance");
    }

    public String sumNameField() {
        return this.sumNameField;
    }

    protected List<String> orinalAmountField() {
        return Collections.emptyList();
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"org", (Object)"orgname");
    }

    protected boolean isOrgNeedAddRootNode() {
        return true;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return true;
    }

    private boolean isEmpty(DataSet dataSet) {
        return null == dataSet || dataSet.isEmpty();
    }

    private DataSet unionDataSet(DataSet left, DataSet right) {
        if (this.isEmpty(right)) {
            return left;
        }
        return this.isEmpty(left) ? right : left.union(right);
    }

    private DataSet createEmptyDs(String[] fields) {
        RowMeta rowMeta = new RowMeta(fields, new DataType[]{DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.LongType, DataType.StringType, DataType.LongType});
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(rowMeta).build();
    }
}

