/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.ExpireBizWarnHelper;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ExpireBizWarnDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String FIELD_RESULT = "billtype,biztype,contractbillno,contractno,billno,expiredate,orgname,bankname,currency,amount,expireamount,sort";

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        String billTypes = (String)paramMap.get("filter_billtype");
        Set<String> billTypeSet = ExpireBizWarnHelper.getBillTypes(billTypes);
        List orgIds = this.getQueryOrgIds(queryParam);
        DataSet ds = null;
        for (String billType : billTypeSet) {
            if (EmptyUtil.isEmpty((String)billType)) continue;
            DataSet billDs = this.getBillDs(paramMap, billType, orgIds).select(FIELD_RESULT);
            if (ds == null) {
                ds = billDs;
                continue;
            }
            ds = ds.union(billDs);
        }
        if (ds == null) {
            return MonReportHelper.createEmptyDs();
        }
        return ds;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam queryParam) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        return dataSet.addField("statcurrency", "tarcurrency");
    }

    private DataSet getBillDs(Map<String, Object> paramMap, String billType, List<Long> orgIds) {
        Date filterDate = MonReportHelper.getCutOffDate(paramMap);
        Map<String, Pair<String, String>> filterColums = ExpireBizWarnHelper.getFilterColums();
        Pair<String, String> columPair = filterColums.get(billType);
        QFilter dateFilter = new QFilter((String)columPair.getRight(), "<=", (Object)filterDate);
        Map<String, String> extendDateMap = ExpireBizWarnHelper.getExtendDateFilter();
        if (extendDateMap.get(billType) != null) {
            String extendField = extendDateMap.get(billType);
            dateFilter = dateFilter.and(new QFilter(extendField, "is null", null));
            QFilter extendDateFilter = new QFilter(extendField, "is not null", null).and(new QFilter(extendField, "<=", (Object)filterDate));
            dateFilter = dateFilter.or(extendDateFilter);
        }
        QFilter filter = dateFilter;
        filter.and(new QFilter((String)columPair.getLeft(), "in", orgIds));
        filter = this.getFilter(filter, billType, paramMap);
        Map<String, String> columsConfig = ExpireBizWarnHelper.getColumsConfig();
        String fields = columsConfig.get(billType);
        String entityName = "cfm_loanbill_b_l".equals(billType) ? "cfm_loanbill" : billType;
        DataSet billDs = QueryServiceHelper.queryDataSet((String)"ExpireBizWarnDataListPlugin", (String)entityName, (String)fields, (QFilter[])new QFilter[]{filter}, null).addField("0", this.sumField);
        DataSet updateBillDs = this.updateCustomData(billDs.copy(), billType);
        if (updateBillDs != null) {
            return updateBillDs;
        }
        return billDs;
    }

    public List<String> orinalAmountField() {
        return Arrays.asList("amount", "expireamount");
    }

    protected String getReportField(String field) {
        return field + "ex";
    }

    public List<String> groupFields() {
        ArrayList<String> groupFields = new ArrayList<String>(3);
        groupFields.add("billtype");
        groupFields.add("sort");
        return groupFields;
    }

    public List<String> sumAmountFields() {
        return Collections.singletonList("expireamountex");
    }

    public String subNameField() {
        return "biztype";
    }

    public String sumNameField() {
        return "biztype";
    }

    private DataSet updateCustomData(DataSet billDs, String billType) {
        switch (billType) {
            case "cfm_creditlimit": {
                return this.updateCreditLimitData(billDs);
            }
            case "cfm_loanbill_b_l": {
                return this.updateLoandData(billDs);
            }
            case "gm_guaranteecontract": {
                return this.updateGuarantCont(billDs);
            }
            case "lc_arrival": 
            case "lc_present": {
                return this.updateLcBill(billDs);
            }
            case "cim_finsubscribe": {
                return this.updateCimAmt(billDs);
            }
        }
        return null;
    }

    private DataSet updateCimAmt(DataSet billDs) {
        return billDs.updateField("expireamount", "case when redeemway='amount_redeem' then expireamount else 0 end");
    }

    private DataSet updateLcBill(DataSet billDs) {
        return billDs.updateField("biztype", "case when arrivaltype!='credit' then arrivaltype else biztype end ").updateField("biztype", "case when biztype='da' then '" + this.getDarec() + "' else biztype end").updateField("biztype", "case when biztype='dp' then '" + this.getDprec() + "' else biztype end");
    }

    private DataSet updateGuarantCont(DataSet billDs) {
        HashSet gContId = new HashSet();
        billDs.copy().forEach(d -> gContId.add(d.getLong("id")));
        DataSet gcontUseDs = QueryServiceHelper.queryDataSet((String)"updateGuarantCont", (String)"gm_guaranteeuse", (String)"gcontract,gdebtbalance*gexchrate useamt", (QFilter[])new QFilter[]{new QFilter("gcontract", "in", gContId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("gsrcbilltype", "!=", (Object)"cfm_creditlimit")}, null);
        DataSet useAmtDs = gcontUseDs.groupBy(new String[]{"gcontract"}).sum("useamt").finish();
        billDs = !useAmtDs.isEmpty() ? billDs.leftJoin(useAmtDs).on("id", "gcontract").select(billDs.getRowMeta().getFieldNames(), new String[]{"useamt"}).finish().addField("case when useamt is null then 0 else useamt end", "expireamount") : billDs.addField("0", "expireamount");
        return billDs;
    }

    private DataSet updateLoandData(DataSet billDs) {
        return billDs.updateField("billtype", "case when loantype in ('entrust','ec') then 'cfm_loanbill_e_l' when loantype='bond' then 'cfm_loanbill_bond' else billtype end billtype").updateField("sort", "case when loantype in ('entrust','ec') then 3 when loantype='bond' then 4 else sort end sort");
    }

    private DataSet updateCreditLimitData(DataSet billDs) {
        Set<Long> bankIds = ExpireBizWarnHelper.getPropVals(billDs, "bank");
        Set<String> fields = Arrays.stream(billDs.getRowMeta().getFieldNames()).filter(o -> !"bank".equals(o) && !"banktype".equals(o) && !"bankname".equals(o)).collect(Collectors.toSet());
        if (bankIds.size() == 0) {
            fields.add("bankname");
            return billDs.select(fields.toArray(new String[0]));
        }
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)"updateBankName", (String)"bos_org", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", bankIds)}, null);
        fields.add("case when bankname is null then name else bankname end bankname");
        return billDs.leftJoin(orgDs).on("bank", "id").select(billDs.getRowMeta().getFieldNames(), new String[]{"name"}).select(fields.toArray(new String[0])).finish();
    }

    private QFilter getFilter(QFilter filter, String billType, Map<String, Object> paramMap) {
        String billTypes = (String)paramMap.get("filter_billtype");
        Set<String> billTypeSet = Arrays.stream(billTypes.split(",")).filter(o -> EmptyUtil.isNoEmpty((String)o)).collect(Collectors.toSet());
        switch (billType) {
            case "cfm_creditlimit": {
                filter.and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("isclose", "=", (Object)"0"));
                break;
            }
            case "cfm_loanbill_b_l": 
            case "cfm_loanbill_e_l": 
            case "cfm_loanbill_bond": 
            case "fl_receiptbill": {
                filter.and(ExpireBizWarnHelper.getLoanFilterByType(billTypeSet));
                break;
            }
            case "cdm_payablebill": {
                filter.and(new QFilter("rptype", "=", (Object)"paybill")).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("draftbillstatus", "=", (Object)"registered"));
                break;
            }
            case "lc_arrival": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("arrivalstatus", "!=", (Object)"arrival_pay"));
                break;
            }
            case "gm_letterofguarantee": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("bizstatus", "not in", Arrays.asList("cancelled", "claimed")));
                break;
            }
            case "gm_guaranteecontract": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("bizstatus", "!=", (Object)"closed"));
                break;
            }
            case "cim_invest_loanbill": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("confirmstatus", "=", (Object)"yetconfirm")).and(new QFilter("datasource", "=", (Object)"invest")).and(new QFilter("drawtype", "!=", (Object)"closeout"))).and(new QFilter("notrepayamount", ">", (Object)0));
                break;
            }
            case "cim_finsubscribe": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("finservicestatus", "!=", (Object)"subscribe_end"));
                break;
            }
            case "cdm_receivablebill": {
                filter.and(new QFilter("rptype", "=", (Object)"receivebill")).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("draftbillstatus", "in", Arrays.asList("registered", "pledged", "collocated")));
                break;
            }
            case "lc_present": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("arrivalstatus", "!=", (Object)"present_reciect"));
                break;
            }
            case "gm_receiveletter": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("bizstatus", "not in", Arrays.asList("cancelled", "claimed")));
                break;
            }
            case "cim_deposit": {
                filter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("bizstatus", "in", Arrays.asList("subscribe_done", "subscribe_part")));
            }
        }
        return filter;
    }

    private String getDarec() {
        return ResManager.loadKDString((String)"DA\u5230\u5355", (String)"ExpireBizWarnDataListPlugin_0", (String)"tmc-mon-report", (Object[])new Object[0]);
    }

    private String getDprec() {
        return ResManager.loadKDString((String)"DP\u5230\u5355", (String)"ExpireBizWarnDataListPlugin_1", (String)"tmc-mon-report", (Object[])new Object[0]);
    }
}

