/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.report.data.AbstractTmcListDataPlugin;
import kd.tmc.mon.report.helper.ReportCommonHelper;
import kd.tmc.mon.report.service.FinOrgEvaService;

public class FinOrgEvaluationDataListPlugin
extends AbstractTmcListDataPlugin {
    public DataSet query(ReportQueryParam param, Object paramObject) throws Throwable {
        Map<String, Object> paramMap = ReportCommonHelper.transQueryParam(param);
        paramMap.putAll(param.getCustomParam());
        DataSet resultDataSet = this.getQueryDataSet(paramMap);
        return resultDataSet;
    }

    private DataSet getQueryDataSet(Map<String, Object> paramMap) {
        String businessRangeStr = (String)paramMap.get("filter_businessrange");
        int topnum = Integer.parseInt((String)paramMap.get("filter_topnum"));
        DataSet acctBankDS = FinOrgEvaService.getAcctBankDataSet(paramMap);
        DataSet allBankDS = FinOrgEvaService.getAllBankDataSet();
        DataSet bankJournalDataSet = FinOrgEvaService.getBankJournalDataSet(paramMap, acctBankDS.copy());
        QFilter[] creditLimitFilters = FinOrgEvaService.initCreditLimitQFilter(paramMap);
        DataSet creditLimitDataSet = FinOrgEvaService.getCreditLimitDataSet(creditLimitFilters, paramMap, allBankDS.copy());
        QFilter[] loanFilters = FinOrgEvaService.initLoanQFilter(paramMap);
        DataSet loanDataSet = FinOrgEvaService.getLoanDataSet(loanFilters, paramMap, allBankDS.copy());
        QFilter[] payableBillFilters = FinOrgEvaService.initPayableBillQFilter(paramMap);
        DataSet payableBillDataSet = FinOrgEvaService.getPayableBillDataSet(payableBillFilters, paramMap, acctBankDS.copy());
        QFilter[] drafttradeBillFilters = FinOrgEvaService.initDrafttradeBillQFilter(paramMap);
        DataSet drafttradeBillDataSet = FinOrgEvaService.getDrafttradeBillDataSet(drafttradeBillFilters, paramMap, acctBankDS.copy());
        DataSet dataSet = allBankDS.copy().groupBy(new String[]{"bank", "finorgtype"}).finish();
        String whereStr = "";
        if (businessRangeStr.indexOf("01") != -1) {
            dataSet = dataSet.join(bankJournalDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_set", "sort_set"}).finish();
            whereStr = whereStr + "amount_set is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_set", "sort_set"});
        }
        if (businessRangeStr.indexOf("02") != -1) {
            dataSet = dataSet.join(creditLimitDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_credit", "sort_credit"}).finish();
            whereStr = whereStr + "or amount_credit is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_credit", "sort_credit"});
        }
        if (businessRangeStr.indexOf("03") != -1) {
            dataSet = dataSet.join(loanDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_loan", "sort_loan"}).finish();
            whereStr = whereStr + "or amount_loan is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_loan", "sort_loan"});
        }
        if (businessRangeStr.indexOf("04") != -1) {
            dataSet = dataSet.join(payableBillDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_acc", "sort_acc"}).finish();
            whereStr = whereStr + "or amount_acc is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_acc", "sort_acc"});
        }
        if (businessRangeStr.indexOf("05") != -1) {
            dataSet = dataSet.join(drafttradeBillDataSet, JoinType.LEFT).on("bank", "bank").on("finorgtype", "finorgtype").select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount_dis", "sort_dis"}).finish();
            whereStr = whereStr + "or amount_dis is not null ";
        } else {
            dataSet = dataSet.addFields(new String[]{"0", "0"}, new String[]{"amount_dis", "sort_dis"});
        }
        if (whereStr.startsWith("or")) {
            whereStr = whereStr.substring(2, whereStr.length());
        }
        dataSet = dataSet.where(whereStr);
        DataSet allBankDs = dataSet.filter("finorgtype = '0'").select(dataSet.getRowMeta().getFieldNames());
        DataSet otherFinDs = dataSet.filter("finorgtype != '0'").select(dataSet.getRowMeta().getFieldNames());
        DataSet finSumDataSet = otherFinDs.where(whereStr).groupBy(new String[]{"finorgtype"}).sum("amount_set").sum("sort_set").sum("amount_credit").sum("sort_credit").sum("amount_loan").sum("sort_loan").sum("amount_acc").sum("sort_acc").sum("amount_dis").sum("sort_dis").finish();
        finSumDataSet = finSumDataSet.addField("' '", "bank");
        DataSet select = finSumDataSet.select("bank,finorgtype,amount_set,sort_set,amount_credit,sort_credit,amount_loan,sort_loan,amount_acc,sort_acc,amount_dis,sort_dis");
        dataSet = select.union(allBankDs);
        dataSet = dataSet.orderBy(new String[]{"amount_set desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_set");
        dataSet = dataSet.orderBy(new String[]{"amount_credit desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_credit");
        dataSet = dataSet.orderBy(new String[]{"amount_loan desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_loan");
        dataSet = dataSet.orderBy(new String[]{"amount_acc desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_acc");
        dataSet = dataSet.orderBy(new String[]{"amount_dis desc"});
        dataSet = this.addSortToDataSet(dataSet, "sort_dis");
        ArrayList<String> sortBy = new ArrayList<String>(5);
        if (businessRangeStr.indexOf("01") != -1) {
            sortBy.add("sort_set asc");
        } else if (businessRangeStr.indexOf("02") != -1) {
            sortBy.add("sort_credit asc");
        } else if (businessRangeStr.indexOf("03") != -1) {
            sortBy.add("sort_loan asc");
        } else if (businessRangeStr.indexOf("04") != -1) {
            sortBy.add("sort_acc asc");
        } else {
            sortBy.add("sort_dis asc");
        }
        dataSet = dataSet.orderBy(sortBy.toArray(new String[0]));
        dataSet = dataSet.top(topnum);
        String currency_rpt = ((DynamicObject)paramMap.get("filter_statcurrency")).getString("id");
        dataSet = dataSet.addField(currency_rpt, "currency_rpt");
        QFilter finOrgTypeFilter = new QFilter("enable", "=", (Object)"1");
        DataSet finOrgTypeDs = QueryServiceHelper.queryDataSet((String)"bd_finorgtype", (String)"bd_finorgtype", (String)"type,name typeName", (QFilter[])new QFilter[]{finOrgTypeFilter}, null);
        if (!finOrgTypeDs.copy().isEmpty()) {
            dataSet = dataSet.leftJoin(finOrgTypeDs).on("finorgtype", "type").select(dataSet.getRowMeta().getFieldNames(), new String[]{"typeName"}).finish();
            dataSet = dataSet.updateField("bank", "case when finorgtype != '0' then typeName else bank end");
        }
        return dataSet;
    }

    public DataSet addSortToDataSet(DataSet dataSet, String sortKey) {
        Algo algo = Algo.create((String)"addSort");
        DataSetBuilder datasetBuilder = algo.createDataSetBuilder(dataSet.getRowMeta());
        int i = 1;
        while (dataSet.hasNext()) {
            Object[] rowData = new Object[dataSet.getRowMeta().getFieldCount()];
            Field[] fields = dataSet.getRowMeta().getFields();
            Row row = dataSet.next();
            for (int j = 0; j < fields.length; ++j) {
                rowData[j] = fields[j].getAlias().equalsIgnoreCase(sortKey) ? Integer.valueOf(i) : row.get(j);
            }
            ++i;
            datasetBuilder.append(rowData);
        }
        dataSet = datasetBuilder.build();
        return dataSet;
    }
}

