/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.mon.report.data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.mon.report.helper.MonReportHelper;
import org.apache.commons.lang3.tuple.Pair;

public class FinProdutSumDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String LONA_FIELDS = "id as loanbillid, finproduct.id finproductid, finproduct.name as finproductname,finproduct.finsource as finsource, region, drawamount, currency, 1 rate";
    private static final String SL_FIELDS = "id as loanbillid, finproduct.id finproductid, finproduct.name as finproductname,finproduct.finsource as finsource, region, banksyndicate_entry.e_shareamount drawamount, currency, banksyndicate_entry.e_shareamount/drawamount rate";
    private static final String BOND_FIELDS = "id as loanbillid, finproduct.id finproductid, finproduct.name as finproductname,finproduct.finsource as finsource, region, investor_entry.e_investamount drawamount, currency, investor_entry.e_investamount/drawamount rate";
    private List<String> regionsList;

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        this.getQueryParam().getCustomParam().put("filter_statdim", paramMap.get("filter_statdim"));
        paramMap.putAll(queryParam.getCustomParam());
        String regionRange = (String)paramMap.get("filter_region");
        String[] regions = regionRange.split(",");
        this.regionsList = new ArrayList<String>(10);
        for (String reg : regions) {
            if (!EmptyUtil.isNoEmpty((String)reg)) continue;
            this.regionsList.add("p_" + reg.toLowerCase());
        }
        DataSet finbalDs = this.queryBalanceDs(queryParam);
        if (finbalDs.isEmpty()) {
            return this.getEmptyDataSet();
        }
        long tarCurrencyId = ((DynamicObject)paramMap.get("filter_statcurrency")).getLong("id");
        String unit = (String)paramMap.get("filter_currencyunit");
        finbalDs = this.addExchangeRateAndCurrencyUnit(finbalDs, paramMap);
        finbalDs = finbalDs.updateField("balance", String.format("balance_report * %s", unit));
        finbalDs = finbalDs.groupBy(new String[]{"finsource", "finproductid", "finproductname", "region"}).sum("balance", "count").finish();
        finbalDs = this.ChangeRowToColDataSet(finbalDs, "region", "finsource, finproductid,finproductname", "p_");
        List<String> fieldsNames = Arrays.asList(finbalDs.getRowMeta().getFieldNames());
        for (String region : this.regionsList) {
            if (fieldsNames.contains(region = this.changeRegion(region))) continue;
            finbalDs = finbalDs.addField("0", region);
        }
        String exp = fieldsNames.stream().filter(s -> s.startsWith("p_")).collect(Collectors.joining("+"));
        DataSet totalAmtDs = (finbalDs = finbalDs.addField(exp, "rowsumamt")).copy().groupBy().sum("rowsumamt").finish();
        if (!totalAmtDs.isEmpty()) {
            BigDecimal totalAmt = ((Row)totalAmtDs.iterator().next()).getBigDecimal("rowsumamt");
            finbalDs = BigDecimal.ZERO.compareTo(totalAmt) == 0 ? finbalDs.addField("0", "ratio") : finbalDs.addField(String.format("(rowsumamt/%s)*100", totalAmt.toPlainString()), "ratio");
        }
        String[] changeFields = (String[])Arrays.stream(finbalDs.getRowMeta().getFieldNames()).filter(f -> f.startsWith("p_")).toArray(String[]::new);
        finbalDs = finbalDs.updateFields(changeFields, (String[])Arrays.stream(changeFields).map(f -> {
            f = String.format(f + " / %s", unit);
            return f;
        }).toArray(String[]::new));
        return finbalDs.addFields(new String[]{"rowsumamt", tarCurrencyId + "L"}, new String[]{"balance", "currency"});
    }

    private String changeRegion(String region) {
        if ("p_r1".equals(region)) {
            return "p_3583";
        }
        if ("p_r2".equals(region)) {
            return "p_3584";
        }
        return "p_3585";
    }

    private DataSet getEmptyDataSet() {
        return Algo.create((String)"EmptyDataSet").createDataSetBuilder(new RowMeta(new String[]{"empty"}, new DataType[]{DataType.StringType})).build();
    }

    private DataSet queryBalanceDs(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        DataSet loanDs = this.queryLoanBillDs(queryParam);
        List<Long> loanBillIds = this.getLoanBillIds(loanDs);
        DataSet repayDs = this.queryRepaymentDs(loanBillIds, paramMap);
        RowMeta rm = loanDs.getRowMeta();
        DataSet finbalDs = loanDs.leftJoin(repayDs).on("loanbillid", "loanbillid").select(rm.getFieldNames(), new String[]{"repayamount"}).finish();
        finbalDs = finbalDs.select("lower(region) as region, finsource, finproductid, finproductname ,currency, case when repayamount is null then drawamount else drawamount-repayamount*rate end as balance");
        finbalDs = finbalDs.groupBy(new String[]{"finsource", "finproductid", "finproductname", "region", "currency"}).sum("balance", "balance").finish();
        finbalDs = finbalDs.filter("balance != 0");
        return finbalDs;
    }

    private DataSet queryLoanBillDs(ReportQueryParam queryParam) {
        Map paramMap = this.transQueryParam(queryParam);
        List orgIds = this.getQueryOrgIds(queryParam);
        String regionRange = (String)paramMap.get("filter_region");
        String[] regions = regionRange.split(",");
        QFilter loanQF = new QFilter("org.id", "in", (Object)orgIds);
        loanQF.and(new QFilter("finproduct.id", ">", (Object)0L));
        loanQF.and(new QFilter("billstatus", "=", (Object)"C"));
        loanQF.and(new QFilter("confirmstatus", "=", (Object)"yetconfirm"));
        loanQF.and("region", "in", (Object)regions);
        DynamicObjectCollection finproducts = (DynamicObjectCollection)paramMap.get("filter_finproduct");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)finproducts)) {
            List finproductIds = finproducts.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
            loanQF.and(new QFilter("finproduct.id", "in", finproductIds));
        }
        Date cutoffDate = (Date)paramMap.get("filter_cutoffdate");
        loanQF.and(new QFilter("bizdate", "<=", (Object)cutoffDate));
        String creditorTypes = (String)paramMap.get("filter_creditortype");
        QFilter loanFilter = MonReportHelper.getCreditortypeFilter(loanQF.copy(), creditorTypes, "");
        DataSet loanDs = QueryServiceHelper.queryDataSet((String)"queryloan", (String)"cfm_loanbill", (String)LONA_FIELDS, (QFilter[])new QFilter[]{loanQF, loanFilter}, null);
        QFilter slFilter = MonReportHelper.getCreditortypeFilter(loanQF.copy(), creditorTypes, "sl");
        DataSet slLoanDs = QueryServiceHelper.queryDataSet((String)"queryloansl", (String)"cfm_loanbill", (String)SL_FIELDS, (QFilter[])new QFilter[]{loanQF, slFilter}, null);
        QFilter bondFilter = MonReportHelper.getCreditortypeFilter(loanQF.copy(), creditorTypes, "bond");
        DataSet bondLoanDs = QueryServiceHelper.queryDataSet((String)"queryloanbond", (String)"cfm_loanbill_bond", (String)BOND_FIELDS, (QFilter[])new QFilter[]{loanQF, bondFilter}, null);
        return loanDs.union(slLoanDs).union(bondLoanDs);
    }

    private List<Long> getLoanBillIds(DataSet loanDs) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        for (Row row : loanDs.copy()) {
            ids.add(row.getLong("loanbillid"));
        }
        return ids;
    }

    private DataSet queryRepaymentDs(List<Long> loanbillIds, Map<String, Object> paramMap) {
        Date cutoffDate = (Date)paramMap.get("filter_cutoffdate");
        QFilter repayQF = new QFilter("bizdate", "<=", (Object)cutoffDate);
        repayQF.and(new QFilter("loans.e_loanbill.id", "in", loanbillIds));
        DataSet repayDs = QueryServiceHelper.queryDataSet((String)"queryrepayment", (String)"cfm_repaymentbill", (String)"loans.e_loanbill.id as loanbillid, loans.e_repayamount as repayamount", (QFilter[])repayQF.toArray(), null);
        repayDs = repayDs.groupBy(new String[]{"loanbillid"}).sum("repayamount").finish();
        return repayDs;
    }

    protected boolean isNeedOrgTree() {
        return false;
    }

    protected List<String> orinalAmountField() {
        return Collections.singletonList("balance");
    }

    public List<String> sumAmountFields() {
        ArrayList<String> sumFields = new ArrayList<String>(4);
        sumFields.add("balance");
        sumFields.add("ratio");
        for (String region : this.regionsList) {
            sumFields.add(this.changeRegion(region));
        }
        return sumFields.stream().distinct().collect(Collectors.toList());
    }

    public Pair<String, String> getBizAndReportOrgProp() {
        return Pair.of((Object)"finproductid", (Object)"finproductname");
    }

    public List<String> groupFields() {
        return new ArrayList<String>(Collections.singletonList("finsource"));
    }
}

